/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.builder;

import com.github.rvesse.airline.CommandFactory;
import com.github.rvesse.airline.DefaultCommandFactory;
import com.github.rvesse.airline.annotations.AirlineModule;
import com.github.rvesse.airline.builder.AbstractBuilder;
import com.github.rvesse.airline.builder.AliasBuilder;
import com.github.rvesse.airline.builder.UserAliasSourceBuilder;
import com.github.rvesse.airline.model.AliasMetadata;
import com.github.rvesse.airline.model.ParserMetadata;
import com.github.rvesse.airline.parser.aliases.UserAliasesSource;
import com.github.rvesse.airline.parser.errors.handlers.ParserErrorHandler;
import com.github.rvesse.airline.parser.options.ClassicGetOptParser;
import com.github.rvesse.airline.parser.options.LongGetOptParser;
import com.github.rvesse.airline.parser.options.OptionParser;
import com.github.rvesse.airline.parser.options.StandardOptionParser;
import com.github.rvesse.airline.parser.resources.ResourceLocator;
import com.github.rvesse.airline.types.DefaultTypeConverter;
import com.github.rvesse.airline.types.TypeConverter;
import com.github.rvesse.airline.types.numerics.DefaultNumericConverter;
import com.github.rvesse.airline.types.numerics.NumericTypeConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ParserBuilder<C>
extends AbstractBuilder<ParserMetadata<C>> {
    protected TypeConverter typeConverter = new DefaultTypeConverter();
    protected NumericTypeConverter numericTypeConverter = new DefaultNumericConverter();
    protected final Map<String, AliasBuilder<C>> aliases = new HashMap<String, AliasBuilder<C>>();
    protected CommandFactory<C> commandFactory = new DefaultCommandFactory<C>();
    protected boolean allowAbbreviatedCommands;
    protected boolean allowAbbreviatedOptions;
    protected boolean aliasesOverrideBuiltIns;
    protected boolean aliasesMayChain;
    private char forceBuiltInPrefix = (char)33;
    protected final List<OptionParser<C>> optionParsers = new ArrayList<OptionParser<C>>();
    protected String argsSeparator;
    protected String flagNegationPrefix;
    protected UserAliasSourceBuilder<C> userAliasesBuilder = new UserAliasSourceBuilder(this);
    protected ParserErrorHandler errorHandler;
    protected Set<String> injectionAnnotationClasses = new LinkedHashSet<String>();

    public static <T> ParserMetadata<T> defaultConfiguration() {
        return new ParserBuilder().build();
    }

    public ParserBuilder<C> withCommandFactory(CommandFactory<C> commandFactory) {
        this.commandFactory = commandFactory;
        return this;
    }

    public ParserBuilder<C> withDefaultCommandFactory() {
        this.commandFactory = null;
        return this;
    }

    public ParserBuilder<C> withCompositionAnnotations(Collection<String> annotationClassNames) {
        if (annotationClassNames != null) {
            this.injectionAnnotationClasses.addAll(annotationClassNames);
        }
        return this;
    }

    public ParserBuilder<C> withCompositionAnnotations(String ... annotationClassNames) {
        return this.withCompositionAnnotations(Arrays.asList(annotationClassNames));
    }

    public ParserBuilder<C> withDefaultCompositionAnnotations() {
        return this.withCompositionAnnotations(AirlineModule.class.getCanonicalName(), "javax.inject.Inject", "jakarta.inject.Inject", "com.google.inject.Inject");
    }

    public AliasBuilder<C> withAlias(String name) {
        this.checkNotBlank(name, "Alias name");
        if (this.aliases.containsKey(name)) {
            return this.aliases.get(name);
        }
        AliasBuilder alias = new AliasBuilder(this, name);
        this.aliases.put(name, alias);
        return alias;
    }

    public AliasBuilder<C> getAlias(String name) {
        this.checkNotBlank(name, "Alias name");
        if (!this.aliases.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Alias %s has not been declared", name));
        }
        return this.aliases.get(name);
    }

    public ParserBuilder<C> withAliasForceBuiltInPrefix(char prefix) {
        this.forceBuiltInPrefix = prefix;
        return this;
    }

    public UserAliasSourceBuilder<C> withUserAliases() {
        return this.userAliasesBuilder;
    }

    @Deprecated
    public ParserBuilder<C> withUserAliases(String programName) {
        this.userAliasesBuilder.withProgramName(programName);
        this.userAliasesBuilder.withDefaultSearchLocation(programName);
        return this;
    }

    @Deprecated
    public ParserBuilder<C> withUserAliases(String programName, String searchLocation) {
        this.userAliasesBuilder.withProgramName(programName);
        this.userAliasesBuilder.withSearchLocation(searchLocation);
        return this;
    }

    @Deprecated
    public ParserBuilder<C> withUserAliases(String filename, String prefix, String ... searchLocations) {
        this.userAliasesBuilder.withFilename(filename);
        this.userAliasesBuilder.withPrefix(prefix);
        this.userAliasesBuilder.withSearchLocations(searchLocations);
        return this;
    }

    @Deprecated
    public ParserBuilder<C> withUserAliases(String filename, String prefix, List<ResourceLocator> locators, String ... searchLocations) {
        this.userAliasesBuilder.withFilename(filename);
        this.userAliasesBuilder.withPrefix(prefix);
        this.userAliasesBuilder.withSearchLocations(searchLocations);
        this.userAliasesBuilder.withLocators(locators);
        return this;
    }

    public ParserBuilder<C> withAliasesOverridingBuiltIns() {
        this.aliasesOverrideBuiltIns = true;
        return this;
    }

    public ParserBuilder<C> withAliasesChaining() {
        this.aliasesMayChain = true;
        return this;
    }

    public ParserBuilder<C> withCommandAbbreviation() {
        this.allowAbbreviatedCommands = true;
        return this;
    }

    public ParserBuilder<C> withOptionAbbreviation() {
        this.allowAbbreviatedOptions = true;
        return this;
    }

    public ParserBuilder<C> withTypeConverter(TypeConverter converter) {
        this.typeConverter = converter;
        return this;
    }

    public ParserBuilder<C> withDefaultTypeConverter() {
        this.typeConverter = null;
        return this;
    }

    public ParserBuilder<C> withNumericTypeConverter(NumericTypeConverter converter) {
        this.numericTypeConverter = converter;
        return this;
    }

    public ParserBuilder<C> withDefaultNumericTypeConverter() {
        this.numericTypeConverter = null;
        return this;
    }

    public ParserBuilder<C> withErrorHandler(ParserErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public ParserBuilder<C> withDefaultErrorHandler() {
        this.errorHandler = null;
        return this;
    }

    public ParserBuilder<C> withOptionParser(OptionParser<C> optionParser) {
        if (optionParser != null) {
            this.optionParsers.add(optionParser);
        }
        return this;
    }

    public ParserBuilder<C> withOptionParsers(OptionParser<C> ... optionParsers) {
        if (optionParsers != null) {
            for (OptionParser<C> parser : optionParsers) {
                if (parser == null) continue;
                this.optionParsers.add(parser);
            }
        }
        return this;
    }

    public ParserBuilder<C> withOnlyDefaultOptionParsers() {
        this.optionParsers.clear();
        return this.withDefaultOptionParsers();
    }

    public ParserBuilder<C> withDefaultOptionParsers() {
        return this.withOptionParsers(new StandardOptionParser(), new LongGetOptParser(), new ClassicGetOptParser());
    }

    public ParserBuilder<C> withArgumentsSeparator(String separator) {
        this.argsSeparator = separator;
        return this;
    }

    public ParserBuilder<C> withFlagNegationPrefix(String prefix) {
        this.flagNegationPrefix = prefix;
        return this;
    }

    @Override
    public ParserMetadata<C> build() {
        ArrayList<AliasMetadata> aliasData;
        if (this.injectionAnnotationClasses.size() == 0) {
            this.withDefaultCompositionAnnotations();
        }
        if (this.optionParsers.size() == 0) {
            this.withDefaultOptionParsers();
        }
        Object userAliases = null;
        if (this.userAliasesBuilder.isBuildable()) {
            try {
                userAliases = this.userAliasesBuilder.build();
                for (AliasMetadata alias : ((UserAliasesSource)userAliases).load()) {
                    this.aliases.put(alias.getName(), new AliasBuilder(this, alias.getName()).withArguments(alias.getArguments().toArray(new String[alias.getArguments().size()])));
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load user aliases", e);
            }
        }
        if (this.aliases != null) {
            aliasData = new ArrayList<AliasMetadata>();
            for (AliasBuilder<C> aliasBuilder : this.aliases.values()) {
                aliasData.add(aliasBuilder.build());
            }
        } else {
            aliasData = new ArrayList();
        }
        if (this.typeConverter == null) {
            this.typeConverter = new DefaultTypeConverter();
        }
        this.typeConverter.setNumericConverter(this.numericTypeConverter);
        return new ParserMetadata<C>(this.commandFactory, (Collection<String>)this.injectionAnnotationClasses, this.optionParsers, this.typeConverter, this.errorHandler, this.allowAbbreviatedCommands, this.allowAbbreviatedOptions, (Collection<AliasMetadata>)aliasData, userAliases, this.aliasesOverrideBuiltIns, this.aliasesMayChain, this.forceBuiltInPrefix, this.argsSeparator, this.flagNegationPrefix);
    }
}

