/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TransactionFailureCallback;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.journal.impl.JournalReaderCallback;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageSubscriptionCounterImpl;
import org.apache.activemq.artemis.core.paging.impl.PageTransactionInfoImpl;
import org.apache.activemq.artemis.core.persistence.config.PersistedBridgeConfiguration;
import org.apache.activemq.artemis.core.persistence.config.PersistedDivertConfiguration;
import org.apache.activemq.artemis.core.persistence.impl.journal.AbstractJournalStorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.AckDescribe;
import org.apache.activemq.artemis.core.persistence.impl.journal.BatchingIDGenerator;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeServerMessageImpl;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.CursorAckRecordEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.DeliveryCountUpdateEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.DuplicateIDEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.HeuristicCompletionEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.LargeMessagePersister;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PageCountPendingImpl;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PageCountRecord;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PageCountRecordInc;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PageUpdateTXEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PendingLargeMessageEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PersistentAddressBindingEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PersistentQueueBindingEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.RefEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.ScheduledDeliveryEncoding;
import org.apache.activemq.artemis.spi.core.protocol.MessagePersister;
import org.apache.activemq.artemis.utils.Base64;
import org.apache.activemq.artemis.utils.XMLUtil;
import org.apache.activemq.artemis.utils.XidCodecSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DescribeJournal {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final List<RecordInfo> records;
    private final List<PreparedTransactionInfo> preparedTransactions;
    private List<PersistentQueueBindingEncoding> bindingEncodings;
    private static final PrintStream nullPrintStream = new PrintStream(new OutputStream(){

        @Override
        public void write(int b) throws IOException {
        }
    });

    private static Configuration getConfiguration() {
        ConfigurationImpl configuration;
        String instanceFolder = System.getProperty("artemis.instance");
        if (instanceFolder != null) {
            configuration = new FileConfiguration();
            File configFile = new File(instanceFolder + "/etc/broker.xml");
            try {
                URL url = configFile.toURI().toURL();
                Element e = XMLUtil.urlToElement((URL)url);
                String root = ((FileConfiguration)configuration).getRootElement();
                NodeList children = e.getElementsByTagName(root);
                if (root != null && children.getLength() > 0) {
                    Node item = children.item(0);
                    XMLUtil.validate((Node)item, (String)((FileConfiguration)configuration).getSchema());
                    ((FileConfiguration)configuration).parse((Element)item, url);
                }
            }
            catch (Exception e) {
                logger.error("failed to load broker.xml", (Throwable)e);
            }
        } else {
            configuration = new ConfigurationImpl();
        }
        return configuration;
    }

    public DescribeJournal(List<RecordInfo> records, List<PreparedTransactionInfo> preparedTransactions) {
        this.records = records;
        this.preparedTransactions = preparedTransactions;
    }

    public List<PersistentQueueBindingEncoding> getBindingEncodings() {
        return this.bindingEncodings;
    }

    public DescribeJournal setBindingEncodings(List<PersistentQueueBindingEncoding> bindingEncodings) {
        this.bindingEncodings = bindingEncodings;
        return this;
    }

    public List<RecordInfo> getRecords() {
        return this.records;
    }

    public List<PreparedTransactionInfo> getPreparedTransactions() {
        return this.preparedTransactions;
    }

    public static void describeBindingsJournal(File bindingsDir) throws Exception {
        DescribeJournal.describeBindingsJournal(bindingsDir, System.out, false, true, true);
    }

    public static void describeBindingsJournal(File bindingsDir, PrintStream out, boolean safe, boolean printRecords, boolean printSurviving) throws Exception {
        DescribeJournal.describeBindingsJournal(bindingsDir, out, safe, printRecords, printSurviving, false);
    }

    public static DescribeJournal describeBindingsJournal(File bindingsDir, PrintStream out, boolean safe, boolean printRecords, boolean printSurviving, boolean reclaimed) throws Exception {
        NIOSequentialFileFactory bindingsFF = new NIOSequentialFileFactory(bindingsDir, null, 1);
        JournalImpl bindings = new JournalImpl(0x100000, 2, 2, -1, 0, (SequentialFileFactory)bindingsFF, "activemq-bindings", "bindings", 1);
        return DescribeJournal.describeJournal((SequentialFileFactory)bindingsFF, bindings, bindingsDir, out, safe, printRecords, printSurviving, reclaimed);
    }

    public static DescribeJournal describeMessagesJournal(File messagesDir) throws Exception {
        return DescribeJournal.describeMessagesJournal(messagesDir, System.out, false, true, true, false);
    }

    public static DescribeJournal describeMessagesJournal(File messagesDir, PrintStream out, boolean safe, boolean printRecords, boolean printSurviving, boolean reclaimed) throws Exception {
        Configuration configuration = DescribeJournal.getConfiguration();
        NIOSequentialFileFactory messagesFF = new NIOSequentialFileFactory(messagesDir, null, 1);
        JournalImpl messagesJournal = new JournalImpl(configuration.getJournalFileSize(), configuration.getJournalMinFiles(), configuration.getJournalPoolFiles(), 0, 0, (SequentialFileFactory)messagesFF, "activemq-data", "amq", 1);
        return DescribeJournal.describeJournal((SequentialFileFactory)messagesFF, messagesJournal, messagesDir, out, safe, printRecords, printSurviving, reclaimed);
    }

    private static DescribeJournal describeJournal(SequentialFileFactory fileFactory, JournalImpl journal, File path, PrintStream out, final boolean safe, boolean printRecords, boolean printSurving, boolean reclaimed) throws Exception {
        List files = journal.orderFiles();
        final HashMap<Long, PageSubscriptionCounterImpl> counters = new HashMap<Long, PageSubscriptionCounterImpl>();
        final PrintStream recordsPrintStream = printRecords ? out : nullPrintStream;
        PrintStream survivingPrintStrea = printSurving ? out : nullPrintStream;
        recordsPrintStream.println("Journal path: " + path);
        for (JournalFile file : files) {
            recordsPrintStream.println("#" + file + " (size=" + file.getFile().size() + ")");
            JournalImpl.readJournalFile((SequentialFileFactory)fileFactory, (JournalFile)file, (JournalReaderCallback)new JournalReaderCallback(){

                public void onReadEventRecord(RecordInfo recordInfo) throws Exception {
                    recordsPrintStream.println("operation@Event;" + DescribeJournal.describeRecord(recordInfo, safe));
                }

                public void onReadUpdateRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
                    recordsPrintStream.println("operation@UpdateTX;txID=" + transactionID + "," + DescribeJournal.describeRecord(recordInfo, safe));
                    this.checkRecordCounter(recordInfo);
                }

                public void onReadUpdateRecord(RecordInfo recordInfo) throws Exception {
                    recordsPrintStream.println("operation@Update;" + DescribeJournal.describeRecord(recordInfo, safe));
                    this.checkRecordCounter(recordInfo);
                }

                public void onReadRollbackRecord(long transactionID) throws Exception {
                    recordsPrintStream.println("operation@Rollback;txID=" + transactionID);
                }

                public void onReadPrepareRecord(long transactionID, byte[] extraData, int numberOfRecords) throws Exception {
                    recordsPrintStream.println("operation@Prepare,txID=" + transactionID + ",numberOfRecords=" + numberOfRecords + ",extraData=" + DescribeJournal.encode(extraData) + ", xid=" + DescribeJournal.toXid(extraData));
                }

                public void onReadDeleteRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
                    recordsPrintStream.println("operation@DeleteRecordTX;txID=" + transactionID + "," + DescribeJournal.describeRecord(recordInfo, safe));
                }

                public void onReadDeleteRecord(long recordID) throws Exception {
                    recordsPrintStream.println("operation@DeleteRecord;recordID=" + recordID);
                }

                public void onReadCommitRecord(long transactionID, int numberOfRecords) throws Exception {
                    recordsPrintStream.println("operation@Commit;txID=" + transactionID + ",numberOfRecords=" + numberOfRecords);
                }

                public void onReadAddRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
                    recordsPrintStream.println("operation@AddRecordTX;txID=" + transactionID + "," + DescribeJournal.describeRecord(recordInfo, safe));
                }

                public void onReadAddRecord(RecordInfo recordInfo) throws Exception {
                    recordsPrintStream.println("operation@AddRecord;" + DescribeJournal.describeRecord(recordInfo, safe));
                }

                public void markAsDataFile(JournalFile file1) {
                }

                public void checkRecordCounter(RecordInfo info) {
                    if (info.getUserRecordType() == 40) {
                        PageCountRecord encoding = (PageCountRecord)DescribeJournal.newObjectEncoding(info);
                        long queueIDForCounter = encoding.getQueueID();
                        PageSubscriptionCounterImpl subsCounter = DescribeJournal.lookupCounter(counters, queueIDForCounter);
                        if (subsCounter.getValue() != 0L && subsCounter.getValue() != encoding.getValue()) {
                            recordsPrintStream.println("####### Counter replace wrongly on queue " + queueIDForCounter + " oldValue=" + subsCounter.getValue() + " newValue=" + encoding.getValue());
                        }
                        subsCounter.loadValue(info.id, encoding.getValue(), encoding.getPersistentSize());
                        subsCounter.processReload();
                        recordsPrintStream.print("#Counter queue " + queueIDForCounter + " value=" + subsCounter.getValue() + " persistentSize=" + subsCounter.getPersistentSize() + ", result=" + subsCounter.getValue());
                        if (subsCounter.getValue() < 0L) {
                            recordsPrintStream.println(" #NegativeCounter!!!!");
                        } else {
                            recordsPrintStream.println();
                        }
                        recordsPrintStream.println();
                    } else if (info.getUserRecordType() == 41) {
                        PageCountRecordInc encoding = (PageCountRecordInc)DescribeJournal.newObjectEncoding(info);
                        long queueIDForCounter = encoding.getQueueID();
                        PageSubscriptionCounterImpl subsCounter = DescribeJournal.lookupCounter(counters, queueIDForCounter);
                        subsCounter.loadInc(info.id, encoding.getValue(), encoding.getPersistentSize());
                        subsCounter.processReload();
                        recordsPrintStream.print("#Counter queue " + queueIDForCounter + " value=" + subsCounter.getValue() + " persistentSize=" + subsCounter.getPersistentSize() + " increased by " + encoding.getValue());
                        if (subsCounter.getValue() < 0L) {
                            recordsPrintStream.println(" #NegativeCounter!!!!");
                        } else {
                            recordsPrintStream.println();
                        }
                        recordsPrintStream.println();
                    }
                }
            }, null, (boolean)reclaimed, null);
        }
        recordsPrintStream.println();
        if (counters.size() != 0) {
            recordsPrintStream.println("#Counters during initial load:");
            DescribeJournal.printCounters(recordsPrintStream, counters);
        }
        return DescribeJournal.printSurvivingRecords((Journal)journal, survivingPrintStrea, safe);
    }

    public static DescribeJournal printSurvivingRecords(Journal journal, PrintStream out, final boolean safe) throws Exception {
        HashMap<Long, PageSubscriptionCounterImpl> counters = new HashMap<Long, PageSubscriptionCounterImpl>();
        out.println("### Surviving Records Summary ###");
        LinkedList<RecordInfo> records = new LinkedList<RecordInfo>();
        LinkedList<PreparedTransactionInfo> preparedTransactions = new LinkedList<PreparedTransactionInfo>();
        LinkedList<PersistentQueueBindingEncoding> bindings = null;
        journal.start();
        final StringBuffer bufferFailingTransactions = new StringBuffer();
        long messageCount = 0L;
        long largeMessageCount = 0L;
        final class Count {
            int value;

            Count(int v) {
                this.value = v;
            }

            public String toString() {
                return Integer.toString(this.value);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Count count = (Count)o;
                return this.value == count.value;
            }

            public int hashCode() {
                return Integer.hashCode(this.value);
            }
        }
        HashMap<Long, Count> messageRefCounts = new HashMap<Long, Count>();
        long preparedMessageCount = 0L;
        long preparedLargeMessageCount = 0L;
        HashMap<Long, Count> preparedMessageRefCount = new HashMap<Long, Count>();
        journal.load(records, preparedTransactions, new TransactionFailureCallback(){

            public void failedTransaction(long transactionID, List<RecordInfo> records1, List<RecordInfo> recordsToDelete) {
                bufferFailingTransactions.append("Transaction " + transactionID + " failed with these records:\n");
                for (RecordInfo info : records1) {
                    bufferFailingTransactions.append("- " + DescribeJournal.describeRecord(info, safe) + "\n");
                }
                for (RecordInfo info : recordsToDelete) {
                    bufferFailingTransactions.append("- " + DescribeJournal.describeRecord(info, safe) + " <marked to delete>\n");
                }
            }
        }, false);
        for (RecordInfo info : records) {
            Object encoding;
            Count count2;
            Object ref;
            PageSubscriptionCounterImpl subsCounter = null;
            long queueIDForCounter = 0L;
            Object o = DescribeJournal.newObjectEncoding(info);
            byte userRecordType = info.getUserRecordType();
            if (userRecordType == 31 || userRecordType == 45) {
                ++messageCount;
            } else if (userRecordType == 30) {
                ++largeMessageCount;
            } else if (userRecordType == 32) {
                ref = (ReferenceDescribe)o;
                count2 = (Count)messageRefCounts.get(((ReferenceDescribe)ref).refEncoding.queueID);
                if (count2 == null) {
                    count2 = new Count(0);
                    messageRefCounts.put(((ReferenceDescribe)ref).refEncoding.queueID, count2);
                }
                ++count2.value;
            } else if (userRecordType == 33) {
                ref = (AckDescribe)o;
                count2 = (Count)messageRefCounts.get(((AckDescribe)ref).refEncoding.queueID);
                if (count2 == null) {
                    messageRefCounts.put(((AckDescribe)ref).refEncoding.queueID, new Count(0));
                } else {
                    --count2.value;
                }
            } else if (userRecordType == 40) {
                encoding = (PageCountRecord)o;
                queueIDForCounter = ((PageCountRecord)encoding).getQueueID();
                subsCounter = DescribeJournal.lookupCounter(counters, queueIDForCounter);
                subsCounter.loadValue(info.id, ((PageCountRecord)encoding).getValue(), ((PageCountRecord)encoding).getPersistentSize());
                subsCounter.processReload();
            } else if (userRecordType == 41) {
                encoding = (PageCountRecordInc)o;
                queueIDForCounter = ((PageCountRecordInc)encoding).getQueueID();
                subsCounter = DescribeJournal.lookupCounter(counters, queueIDForCounter);
                subsCounter.loadInc(info.id, ((PageCountRecordInc)encoding).getValue(), ((PageCountRecordInc)encoding).getPersistentSize());
                subsCounter.processReload();
            } else if (userRecordType == 21) {
                PersistentQueueBindingEncoding bindingEncoding = (PersistentQueueBindingEncoding)DescribeJournal.newObjectEncoding(info, null);
                if (bindings == null) {
                    bindings = new LinkedList<PersistentQueueBindingEncoding>();
                }
                bindings.add(bindingEncoding);
            }
            out.println(DescribeJournal.describeRecord(info, o, safe));
            if (subsCounter == null) continue;
            out.println("##SubsCounter for queue=" + queueIDForCounter + ", value=" + subsCounter.getValue());
            out.println();
        }
        if (counters.size() > 0) {
            out.println("### Page Counters");
            DescribeJournal.printCounters(out, counters);
        }
        out.println();
        out.println("### Prepared TX ###");
        for (PreparedTransactionInfo tx : preparedTransactions) {
            out.println(tx.getId());
            for (RecordInfo info : tx.getRecords()) {
                Object o = DescribeJournal.newObjectEncoding(info);
                out.println("- " + DescribeJournal.describeRecord(info, o, safe));
                byte userRecordType = info.getUserRecordType();
                if (userRecordType == 31 || userRecordType == 45) {
                    ++preparedMessageCount;
                    continue;
                }
                if (userRecordType == 30) {
                    ++preparedLargeMessageCount;
                    continue;
                }
                if (userRecordType != 32) continue;
                ReferenceDescribe ref = (ReferenceDescribe)o;
                Count count3 = (Count)preparedMessageRefCount.get(ref.refEncoding.queueID);
                if (count3 == null) {
                    count3 = new Count(0);
                    preparedMessageRefCount.put(ref.refEncoding.queueID, count3);
                }
                ++count3.value;
            }
            for (RecordInfo info : tx.getRecordsToDelete()) {
                out.println("- " + DescribeJournal.describeRecord(info, safe) + " <marked to delete>");
            }
        }
        String missingTX = bufferFailingTransactions.toString();
        if (missingTX.length() > 0) {
            out.println();
            out.println("### Failed Transactions (Missing commit/prepare/rollback record) ###");
        }
        out.println(bufferFailingTransactions.toString());
        out.println("### Message Counts ###");
        out.println("message count=" + messageCount);
        out.println("large message count=" + largeMessageCount);
        out.println("message reference count");
        messageRefCounts.forEach((queueId, count) -> out.println("queue id " + queueId + ",count=" + count));
        out.println("prepared message count=" + preparedMessageCount);
        out.println("prepared large message count=" + preparedLargeMessageCount);
        out.println("prepared message reference count");
        preparedMessageRefCount.forEach((queueId, count) -> out.println("queue id " + queueId + ",count=" + count));
        journal.stop();
        return new DescribeJournal(records, preparedTransactions).setBindingEncodings(bindings);
    }

    protected static void printCounters(PrintStream out, Map<Long, PageSubscriptionCounterImpl> counters) {
        for (Map.Entry<Long, PageSubscriptionCounterImpl> entry : counters.entrySet()) {
            out.println("Queue " + entry.getKey() + " value=" + entry.getValue().getValue());
        }
    }

    protected static PageSubscriptionCounterImpl lookupCounter(Map<Long, PageSubscriptionCounterImpl> counters, long queueIDForCounter) {
        PageSubscriptionCounterImpl subsCounter = counters.get(queueIDForCounter);
        if (subsCounter == null) {
            subsCounter = new PageSubscriptionCounterImpl(null, -1L);
            counters.put(queueIDForCounter, subsCounter);
        }
        return subsCounter;
    }

    private static boolean isSafe(Object obj) {
        return !(obj instanceof PersistentAddressBindingEncoding) && !(obj instanceof MessageDescribe) && !(obj instanceof PersistentQueueBindingEncoding);
    }

    private static String toString(Object obj, boolean safe) {
        if (obj == null) {
            return "** null **";
        }
        if (safe && !DescribeJournal.isSafe(obj)) {
            if (obj instanceof MessageDescribe) {
                MessageDescribe describe = (MessageDescribe)obj;
                try {
                    return describe.getMsg().getClass().getSimpleName() + "(safe data, size=" + describe.getMsg().getPersistentSize() + ")";
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return describe.getMsg().getClass().getSimpleName() + "(safe data)";
                }
            }
            return obj.getClass().getSimpleName() + "(safe data)";
        }
        return obj.toString();
    }

    private static String describeRecord(RecordInfo info, boolean safe) {
        return "recordID=" + info.id + ";userRecordType=" + info.userRecordType + ";isUpdate=" + info.isUpdate + ";compactCount=" + info.compactCount + ";" + DescribeJournal.toString(DescribeJournal.newObjectEncoding(info), safe);
    }

    private static String describeRecord(RecordInfo info, Object o, boolean safe) {
        return "recordID=" + info.id + ";userRecordType=" + info.userRecordType + ";isUpdate=" + info.isUpdate + ";compactCount=" + info.compactCount + ";" + DescribeJournal.toString(o, safe);
    }

    private static String encode(byte[] data) {
        return Base64.encodeBytes((byte[])data, (int)0, (int)data.length, (int)24);
    }

    private static Xid toXid(byte[] data) {
        try {
            return XidCodecSupport.decodeXid((ActiveMQBuffer)ActiveMQBuffers.wrappedBuffer((byte[])data));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object newObjectEncoding(RecordInfo info) {
        return DescribeJournal.newObjectEncoding(info, null);
    }

    public static Object newObjectEncoding(RecordInfo info, JournalStorageManager storageManager) {
        ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer((byte[])info.data);
        long id = info.id;
        byte rec = info.getUserRecordType();
        switch (rec) {
            case 27: {
                PersistedDivertConfiguration persistedDivertConfiguration = new PersistedDivertConfiguration();
                persistedDivertConfiguration.decode(buffer);
                return persistedDivertConfiguration;
            }
            case 28: {
                PersistedBridgeConfiguration persistedBridgeConfiguration = new PersistedBridgeConfiguration();
                persistedBridgeConfiguration.decode(buffer);
                return persistedBridgeConfiguration;
            }
            case 29: {
                PendingLargeMessageEncoding lmEncoding = new PendingLargeMessageEncoding();
                lmEncoding.decode(buffer);
                return lmEncoding;
            }
            case 30: {
                LargeServerMessageImpl largeMessage = new LargeServerMessageImpl(storageManager);
                LargeMessagePersister.getInstance().decode(buffer, largeMessage, null);
                return new MessageDescribe(largeMessage.toMessage());
            }
            case 31: {
                return "ADD-MESSAGE is not supported any longer, use export/import";
            }
            case 45: {
                Message message = MessagePersister.getInstance().decode(buffer, null, null, storageManager);
                return new MessageDescribe(message);
            }
            case 32: {
                RefEncoding encoding = new RefEncoding();
                encoding.decode(buffer);
                return new ReferenceDescribe(encoding);
            }
            case 33: {
                RefEncoding encoding = new RefEncoding();
                encoding.decode(buffer);
                return new AckDescribe(encoding);
            }
            case 34: {
                DeliveryCountUpdateEncoding updateDeliveryCount = new DeliveryCountUpdateEncoding();
                updateDeliveryCount.decode(buffer);
                return updateDeliveryCount;
            }
            case 35: {
                if (info.isUpdate) {
                    PageUpdateTXEncoding pageUpdate = new PageUpdateTXEncoding();
                    pageUpdate.decode(buffer);
                    return pageUpdate;
                }
                PageTransactionInfoImpl pageTransactionInfo = new PageTransactionInfoImpl();
                pageTransactionInfo.decode(buffer);
                pageTransactionInfo.setRecordID(info.id);
                return pageTransactionInfo;
            }
            case 36: {
                ScheduledDeliveryEncoding encoding = new ScheduledDeliveryEncoding();
                encoding.decode(buffer);
                return encoding;
            }
            case 37: {
                DuplicateIDEncoding encoding = new DuplicateIDEncoding();
                encoding.decode(buffer);
                return encoding;
            }
            case 38: {
                HeuristicCompletionEncoding encoding = new HeuristicCompletionEncoding();
                encoding.decode(buffer);
                return encoding;
            }
            case 39: {
                CursorAckRecordEncoding encoding = new CursorAckRecordEncoding();
                encoding.decode(buffer);
                return encoding;
            }
            case 40: {
                PageCountRecord encoding = new PageCountRecord();
                encoding.decode(buffer);
                return encoding;
            }
            case 42: {
                PageCompleteCursorAckRecordEncoding encoding = new PageCompleteCursorAckRecordEncoding();
                encoding.decode(buffer);
                return encoding;
            }
            case 41: {
                PageCountRecordInc encoding = new PageCountRecordInc();
                encoding.decode(buffer);
                return encoding;
            }
            case 43: {
                PageCountPendingImpl encoding = new PageCountPendingImpl();
                encoding.decode(buffer);
                encoding.setID(info.id);
                return encoding;
            }
            case 22: {
                return AbstractJournalStorageManager.newQueueStatusEncoding(id, buffer);
            }
            case 21: {
                return AbstractJournalStorageManager.newQueueBindingEncoding(id, buffer);
            }
            case 24: {
                BatchingIDGenerator.IDCounterEncoding idReturn = new BatchingIDGenerator.IDCounterEncoding();
                idReturn.decode(buffer);
                return idReturn;
            }
            case 20: {
                return AbstractJournalStorageManager.newGroupEncoding(id, buffer);
            }
            case 25: {
                return AbstractJournalStorageManager.newAddressEncoding(id, buffer);
            }
            case 26: {
                return AbstractJournalStorageManager.newSecurityRecord(id, buffer);
            }
            case 44: {
                return AbstractJournalStorageManager.newAddressBindingEncoding(id, buffer);
            }
            case 46: {
                return AbstractJournalStorageManager.newAddressStatusEncoding(id, buffer);
            }
            case 47: {
                return AbstractJournalStorageManager.newUserEncoding(id, buffer);
            }
            case 48: {
                return AbstractJournalStorageManager.newRoleEncoding(id, buffer);
            }
        }
        return null;
    }

    public static final class ReferenceDescribe {
        public RefEncoding refEncoding;

        public ReferenceDescribe(RefEncoding refEncoding) {
            this.refEncoding = refEncoding;
        }

        public String toString() {
            return "AddRef;" + this.refEncoding;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.refEncoding == null ? 0 : this.refEncoding.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ReferenceDescribe)) {
                return false;
            }
            ReferenceDescribe other = (ReferenceDescribe)obj;
            return !(this.refEncoding == null ? other.refEncoding != null : !this.refEncoding.equals(other.refEncoding));
        }
    }

    public static final class MessageDescribe {
        Message msg;

        public MessageDescribe(Message msg) {
            this.msg = msg;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.msg.isLargeMessage() ? "LargeMessage(" : "Message(");
            buffer.append("messageID=" + this.msg.getMessageID());
            if (this.msg.getUserID() != null) {
                buffer.append(";userMessageID=" + this.msg.getUserID().toString());
            }
            buffer.append(";msg=" + this.msg.toString());
            return buffer.toString();
        }

        public Message getMsg() {
            return this.msg;
        }
    }

    private static final class PageCompleteCursorAckRecordEncoding
    extends CursorAckRecordEncoding {
        private PageCompleteCursorAckRecordEncoding() {
        }

        @Override
        public String toString() {
            return "PGComplete [queueID=" + this.queueID + ", position=" + this.position + "]";
        }
    }
}

