/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.address;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.commands.AbstractAction;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.address.AddressAbstract;

@Command(name="delete", description="Delete an address.")
public class DeleteAddress
extends AddressAbstract {
    @Option(name={"--force"}, description="Delete the address even if it has queues. All messages in those queues will be deleted! Default: false.")
    private Boolean force = false;

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        this.deleteAddress(context);
        return null;
    }

    private void deleteAddress(final ActionContext context) throws Exception {
        this.performCoreManagement(new AbstractAction.ManagementCallback<ClientMessage>(){

            @Override
            public void setUpInvocation(ClientMessage message) throws Exception {
                ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"deleteAddress", (Object[])new Object[]{DeleteAddress.this.getName(true), DeleteAddress.this.force});
            }

            @Override
            public void requestSuccessful(ClientMessage reply) throws Exception {
                context.out.println("Address " + DeleteAddress.this.getName(true) + " deleted successfully.");
            }

            @Override
            public void requestFailed(ClientMessage reply) throws Exception {
                String errMsg = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
                context.err.println("Failed to delete address " + DeleteAddress.this.getName(true) + ". Reason: " + errMsg);
            }
        });
    }

    public void setForce(Boolean force) {
        this.force = force;
    }
}

