/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.mirror;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPMirrorBrokerConnectionElement;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.server.mirror.MirrorController;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessageBrokerAccessor;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManager;
import org.apache.activemq.artemis.protocol.amqp.connect.AMQPBrokerConnection;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerTarget;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorMessageFactory;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.BasicMirrorController;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.MirrorAddressFilter;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.ReferenceNodeStore;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.engine.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPMirrorControllerSource
extends BasicMirrorController<Sender>
implements MirrorController,
ActiveMQComponent {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final Symbol EVENT_TYPE = Symbol.getSymbol((String)"x-opt-amq-mr-ev-type");
    public static final Symbol ACK_REASON = Symbol.getSymbol((String)"x-opt-amq-mr-ack-reason");
    public static final Symbol ADDRESS = Symbol.getSymbol((String)"x-opt-amq-mr-adr");
    public static final Symbol QUEUE = Symbol.getSymbol((String)"x-opt-amq-mr-qu");
    public static final Symbol BROKER_ID = Symbol.getSymbol((String)"x-opt-amq-bkr-id");
    public static final Symbol ADD_ADDRESS = Symbol.getSymbol((String)"addAddress");
    public static final Symbol DELETE_ADDRESS = Symbol.getSymbol((String)"deleteAddress");
    public static final Symbol CREATE_QUEUE = Symbol.getSymbol((String)"createQueue");
    public static final Symbol DELETE_QUEUE = Symbol.getSymbol((String)"deleteQueue");
    public static final Symbol POST_ACK = Symbol.getSymbol((String)"postAck");
    public static final Symbol INTERNAL_ID = Symbol.getSymbol((String)"x-opt-amq-mr-id");
    public static final Symbol INTERNAL_DESTINATION = Symbol.getSymbol((String)"x-opt-amq-mr-dst");
    public static final Symbol TARGET_QUEUES = Symbol.getSymbol((String)"x-opt-amq-mr-trg-q");
    public static final Symbol MIRROR_CAPABILITY = Symbol.getSymbol((String)"amq.mirror");
    public static final Symbol QPID_DISPATCH_WAYPOINT_CAPABILITY = Symbol.valueOf((String)"qd.waypoint");
    public static final SimpleString INTERNAL_ID_EXTRA_PROPERTY = SimpleString.toSimpleString((String)INTERNAL_ID.toString());
    public static final SimpleString INTERNAL_BROKER_ID_EXTRA_PROPERTY = SimpleString.toSimpleString((String)BROKER_ID.toString());
    private static final ThreadLocal<RoutingContext> mirrorControlRouting = ThreadLocal.withInitial(() -> new RoutingContextImpl(null));
    final Queue snfQueue;
    final ActiveMQServer server;
    final ReferenceNodeStore idSupplier;
    final boolean acks;
    final boolean addQueues;
    final boolean deleteQueues;
    final MirrorAddressFilter addressFilter;
    private final AMQPBrokerConnection brokerConnection;
    private final boolean sync;
    final AMQPMirrorBrokerConnectionElement replicaConfig;
    boolean started;

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public boolean isStarted() {
        return this.started;
    }

    public AMQPMirrorControllerSource(ProtonProtocolManager protonProtocolManager, Queue snfQueue, ActiveMQServer server, AMQPMirrorBrokerConnectionElement replicaConfig, AMQPBrokerConnection brokerConnection) {
        super(server);
        this.replicaConfig = replicaConfig;
        this.snfQueue = snfQueue;
        this.server = server;
        this.idSupplier = protonProtocolManager.getReferenceIDSupplier();
        this.addQueues = replicaConfig.isQueueCreation();
        this.deleteQueues = replicaConfig.isQueueRemoval();
        this.addressFilter = new MirrorAddressFilter(replicaConfig.getAddressFilter());
        this.acks = replicaConfig.isMessageAcknowledgements();
        this.brokerConnection = brokerConnection;
        this.sync = replicaConfig.isSync();
    }

    public Queue getSnfQueue() {
        return this.snfQueue;
    }

    public AMQPBrokerConnection getBrokerConnection() {
        return this.brokerConnection;
    }

    public void addAddress(AddressInfo addressInfo) throws Exception {
        logger.trace("{} addAddress {}", (Object)this.server, (Object)addressInfo);
        if (AMQPMirrorControllerTarget.getControllerInUse() != null && !addressInfo.isInternal()) {
            return;
        }
        if (this.ignoreAddress(addressInfo.getName())) {
            return;
        }
        if (this.addQueues) {
            Message message = this.createMessage(addressInfo.getName(), null, ADD_ADDRESS, null, addressInfo.toJSON());
            AMQPMirrorControllerSource.route(this.server, message);
        }
    }

    public void deleteAddress(AddressInfo addressInfo) throws Exception {
        logger.trace("{} deleteAddress {}", (Object)this.server, (Object)addressInfo);
        if (this.invalidTarget(AMQPMirrorControllerTarget.getControllerInUse()) || addressInfo.isInternal()) {
            return;
        }
        if (this.ignoreAddress(addressInfo.getName())) {
            return;
        }
        if (this.deleteQueues) {
            Message message = this.createMessage(addressInfo.getName(), null, DELETE_ADDRESS, null, addressInfo.toJSON());
            AMQPMirrorControllerSource.route(this.server, message);
        }
    }

    public void createQueue(QueueConfiguration queueConfiguration) throws Exception {
        logger.trace("{} createQueue {}", (Object)this.server, (Object)queueConfiguration);
        if (this.invalidTarget(AMQPMirrorControllerTarget.getControllerInUse()) || queueConfiguration.isInternal().booleanValue()) {
            if (logger.isTraceEnabled()) {
                logger.trace("Rejecting ping pong on create {} as isInternal={} and mirror target = {}", new Object[]{queueConfiguration, queueConfiguration.isInternal(), AMQPMirrorControllerTarget.getControllerInUse()});
            }
            return;
        }
        if (this.ignoreAddress(queueConfiguration.getAddress())) {
            if (logger.isTraceEnabled()) {
                logger.trace("Skipping create {}, queue address {} doesn't match filter", (Object)queueConfiguration, (Object)queueConfiguration.getAddress());
            }
            return;
        }
        if (this.addQueues) {
            Message message = this.createMessage(queueConfiguration.getAddress(), queueConfiguration.getName(), CREATE_QUEUE, null, queueConfiguration.toJSON());
            AMQPMirrorControllerSource.route(this.server, message);
        }
    }

    public void deleteQueue(SimpleString address, SimpleString queue) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("{} deleteQueue {}/{}", new Object[]{this.server, address, queue});
        }
        if (this.invalidTarget(AMQPMirrorControllerTarget.getControllerInUse())) {
            return;
        }
        if (this.ignoreAddress(address)) {
            return;
        }
        if (this.deleteQueues) {
            Message message = this.createMessage(address, queue, DELETE_QUEUE, null, queue.toString());
            AMQPMirrorControllerSource.route(this.server, message);
        }
    }

    private boolean invalidTarget(MirrorController controller) {
        return controller != null && this.sameNode(this.getRemoteMirrorId(), controller.getRemoteMirrorId());
    }

    private boolean ignoreAddress(SimpleString address) {
        return !this.addressFilter.match(address);
    }

    private boolean sameNode(String remoteID, String sourceID) {
        return remoteID != null && sourceID != null && remoteID.equals(sourceID);
    }

    public void sendMessage(Transaction tx, Message message, RoutingContext context) {
        SimpleString address = context.getAddress(message);
        if (context.isInternal()) {
            logger.trace("sendMessage::server {} is discarding send to avoid sending to internal queue", (Object)this.server);
            return;
        }
        if (this.invalidTarget(context.getMirrorSource())) {
            logger.trace("sendMessage::server {} is discarding send to avoid infinite loop (reflection with the mirror)", (Object)this.server);
            return;
        }
        if (this.ignoreAddress(address)) {
            logger.trace("sendMessage::server {} is discarding send to address {}, address doesn't match filter", (Object)this.server, (Object)address);
            return;
        }
        logger.trace("sendMessage::{} send message {}", (Object)this.server, (Object)message);
        try {
            context.setReusable(false);
            String nodeID = this.idSupplier.getServerID(message);
            if (nodeID != null && nodeID.equals(this.getRemoteMirrorId())) {
                logger.trace("sendMessage::Message {} already belonged to the node, {}, it won't circle send", (Object)message, (Object)this.getRemoteMirrorId());
                return;
            }
            final MessageReference ref = MessageReference.Factory.createReference((Message)message, (Queue)this.snfQueue);
            AMQPMirrorControllerSource.setProtocolData(ref, nodeID, this.idSupplier.getID(ref), context);
            this.snfQueue.refUp(ref);
            if (tx != null) {
                logger.debug("sendMessage::Mirroring Message {} with TX", (Object)message);
                this.getSendOperation(tx).addRef(ref);
            }
            if (this.sync) {
                OperationContext operContext = OperationContextImpl.getContext((ExecutorFactory)this.server.getExecutorFactory());
                if (tx == null) {
                    operContext.replicationLineUp();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("sendMessage::mirror syncUp context={}, ref={}", (Object)operContext, (Object)ref);
                }
                ref.setProtocolData(OperationContext.class, (Object)operContext);
            }
            if (message.isDurable() && this.snfQueue.isDurable()) {
                PostOfficeImpl.storeDurableReference((StorageManager)this.server.getStorageManager(), (Message)message, (Transaction)context.getTransaction(), (Queue)this.snfQueue, (boolean)true);
            }
            if (tx == null) {
                this.server.getStorageManager().afterStoreOperations(new IOCallback(){

                    public void done() {
                        PostOfficeImpl.processReference((MessageReference)ref, (boolean)false);
                    }

                    public void onError(int errorCode, String errorMessage) {
                    }
                });
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
    }

    private void syncDone(MessageReference reference) {
        OperationContext ctx = (OperationContext)reference.getProtocolData(OperationContext.class);
        if (ctx != null) {
            ctx.replicationDone();
            logger.debug("syncDone::replicationDone::ctx={},ref={}", (Object)ctx, (Object)reference);
        } else {
            Message message = reference.getMessage();
            if (message != null) {
                ctx = (OperationContext)message.getUserContext(OperationContext.class);
                if (ctx != null) {
                    ctx.replicationDone();
                    logger.debug("syncDone::replicationDone message={}", (Object)message);
                } else {
                    logger.trace("syncDone::No operationContext set on message {}", (Object)message);
                }
            } else {
                logger.debug("syncDone::no message set on reference {}", (Object)reference);
            }
        }
    }

    public static void validateProtocolData(ReferenceNodeStore referenceIDSupplier, MessageReference ref, SimpleString snfAddress) {
        if (ref.getProtocolData(DeliveryAnnotations.class) == null && !ref.getMessage().getAddressSimpleString().equals((Object)snfAddress)) {
            AMQPMirrorControllerSource.setProtocolData(referenceIDSupplier, ref);
        }
    }

    private static String setProtocolData(ReferenceNodeStore referenceIDSupplier, MessageReference ref) {
        String brokerID = referenceIDSupplier.getServerID(ref);
        long id = referenceIDSupplier.getID(ref);
        AMQPMirrorControllerSource.setProtocolData(ref, brokerID, id, null);
        return brokerID;
    }

    private static void setProtocolData(MessageReference ref, String brokerID, long id, RoutingContext routingContext) {
        Properties amqpProperties;
        HashMap<Symbol, Object> daMap = new HashMap<Symbol, Object>();
        DeliveryAnnotations deliveryAnnotations = new DeliveryAnnotations(daMap);
        if (brokerID != null) {
            daMap.put(BROKER_ID, brokerID);
        }
        daMap.put(INTERNAL_ID, id);
        String address = ref.getMessage().getAddress();
        if (!(address == null || (amqpProperties = AMQPMirrorControllerSource.getProperties(ref.getMessage())) != null && address.equals(amqpProperties.getTo()))) {
            daMap.put(INTERNAL_DESTINATION, ref.getMessage().getAddress());
        }
        if (routingContext != null && routingContext.isMirrorIndividualRoute()) {
            ArrayList queues = new ArrayList();
            routingContext.forEachDurable(q -> queues.add(String.valueOf(q.getName())));
            daMap.put(TARGET_QUEUES, queues);
        }
        ref.setProtocolData(DeliveryAnnotations.class, (Object)deliveryAnnotations);
    }

    private static Properties getProperties(Message message) {
        if (message instanceof AMQPMessage) {
            return AMQPMessageBrokerAccessor.getCurrentProperties((AMQPMessage)message);
        }
        return null;
    }

    private void postACKInternalMessage(MessageReference reference) {
        logger.debug("postACKInternalMessage::server={}, ref={}", (Object)this.server, (Object)reference);
        if (this.sync) {
            this.syncDone(reference);
        }
    }

    public void postAcknowledge(MessageReference ref, AckReason reason) throws Exception {
        if (!this.acks || ref.getQueue().isMirrorController()) {
            this.postACKInternalMessage(ref);
            return;
        }
    }

    public void preAcknowledge(Transaction tx, final MessageReference ref, AckReason reason) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("postACKInternalMessage::tx={}, ref={}, reason={}", new Object[]{tx, ref, reason});
        }
        MirrorController controllerInUse = AMQPMirrorControllerTarget.getControllerInUse();
        if (!this.acks || ref.getQueue().isMirrorController()) {
            return;
        }
        if (this.invalidTarget(controllerInUse)) {
            return;
        }
        if (ref.getQueue() != null && (ref.getQueue().isInternalQueue() || ref.getQueue().isMirrorController())) {
            if (logger.isDebugEnabled()) {
                logger.debug("preAcknowledge::{} rejecting preAcknowledge queue={}, ref={} to avoid infinite loop with the mirror (reflection)", new Object[]{this.server, ref.getQueue().getName(), ref});
            }
            return;
        }
        if (this.ignoreAddress(ref.getQueue().getAddress())) {
            if (logger.isTraceEnabled()) {
                logger.trace("preAcknowledge::{} rejecting preAcknowledge queue={}, ref={}, queue address is excluded", new Object[]{this.server, ref.getQueue().getName(), ref});
            }
            return;
        }
        logger.trace("preAcknowledge::{} preAcknowledge {}", (Object)this.server, (Object)ref);
        String nodeID = this.idSupplier.getServerID(ref);
        long internalID = this.idSupplier.getID(ref);
        final Message messageCommand = this.createMessage(ref.getQueue().getAddress(), ref.getQueue().getName(), POST_ACK, nodeID, internalID, reason);
        if (this.sync) {
            OperationContext operationContext = OperationContextImpl.getContext((ExecutorFactory)this.server.getExecutorFactory());
            messageCommand.setUserContext(OperationContext.class, (Object)operationContext);
            if (tx == null) {
                operationContext.replicationLineUp();
            }
        }
        if (tx != null) {
            MirrorACKOperation operation = this.getAckOperation(tx);
            operation.addMessage(messageCommand, ref);
        } else {
            this.server.getStorageManager().afterStoreOperations(new IOCallback(){

                public void done() {
                    try {
                        logger.debug("preAcknowledge::afterStoreOperation for messageReference {}", (Object)ref);
                        AMQPMirrorControllerSource.route(AMQPMirrorControllerSource.this.server, messageCommand);
                    }
                    catch (Exception e) {
                        logger.warn(e.getMessage(), (Throwable)e);
                    }
                }

                public void onError(int errorCode, String errorMessage) {
                }
            });
        }
    }

    private MirrorACKOperation getAckOperation(Transaction tx) {
        MirrorACKOperation ackOperation = (MirrorACKOperation)((Object)tx.getProperty(11));
        if (ackOperation == null) {
            logger.trace("getAckOperation::setting operation on transaction {}", (Object)tx);
            ackOperation = new MirrorACKOperation(this.server);
            tx.putProperty(11, (Object)ackOperation);
            tx.afterStore((TransactionOperation)ackOperation);
        }
        return ackOperation;
    }

    private MirrorSendOperation getSendOperation(Transaction tx) {
        if (tx == null) {
            return null;
        }
        MirrorSendOperation sendOperation = (MirrorSendOperation)((Object)tx.getProperty(12));
        if (sendOperation == null) {
            logger.trace("getSendOperation::setting operation on transaction {}", (Object)tx);
            sendOperation = new MirrorSendOperation();
            tx.putProperty(12, (Object)sendOperation);
            tx.afterStore((TransactionOperation)sendOperation);
        }
        return sendOperation;
    }

    private Message createMessage(SimpleString address, SimpleString queue, Object event, String brokerID, Object body) {
        return AMQPMirrorMessageFactory.createMessage(this.snfQueue.getAddress().toString(), address, queue, event, brokerID, body, null);
    }

    private Message createMessage(SimpleString address, SimpleString queue, Object event, String brokerID, Object body, AckReason ackReason) {
        return AMQPMirrorMessageFactory.createMessage(this.snfQueue.getAddress().toString(), address, queue, event, brokerID, body, ackReason);
    }

    public static void route(ActiveMQServer server, Message message) throws Exception {
        message.setMessageID(server.getStorageManager().generateID());
        RoutingContext ctx = mirrorControlRouting.get();
        ctx.clear().setMirrorOption(RoutingContext.MirrorOption.disabled);
        server.getPostOffice().route(message, ctx, false);
    }

    private static final class MirrorSendOperation
    extends TransactionOperationAbstract {
        final List<MessageReference> refs = new ArrayList<MessageReference>();

        private MirrorSendOperation() {
        }

        public void addRef(MessageReference ref) {
            this.refs.add(ref);
        }

        public void beforeCommit(Transaction tx) {
            this.refs.forEach(this::doBeforeCommit);
        }

        private void doBeforeCommit(MessageReference ref) {
            OperationContext context = (OperationContext)ref.getProtocolData(OperationContext.class);
            if (context != null) {
                context.replicationLineUp();
            }
        }

        public void afterRollback(Transaction tx) {
            logger.debug("MirrorSendOperation::afterRollback, refs:{}", this.refs);
            this.refs.forEach(this::doBeforeRollback);
        }

        private void doBeforeRollback(MessageReference ref) {
            OperationContext localCTX = (OperationContext)ref.getProtocolData(OperationContext.class);
            if (localCTX != null) {
                localCTX.replicationDone();
            }
        }

        public void afterCommit(Transaction tx) {
            logger.debug("MirrorSendOperation::afterCommit refs:{}", this.refs);
            this.refs.forEach(this::doAfterCommit);
        }

        private void doAfterCommit(MessageReference ref) {
            PostOfficeImpl.processReference((MessageReference)ref, (boolean)false);
        }
    }

    private static class MirrorACKOperation
    extends TransactionOperationAbstract {
        final ActiveMQServer server;
        final HashMap<Message, MessageReference> acks = new HashMap();

        MirrorACKOperation(ActiveMQServer server) {
            this.server = server;
        }

        public void addMessage(Message message, MessageReference ref) {
            this.acks.put(message, ref);
        }

        public void beforeCommit(Transaction tx) {
            logger.debug("MirrorACKOperation::beforeCommit processing {}", this.acks);
            this.acks.forEach(this::doBeforeCommit);
        }

        private void doBeforeCommit(Message ack, MessageReference ref) {
            OperationContext context = (OperationContext)ack.getUserContext(OperationContext.class);
            if (context != null) {
                context.replicationLineUp();
            }
        }

        public void afterCommit(Transaction tx) {
            logger.debug("MirrorACKOperation::afterCommit processing {}", this.acks);
            this.acks.forEach(this::doAfterCommit);
        }

        private void doAfterCommit(Message ack, MessageReference ref) {
            try {
                AMQPMirrorControllerSource.route(this.server, ack);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
            ref.getMessage().usageDown();
        }

        public void afterRollback(Transaction tx) {
            this.acks.forEach(this::doAfterRollback);
        }

        private void doAfterRollback(Message ack, MessageReference ref) {
            OperationContext context = (OperationContext)ack.getUserContext(OperationContext.class);
            if (context != null) {
                context.replicationDone();
            }
        }
    }
}

