/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttVersion;
import java.util.List;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTFailureListener;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTLogger;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSession;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSessionState;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTUtil;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTVersion;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.impl.ServerSessionImpl;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.UUIDGenerator;

public class MQTTConnectionManager {
    private MQTTSession session;

    public MQTTConnectionManager(MQTTSession session) {
        this.session = session;
        MQTTFailureListener failureListener = new MQTTFailureListener(this);
        session.getConnection().addFailureListener(failureListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connect(MqttConnectMessage connect, String validatedUser, String username, String password) throws Exception {
        MQTTSessionState sessionState;
        if (this.session.getVersion() == MQTTVersion.MQTT_5) {
            this.session.getConnection().setProtocolVersion(Byte.toString(MqttVersion.MQTT_5.protocolLevel()));
            String authenticationMethod = MQTTUtil.getProperty(String.class, connect.variableHeader().properties(), MqttProperties.MqttPropertyType.AUTHENTICATION_METHOD);
            if (authenticationMethod != null) {
                this.session.getProtocolHandler().sendConnack((byte)-116);
                this.disconnect(true);
                return;
            }
        }
        boolean cleanStart = connect.variableHeader().isCleanSession();
        String clientId = this.session.getConnection().getClientID();
        boolean sessionPresent = this.session.getProtocolManager().getSessionStates().containsKey(clientId);
        MQTTSessionState mQTTSessionState = sessionState = this.getSessionState(clientId);
        synchronized (mQTTSessionState) {
            MqttProperties connackProperties;
            this.session.setSessionState(sessionState);
            sessionState.setFailed(false);
            ServerSessionImpl serverSession = this.createServerSession(username, password, validatedUser);
            serverSession.start();
            ServerSessionImpl internalServerSession = this.createServerSession(username, password, validatedUser);
            internalServerSession.disableSecurity();
            internalServerSession.start();
            this.session.setServerSession(serverSession, internalServerSession);
            if (cleanStart) {
                this.session.clean(true);
                this.session.setClean(true);
            }
            if (connect.variableHeader().isWillFlag()) {
                MqttProperties willProperties;
                this.session.getState().setWill(true);
                byte[] willMessage = connect.payload().willMessageInBytes();
                this.session.getState().setWillMessage(ByteBufAllocator.DEFAULT.buffer(willMessage.length).writeBytes(willMessage));
                this.session.getState().setWillQoSLevel(connect.variableHeader().willQos());
                this.session.getState().setWillRetain(connect.variableHeader().isWillRetain());
                this.session.getState().setWillTopic(connect.payload().willTopic());
                if (this.session.getVersion() == MQTTVersion.MQTT_5 && (willProperties = connect.payload().willProperties()) != null) {
                    List userProperties;
                    MqttProperties.MqttProperty willDelayInterval = willProperties.getProperty(MqttProperties.MqttPropertyType.WILL_DELAY_INTERVAL.value());
                    if (willDelayInterval != null) {
                        this.session.getState().setWillDelayInterval(((Integer)willDelayInterval.value()).intValue());
                    }
                    if ((userProperties = willProperties.getProperties(MqttProperties.MqttPropertyType.USER_PROPERTY.value())) != null) {
                        this.session.getState().setWillUserProperties(userProperties);
                    }
                }
            }
            if (this.session.getVersion() == MQTTVersion.MQTT_5) {
                this.session.getConnection().setReceiveMaximum(MQTTUtil.getProperty(Integer.class, connect.variableHeader().properties(), MqttProperties.MqttPropertyType.RECEIVE_MAXIMUM, -1));
                sessionState.setClientSessionExpiryInterval(MQTTUtil.getProperty(Integer.class, connect.variableHeader().properties(), MqttProperties.MqttPropertyType.SESSION_EXPIRY_INTERVAL, 0));
                sessionState.setClientMaxPacketSize(MQTTUtil.getProperty(Integer.class, connect.variableHeader().properties(), MqttProperties.MqttPropertyType.MAXIMUM_PACKET_SIZE, 0));
                sessionState.setClientTopicAliasMaximum(MQTTUtil.getProperty(Integer.class, connect.variableHeader().properties(), MqttProperties.MqttPropertyType.TOPIC_ALIAS_MAXIMUM));
                connackProperties = this.getConnackProperties();
            } else {
                connackProperties = MqttProperties.NO_PROPERTIES;
            }
            this.session.getConnection().setConnected(true);
            this.session.getProtocolHandler().sendConnack((byte)0, sessionPresent && !cleanStart, connackProperties);
            this.session.start();
        }
    }

    private MqttProperties getConnackProperties() {
        MqttProperties connackProperties = new MqttProperties();
        if (this.session.getConnection().isClientIdAssignedByBroker()) {
            connackProperties.add((MqttProperties.MqttProperty)new MqttProperties.StringProperty(MqttProperties.MqttPropertyType.ASSIGNED_CLIENT_IDENTIFIER.value(), this.session.getConnection().getClientID()));
        }
        if (this.session.getProtocolManager().getTopicAliasMaximum() != -1) {
            connackProperties.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.TOPIC_ALIAS_MAXIMUM.value(), Integer.valueOf(this.session.getProtocolManager().getTopicAliasMaximum())));
        }
        if (this.session.isUsingServerKeepAlive()) {
            connackProperties.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SERVER_KEEP_ALIVE.value(), Integer.valueOf(this.session.getProtocolManager().getServerKeepAlive())));
        }
        if (this.session.getProtocolManager().getMaximumPacketSize() != -1) {
            connackProperties.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.MAXIMUM_PACKET_SIZE.value(), Integer.valueOf(this.session.getProtocolManager().getMaximumPacketSize())));
        }
        return connackProperties;
    }

    ServerSessionImpl createServerSession(String username, String password, String validatedUser) throws Exception {
        String id = UUIDGenerator.getInstance().generateStringUUID();
        ActiveMQServer server = this.session.getServer();
        ServerSession serverSession = server.createSession(id, username, password, 102400, (RemotingConnection)this.session.getConnection(), true, true, false, false, null, this.session.getSessionCallback(), false, server.newOperationContext(), this.session.getProtocolManager().getPrefixes(), this.session.getProtocolManager().getSecurityDomain(), validatedUser, false);
        return (ServerSessionImpl)serverSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect(boolean failure) {
        if (this.session == null || this.session.getStopped()) {
            return;
        }
        MQTTSessionState mQTTSessionState = this.session.getState();
        synchronized (mQTTSessionState) {
            try {
                this.session.stop(failure);
                this.session.getConnection().destroy();
            }
            catch (Exception e) {
                MQTTLogger.LOGGER.errorDisconnectingClient(e);
            }
            finally {
                String clientId;
                if (this.session.getState() != null && (clientId = this.session.getState().getClientId()) != null && this.session.getProtocolManager().isClientConnected(clientId, this.session.getConnection())) {
                    this.session.getProtocolManager().removeConnectedClient(clientId);
                }
            }
        }
    }

    private synchronized MQTTSessionState getSessionState(String clientId) {
        return this.session.getProtocolManager().getSessionState(clientId);
    }
}

