/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.dto;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.activemq.artemis.dto.AppDTO;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;

@XmlRootElement(name="binding")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BindingDTO {
    @XmlAttribute
    public String uri;
    @XmlElementRef
    public List<AppDTO> apps;
    @XmlAttribute
    public Boolean clientAuth;
    @XmlAttribute
    public String passwordCodec;
    @XmlAttribute
    public String keyStorePath;
    @XmlAttribute
    public String trustStorePath;
    @XmlAttribute
    private String includedTLSProtocols;
    @XmlAttribute
    private String excludedTLSProtocols;
    @XmlAttribute
    private String includedCipherSuites;
    @XmlAttribute
    private String excludedCipherSuites;
    @XmlAttribute
    private String keyStorePassword;
    @XmlAttribute
    private String trustStorePassword;

    public String getKeyStorePassword() throws Exception {
        return this.getPassword(this.keyStorePassword);
    }

    private String getPassword(String password) throws Exception {
        return PasswordMaskingUtil.resolveMask((String)password, (String)this.passwordCodec);
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getTrustStorePassword() throws Exception {
        return this.getPassword(this.trustStorePassword);
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String[] getIncludedTLSProtocols() {
        return this.unmarshalArray(this.includedTLSProtocols);
    }

    public void setIncludedTLSProtocols(String ... protocols) {
        this.includedTLSProtocols = this.marshalArray(protocols);
    }

    public String[] getExcludedTLSProtocols() {
        return this.unmarshalArray(this.excludedTLSProtocols);
    }

    public void setExcludedTLSProtocols(String ... protocols) {
        this.excludedTLSProtocols = this.marshalArray(protocols);
    }

    public String[] getIncludedCipherSuites() {
        return this.unmarshalArray(this.includedCipherSuites);
    }

    public void setIncludedCipherSuites(String ... cipherSuites) {
        this.includedCipherSuites = this.marshalArray(cipherSuites);
    }

    public String[] getExcludedCipherSuites() {
        return this.unmarshalArray(this.excludedCipherSuites);
    }

    public void setExcludedCipherSuites(String ... cipherSuites) {
        this.excludedCipherSuites = this.marshalArray(cipherSuites);
    }

    private String[] unmarshalArray(String text) {
        if (text == null) {
            return null;
        }
        return text.split(",");
    }

    private String marshalArray(String[] array) {
        if (array == null || array.length == 1 && array[0] == null) {
            return null;
        }
        return String.join((CharSequence)",", array);
    }
}

