/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.openwire;

import com.google.common.io.BaseEncoding;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.InflaterOutputStream;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireConstants;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQConsumer;
import org.apache.activemq.artemis.core.protocol.openwire.util.OpenWireUtil;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMapMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.command.ActiveMQStreamMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.util.ByteArrayInputStream;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.ByteSequenceData;
import org.apache.activemq.util.MarshallingSupport;
import org.apache.activemq.wireformat.WireFormat;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenWireMessageConverter {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static Message inbound(org.apache.activemq.command.Message messageSend, WireFormat marshaller, CoreMessageObjectPools coreMessageObjectPools) throws Exception {
        Object scheduledDelay;
        String userId;
        String groupId;
        DataStructure ds;
        BrokerId[] cluster;
        CoreMessage coreMessage = new CoreMessage(-1L, messageSend.getSize(), coreMessageObjectPools);
        String type = messageSend.getType();
        if (type != null) {
            coreMessage.putStringProperty(OpenWireConstants.JMS_TYPE_PROPERTY, new SimpleString(type));
        }
        coreMessage.setDurable(messageSend.isPersistent());
        coreMessage.setExpiration(messageSend.getExpiration());
        coreMessage.setPriority(messageSend.getPriority());
        coreMessage.setTimestamp(messageSend.getTimestamp());
        byte coreType = OpenWireMessageConverter.toCoreType(messageSend.getDataStructureType());
        coreMessage.setType(coreType);
        ActiveMQBuffer body = coreMessage.getBodyBuffer();
        ByteSequence contents = messageSend.getContent();
        if (contents == null && coreType == 3) {
            body.writeNullableString(null);
        } else if (contents != null) {
            boolean messageCompressed = messageSend.isCompressed();
            if (messageCompressed) {
                coreMessage.putBooleanProperty(OpenWireConstants.AMQ_MSG_COMPRESSED, true);
            }
            switch (coreType) {
                case 3: {
                    OpenWireMessageConverter.writeTextType(contents, messageCompressed, body);
                    break;
                }
                case 5: {
                    OpenWireMessageConverter.writeMapType(contents, messageCompressed, body);
                    break;
                }
                case 2: {
                    OpenWireMessageConverter.writeObjectType(contents, messageCompressed, body);
                    break;
                }
                case 6: {
                    OpenWireMessageConverter.writeStreamType(contents, messageCompressed, body);
                    break;
                }
                case 4: {
                    OpenWireMessageConverter.writeBytesType(contents, messageCompressed, body);
                    break;
                }
                default: {
                    OpenWireMessageConverter.writeDefaultType(contents, messageCompressed, body);
                }
            }
        }
        coreMessage.putLongProperty(OpenWireConstants.AMQ_MSG_ARRIVAL, messageSend.getArrival());
        coreMessage.putLongProperty(OpenWireConstants.AMQ_MSG_BROKER_IN_TIME, messageSend.getBrokerInTime());
        BrokerId[] brokers = messageSend.getBrokerPath();
        if (brokers != null) {
            OpenWireMessageConverter.putMsgBrokerPath(brokers, coreMessage);
        }
        if ((cluster = messageSend.getCluster()) != null) {
            OpenWireMessageConverter.putMsgCluster(cluster, coreMessage);
        }
        coreMessage.putIntProperty(OpenWireConstants.AMQ_MSG_COMMAND_ID, messageSend.getCommandId());
        String corrId = messageSend.getCorrelationId();
        if (corrId != null) {
            coreMessage.putStringProperty(OpenWireConstants.JMS_CORRELATION_ID_PROPERTY, new SimpleString(corrId));
        }
        if ((ds = messageSend.getDataStructure()) != null) {
            OpenWireMessageConverter.putMsgDataStructure(ds, marshaller, coreMessage);
        }
        if ((groupId = messageSend.getGroupID()) != null) {
            coreMessage.setGroupID(groupId);
        }
        coreMessage.setGroupSequence(messageSend.getGroupSequence());
        MessageId messageId = messageSend.getMessageId();
        if (messageId != null) {
            coreMessage.putStringProperty(OpenWireConstants.AMQ_MSG_MESSAGE_ID, SimpleString.toSimpleString((String)messageId.toString()));
        }
        coreMessage.setUserID(UUIDGenerator.getInstance().generateUUID());
        ProducerId producerId = messageSend.getProducerId();
        if (producerId != null) {
            coreMessage.putStringProperty(OpenWireConstants.AMQ_MSG_PRODUCER_ID, SimpleString.toSimpleString((String)producerId.toString()));
        }
        OpenWireMessageConverter.putMsgProperties(messageSend, coreMessage);
        ActiveMQDestination replyTo = messageSend.getReplyTo();
        if (replyTo != null) {
            if (replyTo instanceof TemporaryQueue) {
                MessageUtil.setJMSReplyTo((Message)coreMessage, (String)("temp-queue://" + ((TemporaryQueue)replyTo).getQueueName()));
            } else if (replyTo instanceof TemporaryTopic) {
                MessageUtil.setJMSReplyTo((Message)coreMessage, (String)("temp-topic://" + ((TemporaryTopic)replyTo).getTopicName()));
            } else if (replyTo instanceof Queue) {
                MessageUtil.setJMSReplyTo((Message)coreMessage, (String)("queue://" + ((Queue)replyTo).getQueueName()));
            } else if (replyTo instanceof Topic) {
                MessageUtil.setJMSReplyTo((Message)coreMessage, (String)("topic://" + ((Topic)replyTo).getTopicName()));
            } else {
                MessageUtil.setJMSReplyTo((Message)coreMessage, (String)("queue://" + ((Queue)replyTo).getQueueName()));
            }
        }
        if ((userId = messageSend.getUserID()) != null) {
            coreMessage.putStringProperty(OpenWireConstants.AMQ_MSG_USER_ID, new SimpleString(userId));
        }
        coreMessage.putBooleanProperty(OpenWireConstants.AMQ_MSG_DROPPABLE, messageSend.isDroppable());
        ActiveMQDestination origDest = messageSend.getOriginalDestination();
        if (origDest != null) {
            coreMessage.putStringProperty(OpenWireConstants.AMQ_MSG_ORIG_DESTINATION, origDest.getQualifiedName());
        }
        if ((scheduledDelay = messageSend.getProperties().get("AMQ_SCHEDULED_DELAY")) instanceof Long) {
            coreMessage.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, System.currentTimeMillis() + (Long)scheduledDelay);
            coreMessage.removeProperty("AMQ_SCHEDULED_DELAY");
        }
        return coreMessage;
    }

    private static void writeTextType(ByteSequence contents, boolean messageCompressed, ActiveMQBuffer body) throws IOException {
        Object tis = new ByteArrayInputStream(contents);
        if (messageCompressed) {
            tis = new InflaterInputStream((InputStream)tis);
        }
        DataInputStream tdataIn = new DataInputStream((InputStream)tis);
        String text = MarshallingSupport.readUTF8((DataInput)tdataIn);
        tdataIn.close();
        body.writeNullableSimpleString(new SimpleString(text));
    }

    private static void writeMapType(ByteSequence contents, boolean messageCompressed, ActiveMQBuffer body) throws IOException {
        Object mis = new ByteArrayInputStream(contents);
        if (messageCompressed) {
            mis = new InflaterInputStream((InputStream)mis);
        }
        DataInputStream mdataIn = new DataInputStream((InputStream)mis);
        Map map = MarshallingSupport.unmarshalPrimitiveMap((DataInputStream)mdataIn);
        mdataIn.close();
        TypedProperties props = new TypedProperties();
        OpenWireMessageConverter.loadMapIntoProperties(props, map);
        props.encode(body.byteBuf());
    }

    private static void writeObjectType(ByteSequence contents, boolean messageCompressed, ActiveMQBuffer body) throws IOException {
        if (messageCompressed) {
            contents = OpenWireMessageConverter.writeCompressedObjectType(contents);
        }
        body.writeInt(contents.length);
        body.writeBytes(contents.data, contents.offset, contents.length);
    }

    private static ByteSequence writeCompressedObjectType(ByteSequence contents) throws IOException {
        try (InflaterInputStream ois = new InflaterInputStream((InputStream)new ByteArrayInputStream(contents));){
            ByteSequence byteSequence;
            try (ByteArrayOutputStream decompressed = new ByteArrayOutputStream();){
                byte[] buf = new byte[1024];
                int n = ((InputStream)ois).read(buf);
                while (n != -1) {
                    decompressed.write(buf, 0, n);
                    n = ((InputStream)ois).read();
                }
                byteSequence = decompressed.toByteSequence();
            }
            return byteSequence;
        }
    }

    private static void writeStreamType(ByteSequence contents, boolean messageCompressed, ActiveMQBuffer body) throws IOException {
        Object sis = new ByteArrayInputStream(contents);
        if (messageCompressed) {
            sis = new InflaterInputStream((InputStream)sis);
        }
        DataInputStream sdis = new DataInputStream((InputStream)sis);
        int stype = sdis.read();
        while (stype != -1) {
            switch (stype) {
                case 1: {
                    body.writeByte((byte)2);
                    body.writeBoolean(sdis.readBoolean());
                    break;
                }
                case 2: {
                    body.writeByte((byte)3);
                    body.writeByte(sdis.readByte());
                    break;
                }
                case 10: {
                    body.writeByte((byte)4);
                    int slen = sdis.readInt();
                    byte[] sbytes = new byte[slen];
                    sdis.read(sbytes);
                    body.writeInt(slen);
                    body.writeBytes(sbytes);
                    break;
                }
                case 3: {
                    body.writeByte((byte)11);
                    char schar = sdis.readChar();
                    body.writeShort((short)schar);
                    break;
                }
                case 7: {
                    body.writeByte((byte)9);
                    double sdouble = sdis.readDouble();
                    body.writeLong(Double.doubleToLongBits(sdouble));
                    break;
                }
                case 8: {
                    body.writeByte((byte)8);
                    float sfloat = sdis.readFloat();
                    body.writeInt(Float.floatToIntBits(sfloat));
                    break;
                }
                case 5: {
                    body.writeByte((byte)6);
                    body.writeInt(sdis.readInt());
                    break;
                }
                case 6: {
                    body.writeByte((byte)7);
                    body.writeLong(sdis.readLong());
                    break;
                }
                case 4: {
                    body.writeByte((byte)5);
                    body.writeShort(sdis.readShort());
                    break;
                }
                case 9: {
                    body.writeByte((byte)10);
                    String sstring = sdis.readUTF();
                    body.writeNullableString(sstring);
                    break;
                }
                case 13: {
                    body.writeByte((byte)10);
                    String sbigString = MarshallingSupport.readUTF8((DataInput)sdis);
                    body.writeNullableString(sbigString);
                    break;
                }
                case 0: {
                    body.writeByte((byte)10);
                    body.writeNullableString(null);
                    break;
                }
            }
            stype = sdis.read();
        }
        sdis.close();
    }

    private static void writeBytesType(ByteSequence contents, boolean messageCompressed, ActiveMQBuffer body) throws IOException {
        if (messageCompressed) {
            contents = OpenWireMessageConverter.writeCompressedBytesType(contents);
        }
        body.writeBytes(contents.data, contents.offset, contents.length);
    }

    private static ByteSequence writeCompressedBytesType(ByteSequence contents) throws IOException {
        Inflater inflater = new Inflater();
        try {
            ByteSequence byteSequence;
            ByteArrayOutputStream decompressed = new ByteArrayOutputStream();
            try {
                int length = ByteSequenceData.readIntBig((ByteSequence)contents);
                contents.offset = 0;
                byte[] data = Arrays.copyOfRange(contents.getData(), 4, contents.getLength());
                inflater.setInput(data);
                byte[] buffer = new byte[length];
                int count = inflater.inflate(buffer);
                decompressed.write(buffer, 0, count);
                byteSequence = decompressed.toByteSequence();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        decompressed.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            decompressed.close();
            return byteSequence;
        }
        finally {
            inflater.end();
        }
    }

    private static void writeDefaultType(ByteSequence contents, boolean messageCompressed, ActiveMQBuffer body) throws IOException {
        if (messageCompressed) {
            contents = OpenWireMessageConverter.writeCompressedDefaultType(contents);
        }
        body.writeBytes(contents.data, contents.offset, contents.length);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static ByteSequence writeCompressedDefaultType(ByteSequence contents) throws IOException {
        try (ByteArrayOutputStream decompressed = new ByteArrayOutputStream();){
            ByteSequence byteSequence;
            try (InflaterOutputStream os = new InflaterOutputStream((OutputStream)decompressed);){
                ((OutputStream)os).write(contents.data, contents.offset, contents.getLength());
                byteSequence = decompressed.toByteSequence();
            }
            return byteSequence;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static void putMsgBrokerPath(BrokerId[] brokers, CoreMessage coreMessage) {
        StringBuilder builder = new StringBuilder();
        int size = brokers.length;
        for (int i = 0; i < size; ++i) {
            builder.append(brokers[i].getValue());
            if (i == size - 1) continue;
            builder.append(',');
        }
        coreMessage.putStringProperty(OpenWireConstants.AMQ_MSG_BROKER_PATH, new SimpleString(builder.toString()));
    }

    private static void putMsgCluster(BrokerId[] cluster, CoreMessage coreMessage) {
        StringBuilder builder = new StringBuilder();
        int size = cluster.length;
        for (int i = 0; i < size; ++i) {
            builder.append(cluster[i].getValue());
            if (i == size - 1) continue;
            builder.append(',');
        }
        coreMessage.putStringProperty(OpenWireConstants.AMQ_MSG_CLUSTER, new SimpleString(builder.toString()));
    }

    private static void putMsgDataStructure(DataStructure ds, WireFormat marshaller, CoreMessage coreMessage) throws IOException {
        ByteSequence dsBytes = marshaller.marshal((Object)ds);
        dsBytes.compact();
        coreMessage.putBytesProperty(OpenWireConstants.AMQ_MSG_DATASTRUCTURE, dsBytes.data);
    }

    private static void putMsgProperties(org.apache.activemq.command.Message messageSend, CoreMessage coreMessage) throws IOException {
        Map props = messageSend.getProperties();
        if (!props.isEmpty()) {
            props.forEach((key, value) -> {
                try {
                    if (value instanceof UTF8Buffer) {
                        coreMessage.putObjectProperty(key, (Object)value.toString());
                    } else {
                        coreMessage.putObjectProperty(key, value);
                    }
                }
                catch (ActiveMQPropertyConversionException e) {
                    coreMessage.putStringProperty(key, value.toString());
                }
            });
        }
    }

    private static void loadMapIntoProperties(TypedProperties props, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            SimpleString key = new SimpleString(entry.getKey());
            Object value = entry.getValue();
            if (value instanceof UTF8Buffer) {
                value = value.toString();
            }
            TypedProperties.setObjectProperty((SimpleString)key, (Object)value, (TypedProperties)props);
        }
    }

    public static byte toCoreType(byte amqType) {
        switch (amqType) {
            case 29: {
                throw new IllegalStateException("We don't support BLOB type yet!");
            }
            case 24: {
                return 4;
            }
            case 25: {
                return 5;
            }
            case 26: {
                return 2;
            }
            case 27: {
                return 6;
            }
            case 28: {
                return 3;
            }
            case 23: {
                return 0;
            }
        }
        throw new IllegalStateException("Unknown ActiveMQ Artemis message type: " + amqType);
    }

    public static MessageDispatch createMessageDispatch(MessageReference reference, ICoreMessage message, WireFormat marshaller, AMQConsumer consumer, UUID serverNodeUUID) throws IOException {
        ActiveMQMessage amqMessage = OpenWireMessageConverter.toAMQMessage(reference, message, marshaller, consumer, serverNodeUUID);
        amqMessage.getMessageId().setBrokerSequenceId(message.getMessageID());
        MessageDispatch md = new MessageDispatch();
        md.setConsumerId(consumer.getId());
        md.setRedeliveryCounter(reference.getDeliveryCount() - 1);
        md.setDeliverySequenceId(amqMessage.getMessageId().getBrokerSequenceId());
        md.setMessage((org.apache.activemq.command.Message)amqMessage);
        ActiveMQDestination destination = amqMessage.getDestination();
        md.setDestination(destination);
        return md;
    }

    private static ActiveMQMessage toAMQMessage(MessageReference reference, ICoreMessage coreMessage, WireFormat marshaller, AMQConsumer consumer, UUID serverNodeUUID) throws IOException {
        Set props;
        Long ingressTimestamp;
        SimpleString lastValueProperty;
        SimpleString dlqCause;
        Boolean isDroppable;
        MessageId messageId;
        byte[] dsBytes;
        Integer commandId;
        SimpleString clusterPath;
        byte[] bytes;
        Object amqMsg;
        byte coreType = coreMessage.getType();
        Boolean compressProp = OpenWireMessageConverter.getObjectProperty(coreMessage, Boolean.class, OpenWireConstants.AMQ_MSG_COMPRESSED);
        boolean isCompressed = compressProp != null && compressProp != false;
        ActiveMQBuffer buffer = coreMessage.getDataBuffer();
        buffer.resetReaderIndex();
        switch (coreType) {
            case 4: {
                amqMsg = new EagerActiveMQBytesMessage(0);
                bytes = OpenWireMessageConverter.toAMQMessageBytesType(buffer, isCompressed);
                break;
            }
            case 5: {
                amqMsg = new ActiveMQMapMessage();
                bytes = OpenWireMessageConverter.toAMQMessageMapType(buffer, isCompressed);
                break;
            }
            case 2: {
                amqMsg = new ActiveMQObjectMessage();
                bytes = OpenWireMessageConverter.toAMQMessageObjectType(buffer, isCompressed);
                break;
            }
            case 6: {
                amqMsg = new ActiveMQStreamMessage();
                bytes = OpenWireMessageConverter.toAMQMessageStreamType(buffer, isCompressed);
                break;
            }
            case 3: {
                amqMsg = new ActiveMQTextMessage();
                bytes = OpenWireMessageConverter.toAMQMessageTextType(buffer, isCompressed);
                break;
            }
            case 0: {
                amqMsg = new ActiveMQMessage();
                bytes = OpenWireMessageConverter.toAMQMessageDefaultType(buffer, isCompressed);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown message type: " + coreMessage.getType());
            }
        }
        String type = OpenWireMessageConverter.getObjectProperty(coreMessage, String.class, OpenWireConstants.JMS_TYPE_PROPERTY);
        if (type != null) {
            amqMsg.setJMSType(type);
        }
        amqMsg.setPersistent(coreMessage.isDurable());
        amqMsg.setExpiration(coreMessage.getExpiration());
        amqMsg.setPriority(coreMessage.getPriority());
        amqMsg.setTimestamp(coreMessage.getTimestamp());
        Long brokerInTime = OpenWireMessageConverter.getObjectProperty(coreMessage, Long.class, OpenWireConstants.AMQ_MSG_BROKER_IN_TIME);
        if (brokerInTime == null) {
            brokerInTime = 0L;
        }
        amqMsg.setBrokerInTime(brokerInTime.longValue());
        amqMsg.setCompressed(isCompressed);
        Long arrival = OpenWireMessageConverter.getObjectProperty(coreMessage, Long.class, OpenWireConstants.AMQ_MSG_ARRIVAL);
        if (arrival == null) {
            arrival = 0L;
        }
        amqMsg.setArrival(arrival.longValue());
        SimpleString brokerPath = OpenWireMessageConverter.getObjectProperty(coreMessage, SimpleString.class, OpenWireConstants.AMQ_MSG_BROKER_PATH);
        if (brokerPath != null && brokerPath.length() > 0) {
            OpenWireMessageConverter.setAMQMsgBrokerPath((ActiveMQMessage)amqMsg, brokerPath.toString());
        }
        if ((clusterPath = OpenWireMessageConverter.getObjectProperty(coreMessage, SimpleString.class, OpenWireConstants.AMQ_MSG_CLUSTER)) != null && clusterPath.length() > 0) {
            OpenWireMessageConverter.setAMQMsgClusterPath((ActiveMQMessage)amqMsg, clusterPath.toString());
        }
        if ((commandId = OpenWireMessageConverter.getObjectProperty(coreMessage, Integer.class, OpenWireConstants.AMQ_MSG_COMMAND_ID)) == null) {
            commandId = -1;
        }
        amqMsg.setCommandId(commandId.intValue());
        SimpleString corrId = OpenWireMessageConverter.getObjectProperty(coreMessage, SimpleString.class, OpenWireConstants.JMS_CORRELATION_ID_PROPERTY);
        if (corrId != null) {
            amqMsg.setCorrelationId(corrId.toString());
        }
        if ((dsBytes = OpenWireMessageConverter.getObjectProperty(coreMessage, byte[].class, OpenWireConstants.AMQ_MSG_DATASTRUCTURE)) != null) {
            OpenWireMessageConverter.setAMQMsgDataStructure((ActiveMQMessage)amqMsg, marshaller, dsBytes);
        }
        ActiveMQDestination actualDestination = consumer.getOpenwireDestination();
        amqMsg.setDestination(OpenWireUtil.toAMQAddress((Message)coreMessage, actualDestination));
        SimpleString value = coreMessage.getGroupID();
        if (value != null) {
            String groupId = value.toString();
            amqMsg.setGroupID(groupId);
        }
        amqMsg.setGroupSequence(coreMessage.getGroupSequence());
        Object messageIdValue = OpenWireMessageConverter.getObjectProperty(coreMessage, Object.class, OpenWireConstants.AMQ_MSG_MESSAGE_ID);
        if (messageIdValue instanceof SimpleString) {
            messageId = new MessageId(messageIdValue.toString());
        } else if (messageIdValue instanceof byte[]) {
            ByteSequence midSeq = new ByteSequence((byte[])messageIdValue);
            messageId = (MessageId)marshaller.unmarshal(midSeq);
        } else {
            String midd = "ID:" + serverNodeUUID + ":-1:-1:" + coreMessage.getMessageID() / Integer.MAX_VALUE;
            messageId = new MessageId(midd, coreMessage.getMessageID() % Integer.MAX_VALUE);
        }
        amqMsg.setMessageId(messageId);
        Object origDestValue = OpenWireMessageConverter.getObjectProperty(coreMessage, Object.class, OpenWireConstants.AMQ_MSG_ORIG_DESTINATION);
        if (origDestValue instanceof SimpleString) {
            amqMsg.setOriginalDestination(ActiveMQDestination.createDestination((String)origDestValue.toString(), (byte)1));
        } else if (origDestValue instanceof byte[]) {
            ActiveMQDestination origDest = (ActiveMQDestination)marshaller.unmarshal(new ByteSequence((byte[])origDestValue));
            amqMsg.setOriginalDestination(origDest);
        }
        Object producerIdValue = OpenWireMessageConverter.getObjectProperty(coreMessage, Object.class, OpenWireConstants.AMQ_MSG_PRODUCER_ID);
        if (producerIdValue instanceof SimpleString && ((SimpleString)producerIdValue).length() > 0) {
            amqMsg.setProducerId(new ProducerId(producerIdValue.toString()));
        } else if (producerIdValue instanceof byte[]) {
            ProducerId producerId = (ProducerId)marshaller.unmarshal(new ByteSequence((byte[])producerIdValue));
            amqMsg.setProducerId(producerId);
        }
        amqMsg.setRedeliveryCounter(reference.getDeliveryCount() - 1);
        Object replyToValue = OpenWireMessageConverter.getObjectProperty(coreMessage, Object.class, OpenWireConstants.AMQ_MSG_REPLY_TO);
        if (replyToValue instanceof SimpleString) {
            amqMsg.setReplyTo(ActiveMQDestination.createDestination((String)replyToValue.toString(), (byte)1));
        } else if (replyToValue instanceof byte[]) {
            ActiveMQDestination replyTo = (ActiveMQDestination)marshaller.unmarshal(new ByteSequence((byte[])replyToValue));
            amqMsg.setReplyTo(replyTo);
        }
        SimpleString userId = OpenWireMessageConverter.getObjectProperty(coreMessage, SimpleString.class, OpenWireConstants.AMQ_MSG_USER_ID);
        if (userId != null && userId.length() > 0) {
            amqMsg.setUserID(userId.toString());
        }
        if ((isDroppable = OpenWireMessageConverter.getObjectProperty(coreMessage, Boolean.class, OpenWireConstants.AMQ_MSG_DROPPABLE)) != null) {
            amqMsg.setDroppable(isDroppable.booleanValue());
        }
        if ((dlqCause = OpenWireMessageConverter.getObjectProperty(coreMessage, SimpleString.class, OpenWireConstants.AMQ_MSG_DLQ_DELIVERY_FAILURE_CAUSE_PROPERTY)) != null) {
            OpenWireMessageConverter.setAMQMsgDlqDeliveryFailureCause((ActiveMQMessage)amqMsg, dlqCause);
        }
        if ((lastValueProperty = coreMessage.getLastValueProperty()) != null) {
            OpenWireMessageConverter.setAMQMsgHdrLastValueName((ActiveMQMessage)amqMsg, lastValueProperty);
        }
        if ((ingressTimestamp = OpenWireMessageConverter.getObjectProperty(coreMessage, Long.class, Message.HDR_INGRESS_TIMESTAMP)) != null) {
            OpenWireMessageConverter.setAMQMsgHdrIngressTimestamp((ActiveMQMessage)amqMsg, ingressTimestamp);
        }
        if ((props = coreMessage.getPropertyNames()) != null) {
            OpenWireMessageConverter.setAMQMsgObjectProperties((ActiveMQMessage)amqMsg, coreMessage, props);
        }
        if (bytes != null) {
            ByteSequence content = new ByteSequence(bytes);
            amqMsg.setContent(content);
        }
        return amqMsg;
    }

    private static <T> T getObjectProperty(ICoreMessage message, Class<T> type, SimpleString property) {
        if (message.getPropertyNames().contains(property)) {
            try {
                Object value = message.getObjectProperty(property);
                if (type == String.class && value != null) {
                    return (T)value.toString();
                }
                return type.cast(value);
            }
            catch (ClassCastException e) {
                ActiveMQServerLogger.LOGGER.failedToDealWithObjectProperty(property, e.getMessage());
            }
        }
        return null;
    }

    private static byte[] toAMQMessageTextType(ActiveMQBuffer buffer, boolean isCompressed) throws IOException {
        byte[] bytes = null;
        SimpleString text = buffer.readNullableSimpleString();
        if (text != null) {
            java.io.ByteArrayOutputStream bytesOut;
            OutputStream out = bytesOut = new java.io.ByteArrayOutputStream(text.length() + 4);
            if (isCompressed) {
                out = new DeflaterOutputStream(out, true);
            }
            try (DataOutputStream dataOut = new DataOutputStream(out);){
                MarshallingSupport.writeUTF8((DataOutput)dataOut, (String)text.toString());
                dataOut.flush();
                bytes = bytesOut.toByteArray();
            }
        }
        return bytes;
    }

    private static byte[] toAMQMessageMapType(ActiveMQBuffer buffer, boolean isCompressed) throws IOException {
        byte[] bytes = null;
        if (buffer.readableBytes() > 0) {
            java.io.ByteArrayOutputStream out;
            TypedProperties mapData = new TypedProperties();
            mapData.decode(buffer.byteBuf());
            Map map = mapData.getMap();
            OutputStream os = out = new java.io.ByteArrayOutputStream(mapData.getEncodeSize());
            if (isCompressed) {
                os = new DeflaterOutputStream(os, true);
            }
            try (DataOutputStream dataOut = new DataOutputStream(os);){
                MarshallingSupport.marshalPrimitiveMap((Map)map, (DataOutputStream)dataOut);
                dataOut.flush();
            }
            bytes = out.toByteArray();
        }
        return bytes;
    }

    private static byte[] toAMQMessageObjectType(ActiveMQBuffer buffer, boolean isCompressed) throws IOException {
        byte[] bytes = null;
        if (buffer.readableBytes() > 0) {
            int len = buffer.readInt();
            bytes = new byte[len];
            buffer.readBytes(bytes);
            if (isCompressed) {
                java.io.ByteArrayOutputStream bytesOut = new java.io.ByteArrayOutputStream();
                try (DeflaterOutputStream out = new DeflaterOutputStream((OutputStream)bytesOut, true);){
                    out.write(bytes);
                    out.flush();
                }
                bytes = bytesOut.toByteArray();
            }
        }
        return bytes;
    }

    private static byte[] toAMQMessageStreamType(ActiveMQBuffer buffer, boolean isCompressed) throws IOException {
        ByteArrayOutputStream bytesOut;
        Object out = bytesOut = new ByteArrayOutputStream();
        if (isCompressed) {
            out = new DeflaterOutputStream((OutputStream)bytesOut, true);
        }
        try (DataOutputStream dataOut = new DataOutputStream((OutputStream)out);){
            boolean stop = false;
            while (!stop && buffer.readable()) {
                byte primitiveType = buffer.readByte();
                switch (primitiveType) {
                    case 2: {
                        MarshallingSupport.marshalBoolean((DataOutputStream)dataOut, (boolean)buffer.readBoolean());
                        break;
                    }
                    case 3: {
                        MarshallingSupport.marshalByte((DataOutputStream)dataOut, (byte)buffer.readByte());
                        break;
                    }
                    case 4: {
                        int len = buffer.readInt();
                        byte[] bytesData = new byte[len];
                        buffer.readBytes(bytesData);
                        MarshallingSupport.marshalByteArray((DataOutputStream)dataOut, (byte[])bytesData);
                        break;
                    }
                    case 11: {
                        char ch = (char)buffer.readShort();
                        MarshallingSupport.marshalChar((DataOutputStream)dataOut, (char)ch);
                        break;
                    }
                    case 9: {
                        double doubleVal = Double.longBitsToDouble(buffer.readLong());
                        MarshallingSupport.marshalDouble((DataOutputStream)dataOut, (double)doubleVal);
                        break;
                    }
                    case 8: {
                        float floatVal = Float.intBitsToFloat(buffer.readInt());
                        MarshallingSupport.marshalFloat((DataOutputStream)dataOut, (float)floatVal);
                        break;
                    }
                    case 6: {
                        MarshallingSupport.marshalInt((DataOutputStream)dataOut, (int)buffer.readInt());
                        break;
                    }
                    case 7: {
                        MarshallingSupport.marshalLong((DataOutputStream)dataOut, (long)buffer.readLong());
                        break;
                    }
                    case 5: {
                        MarshallingSupport.marshalShort((DataOutputStream)dataOut, (short)buffer.readShort());
                        break;
                    }
                    case 10: {
                        String string = buffer.readNullableString();
                        if (string == null) {
                            MarshallingSupport.marshalNull((DataOutputStream)dataOut);
                            break;
                        }
                        MarshallingSupport.marshalString((DataOutputStream)dataOut, (String)string);
                        break;
                    }
                    default: {
                        stop = true;
                    }
                }
                dataOut.flush();
            }
        }
        byte[] bytes = bytesOut.toByteArray();
        return bytes;
    }

    private static byte[] toAMQMessageBytesType(ActiveMQBuffer buffer, boolean isCompressed) throws IOException {
        int n = buffer.readableBytes();
        byte[] bytes = new byte[n];
        buffer.readBytes(bytes);
        if (isCompressed) {
            bytes = OpenWireMessageConverter.toAMQMessageCompressedBytesType(bytes);
        }
        return bytes;
    }

    private static byte[] toAMQMessageCompressedBytesType(byte[] bytes) throws IOException {
        int length = bytes.length;
        Deflater deflater = new Deflater();
        try {
            byte[] byArray;
            try (ByteArrayOutputStream compressed = new ByteArrayOutputStream();){
                compressed.write(new byte[4]);
                deflater.setInput(bytes);
                deflater.finish();
                byte[] bytesBuf = new byte[1024];
                while (!deflater.finished()) {
                    int count = deflater.deflate(bytesBuf);
                    compressed.write(bytesBuf, 0, count);
                }
                compressed.flush();
                ByteSequence byteSeq = compressed.toByteSequence();
                ByteSequenceData.writeIntBig((ByteSequence)byteSeq, (int)length);
                byArray = Arrays.copyOfRange(byteSeq.data, 0, byteSeq.length);
            }
            return byArray;
        }
        finally {
            deflater.end();
        }
    }

    private static byte[] toAMQMessageDefaultType(ActiveMQBuffer buffer, boolean isCompressed) throws IOException {
        int n = buffer.readableBytes();
        byte[] bytes = new byte[n];
        buffer.readBytes(bytes);
        if (isCompressed) {
            try (java.io.ByteArrayOutputStream bytesOut = new java.io.ByteArrayOutputStream();
                 DeflaterOutputStream out = new DeflaterOutputStream((OutputStream)bytesOut, true);){
                out.write(bytes);
                out.flush();
                bytes = bytesOut.toByteArray();
            }
        }
        return bytes;
    }

    private static void setAMQMsgBrokerPath(ActiveMQMessage amqMsg, String brokerPath) {
        String[] brokers = brokerPath.split(",");
        BrokerId[] bids = new BrokerId[brokers.length];
        for (int i = 0; i < bids.length; ++i) {
            bids[i] = new BrokerId(brokers[i]);
        }
        amqMsg.setBrokerPath(bids);
    }

    private static void setAMQMsgClusterPath(ActiveMQMessage amqMsg, String clusterPath) {
        String[] cluster = clusterPath.split(",");
        BrokerId[] bids = new BrokerId[cluster.length];
        for (int i = 0; i < bids.length; ++i) {
            bids[i] = new BrokerId(cluster[i]);
        }
        amqMsg.setCluster(bids);
    }

    private static void setAMQMsgDataStructure(ActiveMQMessage amqMsg, WireFormat marshaller, byte[] dsBytes) throws IOException {
        ByteSequence seq = new ByteSequence(dsBytes);
        DataStructure ds = (DataStructure)marshaller.unmarshal(seq);
        amqMsg.setDataStructure(ds);
    }

    private static void setAMQMsgDlqDeliveryFailureCause(ActiveMQMessage amqMsg, SimpleString dlqCause) throws IOException {
        try {
            amqMsg.setStringProperty("dlqDeliveryFailureCause", dlqCause.toString());
        }
        catch (JMSException e) {
            throw new IOException("failure to set dlq property " + dlqCause, e);
        }
    }

    private static void setAMQMsgHdrLastValueName(ActiveMQMessage amqMsg, SimpleString lastValueProperty) throws IOException {
        try {
            amqMsg.setStringProperty(Message.HDR_LAST_VALUE_NAME.toString(), lastValueProperty.toString());
        }
        catch (JMSException e) {
            throw new IOException("failure to set lvq property " + lastValueProperty, e);
        }
    }

    private static void setAMQMsgHdrIngressTimestamp(ActiveMQMessage amqMsg, Long ingressTimestamp) throws IOException {
        try {
            amqMsg.setLongProperty(Message.HDR_INGRESS_TIMESTAMP.toString(), ingressTimestamp.longValue());
        }
        catch (JMSException e) {
            throw new IOException("failure to set ingress timestamp property " + ingressTimestamp, e);
        }
    }

    private static void setAMQMsgObjectProperties(ActiveMQMessage amqMsg, ICoreMessage coreMessage, Set<SimpleString> props) throws IOException {
        for (SimpleString s : props) {
            String keyStr = s.toString();
            if (keyStr.length() == 0) {
                logger.debug("ignoring property with empty key name");
                continue;
            }
            if (!coreMessage.containsProperty(ManagementHelper.HDR_NOTIFICATION_TYPE) && (keyStr.startsWith("_AMQ") || keyStr.startsWith("__HDR_"))) continue;
            Object prop = coreMessage.getObjectProperty(s);
            try {
                if (prop instanceof SimpleString) {
                    amqMsg.setObjectProperty(keyStr, (Object)prop.toString());
                    continue;
                }
                if (prop instanceof byte[]) {
                    amqMsg.setObjectProperty(keyStr, (Object)BaseEncoding.base16().encode((byte[])prop));
                    continue;
                }
                if (keyStr.equals("JMSXDeliveryCount") && prop instanceof Long) {
                    Long l = (Long)prop;
                    amqMsg.setObjectProperty(keyStr, (Object)l.intValue());
                    continue;
                }
                amqMsg.setObjectProperty(keyStr, prop);
            }
            catch (JMSException e) {
                ActiveMQServerLogger.LOGGER.failedToDealWithObjectProperty(s, e.getMessage());
            }
        }
    }

    private static final class EagerActiveMQBytesMessage
    extends ActiveMQBytesMessage {
        EagerActiveMQBytesMessage(int size) {
            ByteArrayOutputStream os = this.bytesOut = new ByteArrayOutputStream(size);
            this.dataOut = new DataOutputStream((OutputStream)os);
        }
    }
}

