/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.mirror;

import java.lang.invoke.MethodHandles;
import java.util.function.BooleanSupplier;
import java.util.function.ToIntFunction;
import org.apache.activemq.artemis.api.core.ActiveMQAddressDoesNotExistException;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.RunnableCallback;
import org.apache.activemq.artemis.core.paging.cursor.PagedReference;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.server.mirror.MirrorController;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessageBrokerAccessor;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerSource;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.BasicMirrorController;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.MirrorTransaction;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.ReferenceNodeStore;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonAbstractReceiver;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.collections.NodeStore;
import org.apache.activemq.artemis.utils.pools.MpscPool;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPMirrorControllerTarget
extends ProtonAbstractReceiver
implements MirrorController {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final ThreadLocal<MirrorController> CONTROLLER_THREAD_LOCAL = new ThreadLocal();
    private final MpscPool<ACKMessageOperation> ackMessageMpscPool;
    final RoutingContextImpl routingContext;
    final BasicMirrorController<Receiver> basicController;
    final ActiveMQServer server;
    DuplicateIDCache lruduplicateIDCache;
    String lruDuplicateIDKey;
    private final ReferenceNodeStore referenceNodeStore;
    OperationContext mirrorContext;

    public static void setControllerInUse(MirrorController controller) {
        CONTROLLER_THREAD_LOCAL.set(controller);
    }

    public static MirrorController getControllerInUse() {
        return CONTROLLER_THREAD_LOCAL.get();
    }

    public AMQPMirrorControllerTarget(AMQPSessionCallback sessionSPI, AMQPConnectionContext connection, AMQPSessionContext protonSession, Receiver receiver, ActiveMQServer server) {
        super(sessionSPI, connection, protonSession, receiver);
        this.ackMessageMpscPool = new MpscPool(this.amqpCredits, ACKMessageOperation::reset, () -> new ACKMessageOperation());
        this.routingContext = new RoutingContextImpl(null);
        this.basicController = new BasicMirrorController(server);
        this.basicController.setLink(receiver);
        this.server = server;
        this.referenceNodeStore = sessionSPI.getProtocolManager().getReferenceIDSupplier();
        this.mirrorContext = protonSession.getSessionSPI().getSessionContext();
    }

    public String getRemoteMirrorId() {
        return this.basicController.getRemoteMirrorId();
    }

    @Override
    public void flow() {
        this.creditRunnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actualDelivery(AMQPMessage message, Delivery delivery, Receiver receiver, Transaction tx) {
        this.recoverContext();
        this.incrementSettle();
        logger.trace("{}::actualdelivery call for {}", (Object)this.server, (Object)message);
        AMQPMirrorControllerTarget.setControllerInUse(this);
        delivery.setContext((Object)message);
        ACKMessageOperation messageAckOperation = ((ACKMessageOperation)this.ackMessageMpscPool.borrow()).setDelivery(delivery);
        try {
            Object eventType = AMQPMessageBrokerAccessor.getMessageAnnotationProperty(message, AMQPMirrorControllerSource.EVENT_TYPE);
            if (eventType != null) {
                if (eventType.equals(AMQPMirrorControllerSource.ADD_ADDRESS)) {
                    AddressInfo addressInfo = this.parseAddress(message);
                    this.addAddress(addressInfo);
                } else if (eventType.equals(AMQPMirrorControllerSource.DELETE_ADDRESS)) {
                    AddressInfo addressInfo = this.parseAddress(message);
                    this.deleteAddress(addressInfo);
                } else if (eventType.equals(AMQPMirrorControllerSource.CREATE_QUEUE)) {
                    QueueConfiguration queueConfiguration = this.parseQueue(message);
                    this.createQueue(queueConfiguration);
                } else if (eventType.equals(AMQPMirrorControllerSource.DELETE_QUEUE)) {
                    String address = (String)AMQPMessageBrokerAccessor.getMessageAnnotationProperty(message, AMQPMirrorControllerSource.ADDRESS);
                    String queueName = (String)AMQPMessageBrokerAccessor.getMessageAnnotationProperty(message, AMQPMirrorControllerSource.QUEUE);
                    this.deleteQueue(SimpleString.toSimpleString((String)address), SimpleString.toSimpleString((String)queueName));
                } else if (eventType.equals(AMQPMirrorControllerSource.POST_ACK)) {
                    AmqpValue value;
                    Long messageID;
                    String queueName;
                    String nodeID = (String)AMQPMessageBrokerAccessor.getMessageAnnotationProperty(message, AMQPMirrorControllerSource.BROKER_ID);
                    AckReason ackReason = AMQPMessageBrokerAccessor.getMessageAnnotationAckReason(message);
                    if (nodeID == null) {
                        nodeID = this.getRemoteMirrorId();
                    }
                    if (this.postAcknowledge(queueName = (String)AMQPMessageBrokerAccessor.getMessageAnnotationProperty(message, AMQPMirrorControllerSource.QUEUE), nodeID, messageID = (Long)(value = (AmqpValue)message.getBody()).getValue(), messageAckOperation, ackReason)) {
                        messageAckOperation = null;
                    }
                }
            } else if (this.sendMessage(message, messageAckOperation)) {
                messageAckOperation = null;
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
        finally {
            AMQPMirrorControllerTarget.setControllerInUse(null);
            if (messageAckOperation != null) {
                this.server.getStorageManager().afterCompleteOperations((IOCallback)messageAckOperation);
            }
        }
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        this.receiver.setSenderSettleMode(this.receiver.getRemoteSenderSettleMode());
        this.receiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
        this.flow();
    }

    private QueueConfiguration parseQueue(AMQPMessage message) {
        AmqpValue bodyValue = (AmqpValue)message.getBody();
        String body = (String)bodyValue.getValue();
        return QueueConfiguration.fromJSON((String)body);
    }

    private AddressInfo parseAddress(AMQPMessage message) {
        AmqpValue bodyValue = (AmqpValue)message.getBody();
        String body = (String)bodyValue.getValue();
        return AddressInfo.fromJSON((String)body);
    }

    public void preAcknowledge(Transaction tx, MessageReference ref, AckReason reason) throws Exception {
    }

    public void addAddress(AddressInfo addressInfo) throws Exception {
        logger.debug("{} adding address {}", (Object)this.server, (Object)addressInfo);
        this.server.addAddressInfo(addressInfo);
    }

    public void deleteAddress(AddressInfo addressInfo) throws Exception {
        logger.debug("{} delete address {}", (Object)this.server, (Object)addressInfo);
        try {
            this.server.removeAddressInfo(addressInfo.getName(), null, true);
        }
        catch (ActiveMQAddressDoesNotExistException expected) {
            logger.debug(expected.getMessage(), (Throwable)expected);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void createQueue(QueueConfiguration queueConfiguration) throws Exception {
        logger.debug("{} adding queue {}", (Object)this.server, (Object)queueConfiguration);
        try {
            this.server.createQueue(queueConfiguration, true);
        }
        catch (Exception e) {
            logger.debug("Queue could not be created, already existed {}", (Object)queueConfiguration, (Object)e);
        }
    }

    public void deleteQueue(SimpleString addressName, SimpleString queueName) throws Exception {
        block3: {
            if (logger.isDebugEnabled()) {
                logger.debug("{} destroy queue {} on address = {} server {}", new Object[]{this.server, queueName, addressName, this.server.getIdentity()});
            }
            try {
                this.server.destroyQueue(queueName, null, false, true, false, false);
            }
            catch (ActiveMQNonExistentQueueException expected) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("{} queue {} was previously removed", new Object[]{this.server, queueName, expected});
            }
        }
    }

    public boolean postAcknowledge(String queue, String nodeID, long messageID, ACKMessageOperation ackMessage, AckReason reason) throws Exception {
        Queue targetQueue = this.server.locateQueue(queue);
        if (targetQueue == null) {
            logger.warn("Queue {} not found on mirror target, ignoring ack for queue={}, messageID={}, nodeID={}", new Object[]{queue, queue, messageID, nodeID});
            return false;
        }
        if (logger.isDebugEnabled() && targetQueue.getConsumerCount() > 0) {
            logger.debug("server {}, queue {} has consumers while delivering ack for {}", new Object[]{this.server.getIdentity(), targetQueue.getName(), messageID});
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Server {} with queue = {} being acked for {} coming from {} targetQueue = {}", new Object[]{this.server.getIdentity(), queue, messageID, messageID, targetQueue});
        }
        this.performAck(nodeID, messageID, targetQueue, ackMessage, reason, (short)0);
        return true;
    }

    public void performAckOnPage(String nodeID, long messageID, Queue targetQueue, IOCallback ackMessageOperation) {
        PageAck pageAck = new PageAck(targetQueue, nodeID, messageID, ackMessageOperation);
        targetQueue.getPageSubscription().scanAck((BooleanSupplier)pageAck, (ToIntFunction)pageAck, (Runnable)pageAck, (Runnable)pageAck);
    }

    private void performAck(String nodeID, long messageID, Queue targetQueue, ACKMessageOperation ackMessageOperation, AckReason reason, short retry) {
        MessageReference reference = targetQueue.removeWithSuppliedID(nodeID, messageID, (NodeStore)this.referenceNodeStore);
        if (logger.isTraceEnabled()) {
            logger.trace("performAck (nodeID={}, messageID={}), targetQueue={}). Ref={}", new Object[]{nodeID, messageID, targetQueue.getName(), reference});
        }
        if (reference == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Retrying Reference not found on messageID={}, nodeID={}, currentRetry={}", new Object[]{messageID, nodeID, retry});
            }
            switch (retry) {
                case 0: {
                    this.sessionSPI.getSessionContext().executeOnCompletion((IOCallback)new RunnableCallback(() -> this.performAck(nodeID, messageID, targetQueue, ackMessageOperation, reason, (short)1)));
                    return;
                }
                case 1: {
                    targetQueue.flushOnIntermediate(() -> {
                        this.recoverContext();
                        this.performAck(nodeID, messageID, targetQueue, ackMessageOperation, reason, (short)2);
                    });
                    return;
                }
                case 2: {
                    if (reason != AckReason.EXPIRED) {
                        this.performAckOnPage(nodeID, messageID, targetQueue, ackMessageOperation);
                        return;
                    }
                    this.connection.runNow(ackMessageOperation);
                }
            }
        }
        if (reference != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("Post ack Server {} worked well for messageID={} nodeID={}", new Object[]{this.server, messageID, nodeID});
            }
            try {
                switch (reason) {
                    case EXPIRED: {
                        targetQueue.expire(reference, null, false);
                        break;
                    }
                    default: {
                        targetQueue.acknowledge(null, reference, reason, null, false);
                    }
                }
                OperationContextImpl.getContext().executeOnCompletion((IOCallback)ackMessageOperation);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean sendMessage(AMQPMessage message, ACKMessageOperation messageCompletionAck) throws Exception {
        DuplicateIDCache duplicateIDCache;
        String internalMirrorID;
        if (message.getMessageID() <= 0L) {
            message.setMessageID(this.server.getStorageManager().generateID());
        }
        if ((internalMirrorID = (String)AMQPMessageBrokerAccessor.getDeliveryAnnotationProperty(message, AMQPMirrorControllerSource.BROKER_ID)) == null) {
            internalMirrorID = this.getRemoteMirrorId();
        }
        Long internalIDLong = (Long)AMQPMessageBrokerAccessor.getDeliveryAnnotationProperty(message, AMQPMirrorControllerSource.INTERNAL_ID);
        String internalAddress = (String)AMQPMessageBrokerAccessor.getDeliveryAnnotationProperty(message, AMQPMirrorControllerSource.INTERNAL_DESTINATION);
        long internalID = 0L;
        if (internalIDLong != null) {
            internalID = internalIDLong;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("sendMessage on server {} for message {} with internalID = {} mirror id {}", new Object[]{this.server, message, internalIDLong, internalMirrorID});
        }
        this.routingContext.setDuplicateDetection(false);
        if (this.lruDuplicateIDKey != null && this.lruDuplicateIDKey.equals(internalMirrorID)) {
            duplicateIDCache = this.lruduplicateIDCache;
        } else {
            logger.trace("Setting up duplicate detection cache on {}, ServerID={} with {} elements, being the number of credits", new Object[]{"$ACTIVEMQ_ARTEMIS_MIRROR", internalMirrorID, this.connection.getAmqpCredits()});
            this.lruDuplicateIDKey = internalMirrorID;
            duplicateIDCache = this.lruduplicateIDCache = this.server.getPostOffice().getDuplicateIDCache(SimpleString.toSimpleString((String)("$ACTIVEMQ_ARTEMIS_MIRROR_" + internalMirrorID)), this.connection.getAmqpCredits());
        }
        byte[] duplicateIDBytes = ByteUtil.longToBytes((long)internalIDLong);
        if (duplicateIDCache.contains(duplicateIDBytes)) {
            this.flow();
            return false;
        }
        message.setBrokerProperty(AMQPMirrorControllerSource.INTERNAL_ID_EXTRA_PROPERTY, internalID);
        message.setBrokerProperty(AMQPMirrorControllerSource.INTERNAL_BROKER_ID_EXTRA_PROPERTY, internalMirrorID);
        if (internalAddress != null) {
            message.setAddress(internalAddress);
        }
        MirrorTransaction transaction = new MirrorTransaction(this.server.getStorageManager());
        transaction.addOperation((TransactionOperation)messageCompletionAck.tx);
        this.routingContext.setTransaction((Transaction)transaction);
        duplicateIDCache.addToCache(duplicateIDBytes, (Transaction)transaction);
        this.routingContext.clear().setMirrorSource((MirrorController)this).setLoadBalancingType(MessageLoadBalancingType.OFF);
        this.server.getPostOffice().route((Message)message, (RoutingContext)this.routingContext, false);
        transaction.commit();
        this.flow();
        return true;
    }

    public void postAcknowledge(MessageReference ref, AckReason reason) {
    }

    public void sendMessage(Transaction tx, Message message, RoutingContext context) {
    }

    class PageAck
    implements ToIntFunction<PagedReference>,
    BooleanSupplier,
    Runnable {
        final Queue targetQueue;
        final String nodeID;
        final long messageID;
        final IOCallback operation;

        PageAck(Queue targetQueue, String nodeID, long messageID, IOCallback operation) {
            this.targetQueue = targetQueue;
            this.nodeID = nodeID;
            this.messageID = messageID;
            this.operation = operation;
        }

        @Override
        public boolean getAsBoolean() {
            try {
                AMQPMirrorControllerTarget.this.recoverContext();
                MessageReference reference = this.targetQueue.removeWithSuppliedID(this.nodeID, this.messageID, (NodeStore)AMQPMirrorControllerTarget.this.referenceNodeStore);
                if (reference == null) {
                    return false;
                }
                this.targetQueue.acknowledge(null, reference, AckReason.NORMAL, null, false);
                OperationContextImpl.getContext().executeOnCompletion(this.operation);
                return true;
            }
            catch (Throwable e) {
                logger.warn(e.getMessage(), e);
                return false;
            }
        }

        @Override
        public int applyAsInt(PagedReference reference) {
            String refNodeID = AMQPMirrorControllerTarget.this.referenceNodeStore.getServerID((MessageReference)reference);
            long refMessageID = AMQPMirrorControllerTarget.this.referenceNodeStore.getID((MessageReference)reference);
            if (refNodeID == null) {
                refNodeID = AMQPMirrorControllerTarget.this.referenceNodeStore.getDefaultNodeID();
            }
            if (refNodeID.equals(this.nodeID)) {
                long diff = refMessageID - this.messageID;
                if (diff == 0L) {
                    return 0;
                }
                if (diff > 0L) {
                    return 1;
                }
                return -1;
            }
            return -1;
        }

        @Override
        public void run() {
            this.operation.done();
        }
    }

    class ACKMessageOperation
    implements IOCallback,
    Runnable {
        Delivery delivery;
        public TransactionOperationAbstract tx = new TransactionOperationAbstract(){

            public void afterCommit(Transaction tx) {
                ACKMessageOperation.this.connectionRun();
            }
        };

        ACKMessageOperation() {
        }

        void reset() {
            this.delivery = null;
        }

        ACKMessageOperation setDelivery(Delivery delivery) {
            this.delivery = delivery;
            return this;
        }

        @Override
        public void run() {
            if (!AMQPMirrorControllerTarget.this.connection.isHandler()) {
                logger.info("Moving execution to proton handler");
                this.connectionRun();
                return;
            }
            logger.trace("Delivery settling for {}, context={}", (Object)this.delivery, this.delivery.getContext());
            this.delivery.disposition((DeliveryState)Accepted.getInstance());
            AMQPMirrorControllerTarget.this.settle(this.delivery);
            AMQPMirrorControllerTarget.this.connection.flush();
            AMQPMirrorControllerTarget.this.ackMessageMpscPool.release((Object)this);
        }

        public void done() {
            this.connectionRun();
        }

        public void connectionRun() {
            AMQPMirrorControllerTarget.this.connection.runNow(this);
        }

        public void onError(int errorCode, String errorMessage) {
            logger.warn("{}-{}", (Object)errorCode, (Object)errorMessage);
        }
    }
}

