/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueManager;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.utils.ReferenceCounterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueManagerImpl
extends ReferenceCounterUtil
implements QueueManager {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SimpleString queueName;
    private final ActiveMQServer server;

    private void doIt() {
        Queue queue = this.server.locateQueue(this.queueName);
        if (queue == null) {
            logger.debug("no queue to delete \"{}\".", (Object)this.queueName);
            return;
        }
        if (queue.isPurgeOnNoConsumers()) {
            QueueManagerImpl.purge(queue);
        }
    }

    private static void purge(Queue queue) {
        long consumerCount = queue.getConsumerCount();
        long messageCount = queue.getMessageCount();
        if (logger.isDebugEnabled()) {
            logger.debug("purging queue \"{}\": consumerCount = {}; messageCount = {}", new Object[]{queue.getName(), consumerCount, messageCount});
        }
        try {
            queue.deleteMatchingReferences(500, null, AckReason.KILLED);
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.failedToPurgeQueue(queue.getName(), e);
        }
    }

    public static void performAutoDeleteQueue(ActiveMQServer server, Queue queue) {
        SimpleString queueName = queue.getName();
        AddressSettings settings = server.getAddressSettingsRepository().getMatch(queue.getAddress().toString());
        if (logger.isDebugEnabled()) {
            logger.debug("deleting auto-created queue \"{}\": consumerCount = {}; messageCount = {}; isAutoDelete = {}", new Object[]{queueName, queue.getConsumerCount(), queue.getMessageCount(), queue.isAutoDelete()});
        }
        ActiveMQServerLogger.LOGGER.autoRemoveQueue(String.valueOf(queue.getName()), queue.getID(), String.valueOf(queue.getAddress()));
        try {
            server.destroyQueue(queueName, null, true, false, false, true);
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.errorRemovingAutoCreatedDestination("queue", queueName, e);
        }
    }

    public static boolean isAutoDelete(Queue queue) {
        return queue.isAutoDelete();
    }

    public static boolean messageCountCheck(Queue queue) {
        return queue.getAutoDeleteMessageCount() == -1L || queue.getMessageCount() <= queue.getAutoDeleteMessageCount();
    }

    public static boolean delayCheck(Queue queue) {
        return System.currentTimeMillis() - queue.getConsumerRemovedTimestamp() >= queue.getAutoDeleteDelay();
    }

    public static boolean consumerCountCheck(Queue queue) {
        return queue.getConsumerCount() == 0;
    }

    public QueueManagerImpl(ActiveMQServer server, SimpleString queueName) {
        super((Executor)server.getExecutorFactory().getExecutor());
        this.server = server;
        this.queueName = queueName;
        this.setTask(this::doIt);
    }

    @Override
    public SimpleString getQueueName() {
        return this.queueName;
    }
}

