/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.component;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.DispatcherType;
import org.apache.activemq.artemis.ActiveMQWebLogger;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.component.AuthenticationFilter;
import org.apache.activemq.artemis.component.DefaultHandler;
import org.apache.activemq.artemis.component.JolokiaFilter;
import org.apache.activemq.artemis.component.WebTmpCleaner;
import org.apache.activemq.artemis.components.ExternalComponent;
import org.apache.activemq.artemis.dto.AppDTO;
import org.apache.activemq.artemis.dto.BindingDTO;
import org.apache.activemq.artemis.dto.ComponentDTO;
import org.apache.activemq.artemis.dto.WebServerDTO;
import org.apache.activemq.artemis.marker.WebServerComponentMarker;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.DefaultAuthenticatorFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.RequestLogWriter;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServerComponent
implements ExternalComponent,
WebServerComponentMarker {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String DIR_ALLOWED = "org.eclipse.jetty.servlet.Default.dirAllowed";
    public static final String WEB_CONSOLE_DISPLAY_NAME = System.getProperty("org.apache.activemq.artemis.webConsoleDisplayName", "hawtio");
    private Server server;
    private HandlerList handlers;
    private WebServerDTO webServerConfig;
    private final List<String> consoleUrls = new ArrayList<String>();
    private final List<String> jolokiaUrls = new ArrayList<String>();
    private final List<Pair<WebAppContext, String>> webContextData = new ArrayList<Pair<WebAppContext, String>>();
    private ServerConnector[] connectors;
    private Path artemisHomePath;
    private Path temporaryWarDir;
    private String artemisInstance;
    private String artemisHome;

    public void configure(ComponentDTO config, String artemisInstance, String artemisHome) throws Exception {
        this.webServerConfig = (WebServerDTO)config;
        this.artemisInstance = artemisInstance;
        this.artemisHome = artemisHome;
        this.temporaryWarDir = Paths.get(artemisInstance != null ? artemisInstance : ".", new String[0]).resolve("tmp").resolve("webapps").toAbsolutePath();
        if (!Files.exists(this.temporaryWarDir, new LinkOption[0])) {
            Files.createDirectories(this.temporaryWarDir, new FileAttribute[0]);
        }
    }

    public synchronized void start() throws Exception {
        if (this.isStarted()) {
            return;
        }
        ActiveMQWebLogger.LOGGER.startingEmbeddedWebServer();
        this.server = new Server();
        this.handlers = new HandlerList();
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        if (this.webServerConfig.customizer != null) {
            try {
                httpConfiguration.addCustomizer((HttpConfiguration.Customizer)Class.forName(this.webServerConfig.customizer).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Throwable t) {
                ActiveMQWebLogger.LOGGER.customizerNotLoaded(this.webServerConfig.customizer, t);
            }
        }
        List bindings = this.webServerConfig.getBindings();
        this.connectors = new ServerConnector[bindings.size()];
        String[] virtualHosts = new String[bindings.size()];
        this.artemisHomePath = Paths.get(this.artemisHome != null ? this.artemisHome : ".", new String[0]);
        Path homeWarDir = this.artemisHomePath.resolve(this.webServerConfig.path).toAbsolutePath();
        Path instanceWarDir = Paths.get(this.artemisInstance != null ? this.artemisInstance : ".", new String[0]).resolve(this.webServerConfig.path).toAbsolutePath();
        for (int i = 0; i < bindings.size(); ++i) {
            ServerConnector connector;
            BindingDTO binding = (BindingDTO)bindings.get(i);
            URI uri = new URI(binding.uri);
            String scheme = uri.getScheme();
            this.connectors[i] = connector = this.createServerConnector(httpConfiguration, i, binding, uri, scheme);
            virtualHosts[i] = "@Connector-" + i;
            if (binding.apps == null || binding.apps.size() <= 0) continue;
            for (AppDTO app : binding.apps) {
                Path dirToUse = homeWarDir;
                if (new File(instanceWarDir.toFile() + File.separator + app.war).exists()) {
                    dirToUse = instanceWarDir;
                }
                WebAppContext webContext = this.createWebAppContext(app.url, app.war, dirToUse, virtualHosts[i]);
                this.handlers.addHandler((Handler)webContext);
                webContext.setInitParameter(DIR_ALLOWED, "false");
                webContext.getSessionHandler().getSessionCookieConfig().setComment("__SAME_SITE_STRICT__");
                this.webContextData.add((Pair<WebAppContext, String>)new Pair((Object)webContext, (Object)binding.uri));
            }
        }
        this.server.setConnectors((Connector[])this.connectors);
        ResourceHandler homeResourceHandler = new ResourceHandler();
        homeResourceHandler.setResourceBase(homeWarDir.toString());
        homeResourceHandler.setDirectoriesListed(false);
        homeResourceHandler.setWelcomeFiles(new String[]{"index.html"});
        ContextHandler homeContext = new ContextHandler();
        homeContext.setContextPath("/");
        homeContext.setResourceBase(homeWarDir.toString());
        homeContext.setHandler((Handler)homeResourceHandler);
        homeContext.setVirtualHosts(virtualHosts);
        homeContext.setInitParameter(DIR_ALLOWED, "false");
        ResourceHandler instanceResourceHandler = new ResourceHandler();
        instanceResourceHandler.setResourceBase(instanceWarDir.toString());
        instanceResourceHandler.setDirectoriesListed(false);
        instanceResourceHandler.setWelcomeFiles(new String[]{"index.html"});
        ContextHandler instanceContext = new ContextHandler();
        instanceContext.setContextPath("/");
        instanceContext.setResourceBase(instanceWarDir.toString());
        instanceContext.setHandler((Handler)instanceResourceHandler);
        instanceContext.setVirtualHosts(virtualHosts);
        homeContext.setInitParameter(DIR_ALLOWED, "false");
        DefaultHandler defaultHandler = new DefaultHandler();
        defaultHandler.setServeIcon(false);
        defaultHandler.setRootRedirectLocation(this.webServerConfig.rootRedirectLocation);
        if (this.webServerConfig.requestLog != null) {
            this.handlers.addHandler((Handler)this.getLogHandler());
        }
        if (this.webServerConfig.webContentEnabled != null && this.webServerConfig.webContentEnabled.booleanValue()) {
            this.handlers.addHandler((Handler)homeContext);
            this.handlers.addHandler((Handler)instanceContext);
        }
        this.handlers.addHandler((Handler)defaultHandler);
        this.server.setHandler((Handler)this.handlers);
        this.cleanupTmp();
        this.server.start();
        this.printStatus(bindings);
    }

    private void printStatus(List<BindingDTO> bindings) {
        ActiveMQWebLogger.LOGGER.webserverStarted(bindings.stream().map(binding -> binding.uri).collect(Collectors.joining(", ")));
        for (Pair<WebAppContext, String> data : this.webContextData) {
            if (!WEB_CONSOLE_DISPLAY_NAME.equals(((WebAppContext)data.getA()).getDisplayName())) continue;
            this.consoleUrls.add((String)data.getB() + ((WebAppContext)data.getA()).getContextPath());
            this.jolokiaUrls.add((String)data.getB() + ((WebAppContext)data.getA()).getContextPath() + "/jolokia");
        }
        if (!this.jolokiaUrls.isEmpty()) {
            ActiveMQWebLogger.LOGGER.jolokiaAvailable(String.join((CharSequence)", ", this.jolokiaUrls));
        }
        if (!this.consoleUrls.isEmpty()) {
            ActiveMQWebLogger.LOGGER.consoleAvailable(String.join((CharSequence)", ", this.consoleUrls));
        }
    }

    private ServerConnector createServerConnector(HttpConfiguration httpConfiguration, int i, BindingDTO binding, URI uri, String scheme) throws Exception {
        ServerConnector connector;
        if ("https".equals(scheme)) {
            SslContextFactory.Server sslFactory = new SslContextFactory.Server();
            sslFactory.setKeyStorePath((String)(binding.keyStorePath == null ? this.artemisInstance + "/etc/keystore.jks" : binding.keyStorePath));
            sslFactory.setKeyStorePassword(binding.getKeyStorePassword() == null ? "password" : binding.getKeyStorePassword());
            if (binding.getIncludedTLSProtocols() != null) {
                sslFactory.setIncludeProtocols(binding.getIncludedTLSProtocols());
            }
            if (binding.getExcludedTLSProtocols() != null) {
                sslFactory.setExcludeProtocols(binding.getExcludedTLSProtocols());
            }
            if (binding.getIncludedCipherSuites() != null) {
                sslFactory.setIncludeCipherSuites(binding.getIncludedCipherSuites());
            }
            if (binding.getExcludedCipherSuites() != null) {
                sslFactory.setExcludeCipherSuites(binding.getExcludedCipherSuites());
            }
            if (binding.clientAuth != null) {
                sslFactory.setNeedClientAuth(binding.clientAuth.booleanValue());
                if (binding.clientAuth.booleanValue()) {
                    sslFactory.setTrustStorePath(binding.trustStorePath);
                    sslFactory.setTrustStorePassword(binding.getTrustStorePassword());
                }
            }
            SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslFactory, "HTTP/1.1");
            httpConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            httpConfiguration.setSendServerVersion(false);
            HttpConnectionFactory httpFactory = new HttpConnectionFactory(httpConfiguration);
            connector = new ServerConnector(this.server, new ConnectionFactory[]{sslConnectionFactory, httpFactory});
        } else {
            httpConfiguration.setSendServerVersion(false);
            HttpConnectionFactory connectionFactory = new HttpConnectionFactory(httpConfiguration);
            connector = new ServerConnector(this.server, new ConnectionFactory[]{connectionFactory});
        }
        connector.setPort(uri.getPort());
        connector.setHost(uri.getHost());
        connector.setName("Connector-" + i);
        return connector;
    }

    private RequestLogHandler getLogHandler() {
        RequestLogWriter requestLogWriter = new RequestLogWriter();
        requestLogWriter.setFilename(this.webServerConfig.requestLog.filename);
        if (this.webServerConfig.requestLog.append != null) {
            requestLogWriter.setAppend(this.webServerConfig.requestLog.append.booleanValue());
        }
        if (this.webServerConfig.requestLog.filenameDateFormat != null) {
            requestLogWriter.setFilenameDateFormat(this.webServerConfig.requestLog.filenameDateFormat);
        }
        if (this.webServerConfig.requestLog.retainDays != null) {
            requestLogWriter.setRetainDays(this.webServerConfig.requestLog.retainDays.intValue());
        }
        CustomRequestLog requestLog = this.webServerConfig.requestLog.format != null ? new CustomRequestLog((RequestLog.Writer)requestLogWriter, this.webServerConfig.requestLog.format) : (this.webServerConfig.requestLog.extended != null && this.webServerConfig.requestLog.extended != false ? new CustomRequestLog((RequestLog.Writer)requestLogWriter, "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\"") : new CustomRequestLog((RequestLog.Writer)requestLogWriter, "%{client}a - %u %t \"%r\" %s %O"));
        if (this.webServerConfig.requestLog.ignorePaths != null && this.webServerConfig.requestLog.ignorePaths.length() > 0) {
            String[] split = this.webServerConfig.requestLog.ignorePaths.split(",");
            String[] ignorePaths = new String[split.length];
            for (int i = 0; i < ignorePaths.length; ++i) {
                ignorePaths[i] = split[i].trim();
            }
            requestLog.setIgnorePaths(ignorePaths);
        }
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        requestLogHandler.setRequestLog((RequestLog)requestLog);
        return requestLogHandler;
    }

    private File getLibFolder() {
        Path lib = this.artemisHomePath.resolve("lib");
        File libFolder = new File(lib.toUri());
        return libFolder;
    }

    private void cleanupTmp() {
        if (this.webContextData.size() == 0) {
            return;
        }
        try {
            ArrayList<File> temporaryFiles = new ArrayList<File>();
            Files.newDirectoryStream(this.temporaryWarDir).forEach(path -> temporaryFiles.add(path.toFile()));
            if (temporaryFiles.size() > 0) {
                WebTmpCleaner.cleanupTmpFiles(this.getLibFolder(), temporaryFiles, true);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to get base dir for tmp web files", (Throwable)e);
        }
    }

    public void cleanupWebTemporaryFiles(List<Pair<WebAppContext, String>> webContextData) throws Exception {
        ArrayList<File> temporaryFiles = new ArrayList<File>();
        for (Pair<WebAppContext, String> data : webContextData) {
            File tmpdir = ((WebAppContext)data.getA()).getTempDirectory();
            temporaryFiles.add(tmpdir);
        }
        if (!temporaryFiles.isEmpty()) {
            WebTmpCleaner.cleanupTmpFiles(this.getLibFolder(), temporaryFiles);
        }
    }

    public boolean isStarted() {
        return this.server != null && this.server.isStarted();
    }

    @Deprecated
    public int getPort() {
        return this.getPort(0);
    }

    public int getPort(int connectorIndex) {
        if (connectorIndex < this.connectors.length) {
            return this.connectors[connectorIndex].getLocalPort();
        }
        return -1;
    }

    protected WebAppContext createWebAppContext(String url, String warFile, Path warDirectory, String virtualHost) {
        WebAppContext webapp = new WebAppContext();
        if (url.startsWith("/")) {
            webapp.setContextPath(url);
        } else {
            webapp.setContextPath("/" + url);
        }
        webapp.addFilter(new FilterHolder(JolokiaFilter.class), "/*", EnumSet.of(DispatcherType.INCLUDE, DispatcherType.REQUEST));
        webapp.addFilter(new FilterHolder(AuthenticationFilter.class), "/auth/login/*", EnumSet.of(DispatcherType.REQUEST));
        webapp.setWar(warDirectory.resolve(warFile).toString());
        webapp.setAttribute("org.eclipse.jetty.webapp.basetempdir", (Object)this.temporaryWarDir.toFile().getAbsolutePath());
        webapp.getSecurityHandler().setAuthenticatorFactory((Authenticator.Factory)new DefaultAuthenticatorFactory());
        webapp.setVirtualHosts(new String[]{virtualHost});
        return webapp;
    }

    public void stop() throws Exception {
        this.stop(false);
    }

    public synchronized void stop(boolean isShutdown) throws Exception {
        if (isShutdown && this.isStarted()) {
            ActiveMQWebLogger.LOGGER.stoppingEmbeddedWebServer();
            this.server.stop();
            this.server = null;
            this.cleanupWebTemporaryFiles(this.webContextData);
            this.webContextData.clear();
            this.jolokiaUrls.clear();
            this.consoleUrls.clear();
            this.handlers = null;
            ActiveMQWebLogger.LOGGER.stoppedEmbeddedWebServer();
        }
    }

    public List<Pair<WebAppContext, String>> getWebContextData() {
        return this.webContextData;
    }
}

