# AMQP CPP example

ActiveMQ Artemis is a multi protocol broker. It will inspect the initial handshake of clients to determine what protocol to use.

All you need to do is to connect a client into activemq's configured port and you should be able connect.

To run this example simply run the command **mvn verify -Pexample**, execute the compile.sh script and start the executable called ./hello

    # first make sure you have the dependencies you need to compile and run the client
    # You will have to adapt this step according to your platform. Consult the [qpid docs](http://qpid.apache.org/releases/qpid-0.30/programming/book/) for more information.
    # There is a list of [packages](http://qpid.apache.org/packages.html) you can install as well.
    [proton-cpp]$ sudo yum install qpid-cpp-client-devel

    # on a first window
    [proton-cpp]$ mvn verify -Pexample

    # on a second window
    # That goes without saying but you will of course need g++ (the C++ compiler) installed
    [proton-cpp]$ ./compile.sh
    [proton-cpp]$ ./hello

You don't need to do anything special to configure the ActiveMQ Artemis broker to accept AMQP clients.

Just for the sake of documentation though we are setting the port of ActiveMQ Artemis on this example as 5672 which is the port qpid have by default.

This is totally optional and you don't need to follow this convention. You can use any port you chose including ActiveMQ's 61616 default port

    <acceptor name="proton-acceptor">tcp://localhost:5672</acceptor>

## Example step-by-step

We are using qpid cpp client on this example. There are several libraries you may chose from for AMQP. We have ellect one that we consider simple enough for users.