/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNullRefException;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.core.management.NotificationType;
import org.apache.activemq.artemis.core.PriorityAware;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.filter.impl.FilterImpl;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PageIterator;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PagedReference;
import org.apache.activemq.artemis.core.persistence.AddressQueueStatus;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeServerMessageImpl;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.RoutingStatus;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.HandleStatus;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.ScheduledDeliveryHandler;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.cluster.RemoteQueueBinding;
import org.apache.activemq.artemis.core.server.cluster.impl.Redistributor;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.BucketMessageGroups;
import org.apache.activemq.artemis.core.server.impl.DisabledMessageGroups;
import org.apache.activemq.artemis.core.server.impl.GroupFirstMessageReference;
import org.apache.activemq.artemis.core.server.impl.MessageGroups;
import org.apache.activemq.artemis.core.server.impl.MessageReferenceImpl;
import org.apache.activemq.artemis.core.server.impl.QueueConsumers;
import org.apache.activemq.artemis.core.server.impl.QueueConsumersImpl;
import org.apache.activemq.artemis.core.server.impl.QueueManagerImpl;
import org.apache.activemq.artemis.core.server.impl.QueueMessageMetrics;
import org.apache.activemq.artemis.core.server.impl.RefsOperation;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.server.impl.ScheduledDeliveryHandlerImpl;
import org.apache.activemq.artemis.core.server.impl.ServerConsumerImpl;
import org.apache.activemq.artemis.core.server.impl.SimpleMessageGroups;
import org.apache.activemq.artemis.core.server.impl.TransientQueueManagerImpl;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.HierarchicalRepositoryChangeListener;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerPolicy;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerThresholdMeasurementUnit;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.core.transaction.impl.BindingsTransactionImpl;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.BooleanUtil;
import org.apache.activemq.artemis.utils.Env;
import org.apache.activemq.artemis.utils.ReferenceCounter;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.SizeAwareMetric;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.apache.activemq.artemis.utils.collections.IterableStream;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.apache.activemq.artemis.utils.collections.NodeStore;
import org.apache.activemq.artemis.utils.collections.PriorityLinkedList;
import org.apache.activemq.artemis.utils.collections.PriorityLinkedListImpl;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.CriticalCloseable;
import org.apache.activemq.artemis.utils.critical.CriticalComponentImpl;
import org.apache.activemq.artemis.utils.critical.EmptyCriticalAnalyzer;
import org.jctools.queues.MpscUnboundedArrayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueImpl
extends CriticalComponentImpl
implements Queue {
    protected static final int CRITICAL_PATHS = 5;
    protected static final int CRITICAL_PATH_ADD_TAIL = 0;
    protected static final int CRITICAL_PATH_ADD_HEAD = 1;
    protected static final int CRITICAL_DELIVER = 2;
    protected static final int CRITICAL_CONSUMER = 3;
    protected static final int CRITICAL_CHECK_DEPAGE = 4;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final AtomicIntegerFieldUpdater<QueueImpl> dispatchingUpdater = AtomicIntegerFieldUpdater.newUpdater(QueueImpl.class, "dispatching");
    private static final AtomicLongFieldUpdater<QueueImpl> dispatchStartTimeUpdater = AtomicLongFieldUpdater.newUpdater(QueueImpl.class, "dispatchStartTime");
    private static final AtomicLongFieldUpdater<QueueImpl> consumerRemovedTimestampUpdater = AtomicLongFieldUpdater.newUpdater(QueueImpl.class, "consumerRemovedTimestamp");
    private static final AtomicReferenceFieldUpdater<QueueImpl, Filter> filterUpdater = AtomicReferenceFieldUpdater.newUpdater(QueueImpl.class, Filter.class, "filter");
    public static final int NUM_PRIORITIES = 10;
    public static final int MAX_DELIVERIES_IN_LOOP = 1000;
    public static final int CHECK_QUEUE_SIZE_PERIOD = 1000;
    public static final int DELIVERY_TIMEOUT = 1000;
    public static final int DEFAULT_FLUSH_LIMIT = 500;
    private final Long id;
    private final SimpleString name;
    private SimpleString user;
    private volatile Filter filter;
    private final boolean propertyDurable;
    private final boolean temporary;
    private final boolean autoCreated;
    private final PostOffice postOffice;
    private volatile boolean queueDestroyed = false;
    private volatile boolean pageDelivered = false;
    private final PagingStore pagingStore;
    protected final PageSubscription pageSubscription;
    private final ReferenceCounter refCountForConsumers;
    private final PageIterator pageIterator;
    private volatile boolean printErrorExpiring = false;
    private boolean mirrorController;
    private volatile boolean hasUnMatchedPending = false;
    private final MpscUnboundedArrayQueue<MessageReference> intermediateMessageReferences = new MpscUnboundedArrayQueue(8192);
    protected final PriorityLinkedList<MessageReference> messageReferences = new PriorityLinkedListImpl(10, MessageReferenceImpl.getIDComparator());
    private NodeStore<MessageReference> nodeStore;
    private final AtomicInteger pagedReferences = new AtomicInteger(0);
    final SizeAwareMetric queueMemorySize = new SizeAwareMetric();
    protected final QueueMessageMetrics pendingMetrics = new QueueMessageMetrics(this, "pending");
    private final QueueMessageMetrics deliveringMetrics = new QueueMessageMetrics(this, "delivering");
    protected final ScheduledDeliveryHandler scheduledDeliveryHandler;
    private final AtomicLong messagesAdded = new AtomicLong(0L);
    private final AtomicLong messagesAcknowledged = new AtomicLong(0L);
    private final AtomicLong ackAttempts = new AtomicLong(0L);
    private final AtomicLong messagesExpired = new AtomicLong(0L);
    private final AtomicLong messagesKilled = new AtomicLong(0L);
    private final AtomicLong messagesReplaced = new AtomicLong(0L);
    private boolean paused;
    private long pauseStatusRecord = -1L;
    private static final int MAX_SCHEDULED_RUNNERS = 1;
    private static final int MAX_DEPAGE_NUM = 1000;
    private final AtomicInteger scheduledRunners = new AtomicInteger(0);
    private final Runnable deliverRunner = new DeliverRunner();
    private final ReentrantLock deliverLock = new ReentrantLock();
    private final ReentrantLock depageLock = new ReentrantLock();
    private volatile boolean depagePending = false;
    private final StorageManager storageManager;
    private volatile AddressSettings addressSettings;
    private final ActiveMQServer server;
    private final ScheduledExecutorService scheduledExecutor;
    private final SimpleString address;
    private ConsumerHolder<Redistributor> redistributor;
    private ScheduledFuture<?> redistributorFuture;
    private volatile long consumerRemovedTimestamp = -1L;
    private final QueueConsumers<ConsumerHolder<? extends Consumer>> consumers = new QueueConsumersImpl<ConsumerHolder<? extends Consumer>>();
    private volatile boolean groupRebalance;
    private volatile boolean groupRebalancePauseDispatch;
    private volatile int groupBuckets;
    private volatile SimpleString groupFirstKey;
    private MessageGroups<Consumer> groups;
    private volatile Consumer exclusiveConsumer;
    private final ArtemisExecutor executor;
    private boolean internalQueue;
    private volatile long lastDirectDeliveryCheck = 0L;
    private volatile boolean directDeliver = true;
    private volatile boolean supportsDirectDeliver = false;
    private AddressSettingsRepositoryListener addressSettingsRepositoryListener;
    private final ReusableLatch deliveriesInTransit = new ReusableLatch(0);
    private final AtomicLong queueRateCheckTime = new AtomicLong(System.currentTimeMillis());
    private final AtomicLong messagesAddedSnapshot = new AtomicLong(0L);
    private ScheduledFuture slowConsumerReaperFuture;
    private SlowConsumerReaperRunnable slowConsumerReaperRunnable;
    private volatile int maxConsumers;
    private volatile boolean exclusive;
    private volatile boolean purgeOnNoConsumers;
    private volatile boolean enabled;
    private final AddressInfo addressInfo;
    private volatile RoutingType routingType;
    private final QueueFactory factory;
    public volatile int dispatching = 0;
    public volatile long dispatchStartTime = -1L;
    private volatile int consumersBeforeDispatch = 0;
    private volatile long delayBeforeDispatch = 0L;
    private final boolean autoDelete;
    private volatile boolean swept;
    private final long autoDeleteDelay;
    private final long autoDeleteMessageCount;
    private volatile boolean configurationManaged;
    private volatile boolean nonDestructive;
    private volatile long ringSize;
    private final Object directDeliveryGuard = new Object();
    private final ConcurrentHashSet<String> lingerSessionIds = new ConcurrentHashSet();

    private void checkIDSupplier(NodeStore<MessageReference> nodeStore) {
        if (this.nodeStore != nodeStore) {
            this.nodeStore = nodeStore;
            this.messageReferences.setNodeStore(nodeStore);
        }
    }

    @Override
    public boolean isSwept() {
        return this.swept;
    }

    @Override
    public void setSwept(boolean swept) {
        this.swept = swept;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String debug() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        out.println("queueMemorySize=" + this.queueMemorySize);
        for (ConsumerHolder queueImpl : this.consumers) {
            out.println("consumer: " + queueImpl.consumer.debug());
        }
        out.println("Intermediate reference size is " + this.intermediateMessageReferences.size());
        boolean foundRef = false;
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            LinkedListIterator iter = this.messageReferences.iterator();
            while (iter.hasNext()) {
                foundRef = true;
                out.println("reference = " + iter.next());
            }
        }
        if (!foundRef) {
            out.println("No permanent references on queue");
        }
        System.out.println(str.toString());
        return str.toString();
    }

    @Deprecated
    public QueueImpl(long id, SimpleString address, SimpleString name, Filter filter, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, ArtemisExecutor executor, ActiveMQServer server, QueueFactory factory) {
        this(id, address, name, filter, null, null, user, durable, temporary, autoCreated, scheduledExecutor, postOffice, storageManager, addressSettingsRepository, executor, server, factory);
    }

    @Deprecated
    public QueueImpl(long id, SimpleString address, SimpleString name, Filter filter, PagingStore pagingStore, PageSubscription pageSubscription, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, ArtemisExecutor executor, ActiveMQServer server, QueueFactory factory) {
        this(id, address, name, filter, pagingStore, pageSubscription, user, durable, temporary, autoCreated, RoutingType.MULTICAST, null, null, scheduledExecutor, postOffice, storageManager, addressSettingsRepository, executor, server, factory);
    }

    @Deprecated
    public QueueImpl(long id, SimpleString address, SimpleString name, Filter filter, PagingStore pagingStore, PageSubscription pageSubscription, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, RoutingType routingType, Integer maxConsumers, Boolean purgeOnNoConsumers, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, ArtemisExecutor executor, ActiveMQServer server, QueueFactory factory) {
        this(id, address, name, filter, pagingStore, pageSubscription, user, durable, temporary, autoCreated, routingType, maxConsumers, null, purgeOnNoConsumers, scheduledExecutor, postOffice, storageManager, addressSettingsRepository, executor, server, factory);
    }

    @Deprecated
    public QueueImpl(long id, SimpleString address, SimpleString name, Filter filter, PagingStore pagingStore, PageSubscription pageSubscription, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, RoutingType routingType, Integer maxConsumers, Boolean exclusive, Boolean purgeOnNoConsumers, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, ArtemisExecutor executor, ActiveMQServer server, QueueFactory factory) {
        this(id, address, name, filter, pagingStore, pageSubscription, user, durable, temporary, autoCreated, routingType, maxConsumers, exclusive, null, null, false, null, null, purgeOnNoConsumers, null, null, null, false, scheduledExecutor, postOffice, storageManager, addressSettingsRepository, executor, server, factory);
    }

    @Deprecated
    public QueueImpl(long id, SimpleString address, SimpleString name, Filter filter, PagingStore pagingStore, PageSubscription pageSubscription, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, RoutingType routingType, Integer maxConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, Boolean purgeOnNoConsumers, Boolean autoDelete, Long autoDeleteDelay, Long autoDeleteMessageCount, boolean configurationManaged, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, ArtemisExecutor executor, ActiveMQServer server, QueueFactory factory) {
        this(id, address, name, filter, pagingStore, pageSubscription, user, durable, temporary, autoCreated, routingType, maxConsumers, exclusive, groupRebalance, groupBuckets, null, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, purgeOnNoConsumers, autoDelete, autoDeleteDelay, autoDeleteMessageCount, configurationManaged, scheduledExecutor, postOffice, storageManager, addressSettingsRepository, executor, server, factory);
    }

    @Deprecated
    public QueueImpl(long id, SimpleString address, SimpleString name, Filter filter, PagingStore pagingStore, PageSubscription pageSubscription, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, RoutingType routingType, Integer maxConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, SimpleString groupFirstKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, Boolean purgeOnNoConsumers, Boolean autoDelete, Long autoDeleteDelay, Long autoDeleteMessageCount, boolean configurationManaged, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, ArtemisExecutor executor, ActiveMQServer server, QueueFactory factory) {
        this(id, address, name, filter, pagingStore, pageSubscription, user, durable, temporary, autoCreated, routingType, maxConsumers, exclusive, groupRebalance, groupBuckets, groupFirstKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, purgeOnNoConsumers, autoDelete, autoDeleteDelay, autoDeleteMessageCount, configurationManaged, null, scheduledExecutor, postOffice, storageManager, addressSettingsRepository, executor, server, factory);
    }

    @Deprecated
    public QueueImpl(long id, SimpleString address, SimpleString name, Filter filter, PagingStore pagingStore, PageSubscription pageSubscription, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, RoutingType routingType, Integer maxConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, SimpleString groupFirstKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, Boolean purgeOnNoConsumers, Boolean autoDelete, Long autoDeleteDelay, Long autoDeleteMessageCount, boolean configurationManaged, Long ringSize, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, ArtemisExecutor executor, ActiveMQServer server, QueueFactory factory) {
        this(new QueueConfiguration(name).setId(Long.valueOf(id)).setAddress(address).setFilterString(filter == null ? null : filter.getFilterString()).setUser(user).setDurable(Boolean.valueOf(durable)).setTemporary(Boolean.valueOf(temporary)).setAutoCreated(Boolean.valueOf(autoCreated)).setRoutingType(routingType).setMaxConsumers(maxConsumers).setExclusive(exclusive).setGroupRebalance(groupRebalance).setGroupBuckets(groupBuckets).setGroupFirstKey(groupFirstKey).setNonDestructive(nonDestructive).setConsumersBeforeDispatch(consumersBeforeDispatch).setDelayBeforeDispatch(delayBeforeDispatch).setPurgeOnNoConsumers(purgeOnNoConsumers).setAutoDelete(autoDelete).setAutoDeleteDelay(autoDeleteDelay).setAutoDeleteMessageCount(autoDeleteMessageCount).setConfigurationManaged(Boolean.valueOf(configurationManaged)).setRingSize(ringSize), pagingStore, pageSubscription, scheduledExecutor, postOffice, storageManager, addressSettingsRepository, executor, server, factory);
        this.filter = filter;
    }

    public QueueImpl(QueueConfiguration queueConfiguration, PagingStore pagingStore, PageSubscription pageSubscription, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, ArtemisExecutor executor, ActiveMQServer server, QueueFactory factory) {
        super((CriticalAnalyzer)(server == null ? EmptyCriticalAnalyzer.getInstance() : server.getCriticalAnalyzer()), 5);
        this.id = queueConfiguration.getId();
        this.address = queueConfiguration.getAddress();
        this.refCountForConsumers = queueConfiguration.isTransient() != false ? new TransientQueueManagerImpl(server, queueConfiguration.getName()) : new QueueManagerImpl(server, queueConfiguration.getName());
        this.addressInfo = postOffice == null ? null : postOffice.getAddressInfo(this.address);
        this.routingType = queueConfiguration.getRoutingType();
        this.name = queueConfiguration.getName();
        try {
            this.filter = this.filter == null ? FilterImpl.createFilter(queueConfiguration.getFilterString()) : this.filter;
        }
        catch (ActiveMQException e) {
            throw new RuntimeException(e);
        }
        this.pagingStore = pagingStore;
        this.pageSubscription = pageSubscription;
        this.propertyDurable = queueConfiguration.isDurable();
        this.temporary = queueConfiguration.isTemporary();
        this.autoCreated = queueConfiguration.isAutoCreated();
        this.maxConsumers = queueConfiguration.getMaxConsumers() == null ? ActiveMQDefaultConfiguration.getDefaultMaxQueueConsumers() : queueConfiguration.getMaxConsumers();
        this.exclusive = queueConfiguration.isExclusive() == null ? ActiveMQDefaultConfiguration.getDefaultExclusive() : queueConfiguration.isExclusive();
        this.nonDestructive = queueConfiguration.isNonDestructive() == null ? ActiveMQDefaultConfiguration.getDefaultNonDestructive() : queueConfiguration.isNonDestructive();
        this.purgeOnNoConsumers = queueConfiguration.isPurgeOnNoConsumers() == null ? ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers() : queueConfiguration.isPurgeOnNoConsumers();
        this.enabled = queueConfiguration.isEnabled() == null ? ActiveMQDefaultConfiguration.getDefaultEnabled() : queueConfiguration.isEnabled();
        this.consumersBeforeDispatch = queueConfiguration.getConsumersBeforeDispatch() == null ? ActiveMQDefaultConfiguration.getDefaultConsumersBeforeDispatch() : queueConfiguration.getConsumersBeforeDispatch();
        this.delayBeforeDispatch = queueConfiguration.getDelayBeforeDispatch() == null ? ActiveMQDefaultConfiguration.getDefaultDelayBeforeDispatch() : queueConfiguration.getDelayBeforeDispatch();
        this.groupRebalance = queueConfiguration.isGroupRebalance() == null ? ActiveMQDefaultConfiguration.getDefaultGroupRebalance() : queueConfiguration.isGroupRebalance();
        this.groupRebalancePauseDispatch = queueConfiguration.isGroupRebalancePauseDispatch() == null ? ActiveMQDefaultConfiguration.getDefaultGroupRebalancePauseDispatch() : queueConfiguration.isGroupRebalancePauseDispatch();
        this.groupBuckets = queueConfiguration.getGroupBuckets() == null ? ActiveMQDefaultConfiguration.getDefaultGroupBuckets() : queueConfiguration.getGroupBuckets();
        this.groups = QueueImpl.groupMap(this.groupBuckets);
        this.groupFirstKey = queueConfiguration.getGroupFirstKey() == null ? ActiveMQDefaultConfiguration.getDefaultGroupFirstKey() : queueConfiguration.getGroupFirstKey();
        this.autoDelete = queueConfiguration.isAutoDelete() == null ? ActiveMQDefaultConfiguration.getDefaultQueueAutoDelete((boolean)this.autoCreated) : queueConfiguration.isAutoDelete();
        this.autoDeleteDelay = queueConfiguration.getAutoDeleteDelay() == null ? ActiveMQDefaultConfiguration.getDefaultQueueAutoDeleteDelay() : queueConfiguration.getAutoDeleteDelay();
        this.autoDeleteMessageCount = queueConfiguration.getAutoDeleteMessageCount() == null ? ActiveMQDefaultConfiguration.getDefaultQueueAutoDeleteMessageCount() : queueConfiguration.getAutoDeleteMessageCount();
        this.configurationManaged = queueConfiguration.isConfigurationManaged();
        this.postOffice = postOffice;
        this.storageManager = storageManager;
        this.scheduledExecutor = scheduledExecutor;
        this.server = server;
        this.scheduledDeliveryHandler = new ScheduledDeliveryHandlerImpl(scheduledExecutor, this);
        if (addressSettingsRepository != null) {
            this.addressSettingsRepositoryListener = new AddressSettingsRepositoryListener(addressSettingsRepository);
            addressSettingsRepository.registerListener(this.addressSettingsRepositoryListener);
            this.addressSettings = addressSettingsRepository.getMatch(this.getAddressSettingsMatch());
        } else {
            this.addressSettings = new AddressSettings();
        }
        if (pageSubscription != null) {
            pageSubscription.setQueue(this);
            this.pageIterator = pageSubscription.iterator();
        } else {
            this.pageIterator = null;
        }
        this.executor = executor;
        this.user = queueConfiguration.getUser();
        this.factory = factory;
        if (this.addressInfo != null && this.addressInfo.isPaused()) {
            this.pause(false);
        }
        this.ringSize = queueConfiguration.getRingSize() == null ? ActiveMQDefaultConfiguration.getDefaultRingSize() : queueConfiguration.getRingSize();
    }

    @Override
    public boolean allowsReferenceCallback() {
        return !this.nonDestructive;
    }

    @Override
    public boolean isMirrorController() {
        return this.mirrorController;
    }

    @Override
    public void setMirrorController(boolean mirrorController) {
        this.mirrorController = mirrorController;
    }

    public SimpleString getRoutingName() {
        return this.name;
    }

    public SimpleString getUniqueName() {
        return this.name;
    }

    @Override
    public SimpleString getUser() {
        return this.user;
    }

    @Override
    public void setUser(SimpleString user) {
        this.user = user;
    }

    @Override
    public boolean isExclusive() {
        return this.exclusive;
    }

    @Override
    public synchronized void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
        if (!exclusive) {
            this.exclusiveConsumer = null;
        }
    }

    @Override
    public int getConsumersBeforeDispatch() {
        return this.consumersBeforeDispatch;
    }

    @Override
    public synchronized void setConsumersBeforeDispatch(int consumersBeforeDispatch) {
        this.consumersBeforeDispatch = consumersBeforeDispatch;
    }

    @Override
    public long getDelayBeforeDispatch() {
        return this.delayBeforeDispatch;
    }

    @Override
    public synchronized void setDelayBeforeDispatch(long delayBeforeDispatch) {
        this.delayBeforeDispatch = delayBeforeDispatch;
    }

    @Override
    public long getDispatchStartTime() {
        return dispatchStartTimeUpdater.get(this);
    }

    @Override
    public boolean isDispatching() {
        return BooleanUtil.toBoolean((int)dispatchingUpdater.get(this));
    }

    @Override
    public synchronized void setDispatching(boolean dispatching) {
        if (dispatchingUpdater.compareAndSet(this, BooleanUtil.toInt((!dispatching ? 1 : 0) != 0), BooleanUtil.toInt((boolean)dispatching))) {
            if (dispatching) {
                dispatchStartTimeUpdater.set(this, System.currentTimeMillis());
            } else {
                dispatchStartTimeUpdater.set(this, -1L);
            }
        }
    }

    @Override
    public boolean isLastValue() {
        return false;
    }

    @Override
    public SimpleString getLastValueKey() {
        return null;
    }

    @Override
    public boolean isNonDestructive() {
        return this.nonDestructive;
    }

    @Override
    public synchronized void setNonDestructive(boolean nonDestructive) {
        this.nonDestructive = nonDestructive;
    }

    @Override
    public void route(Message message, RoutingContext context) throws Exception {
        if (!this.enabled) {
            context.setReusable(false);
            return;
        }
        if (this.purgeOnNoConsumers) {
            context.setReusable(false);
            if (this.getConsumerCount() == 0) {
                return;
            }
        }
        context.addQueue(this.address, this);
    }

    @Override
    public void routeWithAck(Message message, RoutingContext context) {
        context.addQueueWithAck(this.address, this);
    }

    @Override
    public ReferenceCounter getConsumersRefCount() {
        return this.refCountForConsumers;
    }

    @Override
    public boolean isDurable() {
        return this.propertyDurable;
    }

    @Override
    public boolean isDurableMessage() {
        return this.propertyDurable && !this.purgeOnNoConsumers;
    }

    @Override
    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    @Override
    public long getAutoDeleteDelay() {
        return this.autoDeleteDelay;
    }

    @Override
    public long getAutoDeleteMessageCount() {
        return this.autoDeleteMessageCount;
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    @Override
    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    @Override
    public boolean isPurgeOnNoConsumers() {
        return this.purgeOnNoConsumers;
    }

    @Override
    public synchronized void setPurgeOnNoConsumers(boolean value) {
        this.purgeOnNoConsumers = value;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public synchronized void setEnabled(boolean value) {
        this.enabled = value;
    }

    @Override
    public int getMaxConsumers() {
        return this.maxConsumers;
    }

    @Override
    public synchronized void setMaxConsumer(int maxConsumers) {
        this.maxConsumers = maxConsumers;
    }

    @Override
    public int getGroupBuckets() {
        return this.groupBuckets;
    }

    @Override
    public synchronized void setGroupBuckets(int groupBuckets) {
        if (this.groupBuckets != groupBuckets) {
            this.groups = QueueImpl.groupMap(groupBuckets);
            this.groupBuckets = groupBuckets;
        }
    }

    @Override
    public boolean isGroupRebalance() {
        return this.groupRebalance;
    }

    @Override
    public synchronized void setGroupRebalance(boolean groupRebalance) {
        this.groupRebalance = groupRebalance;
    }

    @Override
    public boolean isGroupRebalancePauseDispatch() {
        return this.groupRebalancePauseDispatch;
    }

    @Override
    public synchronized void setGroupRebalancePauseDispatch(boolean groupRebalancePauseDispatch) {
        this.groupRebalancePauseDispatch = groupRebalancePauseDispatch;
    }

    @Override
    public SimpleString getGroupFirstKey() {
        return this.groupFirstKey;
    }

    @Override
    public synchronized void setGroupFirstKey(SimpleString groupFirstKey) {
        this.groupFirstKey = groupFirstKey;
    }

    @Override
    public boolean isConfigurationManaged() {
        return this.configurationManaged;
    }

    @Override
    public synchronized void setConfigurationManaged(boolean configurationManaged) {
        this.configurationManaged = configurationManaged;
    }

    @Override
    public SimpleString getName() {
        return this.name;
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public Long getID() {
        return this.id;
    }

    @Override
    public int durableUp(Message message) {
        return message.durableUp();
    }

    @Override
    public int durableDown(Message message) {
        return message.durableDown();
    }

    @Override
    public void refUp(MessageReference messageReference) {
        int count = messageReference.getMessage().refUp();
        if (count == 1 && messageReference.getMessage().getOwner() != null) {
            ((PagingStore)messageReference.getMessage().getOwner()).addSize(messageReference.getMessageMemoryEstimate(), false);
        }
        if (this.pagingStore != null) {
            this.pagingStore.refUp(messageReference.getMessage(), count);
        }
    }

    @Override
    public void refDown(MessageReference messageReference) {
        int count = messageReference.getMessage().refDown();
        if (count == 0 && messageReference.getMessage().getOwner() != null) {
            ((PagingStore)messageReference.getMessage().getOwner()).addSize(-messageReference.getMessageMemoryEstimate(), false);
        }
        if (this.pagingStore != null) {
            this.pagingStore.refDown(messageReference.getMessage(), count);
        }
    }

    @Override
    public PagingStore getPagingStore() {
        return this.pagingStore;
    }

    @Override
    public PageSubscription getPageSubscription() {
        return this.pageSubscription;
    }

    @Override
    public RoutingType getRoutingType() {
        return this.routingType;
    }

    @Override
    public void setRoutingType(RoutingType routingType) {
        if (this.addressInfo.getRoutingTypes().contains(routingType)) {
            this.routingType = routingType;
        }
    }

    @Override
    public Filter getFilter() {
        return filterUpdater.get(this);
    }

    @Override
    public void setFilter(Filter filter) {
        filterUpdater.set(this, filter);
    }

    @Override
    public void unproposed(final SimpleString groupID) {
        if (groupID.toString().endsWith("." + this.getName())) {
            final SimpleString groupIDToRemove = (SimpleString)groupID.subSequence(0, groupID.length() - this.getName().length() - 1);
            this.getExecutor().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    QueueImpl queueImpl = QueueImpl.this;
                    synchronized (queueImpl) {
                        if (QueueImpl.this.groups.remove(groupIDToRemove) != null) {
                            logger.debug("Removing group after unproposal {} from queue {}", (Object)groupID, (Object)QueueImpl.this);
                        } else {
                            logger.debug("Couldn't remove Removing group {} after unproposal on queue {}", (Object)groupIDToRemove, (Object)QueueImpl.this);
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHead(MessageReference ref, boolean scheduling) {
        if (logger.isTraceEnabled()) {
            logger.trace("AddHead, size = {}, intermediate size = {}, references size = {}\nreference={}", new Object[]{this.queueMemorySize, this.intermediateMessageReferences.size(), this.messageReferences.size(), ref});
        }
        try (CriticalCloseable metric = this.measureCritical(1);){
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                if (this.ringSize != -1L) {
                    this.enforceRing(ref, scheduling, true);
                }
                if (!ref.isAlreadyAcked()) {
                    if (!scheduling && this.scheduledDeliveryHandler.checkAndSchedule(ref, false)) {
                        return;
                    }
                    this.internalAddHead(ref);
                    this.directDeliver = false;
                }
            }
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSorted(MessageReference ref, boolean scheduling) {
        if (logger.isTraceEnabled()) {
            logger.trace("addSorted, size = {}, intermediate size = {}, references size = {}\nreference={}", new Object[]{this.queueMemorySize, this.intermediateMessageReferences.size(), this.messageReferences.size(), ref});
        }
        try (CriticalCloseable metric = this.measureCritical(1);){
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                if (this.ringSize != -1L) {
                    this.enforceRing(ref, false, true);
                }
                if (!ref.isAlreadyAcked()) {
                    if (!scheduling && this.scheduledDeliveryHandler.checkAndSchedule(ref, false)) {
                        return;
                    }
                    this.internalAddSorted(ref);
                    this.directDeliver = false;
                }
            }
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHead(List<MessageReference> refs, boolean scheduling) {
        try (CriticalCloseable metric = this.measureCritical(1);){
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                for (MessageReference ref : refs) {
                    this.addHead(ref, scheduling);
                }
                this.resetAllIterators();
                this.deliverAsync();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSorted(List<MessageReference> refs, boolean scheduling) {
        if (refs.size() > 1000) {
            logger.debug("Switching addSorted call to addSortedLargeTX on queue {}", (Object)this.name);
            this.addSortedLargeTX(refs, scheduling);
            return;
        }
        try (CriticalCloseable metric = this.measureCritical(1);){
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                for (MessageReference ref : refs) {
                    this.addSorted(ref, scheduling);
                }
                this.resetAllIterators();
                this.deliverAsync();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSortedLargeTX(List<MessageReference> refs, boolean scheduling) {
        for (MessageReference ref : refs) {
            this.addSorted(ref, scheduling);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("addSortedHugeLoad finished on queue {}", (Object)this.name);
        }
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            this.resetAllIterators();
            this.deliverAsync();
        }
    }

    @Override
    public synchronized void reload(MessageReference ref) {
        this.queueMemorySize.addSize(ref.getMessageMemoryEstimate());
        if (!this.scheduledDeliveryHandler.checkAndSchedule(ref, true)) {
            this.internalAddTail(ref);
        }
        this.directDeliver = false;
        if (!ref.isPaged()) {
            this.incrementMesssagesAdded();
        }
    }

    @Override
    public void addTail(MessageReference ref) {
        this.addTail(ref, false);
    }

    @Override
    public void flushOnIntermediate(final Runnable runnable) {
        this.intermediateMessageReferences.add((Object)new MessageReferenceImpl(){

            @Override
            public boolean skipDelivery() {
                runnable.run();
                return true;
            }
        });
        this.deliverAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTail(MessageReference ref, boolean direct) {
        try (CriticalCloseable metric = this.measureCritical(0);){
            if (this.scheduleIfPossible(ref)) {
                return;
            }
            if (direct && this.supportsDirectDeliver && !this.directDeliver && System.currentTimeMillis() - this.lastDirectDeliveryCheck > 1000L) {
                logger.trace("Checking to re-enable direct deliver on queue {}", (Object)this.name);
                this.lastDirectDeliveryCheck = System.currentTimeMillis();
                Object object = this.directDeliveryGuard;
                synchronized (object) {
                    if (this.deliveriesInTransit.getCount() == 0 && this.getExecutor().isFlushed() && this.intermediateMessageReferences.isEmpty() && this.messageReferences.isEmpty() && this.pageIterator != null && !this.pageIterator.hasNext() && this.pageSubscription != null && !this.pageSubscription.isPaging()) {
                        this.directDeliver = this.supportsDirectDeliver;
                        if (logger.isTraceEnabled()) {
                            logger.trace("Setting direct deliverer to {} on queue {}", (Object)this.supportsDirectDeliver, (Object)this.name);
                        }
                    } else {
                        logger.trace("Couldn't set direct deliver back on queue {}", (Object)this.name);
                    }
                }
            }
            if (direct && this.supportsDirectDeliver && this.directDeliver && this.deliveriesInTransit.getCount() == 0 && this.deliverDirect(ref)) {
                return;
            }
            this.queueMemorySize.addSize(ref.getMessageMemoryEstimate());
            this.intermediateMessageReferences.add((Object)ref);
            this.directDeliver = false;
            this.deliverAsync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean scheduleIfPossible(MessageReference ref) {
        if (this.scheduledDeliveryHandler.checkAndSchedule(ref, true)) {
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                if (!ref.isPaged()) {
                    this.incrementMesssagesAdded();
                }
            }
            return true;
        }
        return false;
    }

    private boolean flushDeliveriesInTransit() {
        try {
            if (this.deliveriesInTransit.await(1000L)) {
                return true;
            }
            ActiveMQServerLogger.LOGGER.timeoutFlushInTransit(this.getName().toString(), this.getAddress().toString());
            return false;
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.unableToFlushDeliveries(e);
            return false;
        }
    }

    @Override
    public void forceDelivery() {
        if (this.pageSubscription != null && this.pageSubscription.isPaging()) {
            logger.trace("Force delivery scheduling depage");
            this.scheduleDepage(false);
        }
        logger.trace("Force delivery delivering async");
        this.deliverAsync();
    }

    @Override
    public void deliverAsync() {
        this.deliverAsync(false);
    }

    private void deliverAsync(boolean noWait) {
        if (this.scheduledRunners.get() < 1) {
            this.scheduledRunners.incrementAndGet();
            try {
                this.getExecutor().execute(this.deliverRunner);
            }
            catch (RejectedExecutionException ignored) {
                this.scheduledRunners.decrementAndGet();
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                QueueImpl.this.cancelRedistributor();
            }
        });
        this.addressSettingsRepositoryListener.close();
    }

    public ArtemisExecutor getExecutor() {
        if (this.pageSubscription != null && this.pageSubscription.isPaging()) {
            return this.pageSubscription.getPagingStore().getExecutor();
        }
        return this.executor;
    }

    public void deliverNow() {
        this.deliverAsync();
        this.flushExecutor();
    }

    @Override
    public boolean flushExecutor() {
        boolean ok = this.internalFlushExecutor(10000L, true);
        if (!ok) {
            ActiveMQServerLogger.LOGGER.errorFlushingExecutorsOnQueue();
        }
        return ok;
    }

    private boolean internalFlushExecutor(long timeout, boolean log) {
        if (!this.getExecutor().flush(timeout, TimeUnit.MILLISECONDS)) {
            if (log) {
                ActiveMQServerLogger.LOGGER.queueBusy(this.name.toString(), timeout);
            }
            return false;
        }
        return true;
    }

    private boolean canDispatch() {
        boolean canDispatch = BooleanUtil.toBoolean((int)dispatchingUpdater.get(this));
        if (canDispatch) {
            return true;
        }
        if (this.inFlightMessages()) {
            return false;
        }
        if (this.getConsumerCount() >= this.consumersBeforeDispatch) {
            if (dispatchingUpdater.compareAndSet(this, BooleanUtil.toInt((boolean)false), BooleanUtil.toInt((boolean)true))) {
                dispatchStartTimeUpdater.set(this, System.currentTimeMillis());
            }
            return true;
        }
        long currentDispatchStartTime = dispatchStartTimeUpdater.get(this);
        if (currentDispatchStartTime != -1L && currentDispatchStartTime < System.currentTimeMillis()) {
            dispatchingUpdater.set(this, BooleanUtil.toInt((boolean)true));
            return true;
        }
        return false;
    }

    private boolean inFlightMessages() {
        return this.consumers.stream().mapToInt(c -> c.consumer().getDeliveringMessages().size()).sum() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConsumer(Consumer consumer) throws Exception {
        logger.debug("{} adding consumer {}", (Object)this, (Object)consumer);
        this.setSwept(false);
        try (CriticalCloseable metric = this.measureCritical(3);){
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                ConsumerHolder<Consumer> newConsumerHolder;
                if (this.maxConsumers != -1 && this.getConsumerCount() >= this.maxConsumers) {
                    throw ActiveMQMessageBundle.BUNDLE.maxConsumerLimitReachedForQueue(this.address, this.name);
                }
                if (this.consumers.isEmpty()) {
                    this.supportsDirectDeliver = consumer.supportsDirectDelivery();
                } else if (!consumer.supportsDirectDelivery()) {
                    this.supportsDirectDeliver = false;
                }
                this.cancelRedistributor();
                if (this.groupRebalance) {
                    if (this.groupRebalancePauseDispatch) {
                        this.stopDispatch();
                    }
                    this.groups.removeAll();
                }
                if (this.consumers.add(newConsumerHolder = new ConsumerHolder<Consumer>(consumer))) {
                    if (this.delayBeforeDispatch >= 0L) {
                        dispatchStartTimeUpdater.compareAndSet(this, -1L, this.delayBeforeDispatch + System.currentTimeMillis());
                    }
                    this.refCountForConsumers.increment();
                }
            }
        }
    }

    @Override
    public void addLingerSession(String sessionId) {
        this.lingerSessionIds.add((Object)sessionId);
    }

    @Override
    public void removeLingerSession(String sessionId) {
        this.lingerSessionIds.remove((Object)sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConsumer(Consumer consumer) {
        try (CriticalCloseable metric = this.measureCritical(3);){
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                boolean consumerRemoved = false;
                for (ConsumerHolder consumerHolder : this.consumers) {
                    if (consumerHolder.consumer != consumer) continue;
                    if (consumerHolder.iter != null) {
                        consumerHolder.iter.close();
                    }
                    this.consumers.remove(consumerHolder);
                    consumerRemoved = true;
                    break;
                }
                this.supportsDirectDeliver = this.checkConsumerDirectDeliver();
                if (consumerRemoved) {
                    consumerRemovedTimestampUpdater.set(this, System.currentTimeMillis());
                    if (this.refCountForConsumers.decrement() == 0) {
                        this.stopDispatch();
                    }
                }
                if (consumer == this.exclusiveConsumer) {
                    this.exclusiveConsumer = null;
                }
                this.groups.removeIf(consumer::equals);
            }
        }
    }

    private void stopDispatch() {
        boolean stopped = dispatchingUpdater.compareAndSet(this, BooleanUtil.toInt((boolean)true), BooleanUtil.toInt((boolean)false));
        if (stopped) {
            dispatchStartTimeUpdater.set(this, -1L);
        }
    }

    private boolean checkConsumerDirectDeliver() {
        if (this.consumers.isEmpty()) {
            return false;
        }
        boolean supports = true;
        for (ConsumerHolder consumerHolder : this.consumers) {
            if (consumerHolder.consumer.supportsDirectDelivery()) continue;
            supports = false;
        }
        return supports;
    }

    @Override
    public synchronized void addRedistributor(long delay) {
        this.clearRedistributorFuture();
        if (this.redistributor != null) {
            this.deliverAsync();
            return;
        }
        if (delay > 0L) {
            if (this.consumers.isEmpty() || this.hasUnMatchedPending) {
                DelayedAddRedistributor dar = new DelayedAddRedistributor(this.executor);
                this.redistributorFuture = this.scheduledExecutor.schedule(dar, delay, TimeUnit.MILLISECONDS);
            }
        } else {
            this.internalAddRedistributor();
        }
    }

    private void clearRedistributorFuture() {
        ScheduledFuture<?> future = this.redistributorFuture;
        this.redistributorFuture = null;
        if (future != null) {
            future.cancel(false);
        }
    }

    @Override
    public synchronized void cancelRedistributor() {
        this.clearRedistributorFuture();
        this.hasUnMatchedPending = false;
        if (this.redistributor != null) {
            try {
                ((Redistributor)this.redistributor.consumer).stop();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.unableToCancelRedistributor(e);
            }
            finally {
                this.consumers.remove(this.redistributor);
                this.redistributor = null;
            }
        }
    }

    @Override
    public int getConsumerCount() {
        return this.refCountForConsumers.getCount();
    }

    @Override
    public long getConsumerRemovedTimestamp() {
        return consumerRemovedTimestampUpdater.get(this);
    }

    @Override
    public long getRingSize() {
        return this.ringSize;
    }

    @Override
    public synchronized void setRingSize(long ringSize) {
        this.ringSize = ringSize;
    }

    public long getMessageCountForRing() {
        return this.pendingMetrics.getMessageCount();
    }

    public Set<Consumer> getConsumers() {
        HashSet<Consumer> consumersSet = new HashSet<Consumer>(this.consumers.size());
        for (ConsumerHolder consumerHolder : this.consumers) {
            consumersSet.add((Consumer)consumerHolder.consumer);
        }
        return consumersSet;
    }

    @Override
    public synchronized Map<SimpleString, Consumer> getGroups() {
        return this.groups.toMap();
    }

    @Override
    public synchronized void resetGroup(SimpleString groupId) {
        this.groups.remove(groupId);
    }

    @Override
    public synchronized void resetAllGroups() {
        this.groups.removeAll();
    }

    @Override
    public synchronized int getGroupCount() {
        return this.groups.size();
    }

    @Override
    public boolean hasMatchingConsumer(Message message) {
        for (ConsumerHolder consumerHolder : this.consumers) {
            Object consumer = consumerHolder.consumer;
            if (consumer instanceof Redistributor) continue;
            Filter filter1 = consumer.getFilter();
            if (filter1 == null) {
                return true;
            }
            if (!filter1.match(message)) continue;
            return true;
        }
        return false;
    }

    @Override
    public LinkedListIterator<MessageReference> iterator() {
        return new SynchronizedIterator((LinkedListIterator<MessageReference>)this.messageReferences.iterator());
    }

    public QueueBrowserIterator browserIterator() {
        return new QueueBrowserIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageReference peekFirstMessage() {
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            if (this.messageReferences != null) {
                return (MessageReference)this.messageReferences.peek();
            }
        }
        return null;
    }

    @Override
    public synchronized MessageReference removeReferenceWithID(long id1) throws Exception {
        try (LinkedListIterator<MessageReference> iterator = this.iterator();){
            MessageReference removed = null;
            while (iterator.hasNext()) {
                MessageReference ref = (MessageReference)iterator.next();
                if (ref.getMessage().getMessageID() != id1) continue;
                iterator.remove();
                this.refRemoved(ref);
                removed = ref;
                break;
            }
            if (removed == null) {
                removed = this.scheduledDeliveryHandler.removeReferenceWithID(id1);
            }
            MessageReference messageReference = removed;
            return messageReference;
        }
    }

    @Override
    public synchronized MessageReference getReference(long id1) throws ActiveMQException {
        try (LinkedListIterator<MessageReference> iterator = this.iterator();){
            while (iterator.hasNext()) {
                MessageReference ref = (MessageReference)iterator.next();
                if (ref.getMessage().getMessageID() != id1) continue;
                MessageReference messageReference = ref;
                return messageReference;
            }
            MessageReference messageReference = null;
            return messageReference;
        }
    }

    @Override
    public long getMessageCount() {
        if (this.pageSubscription != null) {
            return (long)this.pendingMetrics.getMessageCount() + (long)this.getScheduledCount() + (long)this.getDeliveringCount() + this.pageSubscription.getMessageCount();
        }
        return (long)this.pendingMetrics.getMessageCount() + (long)this.getScheduledCount() + (long)this.getDeliveringCount();
    }

    @Override
    public long getPersistentSize() {
        if (this.pageSubscription != null) {
            return this.pendingMetrics.getPersistentSize() + this.getScheduledSize() + this.getDeliveringSize() + this.pageSubscription.getPersistentSize();
        }
        return this.pendingMetrics.getPersistentSize() + this.getScheduledSize() + this.getDeliveringSize();
    }

    @Override
    public long getDurableMessageCount() {
        if (this.isDurable()) {
            if (this.pageSubscription != null) {
                return (long)this.pendingMetrics.getDurableMessageCount() + (long)this.getDurableScheduledCount() + (long)this.getDurableDeliveringCount() + this.pageSubscription.getMessageCount();
            }
            return (long)this.pendingMetrics.getDurableMessageCount() + (long)this.getDurableScheduledCount() + (long)this.getDurableDeliveringCount();
        }
        return 0L;
    }

    @Override
    public long getDurablePersistentSize() {
        if (this.isDurable()) {
            if (this.pageSubscription != null) {
                return this.pendingMetrics.getDurablePersistentSize() + this.getDurableScheduledSize() + this.getDurableDeliveringSize() + this.pageSubscription.getPersistentSize();
            }
            return this.pendingMetrics.getDurablePersistentSize() + this.getDurableScheduledSize() + this.getDurableDeliveringSize();
        }
        return 0L;
    }

    @Override
    public int getScheduledCount() {
        return this.scheduledDeliveryHandler.getScheduledCount();
    }

    @Override
    public long getScheduledSize() {
        return this.scheduledDeliveryHandler.getScheduledSize();
    }

    @Override
    public int getDurableScheduledCount() {
        return this.scheduledDeliveryHandler.getDurableScheduledCount();
    }

    @Override
    public long getDurableScheduledSize() {
        return this.scheduledDeliveryHandler.getDurableScheduledSize();
    }

    @Override
    public synchronized List<MessageReference> getScheduledMessages() {
        return this.scheduledDeliveryHandler.getScheduledReferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<MessageReference>> getDeliveringMessages() {
        Iterator consumerHolderIterator;
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            consumerHolderIterator = this.consumers.iterator();
        }
        HashMap<String, List<MessageReference>> mapReturn = new HashMap<String, List<MessageReference>>();
        while (consumerHolderIterator.hasNext()) {
            ConsumerHolder holder = (ConsumerHolder)consumerHolderIterator.next();
            List<MessageReference> msgs = holder.consumer.getDeliveringMessages();
            if (msgs == null || msgs.size() <= 0) continue;
            mapReturn.put(holder.consumer.toManagementString(), msgs);
        }
        for (String lingerSessionId : this.lingerSessionIds) {
            ServerSession serverSession = this.server.getSessionByID(lingerSessionId);
            List<MessageReference> refs = serverSession == null ? null : serverSession.getInTxLingerMessages();
            if (refs == null || refs.isEmpty()) continue;
            mapReturn.put(serverSession.toManagementString(), refs);
        }
        return mapReturn;
    }

    @Override
    public int getDeliveringCount() {
        return this.deliveringMetrics.getMessageCount();
    }

    @Override
    public long getDeliveringSize() {
        return this.deliveringMetrics.getPersistentSize();
    }

    @Override
    public int getDurableDeliveringCount() {
        return this.deliveringMetrics.getDurableMessageCount();
    }

    @Override
    public long getDurableDeliveringSize() {
        return this.deliveringMetrics.getDurablePersistentSize();
    }

    @Override
    public void acknowledge(MessageReference ref) throws Exception {
        this.acknowledge(ref, null);
    }

    @Override
    public void acknowledge(MessageReference ref, ServerConsumer consumer) throws Exception {
        this.acknowledge(ref, AckReason.NORMAL, consumer);
    }

    @Override
    public void acknowledge(MessageReference ref, AckReason reason, ServerConsumer consumer) throws Exception {
        this.acknowledge(null, ref, reason, consumer, true);
    }

    @Override
    public void acknowledge(Transaction tx, MessageReference ref) throws Exception {
        this.acknowledge(tx, ref, AckReason.NORMAL, null, true);
    }

    @Override
    public void acknowledge(Transaction tx, final MessageReference ref, AckReason reason, ServerConsumer consumer, boolean delivering) throws Exception {
        boolean transactional = tx != null;
        RefsOperation refsOperation = null;
        if (transactional) {
            refsOperation = this.getRefsOperation(tx, reason, false, delivering);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("{} acknowledge tx={} ref={}, reason={}, consumer={}", new Object[]{this, transactional, ref, reason, consumer});
        }
        if (this.nonDestructive && reason == AckReason.NORMAL) {
            if (transactional) {
                refsOperation.addOnlyRefAck(ref);
            } else {
                this.decDelivering(ref);
            }
            logger.debug("acknowledge tx ignored nonDestructive=true and reason=NORMAL");
        } else {
            if (ref.isPaged()) {
                if (transactional) {
                    this.pageSubscription.ackTx(tx, (PagedReference)ref);
                    refsOperation.addAck(ref);
                } else {
                    this.pageSubscription.ack((PagedReference)ref);
                    this.postAcknowledge(ref, reason, delivering);
                }
            } else {
                boolean durableRef;
                Message message = ref.getMessage();
                boolean bl = durableRef = message.isDurable() && this.isDurable();
                if (durableRef) {
                    if (transactional) {
                        this.storageManager.storeAcknowledgeTransactional(tx.getID(), this.id, message.getMessageID());
                        tx.setContainsPersistent();
                    } else {
                        this.storageManager.storeAcknowledge(this.id, message.getMessageID());
                    }
                }
                if (transactional) {
                    this.ackAttempts.incrementAndGet();
                    refsOperation.addAck(ref);
                } else {
                    this.postAcknowledge(ref, reason, delivering);
                }
            }
            if (!transactional) {
                this.ackAttempts.incrementAndGet();
            }
            if (AuditLogger.isMessageLoggingEnabled()) {
                String remoteAddress;
                ServerSession session = consumer != null ? this.server.getSessionByID(consumer.getSessionID()) : null;
                final Subject subject = session == null ? null : session.getRemotingConnection().getSubject();
                String string = remoteAddress = session == null ? null : session.getRemotingConnection().getRemoteAddress();
                if (transactional) {
                    AuditLogger.addAckToTransaction((Subject)subject, (String)remoteAddress, (String)this.getName().toString(), (String)ref.getMessage().toString(), (String)tx.toString());
                    tx.addOperation(new TransactionOperationAbstract(){

                        @Override
                        public void afterCommit(Transaction tx) {
                            QueueImpl.this.auditLogAck(subject, remoteAddress, ref, tx);
                        }

                        @Override
                        public void afterRollback(Transaction tx) {
                            AuditLogger.rolledBackTransaction((Subject)subject, (String)remoteAddress, (String)tx.toString(), (String)ref.toString());
                        }
                    });
                } else {
                    this.auditLogAck(subject, remoteAddress, ref, tx);
                }
            }
            if (this.server != null && this.server.hasBrokerMessagePlugins()) {
                this.server.callBrokerMessagePlugins(plugin -> plugin.messageAcknowledged(tx, ref, reason, consumer));
            }
        }
    }

    private void auditLogAck(Subject subject, String remoteAddress, MessageReference ref, Transaction tx) {
        AuditLogger.coreAcknowledgeMessage((Subject)subject, (String)remoteAddress, (String)this.getName().toString(), (String)ref.getMessage().toString(), (String)(tx == null ? null : tx.toString()));
    }

    @Override
    public void reacknowledge(Transaction tx, MessageReference ref) throws Exception {
        Message message = ref.getMessage();
        if (message.isDurable() && this.isDurable()) {
            tx.setContainsPersistent();
        }
        this.getRefsOperation(tx, AckReason.NORMAL).addAck(ref);
        this.incDelivering(ref);
        this.messagesAcknowledged.incrementAndGet();
    }

    private RefsOperation getRefsOperation(Transaction tx, AckReason ackReason) {
        return this.getRefsOperation(tx, ackReason, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RefsOperation getRefsOperation(Transaction tx, AckReason ackReason, boolean ignoreRedlieveryCheck, boolean delivering) {
        Transaction transaction = tx;
        synchronized (transaction) {
            RefsOperation oper = (RefsOperation)tx.getProperty(6);
            if (oper == null) {
                oper = tx.createRefsOperation(this, ackReason);
                tx.putProperty(6, oper);
                tx.addOperation(oper);
            }
            if (ignoreRedlieveryCheck) {
                oper.setIgnoreRedeliveryCheck();
            }
            oper.setDelivering(delivering);
            return oper;
        }
    }

    @Override
    public void cancel(Transaction tx, MessageReference reference) {
        this.cancel(tx, reference, false);
    }

    @Override
    public void cancel(Transaction tx, MessageReference reference, boolean ignoreRedeliveryCheck) {
        this.getRefsOperation(tx, AckReason.NORMAL, ignoreRedeliveryCheck, true).addAck(reference);
    }

    @Override
    public synchronized void cancel(MessageReference reference, long timeBase) throws Exception {
        Pair<Boolean, Boolean> redeliveryResult = this.checkRedelivery(reference, timeBase, false);
        if (((Boolean)redeliveryResult.getA()).booleanValue()) {
            if (!this.scheduledDeliveryHandler.checkAndSchedule(reference, false)) {
                this.internalAddSorted(reference);
            }
            this.resetAllIterators();
        } else if (!((Boolean)redeliveryResult.getB()).booleanValue()) {
            this.decDelivering(reference);
        }
    }

    @Override
    public void expire(MessageReference ref) throws Exception {
        this.expire(ref, null, true);
    }

    @Override
    public void expire(MessageReference ref, ServerConsumer consumer, boolean delivering) throws Exception {
        if (this.addressSettings.getExpiryAddress() != null) {
            this.createExpiryResources();
            if (logger.isTraceEnabled()) {
                logger.trace("moving expired reference {} to address = {} from queue={}", new Object[]{ref, this.addressSettings.getExpiryAddress(), this.name});
            }
            this.move(null, this.addressSettings.getExpiryAddress(), null, ref, false, AckReason.EXPIRED, consumer, null, delivering);
        } else {
            logger.trace("expiry is null, just acking expired message for reference {} from queue={}", (Object)ref, (Object)this.name);
            this.acknowledge(null, ref, AckReason.EXPIRED, consumer, delivering);
        }
        this.refCountForConsumers.check();
        if (this.server != null && this.server.hasBrokerMessagePlugins()) {
            this.server.callBrokerMessagePlugins(plugin -> plugin.messageExpired(ref, this.addressSettings.getExpiryAddress(), consumer));
        }
    }

    @Override
    public SimpleString getExpiryAddress() {
        return this.addressSettings.getExpiryAddress();
    }

    @Override
    public SimpleString getDeadLetterAddress() {
        return this.addressSettings.getDeadLetterAddress();
    }

    @Override
    public void referenceHandled(MessageReference ref) {
        this.incDelivering(ref);
    }

    @Override
    public void incrementMesssagesAdded() {
        this.messagesAdded.incrementAndGet();
    }

    @Override
    public void deliverScheduledMessages() throws ActiveMQException {
        this.internalDeliverScheduleMessages(this.scheduledDeliveryHandler.cancel(ref -> true));
    }

    @Override
    public void deliverScheduledMessages(String filterString) throws ActiveMQException {
        Filter filter = filterString == null || filterString.length() == 0 ? null : FilterImpl.createFilter(filterString);
        this.internalDeliverScheduleMessages(this.scheduledDeliveryHandler.cancel(ref -> filter == null ? true : filter.match(ref.getMessage())));
    }

    @Override
    public void deliverScheduledMessage(long messageId) throws ActiveMQException {
        this.internalDeliverScheduleMessages(this.scheduledDeliveryHandler.cancel(ref -> ref.getMessageID() == messageId));
    }

    private void internalDeliverScheduleMessages(List<MessageReference> scheduledMessages) {
        if (scheduledMessages != null && scheduledMessages.size() > 0) {
            for (MessageReference ref : scheduledMessages) {
                ref.getMessage().setScheduledDeliveryTime(Long.valueOf(ref.getScheduledDeliveryTime()));
                ref.setScheduledDeliveryTime(0L);
            }
            this.addHead(scheduledMessages, true);
        }
    }

    @Override
    public long getMessagesAdded() {
        if (this.pageSubscription != null) {
            return this.messagesAdded.get() + this.pageSubscription.getCounter().getValueAdded();
        }
        return this.messagesAdded.get();
    }

    @Override
    public long getMessagesAcknowledged() {
        return this.messagesAcknowledged.get();
    }

    @Override
    public long getAcknowledgeAttempts() {
        return this.ackAttempts.get();
    }

    @Override
    public long getMessagesExpired() {
        return this.messagesExpired.get();
    }

    @Override
    public long getMessagesKilled() {
        return this.messagesKilled.get();
    }

    @Override
    public long getMessagesReplaced() {
        return this.messagesReplaced.get();
    }

    @Override
    public int deleteAllReferences() throws Exception {
        return this.deleteAllReferences(500);
    }

    @Override
    public int deleteAllReferences(int flushLimit) throws Exception {
        return this.deleteMatchingReferences(flushLimit, null);
    }

    @Override
    public int deleteMatchingReferences(Filter filter) throws Exception {
        return this.deleteMatchingReferences(500, filter);
    }

    @Override
    public int deleteMatchingReferences(int flushLimit, Filter filter1, AckReason ackReason) throws Exception {
        return this.iterQueue(flushLimit, filter1, this.createDeleteMatchingAction(ackReason));
    }

    QueueIterateAction createDeleteMatchingAction(final AckReason ackReason) {
        return new QueueIterateAction(){

            @Override
            public boolean actMessage(Transaction tx, MessageReference ref) throws Exception {
                QueueImpl.this.incDelivering(ref);
                QueueImpl.this.acknowledge(tx, ref, ackReason, null, true);
                return true;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int iterQueue(int flushLimit, Filter filter1, QueueIterateAction messageAction) throws Exception {
        int count = 0;
        int txCount = 0;
        Integer expectedHits = messageAction.expectedHits();
        this.depagePending = true;
        this.depageLock.lock();
        try {
            TransactionImpl tx = new TransactionImpl(this.storageManager);
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                try (LinkedListIterator<MessageReference> iter = this.iterator();){
                    while (iter.hasNext()) {
                        MessageReference ref2 = (MessageReference)iter.next();
                        if (ref2.isPaged() && this.queueDestroyed || filter1 != null && !filter1.match(ref2.getMessage())) continue;
                        if (messageAction.actMessage(tx, ref2)) {
                            iter.remove();
                            this.refRemoved(ref2);
                        }
                        ++txCount;
                        if (expectedHits == null || ++count < expectedHits) continue;
                        break;
                    }
                    if (txCount > 0) {
                        tx.commit();
                        tx = new TransactionImpl(this.storageManager);
                        txCount = 0;
                    }
                    List<MessageReference> cancelled = this.scheduledDeliveryHandler.cancel(ref -> filter1 == null ? true : filter1.match(ref.getMessage()));
                    for (MessageReference messageReference : cancelled) {
                        messageAction.actMessage(tx, messageReference);
                        ++count;
                        ++txCount;
                    }
                    if (txCount > 0) {
                        tx.commit();
                        tx = new TransactionImpl(this.storageManager);
                        txCount = 0;
                    }
                }
            }
            if (this.pageIterator != null && !this.queueDestroyed) {
                while (this.pageIterator.hasNext()) {
                    PagedReference reference = (PagedReference)this.pageIterator.next();
                    this.pageIterator.remove();
                    if (filter1 == null || filter1.match(reference.getMessage())) {
                        ++count;
                        ++txCount;
                        if (!messageAction.actMessage(tx, reference)) {
                            this.addTail(reference, false);
                        }
                    } else {
                        this.addTail(reference, false);
                    }
                    if (txCount <= 0 || txCount % flushLimit != 0) continue;
                    tx.commit();
                    tx = new TransactionImpl(this.storageManager);
                    txCount = 0;
                }
            }
            if (txCount > 0) {
                tx.commit();
                tx = null;
            }
            if (this.filter != null && !this.queueDestroyed && this.pageSubscription != null) {
                this.scheduleDepage(false);
            }
            int n = count;
            return n;
        }
        finally {
            this.depageLock.unlock();
            this.depagePending = false;
            this.forceDelivery();
        }
    }

    @Override
    public void destroyPaging() throws Exception {
        if (this.pageSubscription != null) {
            this.pageSubscription.destroy();
            this.pageSubscription.cleanupEntries(true);
        }
    }

    @Override
    public synchronized boolean deleteReference(long messageID) throws Exception {
        boolean deleted = false;
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                this.incDelivering(ref);
                this.acknowledge(tx, ref);
                iter.remove();
                this.refRemoved(ref);
                deleted = true;
                break;
            }
            if (!deleted) {
                deleted = this.scheduledDeliveryHandler.removeReferenceWithID(messageID, tx) != null;
            }
            tx.commit();
            boolean bl = deleted;
            return bl;
        }
    }

    @Override
    public void deleteQueue() throws Exception {
        this.deleteQueue(false);
    }

    @Override
    public void removeAddress() throws Exception {
        this.server.removeAddressInfo(this.getAddress(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteQueue(boolean removeConsumers) throws Exception {
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            if (this.queueDestroyed) {
                return;
            }
            this.queueDestroyed = true;
        }
        BindingsTransactionImpl tx = new BindingsTransactionImpl(this.storageManager);
        try {
            this.deleteAllReferences();
            this.destroyPaging();
            this.postOffice.removeBinding(this.name, tx, true);
            if (removeConsumers) {
                for (ConsumerHolder consumerHolder : this.consumers) {
                    consumerHolder.consumer.disconnect();
                }
            }
            if (this.isDurable()) {
                this.storageManager.deleteQueueBinding(tx.getID(), this.getID());
                tx.setContainsPersistent();
            }
            if (this.slowConsumerReaperFuture != null) {
                this.slowConsumerReaperFuture.cancel(false);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            if (this.factory != null) {
                this.factory.queueRemoved(this);
            }
        }
    }

    @Override
    public synchronized boolean expireReference(long messageID) throws Exception {
        if (this.isExpirationRedundant()) {
            return false;
        }
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                this.incDelivering(ref);
                this.expire(ref);
                iter.remove();
                this.refRemoved(ref);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public synchronized int expireReferences(Filter filter) throws Exception {
        if (this.isExpirationRedundant()) {
            return 0;
        }
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        int count = 0;
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (filter != null && !filter.match(ref.getMessage())) continue;
                this.incDelivering(ref);
                this.expire(tx, ref, true);
                iter.remove();
                this.refRemoved(ref);
                ++count;
            }
            tx.commit();
            int n = count;
            return n;
        }
    }

    @Override
    public void expireReferences(Runnable done) {
        if (this.isExpirationRedundant()) {
            if (done != null) {
                done.run();
            }
            return;
        }
        if (!this.queueDestroyed) {
            this.getExecutor().execute((Runnable)new ExpiryScanner(done));
        } else if (done != null) {
            done.run();
        }
    }

    public boolean isExpirationRedundant() {
        SimpleString expiryAddress = this.addressSettings.getExpiryAddress();
        if (expiryAddress != null && expiryAddress.equals((Object)this.address)) {
            logger.trace("Redundant expiration from {} to {}", (Object)this.address, (Object)expiryAddress);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean sendMessageToDeadLetterAddress(long messageID) throws Exception {
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                this.incDelivering(ref);
                this.sendToDeadLetterAddress(null, ref);
                iter.remove();
                this.refRemoved(ref);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public synchronized int sendMessagesToDeadLetterAddress(Filter filter) throws Exception {
        int count = 0;
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (filter != null && !filter.match(ref.getMessage())) continue;
                this.incDelivering(ref);
                this.sendToDeadLetterAddress(null, ref);
                iter.remove();
                this.refRemoved(ref);
                ++count;
            }
            int n = count;
            return n;
        }
    }

    @Override
    public synchronized boolean moveReference(long messageID, SimpleString toAddress, Binding binding, boolean rejectDuplicate) throws Exception {
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                iter.remove();
                this.refRemoved(ref);
                this.incDelivering(ref);
                try {
                    this.move(null, toAddress, binding, ref, rejectDuplicate, AckReason.NORMAL, null, null, true);
                }
                catch (Exception e) {
                    this.decDelivering(ref);
                    throw e;
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public int moveReferences(Filter filter, SimpleString toAddress, Binding binding) throws Exception {
        return this.moveReferences(500, filter, toAddress, false, binding);
    }

    @Override
    public int moveReferences(int flushLimit, Filter filter, SimpleString toAddress, boolean rejectDuplicates, Binding binding) throws Exception {
        return this.moveReferences(flushLimit, filter, toAddress, rejectDuplicates, -1, binding);
    }

    @Override
    public int moveReferences(int flushLimit, Filter filter, final SimpleString toAddress, final boolean rejectDuplicates, int messageCount, final Binding binding) throws Exception {
        final Integer expectedHits = messageCount > 0 ? Integer.valueOf(messageCount) : null;
        final DuplicateIDCache targetDuplicateCache = this.postOffice.getDuplicateIDCache(toAddress);
        return this.iterQueue(flushLimit, filter, new QueueIterateAction(){

            @Override
            public Integer expectedHits() {
                return expectedHits;
            }

            @Override
            public boolean actMessage(Transaction tx, MessageReference ref) throws Exception {
                byte[] duplicateBytes;
                boolean ignored = false;
                QueueImpl.this.incDelivering(ref);
                if (rejectDuplicates && (duplicateBytes = ref.getMessage().getDuplicateIDBytes()) != null && targetDuplicateCache.contains(duplicateBytes)) {
                    ActiveMQServerLogger.LOGGER.messageWithDuplicateID(ref.getMessage().getDuplicateProperty(), toAddress, QueueImpl.this.address, QueueImpl.this.address);
                    QueueImpl.this.acknowledge(tx, ref);
                    ignored = true;
                }
                if (!ignored) {
                    QueueImpl.this.move(null, toAddress, binding, ref, rejectDuplicates, AckReason.NORMAL, null, null, true);
                }
                return true;
            }
        });
    }

    public int moveReferencesBetweenSnFQueues(final SimpleString queueSuffix) throws Exception {
        return this.iterQueue(500, null, new QueueIterateAction(){

            @Override
            public boolean actMessage(Transaction tx, MessageReference ref) throws Exception {
                return QueueImpl.this.moveBetweenSnFQueues(queueSuffix, tx, ref, null);
            }
        });
    }

    public synchronized int rerouteMessages(final SimpleString queueName, Filter filter) throws Exception {
        return this.iterQueue(500, filter, new QueueIterateAction(){

            @Override
            public boolean actMessage(Transaction tx, MessageReference ref) throws Exception {
                RoutingContextImpl routingContext = new RoutingContextImpl(tx);
                routingContext.setAddress(QueueImpl.this.server.locateQueue(queueName).getAddress());
                QueueImpl.this.server.getPostOffice().getBinding(queueName).route(ref.getMessage(), routingContext);
                QueueImpl.this.postOffice.processRoute(ref.getMessage(), routingContext, false);
                return false;
            }
        });
    }

    @Override
    public int retryMessages(Filter filter) throws Exception {
        return this.retryMessages(filter, null);
    }

    @Override
    public int retryMessages(Filter filter, final Integer expectedHits) throws Exception {
        final HashMap queues = new HashMap();
        return this.iterQueue(500, filter, new QueueIterateAction(){

            @Override
            public Integer expectedHits() {
                return expectedHits;
            }

            @Override
            public boolean actMessage(Transaction tx, MessageReference ref) throws Exception {
                String originalMessageAddress = ref.getMessage().getAnnotationString(Message.HDR_ORIGINAL_ADDRESS);
                String originalMessageQueue = ref.getMessage().getAnnotationString(Message.HDR_ORIGINAL_QUEUE);
                Binding binding = null;
                if (originalMessageQueue != null) {
                    binding = QueueImpl.this.postOffice.getBinding(SimpleString.toSimpleString((String)originalMessageQueue));
                }
                if (originalMessageAddress != null && binding != null) {
                    QueueImpl.this.incDelivering(ref);
                    Long targetQueue = null;
                    if (originalMessageQueue != null && !originalMessageQueue.equals(originalMessageAddress) && (targetQueue = (Long)queues.get(originalMessageQueue)) == null && binding instanceof LocalQueueBinding) {
                        targetQueue = ((LocalQueueBinding)binding).getID();
                        queues.put(originalMessageQueue, targetQueue);
                    }
                    QueueImpl.this.move(tx, SimpleString.toSimpleString((String)originalMessageAddress), null, ref, false, AckReason.NORMAL, null, targetQueue, true);
                    return true;
                }
                ActiveMQServerLogger.LOGGER.unableToFindTargetQueue(originalMessageQueue);
                return false;
            }
        });
    }

    @Override
    public synchronized boolean changeReferencePriority(long messageID, byte newPriority) throws Exception {
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                iter.remove();
                this.refRemoved(ref);
                ref.getMessage().setPriority(newPriority);
                this.addTail(ref, false);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public synchronized int changeReferencesPriority(Filter filter, byte newPriority) throws Exception {
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            int count = 0;
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (filter != null && !filter.match(ref.getMessage())) continue;
                ++count;
                iter.remove();
                this.refRemoved(ref);
                ref.getMessage().setPriority(newPriority);
                this.addTail(ref, false);
            }
            int n = count;
            return n;
        }
    }

    @Override
    public synchronized void resetAllIterators() {
        for (ConsumerHolder consumerHolder : this.consumers) {
            consumerHolder.resetIterator();
        }
    }

    @Override
    public synchronized void pause() {
        this.pause(false);
    }

    @Override
    public synchronized void reloadPause(long recordID) {
        this.paused = true;
        if (this.pauseStatusRecord >= 0L) {
            try {
                this.storageManager.deleteQueueStatus(this.pauseStatusRecord);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.unableToDeleteQueueStatus(e);
            }
        }
        this.pauseStatusRecord = recordID;
    }

    @Override
    public synchronized void pause(boolean persist) {
        try {
            this.flushDeliveriesInTransit();
            if (persist && this.isDurable()) {
                if (this.pauseStatusRecord >= 0L) {
                    this.storageManager.deleteQueueStatus(this.pauseStatusRecord);
                }
                this.pauseStatusRecord = this.storageManager.storeQueueStatus(this.id, AddressQueueStatus.PAUSED);
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.unableToPauseQueue(e);
        }
        this.paused = true;
    }

    @Override
    public synchronized void resume() {
        this.paused = false;
        if (this.pauseStatusRecord >= 0L) {
            try {
                this.storageManager.deleteQueueStatus(this.pauseStatusRecord);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.unableToResumeQueue(e);
            }
            this.pauseStatusRecord = -1L;
        }
        this.deliverAsync();
    }

    @Override
    public synchronized boolean isPaused() {
        return this.paused || this.addressInfo != null && this.addressInfo.isPaused();
    }

    @Override
    public synchronized boolean isPersistedPause() {
        return this.pauseStatusRecord >= 0L;
    }

    @Override
    public boolean isDirectDeliver() {
        return this.directDeliver && this.supportsDirectDeliver;
    }

    @Override
    public boolean isInternalQueue() {
        return this.internalQueue;
    }

    @Override
    public void setInternalQueue(boolean internalQueue) {
        this.internalQueue = internalQueue;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QueueImpl)) {
            return false;
        }
        QueueImpl qother = (QueueImpl)other;
        return this.name.equals((Object)qother.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "QueueImpl[name=" + this.name.toString() + ", postOffice=" + this.postOffice + ", temp=" + this.temporary + "]@" + Integer.toHexString(System.identityHashCode(this));
    }

    private synchronized void internalAddTail(MessageReference ref) {
        this.refAdded(ref);
        this.messageReferences.addTail((Object)ref, this.getPriority(ref));
        this.pendingMetrics.incrementMetrics(ref);
        this.enforceRing(false);
    }

    private void internalAddHead(MessageReference ref) {
        this.queueMemorySize.addSize(ref.getMessageMemoryEstimate());
        this.pendingMetrics.incrementMetrics(ref);
        this.refAdded(ref);
        int priority = this.getPriority(ref);
        this.messageReferences.addHead((Object)ref, priority);
        ref.setInDelivery(false);
    }

    private void internalAddSorted(MessageReference ref) {
        this.queueMemorySize.addSize(ref.getMessageMemoryEstimate());
        this.pendingMetrics.incrementMetrics(ref);
        this.refAdded(ref);
        int priority = this.getPriority(ref);
        this.messageReferences.addSorted((Object)ref, priority);
        ref.setInDelivery(false);
    }

    private int getPriority(MessageReference ref) {
        try {
            return ref.getMessage().getPriority();
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.unableToGetMessagePriority(e);
            return 4;
        }
    }

    synchronized void doInternalPoll() {
        MessageReference ref;
        int added = 0;
        while ((ref = (MessageReference)this.intermediateMessageReferences.poll()) != null) {
            if (ref.skipDelivery()) continue;
            this.internalAddTail(ref);
            if (!ref.isPaged()) {
                this.incrementMesssagesAdded();
            }
            if (added++ <= 1000) continue;
            this.deliverAsync(true);
            return;
        }
    }

    private void removeMessagesWhileDelivering() throws Exception {
        assert (this.queueDestroyed) : "Method to be used only when the queue was destroyed";
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        int txCount = 0;
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.isPaged()) continue;
                this.acknowledge(tx, ref, AckReason.KILLED, null, true);
                iter.remove();
                this.refRemoved(ref);
                ++txCount;
            }
            if (txCount > 0) {
                tx.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deliver() {
        if (logger.isTraceEnabled()) {
            logger.trace("Queue {} doing deliver. messageReferences={} with consumers={}", new Object[]{this.name, this.messageReferences.size(), this.getConsumerCount()});
        }
        this.scheduledRunners.decrementAndGet();
        this.doInternalPoll();
        int noDelivery = 0;
        int numNoMatch = 0;
        int numAttempts = 0;
        int handled = 0;
        long timeout = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(1000L);
        this.consumers.reset();
        while (true) {
            MessageReference ref;
            if (handled == 1000 || System.nanoTime() - timeout > 0L) {
                this.deliverAsync(true);
                return false;
            }
            Consumer handledconsumer = null;
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                if (this.queueDestroyed) {
                    if (this.messageReferences.size() == 0) {
                        return false;
                    }
                    try {
                        this.removeMessagesWhileDelivering();
                    }
                    catch (Exception e) {
                        logger.warn(e.getMessage(), (Throwable)e);
                    }
                    return false;
                }
                if (this.isPaused() || !this.canDispatch()) {
                    return false;
                }
                if (this.messageReferences.size() == 0) {
                    break;
                }
                if (!this.consumers.hasNext()) {
                    this.pruneLastValues();
                    break;
                }
                ConsumerHolder holder = (ConsumerHolder)this.consumers.next();
                Object consumer = holder.consumer;
                Consumer groupConsumer = null;
                if (holder.iter == null) {
                    holder.iter = this.messageReferences.iterator();
                }
                if ((ref = holder.iter.hasNext() ? (MessageReference)holder.iter.next() : null) == null) {
                    ++noDelivery;
                } else {
                    if (this.checkExpired(ref)) {
                        logger.trace("Reference {} being expired", (Object)ref);
                        this.removeMessageReference(holder, ref);
                        ++handled;
                        this.consumers.reset();
                        continue;
                    }
                    logger.trace("Queue {} is delivering reference {}", (Object)this.name, (Object)ref);
                    SimpleString groupID = this.extractGroupID(ref);
                    groupConsumer = this.getGroupConsumer(groupID);
                    if (groupConsumer != null) {
                        consumer = groupConsumer;
                    }
                    ++numAttempts;
                    HandleStatus status = this.handle(ref, (Consumer)consumer);
                    if (status == HandleStatus.HANDLED) {
                        noDelivery = 0;
                        numNoMatch = 0;
                        numAttempts = 0;
                        ref = this.handleMessageGroup(ref, (Consumer)consumer, groupConsumer, groupID);
                        this.deliveriesInTransit.countUp();
                        if (!this.nonDestructive) {
                            this.removeMessageReference(holder, ref);
                        }
                        ref.setInDelivery(true);
                        handledconsumer = (Consumer)consumer;
                        ++handled;
                        this.consumers.reset();
                    } else if (status == HandleStatus.BUSY) {
                        try {
                            holder.iter.repeat();
                        }
                        catch (NoSuchElementException e) {
                            logger.warn(e.getMessage(), (Throwable)e);
                        }
                        ++noDelivery;
                        numNoMatch = 0;
                        numAttempts = 0;
                    } else if (status == HandleStatus.NO_MATCH) {
                        this.consumers.reset();
                        if (++numNoMatch == numAttempts && numAttempts == this.consumers.size() && this.redistributor == null) {
                            this.hasUnMatchedPending = true;
                        }
                    }
                }
                if (groupConsumer != null) {
                    if (noDelivery > 0) {
                        this.pruneLastValues();
                        break;
                    }
                    noDelivery = 0;
                } else if (!this.consumers.hasNext()) {
                    if (noDelivery == this.consumers.size()) {
                        this.pruneLastValues();
                        if (handledconsumer != null) {
                            ActiveMQServerLogger.LOGGER.nonDeliveryHandled();
                        } else {
                            logger.debug("{}::All the consumers were busy, giving up now", (Object)this);
                            break;
                        }
                    }
                    noDelivery = 0;
                }
            }
            if (handledconsumer == null) continue;
            this.proceedDeliver(handledconsumer, ref);
        }
        return true;
    }

    protected void pruneLastValues() {
    }

    protected void removeMessageReference(ConsumerHolder<? extends Consumer> holder, MessageReference ref) {
        holder.iter.remove();
        this.refRemoved(ref);
    }

    private void checkDepage() {
        if (this.queueDestroyed) {
            return;
        }
        if (this.pageIterator != null && this.pageSubscription.isPaging()) {
            if (logger.isDebugEnabled()) {
                logger.debug("CheckDepage on queue name {}, id={}", (Object)this.name, (Object)this.id);
            }
            this.pageDelivered = true;
            if (!this.depagePending && this.needsDepage() && this.pageIterator.tryNext() != PageIterator.NextResult.noElements) {
                this.scheduleDepage(false);
            }
        } else {
            this.pageDelivered = false;
        }
    }

    private boolean needsDepage() {
        int maxReadMessages = this.pageSubscription.getPagingStore().getMaxPageReadMessages();
        int maxReadBytes = this.pageSubscription.getPagingStore().getMaxPageReadBytes();
        if (maxReadMessages <= 0 && maxReadBytes <= 0) {
            return this.queueMemorySize.getSize() < this.pageSubscription.getPagingStore().getMaxSize() && this.intermediateMessageReferences.size() + this.messageReferences.size() < 1000;
        }
        return !(maxReadBytes > 0 && this.queueMemorySize.getSize() + this.deliveringMetrics.getPersistentSize() >= (long)maxReadBytes || maxReadMessages > 0 && this.queueMemorySize.getElements() + (long)this.deliveringMetrics.getMessageCount() >= (long)maxReadMessages);
    }

    private SimpleString extractGroupID(MessageReference ref) {
        if (this.internalQueue || this.exclusive || this.groupBuckets == 0) {
            return null;
        }
        try {
            return ref.getMessage().getGroupID();
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.unableToExtractGroupID(e);
            return null;
        }
    }

    private int extractGroupSequence(MessageReference ref) {
        if (this.internalQueue) {
            return 0;
        }
        try {
            return ref.getMessage().getGroupSequence();
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.unableToExtractGroupSequence(e);
            return 0;
        }
    }

    protected void refRemoved(MessageReference ref) {
        this.queueMemorySize.addSize(-ref.getMessageMemoryEstimate());
        this.pendingMetrics.decrementMetrics(ref);
        if (ref.isPaged()) {
            this.pagedReferences.decrementAndGet();
        }
    }

    protected void addRefSize(MessageReference ref) {
        this.queueMemorySize.addSize(ref.getMessageMemoryEstimate());
        this.pendingMetrics.incrementMetrics(ref);
    }

    protected void refAdded(MessageReference ref) {
        if (ref.isPaged()) {
            this.pagedReferences.incrementAndGet();
        }
    }

    private void scheduleDepage(boolean scheduleExpiry) {
        if (!this.depagePending) {
            logger.trace("Scheduling depage for queue {}", (Object)this.name);
            this.depagePending = true;
            this.pageSubscription.getPagingStore().execute(() -> this.depage(scheduleExpiry));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void depage(boolean scheduleExpiry) {
        this.depagePending = false;
        if (!this.depageLock.tryLock()) {
            return;
        }
        try {
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                if (this.isPaused()) return;
                if (this.pageIterator == null) {
                    return;
                }
            }
            long timeout = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(1000L);
            if (logger.isTraceEnabled()) {
                logger.trace("QueueMemorySize before depage on queue={} is {}", (Object)this.name, (Object)this.queueMemorySize.getSize());
            }
            this.directDeliver = false;
            int depaged = 0;
            while (timeout - System.nanoTime() > 0L && this.needsDepage()) {
                PageIterator.NextResult status = this.pageIterator.tryNext();
                if (status == PageIterator.NextResult.retry) continue;
                if (status == PageIterator.NextResult.noElements) break;
                ++depaged;
                PagedReference reference = (PagedReference)this.pageIterator.next();
                if (logger.isDebugEnabled()) {
                    logger.debug("Depaging reference {} on queue {} depaged::{}", new Object[]{reference, this.name, depaged});
                }
                this.addTail(reference, false);
                this.pageIterator.remove();
                this.pageSubscription.incrementDeliveredSize(this.getPersistentSize(reference));
            }
            if (logger.isDebugEnabled()) {
                int maxSize = this.pageSubscription.getPagingStore().getPageSizeBytes();
                if (depaged == 0 && this.queueMemorySize.getSize() >= (long)maxSize) {
                    logger.debug("Couldn't depage any message as the maxSize on the queue was achieved. There are too many pending messages to be acked in reference to the page configuration");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Queue Memory Size after depage on queue={} is {} with maxSize = {}. Depaged {} messages, pendingDelivery={}, intermediateMessageReferences= {}, queueDelivering={}", new Object[]{this.name, this.queueMemorySize.getSize(), maxSize, depaged, this.messageReferences.size(), this.intermediateMessageReferences.size(), this.deliveringMetrics.getMessageCount()});
                }
            }
            this.deliverAsync(true);
            if (depaged <= 0) return;
            if (!scheduleExpiry) return;
            this.expireReferences();
            return;
        }
        finally {
            this.depageLock.unlock();
        }
    }

    @Override
    public synchronized MessageReference removeWithSuppliedID(String serverID, long id, NodeStore<MessageReference> nodeStore) {
        this.checkIDSupplier(nodeStore);
        MessageReference reference = (MessageReference)this.messageReferences.removeWithID(serverID, id);
        if (reference != null) {
            this.refRemoved(reference);
        }
        return reference;
    }

    private void internalAddRedistributor() {
        if (this.redistributor == null && (this.consumers.isEmpty() || this.hasUnMatchedPending)) {
            logger.trace("QueueImpl::Adding redistributor on queue {}", (Object)this);
            this.redistributor = new ConsumerHolder<Redistributor>(new Redistributor(this, this.storageManager, this.postOffice));
            ((Redistributor)this.redistributor.consumer).start();
            this.consumers.add(this.redistributor);
            this.hasUnMatchedPending = false;
            this.deliverAsync();
        }
    }

    @Override
    public Pair<Boolean, Boolean> checkRedelivery(MessageReference reference, long timeBase, boolean ignoreRedeliveryDelay) throws Exception {
        if (this.internalQueue) {
            logger.trace("Queue {} is an internal queue, no checkRedelivery", (Object)this.name);
            this.decDelivering(reference);
            return new Pair((Object)true, (Object)false);
        }
        if (!this.internalQueue && reference.isDurable() && this.isDurable() && !reference.isPaged()) {
            this.storageManager.updateDeliveryCount(reference);
        }
        int maxDeliveries = this.addressSettings.getMaxDeliveryAttempts();
        int deliveryCount = reference.getDeliveryCount();
        if (maxDeliveries > 0 && deliveryCount >= maxDeliveries) {
            if (logger.isTraceEnabled()) {
                logger.trace("Sending reference {} to DLA = {} since ref.getDeliveryCount={} and maxDeliveries={} from queue={}", new Object[]{reference, this.addressSettings.getDeadLetterAddress(), reference.getDeliveryCount(), maxDeliveries, this.name});
            }
            boolean dlaResult = this.sendToDeadLetterAddress(null, reference, this.addressSettings.getDeadLetterAddress());
            return new Pair((Object)false, (Object)dlaResult);
        }
        long redeliveryDelay = this.addressSettings.getRedeliveryDelay();
        if (!ignoreRedeliveryDelay && redeliveryDelay > 0L) {
            redeliveryDelay = this.calculateRedeliveryDelay(this.addressSettings, deliveryCount);
            if (logger.isTraceEnabled()) {
                logger.trace("Setting redeliveryDelay={} on reference={}", (Object)redeliveryDelay, (Object)reference);
            }
            reference.setScheduledDeliveryTime(timeBase + redeliveryDelay);
            if (!reference.isPaged() && reference.isDurable() && this.isDurable()) {
                this.storageManager.updateScheduledDeliveryTime(reference);
            }
        }
        this.decDelivering(reference);
        return new Pair((Object)true, (Object)false);
    }

    public int getNumberOfReferences() {
        return this.messageReferences.size();
    }

    private RoutingStatus move(Transaction originalTX, SimpleString address, Binding binding, MessageReference ref, boolean rejectDuplicate, AckReason reason, ServerConsumer consumer, Long queueID, boolean delivering) throws Exception {
        Transaction tx = originalTX != null ? originalTX : new TransactionImpl(this.storageManager);
        Message copyMessage = this.makeCopy(ref, reason == AckReason.EXPIRED, address);
        Object originalRoutingType = ref.getMessage().getBrokerProperty(Message.HDR_ORIG_ROUTING_TYPE);
        if (originalRoutingType != null && originalRoutingType instanceof Byte) {
            copyMessage.setRoutingType(RoutingType.getType((byte)((Byte)originalRoutingType)));
        }
        if (queueID != null) {
            byte[] encodedBuffer = new byte[8];
            ByteBuffer buffer = ByteBuffer.wrap(encodedBuffer);
            buffer.putLong(0, queueID);
            copyMessage.putBytesProperty(Message.HDR_ROUTE_TO_IDS.toString(), encodedBuffer);
        }
        RoutingContextImpl context = new RoutingContextImpl(tx);
        if (reason == AckReason.EXPIRED) {
            context.setMirrorDisabled(true);
        }
        RoutingStatus routingStatus = this.postOffice.route(copyMessage, context, false, rejectDuplicate, binding);
        this.acknowledge(tx, ref, reason, consumer, delivering);
        if (originalTX == null) {
            tx.commit();
        }
        return routingStatus;
    }

    private boolean moveBetweenSnFQueues(SimpleString queueSuffix, Transaction tx, MessageReference ref, SimpleString newAddress) throws Exception {
        Message copyMessage = this.makeCopy(ref, false, false, newAddress);
        byte[] oldRouteToIDs = null;
        for (SimpleString propName : copyMessage.getPropertyNames()) {
            if (!propName.startsWith(Message.HDR_ROUTE_TO_IDS)) continue;
            oldRouteToIDs = (byte[])copyMessage.removeProperty(propName.toString());
            if (!logger.isDebugEnabled()) break;
            String hashcodeToString = oldRouteToIDs.toString();
            logger.debug("Removed property from message: {} = {} ({})", new Object[]{propName, hashcodeToString, ByteBuffer.wrap(oldRouteToIDs).getLong()});
            break;
        }
        ByteBuffer oldBuffer = ByteBuffer.wrap(oldRouteToIDs);
        RoutingContextImpl routingContext = new RoutingContextImpl(tx);
        while (oldBuffer.hasRemaining()) {
            long oldQueueID = oldBuffer.getLong();
            Pair<String, Binding> result = this.locateTargetBinding(queueSuffix, copyMessage, oldQueueID);
            Binding targetBinding = (Binding)result.getB();
            String targetNodeID = (String)result.getA();
            if (targetBinding == null) {
                ActiveMQServerLogger.LOGGER.unableToFindTargetQueue(targetNodeID);
                continue;
            }
            logger.debug("Routing on binding: {}", (Object)targetBinding);
            targetBinding.route(copyMessage, routingContext);
        }
        this.postOffice.processRoute(copyMessage, routingContext, false);
        ref.handled();
        this.acknowledge(tx, ref);
        this.storageManager.afterCompleteOperations(new IOCallback(){

            public void onError(int errorCode, String errorMessage) {
                ActiveMQServerLogger.LOGGER.ioErrorRedistributing(errorCode, errorMessage);
            }

            public void done() {
                QueueImpl.this.deliverAsync();
            }
        });
        return true;
    }

    private Pair<String, Binding> locateTargetBinding(SimpleString queueSuffix, Message copyMessage, long oldQueueID) {
        String targetNodeID = null;
        RemoteQueueBinding targetBinding = null;
        block0: for (RemoteQueueBinding remoteQueueBinding : IterableStream.iterableOf(this.postOffice.getAllBindings().filter(RemoteQueueBinding.class::isInstance).map(RemoteQueueBinding.class::cast))) {
            if (oldQueueID != remoteQueueBinding.getRemoteQueueID()) continue;
            SimpleString oldQueueName = remoteQueueBinding.getRoutingName();
            String temp = remoteQueueBinding.getQueue().getName().toString();
            targetNodeID = temp.substring(temp.lastIndexOf(".") + 1);
            if (logger.isDebugEnabled()) {
                logger.debug("Message formerly destined for {} with ID: {} on address {} on node {}", new Object[]{oldQueueName, oldQueueID, copyMessage.getAddressSimpleString(), targetNodeID});
            }
            for (RemoteQueueBinding innerRemoteQueueBinding : IterableStream.iterableOf(this.postOffice.getAllBindings().filter(RemoteQueueBinding.class::isInstance).map(RemoteQueueBinding.class::cast))) {
                temp = innerRemoteQueueBinding.getQueue().getName().toString();
                targetNodeID = temp.substring(temp.lastIndexOf(".") + 1);
                if (oldQueueName.equals((Object)innerRemoteQueueBinding.getRoutingName()) && targetNodeID.equals(queueSuffix.toString())) {
                    targetBinding = innerRemoteQueueBinding;
                    if (!logger.isDebugEnabled()) continue block0;
                    logger.debug("Message now destined for {} with ID: {} on address {} on node {}", new Object[]{innerRemoteQueueBinding.getRoutingName(), innerRemoteQueueBinding.getRemoteQueueID(), copyMessage.getAddress(), targetNodeID});
                    continue block0;
                }
                logger.debug("Failed to match: {}", (Object)innerRemoteQueueBinding);
            }
        }
        return new Pair(targetNodeID, targetBinding);
    }

    private Message makeCopy(MessageReference ref, boolean expiry, SimpleString newAddress) throws Exception {
        return this.makeCopy(ref, expiry, true, newAddress);
    }

    private Message makeCopy(MessageReference ref, boolean expiry, boolean copyOriginalHeaders, SimpleString newAddress) throws Exception {
        if (ref == null) {
            ActiveMQServerLogger.LOGGER.nullRefMessage();
            throw new ActiveMQNullRefException("Reference to message is null");
        }
        Message message = ref.getMessage();
        long newID = this.storageManager.generateID();
        Message copy = message.copy(newID, true);
        if (newAddress != null) {
            copy.setAddress(newAddress);
        }
        if (copyOriginalHeaders) {
            copy.referenceOriginalMessage(message, ref.getQueue().getName());
        }
        copy.setExpiration(0L);
        copy.setRoutingType(null);
        if (expiry) {
            copy.setBrokerProperty(Message.HDR_ACTUAL_EXPIRY_TIME, (Object)System.currentTimeMillis());
        }
        copy.reencode();
        return LargeServerMessageImpl.checkLargeMessage(copy, this.storageManager);
    }

    private void expire(Transaction tx, MessageReference ref, boolean delivering) throws Exception {
        SimpleString expiryAddress = this.addressSettings.getExpiryAddress();
        if (expiryAddress != null && expiryAddress.length() != 0) {
            this.createExpiryResources();
            Bindings bindingList = this.postOffice.lookupBindingsForAddress(expiryAddress);
            if (bindingList == null || bindingList.getBindings().isEmpty()) {
                ActiveMQServerLogger.LOGGER.errorExpiringReferencesNoBindings(expiryAddress);
                this.acknowledge(tx, ref, AckReason.EXPIRED, null, delivering);
            } else {
                this.move(tx, expiryAddress, null, ref, false, AckReason.EXPIRED, null, null, delivering);
            }
        } else {
            if (!this.printErrorExpiring) {
                this.printErrorExpiring = true;
                ActiveMQServerLogger.LOGGER.errorExpiringReferencesNoAddress(this.name);
            }
            this.acknowledge(tx, ref, AckReason.EXPIRED, null, delivering);
        }
        if (this.server != null && this.server.hasBrokerMessagePlugins()) {
            ExpiryLogger expiryLogger = (ExpiryLogger)tx.getProperty(9);
            if (expiryLogger == null) {
                expiryLogger = new ExpiryLogger();
                tx.putProperty(9, expiryLogger);
                tx.addOperation(expiryLogger);
            }
            expiryLogger.addExpiry(this.address, ref);
        }
        tx.addOperation(new TransactionOperationAbstract(){

            @Override
            public void afterCommit(Transaction tx) {
                QueueImpl.this.refCountForConsumers.check();
            }
        });
    }

    @Override
    public boolean sendToDeadLetterAddress(Transaction tx, MessageReference ref) throws Exception {
        return this.sendToDeadLetterAddress(tx, ref, this.addressSettings.getDeadLetterAddress());
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean sendToDeadLetterAddress(Transaction tx, MessageReference ref, SimpleString deadLetterAddress) throws Exception {
        if (deadLetterAddress == null) {
            ActiveMQServerLogger.LOGGER.sendingMessageToDLAnoDLA(ref, this.name);
            ref.acknowledge(tx, AckReason.KILLED, null);
            return false;
        }
        this.createDeadLetterResources();
        Bindings bindingList = this.postOffice.lookupBindingsForAddress(deadLetterAddress);
        if (bindingList != null && !bindingList.getBindings().isEmpty()) {
            ActiveMQServerLogger.LOGGER.sendingMessageToDLA(ref, deadLetterAddress, this.name);
            RoutingStatus status = this.move(tx, deadLetterAddress, null, ref, false, AckReason.KILLED, null, null, true);
            if (!status.equals((Object)RoutingStatus.NO_BINDINGS)) return true;
            if (!this.server.getAddressSettingsRepository().getMatch(this.getAddress().toString()).isAutoCreateDeadLetterResources()) return true;
            ActiveMQServerLogger.LOGGER.noMatchingBindingsOnDLAWithAutoCreateDLAResources(deadLetterAddress, ref.toString());
            return true;
        }
        ActiveMQServerLogger.LOGGER.noBindingsOnDLA(ref, deadLetterAddress);
        ref.acknowledge(tx, AckReason.KILLED, null);
        return false;
    }

    private void createDeadLetterResources() throws Exception {
        AddressSettings addressSettings = this.server.getAddressSettingsRepository().getMatch(this.getAddress().toString());
        this.createResources(addressSettings.isAutoCreateDeadLetterResources(), addressSettings.getDeadLetterAddress(), addressSettings.getDeadLetterQueuePrefix(), addressSettings.getDeadLetterQueueSuffix());
    }

    private void createExpiryResources() throws Exception {
        AddressSettings addressSettings = this.server.getAddressSettingsRepository().getMatch(this.getAddress().toString());
        this.createResources(addressSettings.isAutoCreateExpiryResources(), addressSettings.getExpiryAddress(), addressSettings.getExpiryQueuePrefix(), addressSettings.getExpiryQueueSuffix());
    }

    private void createResources(boolean isAutoCreate, SimpleString destinationAddress, SimpleString prefix, SimpleString suffix) throws Exception {
        if (isAutoCreate && !this.getAddress().equals((Object)destinationAddress) && destinationAddress != null && destinationAddress.length() != 0) {
            SimpleString destinationQueueName = prefix.concat(this.getAddress()).concat(suffix);
            SimpleString filter = new SimpleString(String.format("%s = '%s'", Message.HDR_ORIGINAL_ADDRESS, this.getAddress()));
            try {
                this.server.createQueue(new QueueConfiguration(destinationQueueName).setAddress(destinationAddress).setFilterString(filter).setAutoCreated(Boolean.valueOf(true)).setAutoCreateAddress(Boolean.valueOf(true)), true);
            }
            catch (ActiveMQQueueExistsException activeMQQueueExistsException) {
                // empty catch block
            }
        }
    }

    private boolean deliverDirect(MessageReference ref) {
        if (!this.deliverLock.tryLock()) {
            logger.trace("Cannot perform a directDelivery because there is a running async deliver");
            return false;
        }
        try {
            boolean bl = this.deliver(ref);
            return bl;
        }
        finally {
            this.deliverLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deliver(MessageReference ref) {
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            if (!this.supportsDirectDeliver) {
                return false;
            }
            if (this.isPaused() || !this.canDispatch()) {
                return false;
            }
            if (this.checkExpired(ref)) {
                return true;
            }
            this.consumers.reset();
            while (this.consumers.hasNext()) {
                HandleStatus status;
                ConsumerHolder holder = (ConsumerHolder)this.consumers.next();
                Object consumer = holder.consumer;
                SimpleString groupID = this.extractGroupID(ref);
                Consumer groupConsumer = this.getGroupConsumer(groupID);
                if (groupConsumer != null) {
                    consumer = groupConsumer;
                }
                if ((status = this.handle(ref, (Consumer)consumer)) == HandleStatus.HANDLED) {
                    MessageReference reference = this.handleMessageGroup(ref, (Consumer)consumer, groupConsumer, groupID);
                    this.incrementMesssagesAdded();
                    this.deliveriesInTransit.countUp();
                    reference.setInDelivery(true);
                    this.proceedDeliver((Consumer)consumer, reference);
                    this.consumers.reset();
                    return true;
                }
                if (groupConsumer == null) continue;
                break;
            }
            logger.trace("Queue {} is out of direct delivery as no consumers handled a delivery", (Object)this.name);
            return false;
        }
    }

    private Consumer getGroupConsumer(SimpleString groupID) {
        Consumer groupConsumer = null;
        if (this.exclusive) {
            groupConsumer = this.exclusiveConsumer;
        } else if (groupID != null) {
            groupConsumer = this.groups.get(groupID);
        }
        return groupConsumer;
    }

    private MessageReference handleMessageGroup(MessageReference ref, Consumer consumer, Consumer groupConsumer, SimpleString groupID) {
        if (this.exclusive) {
            if (groupConsumer == null) {
                this.exclusiveConsumer = consumer;
                if (this.groupFirstKey != null) {
                    return new GroupFirstMessageReference(this.groupFirstKey, ref);
                }
            }
            this.consumers.repeat();
        } else if (groupID != null) {
            if (this.extractGroupSequence(ref) == -1) {
                this.groups.remove(groupID);
                this.consumers.repeat();
            } else if (groupConsumer == null) {
                this.groups.put(groupID, consumer);
                if (this.groupFirstKey != null) {
                    return new GroupFirstMessageReference(this.groupFirstKey, ref);
                }
            } else {
                this.consumers.repeat();
            }
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proceedDeliver(Consumer consumer, MessageReference reference) {
        try {
            consumer.proceedDeliver(reference);
        }
        catch (Throwable t) {
            this.errorProcessing(consumer, t, reference);
        }
        finally {
            this.deliveriesInTransit.countDown();
        }
    }

    @Override
    public void errorProcessing(Consumer consumer, Throwable t, MessageReference reference) {
        this.executor.execute(() -> this.internalErrorProcessing(consumer, t, reference));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalErrorProcessing(Consumer consumer, Throwable t, MessageReference reference) {
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            ActiveMQServerLogger.LOGGER.removingBadConsumer(consumer, reference, t);
            try {
                this.removeConsumer(consumer);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorRemovingConsumer(e);
            }
            this.addHead(reference, false);
        }
    }

    private boolean checkExpired(MessageReference reference) {
        try {
            if (reference.getMessage().isExpired()) {
                logger.trace("Reference {} is expired", (Object)reference);
                reference.handled();
                try {
                    this.expire(reference);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorExpiringRef(e);
                }
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.unableToCheckIfMessageExpired(e);
            return false;
        }
    }

    private synchronized HandleStatus handle(MessageReference reference, Consumer consumer) {
        HandleStatus status;
        try {
            status = consumer.handle(reference);
        }
        catch (Throwable t) {
            ActiveMQServerLogger.LOGGER.removingBadConsumer(consumer, reference, t);
            try {
                this.removeConsumer(consumer);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorRemovingConsumer(e);
            }
            return HandleStatus.BUSY;
        }
        if (status == null) {
            throw new IllegalStateException("ClientConsumer.handle() should never return null");
        }
        return status;
    }

    @Override
    public void postAcknowledge(MessageReference ref, AckReason reason) {
        this.postAcknowledge(ref, reason, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postAcknowledge(MessageReference ref, AckReason reason, boolean delivering) {
        QueueImpl queue = (QueueImpl)ref.getQueue();
        try {
            int count;
            boolean durableRef;
            Message message;
            if (delivering) {
                queue.decDelivering(ref);
            }
            if (this.nonDestructive && reason == AckReason.NORMAL) {
                ref.setInDelivery(false);
                return;
            }
            if (reason == AckReason.EXPIRED) {
                this.messagesExpired.incrementAndGet();
            } else if (reason == AckReason.KILLED) {
                this.messagesKilled.incrementAndGet();
            } else if (reason == AckReason.REPLACED) {
                this.messagesReplaced.incrementAndGet();
            } else {
                this.messagesAcknowledged.incrementAndGet();
            }
            if (ref.isPaged()) {
                return;
            }
            try {
                message = ref.getMessage();
            }
            catch (Throwable e) {
                ActiveMQServerLogger.LOGGER.unableToPerformPostAcknowledge(e);
                message = null;
            }
            if (message == null || this.nonDestructive && reason == AckReason.NORMAL) {
                return;
            }
            queue.refDown(ref);
            boolean bl = durableRef = message.isDurable() && queue.isDurable();
            if (durableRef && (count = queue.durableDown(message)) == 0) {
                try {
                    this.storageManager.deleteMessage(message.getMessageID());
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.cannotFindMessageOnJournal(message.getMessageID(), e);
                }
            }
        }
        finally {
            this.postOffice.postAcknowledge(ref, reason);
        }
    }

    void postRollback(LinkedList<MessageReference> refs) {
        if (this.purgeOnNoConsumers && this.getConsumerCount() == 0) {
            this.purgeAfterRollback(refs);
            return;
        }
        if (!this.isNonDestructive()) {
            this.addSorted(refs, false);
        }
    }

    private void purgeAfterRollback(LinkedList<MessageReference> refs) {
        try {
            TransactionImpl transaction = new TransactionImpl(this.storageManager);
            for (MessageReference reference : refs) {
                this.incDelivering(reference);
                this.acknowledge(transaction, reference, AckReason.KILLED, null, true);
            }
            transaction.commit();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    private long calculateRedeliveryDelay(AddressSettings addressSettings, int deliveryCount) {
        long redeliveryDelay = addressSettings.getRedeliveryDelay();
        long maxRedeliveryDelay = addressSettings.getMaxRedeliveryDelay();
        double redeliveryMultiplier = addressSettings.getRedeliveryMultiplier();
        double collisionAvoidanceFactor = addressSettings.getRedeliveryCollisionAvoidanceFactor();
        int tmpDeliveryCount = deliveryCount > 0 ? deliveryCount - 1 : 0;
        long delay = (long)((double)redeliveryDelay * Math.pow(redeliveryMultiplier, tmpDeliveryCount));
        if (collisionAvoidanceFactor > 0.0) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            double variance = (((Random)random).nextBoolean() ? collisionAvoidanceFactor : -collisionAvoidanceFactor) * ((Random)random).nextDouble();
            delay = (long)((double)delay + (double)delay * variance);
        }
        if (delay > maxRedeliveryDelay) {
            delay = maxRedeliveryDelay;
        }
        return delay;
    }

    @Override
    public synchronized void resetMessagesAdded() {
        this.messagesAdded.set(0L);
    }

    @Override
    public synchronized void resetMessagesAcknowledged() {
        this.messagesAcknowledged.set(0L);
    }

    @Override
    public synchronized void resetMessagesExpired() {
        this.messagesExpired.set(0L);
    }

    @Override
    public synchronized void resetMessagesKilled() {
        this.messagesKilled.set(0L);
    }

    private float getRate() {
        long locaMessageAdded = this.getMessagesAdded();
        float timeSlice = (float)(System.currentTimeMillis() - this.queueRateCheckTime.getAndSet(System.currentTimeMillis())) / 1000.0f;
        if (timeSlice == 0.0f) {
            this.messagesAddedSnapshot.getAndSet(locaMessageAdded);
            return 0.0f;
        }
        return BigDecimal.valueOf((float)(locaMessageAdded - this.messagesAddedSnapshot.getAndSet(locaMessageAdded)) / timeSlice).setScale(2, 0).floatValue();
    }

    @Override
    public void recheckRefCount(OperationContext context) {
        final ReferenceCounter refCount = this.refCountForConsumers;
        if (refCount != null) {
            context.executeOnCompletion(new IOCallback(){

                public void done() {
                    refCount.check();
                }

                public void onError(int errorCode, String errorMessage) {
                }
            });
        }
    }

    public static MessageGroups<Consumer> groupMap(int groupBuckets) {
        if (groupBuckets == -1) {
            return new SimpleMessageGroups<Consumer>();
        }
        if (groupBuckets == 0) {
            return DisabledMessageGroups.instance();
        }
        return new BucketMessageGroups<Consumer>(groupBuckets);
    }

    @Override
    public QueueConfiguration getQueueConfiguration() {
        return new QueueConfiguration(this.name).setAddress(this.address).setId(this.id).setRoutingType(this.routingType).setFilterString(this.filter == null ? null : this.filter.getFilterString()).setDurable(Boolean.valueOf(this.isDurable())).setUser(this.user).setMaxConsumers(Integer.valueOf(this.maxConsumers)).setExclusive(Boolean.valueOf(this.exclusive)).setGroupRebalance(Boolean.valueOf(this.groupRebalance)).setGroupBuckets(Integer.valueOf(this.groupBuckets)).setGroupFirstKey(this.groupFirstKey).setLastValue(Boolean.valueOf(false)).setLastValueKey((String)null).setNonDestructive(Boolean.valueOf(this.nonDestructive)).setPurgeOnNoConsumers(Boolean.valueOf(this.purgeOnNoConsumers)).setConsumersBeforeDispatch(Integer.valueOf(this.consumersBeforeDispatch)).setDelayBeforeDispatch(Long.valueOf(this.delayBeforeDispatch)).setAutoDelete(Boolean.valueOf(this.autoDelete)).setAutoDeleteDelay(Long.valueOf(this.autoDeleteDelay)).setAutoDeleteMessageCount(Long.valueOf(this.autoDeleteMessageCount)).setRingSize(Long.valueOf(this.ringSize)).setConfigurationManaged(Boolean.valueOf(this.configurationManaged)).setTemporary(Boolean.valueOf(this.temporary)).setInternal(Boolean.valueOf(this.internalQueue)).setTransient(Boolean.valueOf(this.refCountForConsumers instanceof TransientQueueManagerImpl)).setAutoCreated(Boolean.valueOf(this.autoCreated));
    }

    public void incDelivering(MessageReference ref) {
        this.deliveringMetrics.incrementMetrics(ref);
    }

    public void decDelivering(MessageReference reference) {
        this.deliveringMetrics.decrementMetrics(reference);
        if (this.pageDelivered) {
            this.deliverAsync();
        }
    }

    private long getPersistentSize(MessageReference reference) {
        long size = 0L;
        try {
            size = reference.getPersistentSize() > 0L ? reference.getPersistentSize() : 0L;
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.errorCalculatePersistentSize(e);
        }
        return size;
    }

    private void configureSlowConsumerReaper() {
        if (this.addressSettings == null || this.addressSettings.getSlowConsumerThreshold() == -1L) {
            if (this.slowConsumerReaperFuture != null) {
                this.slowConsumerReaperFuture.cancel(false);
                this.slowConsumerReaperFuture = null;
                this.slowConsumerReaperRunnable = null;
                logger.debug("Cancelled slow-consumer-reaper thread for queue \"{}\"", (Object)this.name);
            }
        } else if (this.slowConsumerReaperRunnable == null) {
            this.scheduleSlowConsumerReaper(this.addressSettings);
        } else if (this.slowConsumerReaperRunnable.checkPeriod != this.addressSettings.getSlowConsumerCheckPeriod() || this.slowConsumerReaperRunnable.thresholdInMsgPerSecond != (float)this.addressSettings.getSlowConsumerThreshold() || !this.slowConsumerReaperRunnable.policy.equals((Object)this.addressSettings.getSlowConsumerPolicy())) {
            if (this.slowConsumerReaperFuture != null) {
                this.slowConsumerReaperFuture.cancel(false);
                this.slowConsumerReaperFuture = null;
            }
            this.scheduleSlowConsumerReaper(this.addressSettings);
        }
    }

    void scheduleSlowConsumerReaper(AddressSettings settings) {
        this.slowConsumerReaperRunnable = new SlowConsumerReaperRunnable(settings.getSlowConsumerCheckPeriod(), settings.getSlowConsumerThreshold(), settings.getSlowConsumerThresholdMeasurementUnit(), settings.getSlowConsumerPolicy());
        this.slowConsumerReaperFuture = this.scheduledExecutor.scheduleWithFixedDelay(this.slowConsumerReaperRunnable, settings.getSlowConsumerCheckPeriod(), settings.getSlowConsumerCheckPeriod(), TimeUnit.SECONDS);
        if (logger.isDebugEnabled()) {
            logger.debug("Scheduled slow-consumer-reaper thread for queue \"{}\"; slow-consumer-check-period={}, slow-consumer-threshold={}, slow-consumer-threshold-measurement-unit={}, slow-consumer-policy={}", new Object[]{this.name, settings.getSlowConsumerCheckPeriod(), settings.getSlowConsumerThreshold(), settings.getSlowConsumerThresholdMeasurementUnit(), settings.getSlowConsumerPolicy()});
        }
    }

    private void enforceRing(boolean head) {
        if (this.ringSize != -1L) {
            this.enforceRing(null, false, head);
        }
    }

    private void enforceRing(MessageReference refToAck, boolean scheduling, boolean head) {
        int adjustment;
        int n = adjustment = head ? 1 : 0;
        if (this.getMessageCountForRing() + (long)adjustment > this.ringSize) {
            MessageReference messageReference = refToAck = refToAck == null ? (MessageReference)this.messageReferences.poll() : refToAck;
            if (refToAck != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Preserving ringSize {} by acking message ref {}", (Object)this.ringSize, (Object)refToAck);
                }
                this.referenceHandled(refToAck);
                try {
                    refToAck.acknowledge(null, AckReason.REPLACED, null);
                    if (!refToAck.isInDelivery() && !scheduling) {
                        this.refRemoved(refToAck);
                    }
                    refToAck.setAlreadyAcked();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorAckingOldReference(e);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("Cannot preserve ringSize {}; message ref is null", (Object)this.ringSize);
            }
        }
    }

    private String getAddressSettingsMatch() {
        return ((ActiveMQServerImpl)this.server).getRuntimeTempQueueNamespace(this.temporary) + this.address.toString();
    }

    private void checkDeadLetterAddressAndExpiryAddress() {
        if (!(Env.isTestEnv() || this.internalQueue || this.address.equals((Object)this.server.getConfiguration().getManagementNotificationAddress()))) {
            if (this.addressSettings.getDeadLetterAddress() == null) {
                ActiveMQServerLogger.LOGGER.AddressSettingsNoDLA(this.name);
            }
            if (this.addressSettings.getExpiryAddress() == null) {
                ActiveMQServerLogger.LOGGER.AddressSettingsNoExpiryAddress(this.name);
            }
        }
    }

    private final class SlowConsumerReaperRunnable
    implements Runnable {
        private final SlowConsumerPolicy policy;
        private final float thresholdInMsgPerSecond;
        private final long checkPeriod;

        private SlowConsumerReaperRunnable(long checkPeriod, float slowConsumerThreshold, SlowConsumerThresholdMeasurementUnit unit, SlowConsumerPolicy policy) {
            this.checkPeriod = checkPeriod;
            this.policy = policy;
            this.thresholdInMsgPerSecond = slowConsumerThreshold / (float)unit.getValue();
        }

        @Override
        public void run() {
            int consumerCount;
            float queueRate = QueueImpl.this.getRate();
            long queueMessages = QueueImpl.this.getMessageCount();
            if (logger.isDebugEnabled()) {
                logger.debug("{}:{} has {} message(s) and {} consumer(s) and is receiving messages at a rate of {} msgs/second.", new Object[]{QueueImpl.this.address, QueueImpl.this.name, queueMessages, QueueImpl.this.getConsumerCount(), Float.valueOf(queueRate)});
            }
            if ((consumerCount = QueueImpl.this.getConsumerCount()) == 0) {
                logger.debug("There are no consumers, no need to check slow consumer's rate");
                return;
            }
            float queueThreshold = this.thresholdInMsgPerSecond * (float)consumerCount;
            if (queueRate < queueThreshold && (float)queueMessages < queueThreshold) {
                logger.debug("Insufficient messages received on queue \"{}\" to satisfy slow-consumer-threshold. Skipping inspection of consumer.", (Object)QueueImpl.this.name);
                return;
            }
            for (ConsumerHolder consumerHolder : QueueImpl.this.consumers) {
                ServerConsumerImpl serverConsumer;
                float consumerRate;
                Consumer consumer = consumerHolder.consumer();
                if (!(consumer instanceof ServerConsumerImpl) || !((consumerRate = (serverConsumer = (ServerConsumerImpl)consumer).getRate()) < this.thresholdInMsgPerSecond) && (consumerRate != 0.0f || this.thresholdInMsgPerSecond != 0.0f)) continue;
                RemotingConnection connection = null;
                ActiveMQServer server = ((PostOfficeImpl)QueueImpl.this.postOffice).getServer();
                RemotingService remotingService = server.getRemotingService();
                for (RemotingConnection potentialConnection : remotingService.getConnections()) {
                    if (!potentialConnection.getID().toString().equals(serverConsumer.getConnectionID())) continue;
                    connection = potentialConnection;
                }
                serverConsumer.fireSlowConsumer();
                if (connection == null) continue;
                ActiveMQServerLogger.LOGGER.slowConsumerDetected(serverConsumer.getSessionID(), serverConsumer.getID(), QueueImpl.this.getName().toString(), connection.getRemoteAddress(), this.thresholdInMsgPerSecond, consumerRate);
                if (this.policy.equals((Object)SlowConsumerPolicy.KILL)) {
                    connection.killMessage(server.getNodeID());
                    remotingService.removeConnection(connection.getID());
                    connection.fail((ActiveMQException)ActiveMQMessageBundle.BUNDLE.connectionsClosedByManagement(connection.getRemoteAddress()));
                    continue;
                }
                if (!this.policy.equals((Object)SlowConsumerPolicy.NOTIFY)) continue;
                TypedProperties props = new TypedProperties();
                props.putIntProperty(ManagementHelper.HDR_CONSUMER_COUNT, QueueImpl.this.getConsumerCount());
                props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, QueueImpl.this.address);
                props.putSimpleStringProperty(ManagementHelper.HDR_REMOTE_ADDRESS, SimpleString.toSimpleString((String)connection.getRemoteAddress()));
                if (connection.getID() != null) {
                    props.putSimpleStringProperty(ManagementHelper.HDR_CONNECTION_NAME, SimpleString.toSimpleString((String)connection.getID().toString()));
                }
                props.putLongProperty(ManagementHelper.HDR_CONSUMER_NAME, serverConsumer.getID());
                props.putSimpleStringProperty(ManagementHelper.HDR_SESSION_NAME, SimpleString.toSimpleString((String)serverConsumer.getSessionID()));
                Notification notification = new Notification(null, (NotificationType)CoreNotificationType.CONSUMER_SLOW, props);
                ManagementService managementService = ((PostOfficeImpl)QueueImpl.this.postOffice).getServer().getManagementService();
                try {
                    managementService.sendNotification(notification);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.failedToSendSlowConsumerNotification(notification, e);
                }
            }
        }
    }

    private class AddressSettingsRepositoryListener
    implements HierarchicalRepositoryChangeListener {
        HierarchicalRepository<AddressSettings> addressSettingsRepository;

        AddressSettingsRepositoryListener(HierarchicalRepository addressSettingsRepository) {
            this.addressSettingsRepository = addressSettingsRepository;
        }

        @Override
        public void onChange() {
            QueueImpl.this.addressSettings = this.addressSettingsRepository.getMatch(QueueImpl.this.getAddressSettingsMatch());
            QueueImpl.this.checkDeadLetterAddressAndExpiryAddress();
            QueueImpl.this.configureSlowConsumerReaper();
        }

        public void close() {
            this.addressSettingsRepository.unRegisterListener(this);
        }
    }

    private final class QueueBrowserIterator
    implements LinkedListIterator<MessageReference> {
        LinkedListIterator<PagedReference> pagingIterator = null;
        LinkedListIterator<MessageReference> messagesIterator = null;
        Iterator<? extends MessageReference> lastIterator = null;
        MessageReference cachedNext = null;
        HashSet<PagePosition> previouslyBrowsed = new HashSet();

        private LinkedListIterator<PagedReference> getPagingIterator() {
            if (this.pagingIterator == null) {
                this.pagingIterator = QueueImpl.this.pageSubscription.iterator(true);
            }
            return this.pagingIterator;
        }

        private QueueBrowserIterator() {
            this.messagesIterator = new SynchronizedIterator((LinkedListIterator<MessageReference>)QueueImpl.this.messageReferences.iterator());
        }

        public boolean hasNext() {
            PagedReference nextMessage;
            MessageReference nextMessage2;
            if (this.cachedNext != null) {
                return true;
            }
            if (this.messagesIterator != null && (nextMessage2 = this.iterate(this.messagesIterator)) != null) {
                this.cachedNext = nextMessage2;
                this.lastIterator = this.messagesIterator;
                return true;
            }
            LinkedListIterator<PagedReference> pagingIterator = this.getPagingIterator();
            if (pagingIterator != null && (nextMessage = this.iteratePaging(pagingIterator)) != null) {
                this.cachedNext = nextMessage;
                this.lastIterator = pagingIterator;
                return true;
            }
            return false;
        }

        private PagedReference iteratePaging(LinkedListIterator<PagedReference> iterator) {
            while (iterator.hasNext()) {
                PagedReference ref = (PagedReference)iterator.next();
                if (this.previouslyBrowsed.remove(ref.getPosition())) continue;
                return ref;
            }
            return null;
        }

        private MessageReference iterate(LinkedListIterator<MessageReference> iterator) {
            if (iterator.hasNext()) {
                MessageReference ref = (MessageReference)iterator.next();
                if (ref.isPaged()) {
                    this.previouslyBrowsed.add(((PagedReference)ref).getPosition());
                }
                return ref;
            }
            return null;
        }

        public MessageReference next() {
            PagedReference ref;
            MessageReference ref2;
            if (this.cachedNext != null) {
                try {
                    MessageReference messageReference = this.cachedNext;
                    return messageReference;
                }
                finally {
                    this.cachedNext = null;
                }
            }
            if (this.messagesIterator != null && this.messagesIterator.hasNext() && (ref2 = this.iterate(this.messagesIterator)) != null) {
                return ref2;
            }
            LinkedListIterator<PagedReference> pagingIterator = this.getPagingIterator();
            if (pagingIterator != null && (ref = this.iteratePaging(pagingIterator)) != null) {
                return ref;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.lastIterator != null) {
                this.lastIterator.remove();
            }
        }

        public void repeat() {
        }

        public void close() {
            if (this.getPagingIterator() != null) {
                this.getPagingIterator().close();
            }
            if (this.messagesIterator != null) {
                this.messagesIterator.close();
            }
        }
    }

    private class SynchronizedIterator
    implements LinkedListIterator<MessageReference> {
        private final LinkedListIterator<MessageReference> iter;

        SynchronizedIterator(LinkedListIterator<MessageReference> iter) {
            this.iter = iter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                this.iter.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void repeat() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                this.iter.repeat();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                return this.iter.hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MessageReference next() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                return (MessageReference)this.iter.next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                this.iter.remove();
            }
        }
    }

    abstract class QueueIterateAction {
        QueueIterateAction() {
        }

        public Integer expectedHits() {
            return null;
        }

        public abstract boolean actMessage(Transaction var1, MessageReference var2) throws Exception;
    }

    private final class DeliverRunner
    implements Runnable {
        private DeliverRunner() {
        }

        @Override
        public void run() {
            block18: {
                try {
                    boolean needCheckDepage = false;
                    try (CriticalCloseable metric = QueueImpl.this.measureCritical(2);){
                        QueueImpl.this.deliverLock.lock();
                        try {
                            needCheckDepage = QueueImpl.this.deliver();
                        }
                        finally {
                            QueueImpl.this.deliverLock.unlock();
                        }
                    }
                    if (!needCheckDepage) break block18;
                    metric = QueueImpl.this.measureCritical(4);
                    try {
                        QueueImpl.this.checkDepage();
                    }
                    finally {
                        if (metric != null) {
                            metric.close();
                        }
                    }
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorDelivering(e);
                }
            }
        }
    }

    private class DelayedAddRedistributor
    implements Runnable {
        private final ArtemisExecutor executor1;

        DelayedAddRedistributor(ArtemisExecutor executor) {
            this.executor1 = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                QueueImpl.this.internalAddRedistributor();
                QueueImpl.this.clearRedistributorFuture();
            }
        }
    }

    protected static class ConsumerHolder<T extends Consumer>
    implements PriorityAware {
        final T consumer;
        LinkedListIterator<MessageReference> iter;

        ConsumerHolder(T consumer) {
            this.consumer = consumer;
        }

        private void resetIterator() {
            if (this.iter != null) {
                this.iter.close();
            }
            this.iter = null;
        }

        private Consumer consumer() {
            return this.consumer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConsumerHolder that = (ConsumerHolder)o;
            return Objects.equals(this.consumer, that.consumer);
        }

        public int hashCode() {
            return Objects.hash(this.consumer);
        }

        public int getPriority() {
            return this.consumer.getPriority();
        }
    }

    private class ExpiryLogger
    extends TransactionOperationAbstract {
        List<Pair<SimpleString, MessageReference>> expiries = new LinkedList<Pair<SimpleString, MessageReference>>();

        private ExpiryLogger() {
        }

        public void addExpiry(SimpleString address, MessageReference ref) {
            this.expiries.add((Pair<SimpleString, MessageReference>)new Pair((Object)address, (Object)ref));
        }

        @Override
        public void afterCommit(Transaction tx) {
            for (Pair<SimpleString, MessageReference> pair : this.expiries) {
                try {
                    QueueImpl.this.server.callBrokerMessagePlugins(plugin -> plugin.messageExpired((MessageReference)pair.getB(), (SimpleString)pair.getA(), null));
                }
                catch (Throwable e) {
                    logger.warn(e.getMessage(), e);
                }
            }
            this.expiries.clear();
        }
    }

    class ExpiryScanner
    implements Runnable {
        private final Runnable doneCallback;
        LinkedListIterator<MessageReference> iter = null;

        ExpiryScanner(Runnable doneCallback) {
            this.doneCallback = doneCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean expired = false;
            boolean hasElements = false;
            int elementsIterated = 0;
            int elementsExpired = 0;
            boolean rescheduled = false;
            LinkedList<MessageReference> expiredMessages = new LinkedList<MessageReference>();
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                logger.debug("Scanning for expires on {}", (Object)QueueImpl.this.name);
                if (this.iter == null) {
                    if (QueueImpl.this.server.hasBrokerQueuePlugins()) {
                        try {
                            QueueImpl.this.server.callBrokerQueuePlugins(p -> p.beforeExpiryScan(QueueImpl.this));
                        }
                        catch (Exception e) {
                            logger.warn(e.getMessage(), (Throwable)e);
                        }
                    }
                    this.iter = QueueImpl.this.iterator();
                }
                try {
                    while (!QueueImpl.this.queueDestroyed && QueueImpl.this.postOffice.isStarted() && this.iter.hasNext()) {
                        hasElements = true;
                        MessageReference ref = (MessageReference)this.iter.next();
                        if (ref.getMessage().isExpired()) {
                            ++elementsExpired;
                            QueueImpl.this.incDelivering(ref);
                            expired = true;
                            expiredMessages.add(ref);
                            this.iter.remove();
                        }
                        if (++elementsIterated < 1000) continue;
                        logger.debug("Expiry Scanner on {} ran for {} iteration, scheduling a new one", (Object)QueueImpl.this.getName(), (Object)elementsIterated);
                        rescheduled = true;
                        QueueImpl.this.getExecutor().execute((Runnable)this);
                        break;
                    }
                }
                finally {
                    if (!rescheduled) {
                        logger.debug("Scanning for expires on {} done", (Object)QueueImpl.this.name);
                        if (QueueImpl.this.server.hasBrokerQueuePlugins()) {
                            try {
                                QueueImpl.this.server.callBrokerQueuePlugins(p -> p.afterExpiryScan(QueueImpl.this));
                            }
                            catch (Exception e) {
                                logger.warn(e.getMessage(), (Throwable)e);
                            }
                        }
                        this.iter.close();
                        this.iter = null;
                        if (this.doneCallback != null) {
                            this.doneCallback.run();
                        }
                    }
                }
            }
            if (!expiredMessages.isEmpty()) {
                TransactionImpl tx = new TransactionImpl(QueueImpl.this.storageManager);
                for (MessageReference ref : expiredMessages) {
                    try {
                        QueueImpl.this.expire(tx, ref, true);
                        QueueImpl.this.refRemoved(ref);
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.errorExpiringReferencesOnQueue(ref, e);
                    }
                }
                try {
                    tx.commit();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.unableToCommitTransaction(e);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Expired {} references", (Object)elementsExpired);
                }
            }
            if ((!hasElements || expired) && QueueImpl.this.pageIterator != null && QueueImpl.this.pageIterator.tryNext() != PageIterator.NextResult.noElements) {
                QueueImpl.this.scheduleDepage(true);
            }
        }
    }
}

