/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis;

import java.io.File;
import java.util.Arrays;
import org.apache.activemq.artemis.ActiveMQWebLogger;
import org.slf4j.Logger;

public class ActiveMQWebLogger_impl
implements ActiveMQWebLogger {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public ActiveMQWebLogger_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void webserverStarted(String bind) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ241001: HTTP Server started at {}", (Object)bind);
        }
    }

    @Override
    public void jolokiaAvailable(String bind) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ241002: Artemis Jolokia REST API available at {}", (Object)bind);
        }
    }

    @Override
    public void startingEmbeddedWebServer() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ241003: Starting embedded web server");
        }
    }

    @Override
    public void consoleAvailable(String bind) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ241004: Artemis Console available at {}", (Object)bind);
        }
    }

    @Override
    public void stoppingEmbeddedWebServer() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ241005: Stopping embedded web server");
        }
    }

    @Override
    public void stoppedEmbeddedWebServer() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ241006: Stopped embedded web server");
        }
    }

    @Override
    public void tmpFileNotDeleted(File tmpdir) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ244003: Temporary file not deleted on shutdown: {}", (Object)tmpdir);
        }
    }

    @Override
    public void customizerNotLoaded(String customizer, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ244005: Web customizer {} not loaded: {}", (Object)customizer, (Object)t);
        }
    }
}

