/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.openwire.util;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.XATransactionId;

public class OpenWireUtil {
    public static final WildcardConfiguration OPENWIRE_WILDCARD = new OpenWireWildcardConfiguration();
    public static final String SELECTOR_AWARE_OPTION = "selectorAware";

    public static String extractFilterStringOrNull(ConsumerInfo info, ActiveMQDestination openWireDest) {
        if (info.getSelector() != null && openWireDest.getOptions() != null && Boolean.valueOf((String)openWireDest.getOptions().get(SELECTOR_AWARE_OPTION)).booleanValue()) {
            return info.getSelector();
        }
        return null;
    }

    public static ActiveMQDestination toAMQAddress(Message message, ActiveMQDestination actualDestination) {
        String address = message.getAddress();
        if (address == null || address.equals(actualDestination.getPhysicalName())) {
            return actualDestination;
        }
        if (actualDestination.isQueue()) {
            return new ActiveMQQueue(address);
        }
        return new ActiveMQTopic(address);
    }

    public static XidImpl toXID(TransactionId xaXid) {
        return OpenWireUtil.toXID((XATransactionId)xaXid);
    }

    public static XidImpl toXID(XATransactionId xaXid) {
        return new XidImpl(xaXid.getBranchQualifier(), xaXid.getFormatId(), xaXid.getGlobalTransactionId());
    }

    public static class OpenWireWildcardConfiguration
    extends WildcardConfiguration {
        public OpenWireWildcardConfiguration() {
            this.setDelimiter('.');
            this.setSingleWord('*');
            this.setAnyWords('>');
        }
    }
}

