/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.integration.bootstrap;

import java.util.Arrays;
import org.apache.activemq.artemis.integration.bootstrap.ActiveMQBootstrapLogger;
import org.slf4j.Logger;

public class ActiveMQBootstrapLogger_impl
implements ActiveMQBootstrapLogger {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public ActiveMQBootstrapLogger_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void serverStarting() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ101000: Starting ActiveMQ Artemis Server");
        }
    }

    @Override
    public void serverStopping() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ101001: Stopping ActiveMQ Artemis Server");
        }
    }

    @Override
    public void startedNamingService(String bindAddress, int port, String rmiBindAddress, int rmiPort) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ101002: Starting Naming server on {}:{} (rmi {}:{})", new Object[]{bindAddress, port, rmiBindAddress, rmiPort});
        }
    }

    @Override
    public void serverKilled() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ101003: Halting ActiveMQ Artemis Server after user request");
        }
    }

    @Override
    public void errorDeletingFile(String name) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ104000: Failed to delete file {}", (Object)name);
        }
    }
}

