# Summary

* [Introduction](README.md)
* [Legal Notice](notice.md)
* [Preface](preface.md)
* [Project Info](project-info.md)
* [Versions](versions.md)
* [Messaging Concepts](messaging-concepts.md)
* [Architecture](architecture.md)
* [Using the Server](using-server.md)
* [Upgrading](upgrading.md)
* Address
    * [Model](address-model.md)
    * [Settings](address-settings.md)
* [Protocols and Interoperability](protocols-interoperability.md)
* [AMQP](amqp.md)
    * [Broker Connections](amqp-broker-connections.md)
* [MQTT](mqtt.md)
* [STOMP](stomp.md)
* [OpenWire](openwire.md)
* [Core](core.md)
* [Mapping JMS Concepts to the Core API](jms-core-mapping.md)
* [Using JMS](using-jms.md)
* [The Client Classpath](client-classpath.md)
    * [JMS](client-classpath-jms.md)
    * [Jakarta](client-classpath-jakarta.md)
* [Examples](examples.md)
* [Routing Messages With Wild Cards](wildcard-routing.md)
* [Wildcard Syntax](wildcard-syntax.md)
* [Filter Expressions](filter-expressions.md)
* [Persistence](persistence.md)
* [Configuring Transports](configuring-transports.md)
* [Configuration Reload](config-reload.md)
* [Detecting Dead Connections](connection-ttl.md)
* [Detecting Slow Consumers](slow-consumers.md)
* [Avoiding Network Isolation](network-isolation.md)
* [Detecting Broker Issues (Critical Analysis)](critical-analysis.md)
* [Resource Manager Configuration](transaction-config.md)
* [Flow Control](flow-control.md)
* [Guarantees of sends and commits](send-guarantees.md)
* [Message Redelivery and Undelivered Messages](undelivered-messages.md)
* [Message Expiry](message-expiry.md)
* [Large Messages](large-messages.md)
* [Paging](paging.md)
* [Scheduled Messages](scheduled-messages.md)
* [Last-Value Queues](last-value-queues.md)
* [Non-Destructive Queues](non-destructive-queues.md)
* [Ring Queues](ring-queues.md)
* [Retroactive Addresses](retroactive-addresses.md)
* [Exclusive Queues](exclusive-queues.md)
* [Message Grouping](message-grouping.md)
* [Consumer Priority](consumer-priority.md)
* [Extra Acknowledge Modes](pre-acknowledge.md)
* [Management](management.md)
* [Management Console](management-console.md)
* [Metrics](metrics.md)
* [Security](security.md)
* [Masking Passwords](masking-passwords.md)
* [Broker Plugins](broker-plugins.md)
* [Resource Limits](resource-limits.md)
* [The JMS Bridge](jms-bridge.md)
* [Client Reconnection and Session Reattachment](client-reconnection.md)
* [Diverting and Splitting Message Flows](diverts.md)
* [Core Bridges](core-bridges.md)
* [Transformers](transformers.md)
* [Duplicate Message Detection](duplicate-detection.md)
* [Clusters](clusters.md)
* [Federation](federation.md)
    * [Address Federation](federation-address.md)
    * [Queue Federation](federation-queue.md)
* [High Availability and Failover](ha.md)
* [Connection Routers](connection-routers.md)
* [Graceful Server Shutdown](graceful-shutdown.md)
* [Libaio Native Libraries](libaio.md)
* [Thread management](thread-pooling.md)
* [Embedded Web Server](web-server.md)
* [Logging](logging.md)
* [Embedding the Broker](embedding-activemq.md)
* [Apache Karaf](karaf.md)
* [Apache Tomcat](tomcat.md)
* [Spring Integration](spring-integration.md)
* [CDI Integration](cdi-integration.md)
* [Intercepting Operations](intercepting-operations.md)
* [Data Tools](data-tools.md)
* [Activation Tools](activation-tools.md)
* [Maven Plugin](maven-plugin.md)
* [Unit Testing](unit-testing.md)
* [Troubleshooting and Performance Tuning](perf-tuning.md)
* [Performance Tools](perf-tools.md)
* [Configuration Reference](configuration-index.md)
* [Restart Sequence](restart-sequence.md)
