/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.activemq.artemis.shaded.org.jgroups.util.CondVar;

public class Promise<T> {
    protected final Lock lock = new ReentrantLock();
    protected final CondVar cond = new CondVar(this.lock);
    protected T result;
    protected volatile boolean hasResult = false;

    public T getResultWithTimeout(long timeout) throws TimeoutException {
        return this._getResultWithTimeout(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getResultWithTimeout(long timeout, boolean reset) throws TimeoutException {
        if (!reset) {
            return this._getResultWithTimeout(timeout);
        }
        this.lock.lock();
        try {
            T t = this._getResultWithTimeout(timeout);
            return t;
        }
        finally {
            this.reset();
            this.lock.unlock();
        }
    }

    public T getResult() {
        try {
            return this.getResultWithTimeout(0L);
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    public T getResult(long timeout) {
        return this.getResult(timeout, false);
    }

    public T getResult(long timeout, boolean reset) {
        try {
            return this.getResultWithTimeout(timeout, reset);
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    public boolean hasResult() {
        this.lock.lock();
        try {
            boolean bl = this.hasResult;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setResult(T obj) {
        this.lock.lock();
        try {
            this.result = obj;
            this.hasResult = true;
            this.cond.signal(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean signal) {
        this.lock.lock();
        try {
            this.result = null;
            this.hasResult = false;
            if (signal) {
                this.cond.signal(true);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return String.format("hasResult=%b, result=%s", this.hasResult, this.result);
    }

    protected T _getResultWithTimeout(long timeout) throws TimeoutException {
        if (timeout <= 0L) {
            this.cond.waitFor(this::hasResult);
        } else if (!this.cond.waitFor(this::hasResult, timeout, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException();
        }
        return this.result;
    }
}

