/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.Header;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.MBean;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedAttribute;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedOperation;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.AttributeType;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.FcHeader;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.FlowControl;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Credit;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

@MBean(description="Simple flow control protocol based on a credit system")
public class UFC
extends FlowControl {
    protected static final FcHeader UFC_REPLENISH_HDR = new FcHeader(1);
    protected static final FcHeader UFC_CREDIT_REQUEST_HDR = new FcHeader(2);
    protected final Map<Address, ? extends Credit> sent = Util.createConcurrentMap();

    @Override
    @ManagedOperation(description="Print sender credits")
    public String printSenderCredits() {
        return UFC.printMap(this.sent);
    }

    @Override
    @ManagedOperation(description="Print credits")
    public String printCredits() {
        return String.format("%s\nsenders:\n%s", super.printCredits(), UFC.printMap(this.sent));
    }

    @Override
    protected boolean handleMulticastMessage() {
        return false;
    }

    @Override
    protected Header getReplenishHeader() {
        return UFC_REPLENISH_HDR;
    }

    @Override
    protected Header getCreditRequestHeader() {
        return UFC_CREDIT_REQUEST_HDR;
    }

    @Override
    public void unblock() {
        super.unblock();
        this.sent.values().forEach(cred -> cred.increment(this.max_credits, this.max_credits));
    }

    public long getSenderCreditsFor(Address mbr) {
        Credit credits = this.sent.get(mbr);
        return credits == null ? 0L : credits.get();
    }

    @Override
    @ManagedAttribute(description="Number of times flow control blocks sender", type=AttributeType.SCALAR)
    public int getNumberOfBlockings() {
        int retval = 0;
        for (Credit credit : this.sent.values()) {
            retval += credit.getNumBlockings();
        }
        return retval;
    }

    @Override
    @ManagedAttribute(description="Average time blocked (in ms) in flow control when trying to send a message", type=AttributeType.TIME)
    public double getAverageTimeBlocked() {
        return this.sent.values().stream().mapToDouble(c -> c.getAverageBlockTime() / 1000000.0).average().orElse(0.0);
    }

    @Override
    public void stop() {
        super.stop();
        this.unblock();
        this.sent.values().forEach(Credit::reset);
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.sent.values().forEach(Credit::resetStats);
    }

    @Override
    protected Object handleDownMessage(Message msg, int length) {
        boolean rc;
        Address dest = msg.getDest();
        if (dest == null) {
            this.log.error("%s doesn't handle multicast messages; passing message down", this.getClass().getSimpleName());
            return this.down_prot.down(msg);
        }
        Credit cred = this.sent.get(dest);
        if (cred == null) {
            return this.down_prot.down(msg);
        }
        while (this.running && this.sent.containsKey(dest) && !(rc = cred.decrementIfEnoughCredits(msg, length, this.max_block_time)) && this.running) {
            if (!cred.needToSendCreditRequest(this.max_block_time)) continue;
            this.sendCreditRequest(dest, Math.max(0L, this.max_credits - cred.get()));
        }
        return this.down_prot.down(msg);
    }

    @Override
    protected void handleViewChange(List<Address> mbrs) {
        super.handleViewChange(mbrs);
        if (mbrs == null) {
            return;
        }
        mbrs.stream().filter(addr -> !this.sent.containsKey(addr)).forEach(addr -> this.sent.put((Address)addr, (Credit)this.createCredit((int)this.max_credits)));
        Iterator<Map.Entry<Address, ? extends Credit>> it = this.sent.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Address, ? extends Credit> entry = it.next();
            Address addr2 = entry.getKey();
            if (mbrs.contains(addr2)) continue;
            Credit cred = entry.getValue();
            cred.reset();
            it.remove();
        }
    }

    @Override
    protected void handleCredit(Address sender, long increase) {
        Credit cred;
        if (sender == null || (cred = this.sent.get(sender)) == null || increase <= 0L) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            long new_credit = Math.min(this.max_credits, cred.get() + increase);
            this.log.trace("received %d credits from %s, old credits: %s, new credits: %d", increase, sender, cred, new_credit);
        }
        cred.increment(increase, this.max_credits);
    }

    protected <T extends Credit> T createCredit(int initial_credits) {
        return (T)new Credit(initial_credits);
    }
}

