/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.plugin.impl;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.RoutingStatus;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.cluster.Bridge;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="AMQ")
public interface LoggingActiveMQServerPluginLogger
extends BasicLogger {
    public static final LoggingActiveMQServerPluginLogger LOGGER = (LoggingActiveMQServerPluginLogger)Logger.getMessageLogger(LoggingActiveMQServerPluginLogger.class, (String)LoggingActiveMQServerPluginLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=841000, value="created connection: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void afterCreateConnection(RemotingConnection var1);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=841001, value="destroyed connection: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void afterDestroyConnection(RemotingConnection var1);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=841002, value="created session name: {0}, session connectionID: {1}", format=Message.Format.MESSAGE_FORMAT)
    public void afterCreateSession(String var1, Object var2);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=841003, value="closed session with session name: {0}, failed: {1}", format=Message.Format.MESSAGE_FORMAT)
    public void afterCloseSession(String var1, boolean var2);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=841004, value="added session metadata for session name : {0}, key: {1}, data: {2}", format=Message.Format.MESSAGE_FORMAT)
    public void afterSessionMetadataAdded(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=841005, value="created consumer with ID: {0}, with session name: {1}", format=Message.Format.MESSAGE_FORMAT)
    public void afterCreateConsumer(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=841006, value="closed consumer ID: {0}, with  consumer Session: {1}, failed: {2}", format=Message.Format.MESSAGE_FORMAT)
    public void afterCloseConsumer(String var1, String var2, boolean var3);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=841007, value="created queue: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void afterCreateQueue(Queue var1);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=841008, value="destroyed queue: {0}, with args address: {1}, session: {2}, checkConsumerCount: {3}, removeConsumers: {4}, autoDeleteAddress: {5}", format=Message.Format.MESSAGE_FORMAT)
    public void afterDestroyQueue(Queue var1, SimpleString var2, SecurityAuth var3, boolean var4, boolean var5, boolean var6);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=841009, value="sent message with ID: {0}, result: {1}, transaction: {2}", format=Message.Format.MESSAGE_FORMAT)
    public void afterSend(String var1, RoutingStatus var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=841010, value="routed message with ID: {0}, result: {1}", format=Message.Format.MESSAGE_FORMAT)
    public void afterMessageRoute(String var1, RoutingStatus var2);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=841011, value="delivered message with message ID: {0}, consumer info UNAVAILABLE", format=Message.Format.MESSAGE_FORMAT)
    public void afterDeliverNoConsumer(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=841012, value="delivered message with message ID: {0}, to consumer on address: {1}, queue: {2}, consumer sessionID: {3}, consumerID: {4}", format=Message.Format.MESSAGE_FORMAT)
    public void afterDeliver(String var1, SimpleString var2, SimpleString var3, String var4, long var5);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=841013, value="expired message: {0}, messageExpiryAddress: {1}", format=Message.Format.MESSAGE_FORMAT)
    public void messageExpired(MessageReference var1, SimpleString var2);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=841014, value="messageAcknowledged: {0}, with transaction: {2}", format=Message.Format.MESSAGE_FORMAT)
    public void messageAcknowledged(MessageReference var1, Transaction var2);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=841015, value="deployed bridge: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void afterDeployBridge(Bridge var1);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=841016, value="criticalFailure called with criticalComponent: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void criticalFailure(CriticalComponent var1);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=841017, value="error sending message with ID: {0}, session name: {1}, session connectionID: {2}, exception: {3}", format=Message.Format.MESSAGE_FORMAT)
    public void onSendError(String var1, String var2, String var3, Exception var4);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=841018, value="error routing message with ID: {0}, exception: {1}", format=Message.Format.MESSAGE_FORMAT)
    public void onMessageRouteError(String var1, Exception var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=843000, value="beforeCreateSession called with name: {0}, username: {1}, minLargeMessageSize: {2}, connection: {3}, autoCommitSends: {4}, autoCommitAcks: {5}, preAcknowledge: {6}, xa: {7}, publicAddress: {8}, context: {9}", format=Message.Format.MESSAGE_FORMAT)
    public void beforeCreateSession(String var1, String var2, int var3, RemotingConnection var4, boolean var5, boolean var6, boolean var7, boolean var8, String var9, OperationContext var10);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=843001, value="beforeCloseSession called with session name : {0}, session: {1}, failed: {2}", format=Message.Format.MESSAGE_FORMAT)
    public void beforeCloseSession(String var1, ServerSession var2, boolean var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=843002, value="beforeSessionMetadataAdded called with session name: {0} , session: {1}, key: {2}, data: {3}", format=Message.Format.MESSAGE_FORMAT)
    public void beforeSessionMetadataAdded(String var1, ServerSession var2, String var3, String var4);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=843003, value="added session metadata for session name : {0}, session: {1}, key: {2}, data: {3}", format=Message.Format.MESSAGE_FORMAT)
    public void afterSessionMetadataAddedDetails(String var1, ServerSession var2, String var3, String var4);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=843004, value="beforeCreateConsumer called with ConsumerID: {0}, QueueBinding: {1}, filterString: {2}, browseOnly: {3}, supportLargeMessage: {4}", format=Message.Format.MESSAGE_FORMAT)
    public void beforeCreateConsumer(String var1, QueueBinding var2, SimpleString var3, boolean var4, boolean var5);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=843005, value="beforeCloseConsumer called with consumer: {0}, consumer sessionID: {1}, failed: {2}", format=Message.Format.MESSAGE_FORMAT)
    public void beforeCloseConsumer(ServerConsumer var1, String var2, boolean var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=843006, value="beforeCreateQueue called with queueConfig: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void beforeCreateQueue(QueueConfiguration var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=843007, value="beforeDestroyQueue called with queueName: {0}, session: {1}, checkConsumerCount: {2}, removeConsumers: {3}, autoDeleteAddress: {4}", format=Message.Format.MESSAGE_FORMAT)
    public void beforeDestroyQueue(SimpleString var1, SecurityAuth var2, boolean var3, boolean var4, boolean var5);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=843008, value="beforeSend called with message: {0}, tx: {1}, session: {2}, direct: {3}, noAutoCreateQueue: {4}", format=Message.Format.MESSAGE_FORMAT)
    public void beforeSend(Message var1, Transaction var2, ServerSession var3, boolean var4, boolean var5);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=843009, value="afterSend message: {0}, result: {1}, transaction: {2}, session: {3}, connection: {4}, direct: {5}, noAutoCreateQueue: {6}", format=Message.Format.MESSAGE_FORMAT)
    public void afterSendDetails(Message var1, String var2, Transaction var3, String var4, String var5, boolean var6, boolean var7);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=843010, value="beforeMessageRoute called with message: {0}, context: {1}, direct: {2}, rejectDuplicates: {3}", format=Message.Format.MESSAGE_FORMAT)
    public void beforeMessageRoute(Message var1, RoutingContext var2, boolean var3, boolean var4);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=843011, value="afterMessageRoute message: {0}, with context: {1}, direct: {2}, rejectDuplicates: {3}", format=Message.Format.MESSAGE_FORMAT)
    public void afterMessageRouteDetails(Message var1, RoutingContext var2, boolean var3, boolean var4);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=843012, value="beforeDeliver called with consumer: {0}, reference: {1}", format=Message.Format.MESSAGE_FORMAT)
    public void beforeDeliver(ServerConsumer var1, MessageReference var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=843013, value="delivered message with message ID: {0} to consumer on address: {1}, queue: {2}, consumer sessionID: {3}, consumerID: {4}, full message reference: {5}, full consumer: {6}", format=Message.Format.MESSAGE_FORMAT)
    public void afterDeliverDetails(String var1, SimpleString var2, SimpleString var3, String var4, long var5, MessageReference var7, ServerConsumer var8);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=843014, value="messageAcknowledged ID: {0}, sessionID: {1}, consumerID: {2}, queue: {3}, transaction: {4}, ackReason: {5}", format=Message.Format.MESSAGE_FORMAT)
    public void messageAcknowledgedDetails(String var1, String var2, String var3, String var4, String var5, AckReason var6);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=843015, value="beforeDeployBridge called with bridgeConfiguration: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void beforeDeployBridge(BridgeConfiguration var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=843016, value="onSendError message ID: {0}, message {1}, session name: {2} with tx: {3}, session: {4}, direct: {5}, noAutoCreateQueue: {6}", format=Message.Format.MESSAGE_FORMAT)
    public void onSendErrorDetails(String var1, Message var2, String var3, Transaction var4, ServerSession var5, boolean var6, boolean var7);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=843017, value="onMessageRouteError message: {0}, with context: {1}, direct: {2}, rejectDuplicates: {3}", format=Message.Format.MESSAGE_FORMAT)
    public void onMessageRouteErrorDetails(Message var1, RoutingContext var2, boolean var3, boolean var4);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=843020, value="rolled back transaction {0} involving {1}", format=Message.Format.MESSAGE_FORMAT)
    public void rolledBackTransaction(Transaction var1, String var2);
}

