/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.jms;

import jakarta.jms.Queue;
import jakarta.jms.Topic;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.shaded.org.jboss.logging.Logger;
import org.apache.activemq.artemis.uri.ConnectionFactoryParser;
import org.apache.activemq.artemis.utils.ClassloadingUtil;

public class ActiveMQJMSClient {
    private static final Logger logger = Logger.getLogger(ActiveMQJMSClient.class);
    public static final boolean DEFAULT_ENABLE_1X_PREFIXES;

    public static ActiveMQConnectionFactory createConnectionFactory(String url, String name) throws Exception {
        ConnectionFactoryParser parser = new ConnectionFactoryParser();
        return (ActiveMQConnectionFactory)parser.newObject(parser.expandURI(url), name);
    }

    public static ActiveMQConnectionFactory createConnectionFactoryWithHA(DiscoveryGroupConfiguration groupConfiguration, JMSFactoryType jmsFactoryType) {
        return jmsFactoryType.createConnectionFactoryWithHA(groupConfiguration);
    }

    public static ActiveMQConnectionFactory createConnectionFactoryWithoutHA(DiscoveryGroupConfiguration groupConfiguration, JMSFactoryType jmsFactoryType) {
        return jmsFactoryType.createConnectionFactoryWithoutHA(groupConfiguration);
    }

    public static ActiveMQConnectionFactory createConnectionFactoryWithHA(JMSFactoryType jmsFactoryType, TransportConfiguration ... initialServers) {
        return jmsFactoryType.createConnectionFactoryWithHA(initialServers);
    }

    public static ActiveMQConnectionFactory createConnectionFactoryWithoutHA(JMSFactoryType jmsFactoryType, TransportConfiguration ... transportConfigurations) {
        return jmsFactoryType.createConnectionFactoryWithoutHA(transportConfigurations);
    }

    @Deprecated
    public static Topic createTopic(String name) {
        if (DEFAULT_ENABLE_1X_PREFIXES) {
            return ActiveMQDestination.createTopic(PacketImpl.OLD_TOPIC_PREFIX + name, name);
        }
        return ActiveMQDestination.createTopic(name);
    }

    @Deprecated
    public static Queue createQueue(String name) {
        if (DEFAULT_ENABLE_1X_PREFIXES) {
            return ActiveMQDestination.createQueue(PacketImpl.OLD_QUEUE_PREFIX + name, name);
        }
        return ActiveMQDestination.createQueue(name);
    }

    private ActiveMQJMSClient() {
    }

    static {
        String value1X = System.getProperty(ActiveMQJMSClient.class.getName() + ".enable1xPrefixes");
        if (value1X == null) {
            value1X = ClassloadingUtil.loadProperty(ActiveMQJMSClient.class.getClassLoader(), ActiveMQJMSClient.class.getName() + ".properties", "enable1xPrefixes");
        }
        boolean prefixes = false;
        if (value1X != null) {
            try {
                prefixes = Boolean.parseBoolean(value1X);
            }
            catch (Throwable e) {
                logger.warn(e);
            }
        }
        DEFAULT_ENABLE_1X_PREFIXES = prefixes;
    }
}

