/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.spi.core.protocol.AbstractRemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Connection;

public class MQTTConnection
extends AbstractRemotingConnection {
    private boolean destroyed = false;
    private boolean connected;
    private int receiveMaximum = -1;
    private String protocolVersion;
    private boolean clientIdAssignedByBroker = false;

    public MQTTConnection(Connection transportConnection) throws Exception {
        super(transportConnection, null);
        transportConnection.setProtocolConnection((RemotingConnection)this);
    }

    public void fail(ActiveMQException me) {
        ArrayList copy = new ArrayList(this.failureListeners);
        for (FailureListener listener : copy) {
            listener.connectionFailed(me, false);
        }
        this.transportConnection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fail(ActiveMQException me, String scaleDownTargetNodeID) {
        List list = this.failureListeners;
        synchronized (list) {
            for (FailureListener listener : this.failureListeners) {
                listener.connectionFailed(me, false);
            }
        }
    }

    public Future asyncFail(ActiveMQException me) {
        FutureTask<Object> task = new FutureTask<Object>(() -> {
            this.fail(me);
            return null;
        });
        Thread t = new Thread(task);
        t.start();
        return task;
    }

    public void destroy() {
        this.destroyed = true;
        this.disconnect(false);
    }

    public boolean isClient() {
        return false;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void disconnect(boolean criticalError) {
        this.transportConnection.forceClose();
    }

    public void disconnect(String scaleDownNodeID, boolean criticalError) {
        this.transportConnection.forceClose();
    }

    protected void dataReceived() {
        this.dataReceived = true;
    }

    public void flush() {
        this.transportConnection.checkFlushBatchBuffer();
    }

    public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public boolean getConnected() {
        return this.connected;
    }

    public void killMessage(SimpleString nodeID) {
    }

    public boolean isSupportsFlowControl() {
        return false;
    }

    public String getProtocolName() {
        return "MQTT" + (this.protocolVersion != null ? this.protocolVersion : "");
    }

    public String getTransportLocalAddress() {
        return this.getTransportConnection().getLocalAddress();
    }

    public int getReceiveMaximum() {
        return this.receiveMaximum;
    }

    public void setReceiveMaximum(int maxReceive) {
        this.receiveMaximum = maxReceive;
    }

    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setClientIdAssignedByBroker(boolean clientIdAssignedByBroker) {
        this.clientIdAssignedByBroker = clientIdAssignedByBroker;
    }

    public boolean isClientIdAssignedByBroker() {
        return this.clientIdAssignedByBroker;
    }
}

