/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import jakarta.jms.IllegalStateException;
import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.MessageNotReadableException;
import jakarta.jms.MessageNotWriteableException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.ActiveMQInvalidFilterExpressionException;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.shaded.org.jboss.logging.Messages;
import org.apache.activemq.artemis.shaded.org.jboss.logging.annotations.Cause;
import org.apache.activemq.artemis.shaded.org.jboss.logging.annotations.Message;
import org.apache.activemq.artemis.shaded.org.jboss.logging.annotations.MessageBundle;

@MessageBundle(projectCode="AMQ")
public interface ActiveMQJMSClientBundle {
    public static final ActiveMQJMSClientBundle BUNDLE = Messages.getBundle(ActiveMQJMSClientBundle.class);

    @Message(id=139000, value="Invalid filter: {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQInvalidFilterExpressionException invalidFilter(@Cause Throwable var1, SimpleString var2);

    @Message(id=139001, value="Invalid Subscription Name. It is required to set the subscription name")
    public ActiveMQIllegalStateException invalidSubscriptionName();

    @Message(id=139002, value="Destination {0} does not exist", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQNonExistentQueueException destinationDoesNotExist(SimpleString var1);

    @Message(id=139003, value="name cannot be null")
    public IllegalArgumentException nameCannotBeNull();

    @Message(id=139004, value="name cannot be empty")
    public IllegalArgumentException nameCannotBeEmpty();

    @Message(id=139005, value="It is illegal to call this method from within a Message Listener")
    public IllegalStateRuntimeException callingMethodFromListenerRuntime();

    @Message(id=139006, value="It is illegal to call this method from within a Message Listener")
    public IllegalStateException callingMethodFromListener();

    @Message(id=139007, value="It is illegal to call this method from within a Completion Listener")
    public IllegalStateRuntimeException callingMethodFromCompletionListenerRuntime();

    @Message(id=139008, value="It is illegal to call this method from within a Completion Listener")
    public IllegalStateException callingMethodFromCompletionListener();

    @Message(id=139009, value="Null {0} is not allowed", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException nullArgumentNotAllowed(String var1);

    @Message(id=139010, value="Topic (Destination) cannot be null")
    public InvalidDestinationException nullTopic();

    @Message(id=139011, value="LargeMessage streaming is only possible on ByteMessage or StreamMessage")
    public IllegalStateException onlyValidForByteOrStreamMessages();

    @Message(id=139012, value="The property name ''{0}'' is not a valid java identifier.", format=Message.Format.MESSAGE_FORMAT)
    public JMSRuntimeException invalidJavaIdentifier(String var1);

    @Message(id=139013, value="Message is read-only")
    public MessageNotWriteableException messageNotWritable();

    @Message(id=139014, value="Message is write-only")
    public MessageNotReadableException messageNotReadable();

    @Message(id=139015, value="Illegal deliveryMode value: {0}", format=Message.Format.MESSAGE_FORMAT)
    public JMSException illegalDeliveryMode(int var1);
}

