/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.apache.activemq.artemis.logs.ActiveMQUtilLogger;
import org.apache.activemq.artemis.shaded.org.jboss.logging.Logger;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.Env;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;

public class NetworkHealthCheck
extends ActiveMQScheduledComponent {
    private static final Logger logger = Logger.getLogger(NetworkHealthCheck.class);
    private final Set<ActiveMQComponent> componentList = new ConcurrentHashSet<ActiveMQComponent>();
    private final Set<String> addresses = new ConcurrentHashSet<String>();
    private final Set<URL> urls = new ConcurrentHashSet<URL>();
    private NetworkInterface networkInterface;
    public static final String IPV6_DEFAULT_COMMAND = "ping6 -c 1 %2$s";
    public static final String IPV4_DEFAULT_COMMAND = Env.isMacOs() ? "ping -c 1 -t %d %s" : (Env.isWindowsOs() ? "cmd /C ping -n 1 -w %d %s | findstr /i TTL" : "ping -c 1 -w %d %s");
    private String ipv4Command = IPV4_DEFAULT_COMMAND;
    private String ipv6Command = "ping6 -c 1 %2$s";
    private boolean ignoreLoopback = false;
    private boolean ownShutdown = false;
    private int networkTimeout;

    public NetworkHealthCheck() {
        this(null, 1000L, 1000);
    }

    public NetworkHealthCheck(String nicName, long checkPeriod, int networkTimeout) {
        super(null, null, checkPeriod, TimeUnit.MILLISECONDS, false);
        this.networkTimeout = networkTimeout;
        this.setNICName(nicName);
    }

    public NetworkHealthCheck setNICName(String nicName) {
        NetworkInterface netToUse;
        try {
            netToUse = nicName != null ? NetworkInterface.getByName(nicName) : null;
        }
        catch (Exception e) {
            ActiveMQUtilLogger.LOGGER.failedToSetNIC(e, nicName);
            netToUse = null;
        }
        this.networkInterface = netToUse;
        return this;
    }

    public boolean isIgnoreLoopback() {
        return this.ignoreLoopback;
    }

    public NetworkHealthCheck setIgnoreLoopback(boolean ignoreLoopback) {
        this.ignoreLoopback = ignoreLoopback;
        return this;
    }

    public Set<String> getAddresses() {
        return this.addresses;
    }

    public Set<URL> getUrls() {
        return this.urls;
    }

    public String getNICName() {
        if (this.networkInterface != null) {
            return this.networkInterface.getName();
        }
        return null;
    }

    public NetworkHealthCheck parseAddressList(String addressList) {
        if (addressList != null) {
            String[] addresses;
            for (String address : addresses = addressList.split(",")) {
                if (address.trim().isEmpty()) continue;
                try {
                    String strAddress = address.trim();
                    this.addAddress(strAddress);
                }
                catch (Exception e) {
                    ActiveMQUtilLogger.LOGGER.failedToParseAddressList(e, addressList);
                }
            }
        }
        return this;
    }

    public NetworkHealthCheck parseURIList(String addressList) {
        if (addressList != null) {
            String[] addresses;
            for (String address : addresses = addressList.split(",")) {
                if (address.trim().isEmpty()) continue;
                try {
                    this.addURL(new URL(address.trim()));
                }
                catch (Exception e) {
                    ActiveMQUtilLogger.LOGGER.failedToParseUrlList(e, addressList);
                }
            }
        }
        return this;
    }

    @Override
    protected ActiveMQThreadFactory getThreadFactory() {
        return new ActiveMQThreadFactory("NetworkChecker", "Network-Checker-", false, this.getThisClassLoader());
    }

    private ClassLoader getThisClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return NetworkHealthCheck.this.getClass().getClassLoader();
            }
        });
    }

    public int getNetworkTimeout() {
        return this.networkTimeout;
    }

    @Override
    public synchronized NetworkHealthCheck setPeriod(long period) {
        super.setPeriod(period);
        return this;
    }

    @Override
    public synchronized NetworkHealthCheck setTimeUnit(TimeUnit timeUnit) {
        super.setTimeUnit(timeUnit);
        return this;
    }

    public NetworkHealthCheck setNetworkTimeout(int networkTimeout) {
        this.networkTimeout = networkTimeout;
        return this;
    }

    public NetworkHealthCheck addComponent(ActiveMQComponent component) {
        this.componentList.add(component);
        this.checkStart();
        return this;
    }

    public NetworkHealthCheck clearComponents() {
        this.componentList.clear();
        return this;
    }

    public NetworkHealthCheck addAddress(String straddress) {
        InetAddress address = this.internalCheck(straddress);
        if (address == null) {
            ActiveMQUtilLogger.LOGGER.addressWasntReacheable(straddress);
        }
        if (!this.ignoreLoopback && address != null && address.isLoopbackAddress()) {
            ActiveMQUtilLogger.LOGGER.addressloopback(straddress);
        } else {
            this.addresses.add(straddress);
            this.checkStart();
        }
        return this;
    }

    public NetworkHealthCheck removeAddress(String straddress) {
        this.addresses.remove(straddress);
        return this;
    }

    public NetworkHealthCheck clearAddresses() {
        this.addresses.clear();
        return this;
    }

    public NetworkHealthCheck addURL(URL url) {
        if (!this.check(url)) {
            ActiveMQUtilLogger.LOGGER.urlWasntReacheable(url.toString());
        }
        this.urls.add(url);
        this.checkStart();
        return this;
    }

    public NetworkHealthCheck removeURL(URL url) {
        this.urls.remove(url);
        return this;
    }

    public NetworkHealthCheck clearURL() {
        this.urls.clear();
        return this;
    }

    public String getIpv4Command() {
        return this.ipv4Command;
    }

    public NetworkHealthCheck setIpv4Command(String ipv4Command) {
        this.ipv4Command = ipv4Command;
        return this;
    }

    public String getIpv6Command() {
        return this.ipv6Command;
    }

    public NetworkHealthCheck setIpv6Command(String ipv6Command) {
        this.ipv6Command = ipv6Command;
        return this;
    }

    private void checkStart() {
        if (!(this.isStarted() || this.addresses.isEmpty() && this.urls.isEmpty() || this.componentList.isEmpty())) {
            try {
                this.run();
            }
            finally {
                this.start();
            }
        }
    }

    @Override
    public void run() {
        boolean healthy = this.check();
        if (healthy) {
            for (ActiveMQComponent component : this.componentList) {
                if (!component.isStarted() && this.ownShutdown) {
                    try {
                        ActiveMQUtilLogger.LOGGER.startingService(component.toString());
                        component.start();
                    }
                    catch (Exception e) {
                        ActiveMQUtilLogger.LOGGER.errorStartingComponent(e, component.toString());
                    }
                }
                this.ownShutdown = false;
            }
        } else {
            for (ActiveMQComponent component : this.componentList) {
                if (!component.isStarted()) continue;
                this.ownShutdown = true;
                try {
                    ActiveMQUtilLogger.LOGGER.stoppingService(component.toString());
                    component.stop();
                }
                catch (Exception e) {
                    ActiveMQUtilLogger.LOGGER.errorStoppingComponent(e, component.toString());
                }
            }
        }
    }

    public boolean check() {
        if (this.isEmpty()) {
            return true;
        }
        for (String address : this.addresses) {
            if (!this.check(address)) continue;
            return true;
        }
        for (URL url : this.urls) {
            if (!this.check(url)) continue;
            return true;
        }
        return false;
    }

    public boolean check(String straddress) {
        if (straddress == null) {
            return false;
        }
        return this.internalCheck(straddress) != null;
    }

    private InetAddress internalCheck(String straddress) {
        try {
            InetAddress address = InetAddress.getByName(straddress);
            address = InetAddress.getByName(address.getHostName());
            if (this.check(address)) {
                return address;
            }
            return null;
        }
        catch (Exception e) {
            ActiveMQUtilLogger.LOGGER.failedToCheckAddress(e, straddress);
            return null;
        }
    }

    public boolean check(InetAddress address) throws IOException, InterruptedException {
        if (!this.hasCustomPingCommand() && this.isReachable(address)) {
            if (logger.isTraceEnabled()) {
                logger.tracef(address + " OK", new Object[0]);
            }
            return true;
        }
        return this.purePing(address);
    }

    protected boolean isReachable(InetAddress address) throws IOException {
        return address.isReachable(this.networkInterface, 0, this.networkTimeout);
    }

    public boolean purePing(InetAddress address) throws IOException, InterruptedException {
        long timeout = Math.max(1L, TimeUnit.MILLISECONDS.toSeconds(this.networkTimeout));
        if (logger.isTraceEnabled()) {
            logger.trace("purePing on canonical address " + address.getCanonicalHostName());
        }
        ProcessBuilder processBuilder = address instanceof Inet6Address ? this.buildProcess(this.ipv6Command, timeout, address.getCanonicalHostName()) : this.buildProcess(this.ipv4Command, timeout, address.getCanonicalHostName());
        Process pingProcess = processBuilder.start();
        this.readStream(pingProcess.getInputStream(), false);
        this.readStream(pingProcess.getErrorStream(), true);
        return pingProcess.waitFor() == 0;
    }

    private ProcessBuilder buildProcess(String expressionCommand, long timeout, String host) {
        String command = String.format(expressionCommand, timeout, host);
        if (logger.isDebugEnabled()) {
            logger.debug("executing ping:: " + command);
        }
        ProcessBuilder builder = new ProcessBuilder(command.split(" "));
        return builder;
    }

    private void readStream(InputStream stream, boolean error) throws IOException {
        String inputLine;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        while ((inputLine = reader.readLine()) != null) {
            if (error) {
                ActiveMQUtilLogger.LOGGER.failedToReadFromStream(inputLine);
                continue;
            }
            logger.debug(inputLine);
        }
        reader.close();
    }

    public boolean check(URL url) {
        if (url == null) {
            return false;
        }
        try {
            URLConnection connection = url.openConnection();
            connection.setReadTimeout(this.networkTimeout);
            InputStream is = connection.getInputStream();
            is.close();
            return true;
        }
        catch (Exception e) {
            ActiveMQUtilLogger.LOGGER.failedToCheckURL(e, url.toString());
            return false;
        }
    }

    public boolean isEmpty() {
        return this.addresses.isEmpty() && this.urls.isEmpty();
    }

    public boolean hasCustomPingCommand() {
        return !this.getIpv4Command().equals(IPV4_DEFAULT_COMMAND) || !this.getIpv6Command().equals(IPV6_DEFAULT_COMMAND);
    }
}

