/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.logs;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;

public class AssertionLoggerHandler
extends ExtHandler {
    private static final Map<String, ExtLogRecord> messages = new ConcurrentHashMap<String, ExtLogRecord>();
    private static List<String> traceMessages;
    private static boolean capture;

    public void flush() {
    }

    public void close() throws SecurityException {
    }

    protected void doPublish(ExtLogRecord record) {
        if (capture) {
            messages.put(record.getFormattedMessage(), record);
            if (traceMessages != null) {
                traceMessages.add(record.getFormattedMessage());
            }
        }
    }

    public static boolean hasLevel(Level level) {
        for (ExtLogRecord record : messages.values()) {
            if (!record.getLevel().equals(level)) continue;
            return true;
        }
        return false;
    }

    public static boolean findText(long mstimeout, String ... text) {
        long timeMax = System.currentTimeMillis() + mstimeout;
        do {
            if (!AssertionLoggerHandler.findText(text)) continue;
            return true;
        } while (timeMax > System.currentTimeMillis());
        return false;
    }

    public static boolean findText(String ... text) {
        for (Map.Entry<String, ExtLogRecord> entry : messages.entrySet()) {
            Throwable throwable;
            String txtCheck;
            String key = entry.getKey();
            boolean found = true;
            String[] stringArray = text;
            int n = stringArray.length;
            for (int i = 0; i < n && ((found = key.contains(txtCheck = stringArray[i])) || (throwable = entry.getValue().getThrown()) != null && throwable.getMessage() != null && (found = throwable.getMessage().contains(txtCheck))); ++i) {
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    public static int countText(String ... text) {
        int found = 0;
        if (traceMessages != null) {
            for (String str : traceMessages) {
                for (String txtCheck : text) {
                    if (!str.contains(txtCheck)) continue;
                    ++found;
                }
            }
        } else {
            for (Map.Entry<String, ExtLogRecord> entry : messages.entrySet()) {
                String key = entry.getKey();
                for (String txtCheck : text) {
                    if (!key.contains(txtCheck)) continue;
                    ++found;
                }
            }
        }
        return found;
    }

    public static boolean matchText(String pattern) {
        Pattern r = Pattern.compile(pattern);
        for (Map.Entry<String, ExtLogRecord> entry : messages.entrySet()) {
            if (r.matcher(entry.getKey()).matches()) {
                return true;
            }
            Throwable throwable = entry.getValue().getThrown();
            if (throwable == null || throwable.getMessage() == null || !r.matcher(throwable.getMessage()).matches()) continue;
            return true;
        }
        return false;
    }

    public static final void clear() {
        messages.clear();
        if (traceMessages != null) {
            traceMessages.clear();
        }
    }

    public static final void startCapture() {
        AssertionLoggerHandler.startCapture(false);
    }

    public static final void startCapture(boolean individualMessages) {
        AssertionLoggerHandler.clear();
        if (individualMessages) {
            traceMessages = new LinkedList<String>();
        }
        capture = true;
    }

    public static final void stopCapture() {
        capture = false;
        AssertionLoggerHandler.clear();
        traceMessages = null;
    }

    static {
        capture = false;
    }
}

