/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.config;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzerPolicy;
import org.jboss.logging.Logger;

public final class ActiveMQDefaultConfiguration {
    private static final Logger logger;
    private static long DEFAULT_CLIENT_FAILURE_CHECK_PERIOD;
    private static long DEFAULT_FILE_DEPLOYER_SCAN_PERIOD;
    private static int DEFAULT_JOURNAL_MAX_IO_AIO;
    private static int DEFAULT_JOURNAL_POOL_FILES;
    private static int DEFAULT_JOURNAL_BUFFER_TIMEOUT_AIO;
    private static int DEFAULT_JOURNAL_BUFFER_SIZE_AIO;
    private static int DEFAULT_JOURNAL_MAX_IO_NIO;
    private static int DEFAULT_JOURNAL_BUFFER_TIMEOUT_NIO;
    private static int DEFAULT_JOURNAL_BUFFER_SIZE_NIO;
    private static String PROP_MASK_PASSWORD;
    private static String PROP_PASSWORD_CODEC;
    private static String DEFAULT_HAPOLICY_TYPE;
    private static String DEFAULT_HAPOLICY_BACKUP_STRATEGY;
    private static boolean DEFAULT_RESOLVE_PROTOCOLS;
    private static boolean DEFAULT_FILE_DEPLOYMENT_ENABLED;
    private static boolean DEFAULT_PERSISTENCE_ENABLED;
    private static boolean DEFAULT_JOURNAL_DATASYNC;
    private static int DEFAULT_SCHEDULED_THREAD_POOL_MAX_SIZE;
    private static int DEFAULT_THREAD_POOL_MAX_SIZE;
    private static boolean DEFAULT_SECURITY_ENABLED;
    private static boolean DEFAULT_GRACEFUL_SHUTDOWN_ENABLED;
    private static long DEFAULT_GRACEFUL_SHUTDOWN_TIMEOUT;
    private static long DEFAULT_SECURITY_INVALIDATION_INTERVAL;
    private static long DEFAULT_AUTHENTICATION_CACHE_SIZE;
    private static long DEFAULT_AUTHORIZATION_CACHE_SIZE;
    private static long DEFAULT_JOURNAL_LOCK_ACQUISITION_TIMEOUT;
    private static boolean DEFAULT_WILDCARD_ROUTING_ENABLED;
    private static String DEFAULT_ADDRESS_PATH_SEPARATOR;
    private static SimpleString DEFAULT_MANAGEMENT_ADDRESS;
    private static SimpleString DEFAULT_MANAGEMENT_NOTIFICATION_ADDRESS;
    private static String DEFAULT_CLUSTER_ADDRESS;
    private static String DEFAULT_CLUSTER_USER;
    private static String DEFAULT_CLUSTER_PASSWORD;
    private static String DEFAULT_FEDERATION_USER;
    private static String DEFAULT_FEDERATION_PASSWORD;
    private static Boolean DEFAULT_MASK_PASSWORD;
    private static boolean DEFAULT_JMX_MANAGEMENT_ENABLED;
    private static String DEFAULT_JMX_DOMAIN;
    private static boolean DEFAULT_JMX_IS_USE_BROKER_NAME;
    private static boolean DEFAULT_MESSAGE_COUNTER_ENABLED;
    private static long DEFAULT_MESSAGE_COUNTER_SAMPLE_PERIOD;
    private static int DEFAULT_MESSAGE_COUNTER_MAX_DAY_HISTORY;
    private static long DEFAULT_CONNECTION_TTL_OVERRIDE;
    private static boolean DEFAULT_ASYNC_CONNECTION_EXECUTION_ENABLED;
    private static long DEFAULT_TRANSACTION_TIMEOUT;
    private static long DEFAULT_TRANSACTION_TIMEOUT_SCAN_PERIOD;
    private static long DEFAULT_MESSAGE_EXPIRY_SCAN_PERIOD;
    private static long DEFAULT_ADDRESS_QUEUE_SCAN_PERIOD;
    @Deprecated
    private static int DEFAULT_MESSAGE_EXPIRY_THREAD_PRIORITY;
    private static int DEFAULT_ID_CACHE_SIZE;
    private static boolean DEFAULT_PERSIST_ID_CACHE;
    private static boolean DEFAULT_PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY;
    private static String DEFAULT_PAGING_DIR;
    private static String DEFAULT_BINDINGS_DIRECTORY;
    private static boolean DEFAULT_CREATE_BINDINGS_DIR;
    private static int DEFAULT_MAX_CONCURRENT_PAGE_IO;
    private static boolean DEFAULT_READ_WHOLE_PAGE;
    private static String DEFAULT_JOURNAL_DIR;
    private static String DEFAULT_DATA_DIR;
    private static boolean DEFAULT_CREATE_JOURNAL_DIR;
    private static boolean DEFAULT_JOURNAL_SYNC_TRANSACTIONAL;
    private static boolean DEFAULT_JOURNAL_SYNC_NON_TRANSACTIONAL;
    private static boolean DEFAULT_JOURNAL_LOG_WRITE_RATE;
    private static int DEFAULT_JOURNAL_FILE_SIZE;
    private static int DEFAULT_JOURNAL_MIN_FILES;
    private static int DEFAULT_JOURNAL_COMPACT_PERCENTAGE;
    private static int DEFAULT_JOURNAL_FILE_OPEN_TIMEOUT;
    private static int DEFAULT_JOURNAL_COMPACT_MIN_FILES;
    private static int DEFAULT_JOURNAL_MAX_ATTIC_FILES;
    private static long DEFAULT_SERVER_DUMP_INTERVAL;
    private static int DEFAULT_MEMORY_WARNING_THRESHOLD;
    private static long DEFAULT_MEMORY_MEASURE_INTERVAL;
    private static String DEFAULT_LARGE_MESSAGES_DIR;
    private static long DEFAULT_BROADCAST_PERIOD;
    private static int DEFAULT_BROADCAST_REFRESH_TIMEOUT;
    private static long DEFAULT_CONNECTION_TTL;
    private static double DEFAULT_RETRY_INTERVAL_MULTIPLIER;
    private static long DEFAULT_MAX_RETRY_INTERVAL;
    private static int DEFAULT_BRIDGE_INITIAL_CONNECT_ATTEMPTS;
    private static int DEFAULT_BRIDGE_RECONNECT_ATTEMPTS;
    private static boolean DEFAULT_BRIDGE_DUPLICATE_DETECTION;
    private static int DEFAULT_BRIDGE_CONFIRMATION_WINDOW_SIZE;
    private static int DEFAULT_BRIDGE_PRODUCER_WINDOW_SIZE;
    private static int DEFAULT_BRIDGE_CONNECT_SAME_NODE;
    private static long DEFAULT_CLUSTER_FAILURE_CHECK_PERIOD;
    private static long DEFAULT_CLUSTER_CONNECTION_TTL;
    private static long DEFAULT_CLUSTER_CALL_TIMEOUT;
    private static long DEFAULT_CLUSTER_RETRY_INTERVAL;
    private static double DEFAULT_CLUSTER_RETRY_INTERVAL_MULTIPLIER;
    private static long DEFAULT_CLUSTER_MAX_RETRY_INTERVAL;
    private static int DEFAULT_CLUSTER_INITIAL_CONNECT_ATTEMPTS;
    private static int DEFAULT_CLUSTER_RECONNECT_ATTEMPTS;
    private static boolean DEFAULT_CLUSTER_DUPLICATE_DETECTION;
    private static boolean DEFAULT_CLUSTER_FORWARD_WHEN_NO_CONSUMERS;
    private static String DEFAULT_CLUSTER_MESSAGE_LOAD_BALANCING_TYPE;
    private static int DEFAULT_CLUSTER_MAX_HOPS;
    private static int DEFAULT_CLUSTER_CONFIRMATION_WINDOW_SIZE;
    private static long DEFAULT_CLUSTER_CALL_FAILOVER_TIMEOUT;
    private static long DEFAULT_CLUSTER_NOTIFICATION_INTERVAL;
    private static int DEFAULT_CLUSTER_NOTIFICATION_ATTEMPTS;
    private static boolean DEFAULT_DIVERT_EXCLUSIVE;
    private static String DEFAULT_DIVERT_ROUTING_TYPE;
    private static String DEFAULT_BRIDGE_ROUTING_TYPE;
    private static boolean DEFAULT_HAPOLICY_REQUEST_BACKUP;
    private static int DEFAULT_HAPOLICY_BACKUP_REQUEST_RETRIES;
    private static long DEFAULT_HAPOLICY_BACKUP_REQUEST_RETRY_INTERVAL;
    private static int DEFAULT_HAPOLICY_MAX_BACKUPS;
    private static int DEFAULT_HAPOLICY_BACKUP_PORT_OFFSET;
    private static boolean DEFAULT_CHECK_FOR_LIVE_SERVER;
    private static int DEFAULT_MAX_SAVED_REPLICATED_JOURNALS_SIZE;
    private static boolean DEFAULT_RESTART_BACKUP;
    private static boolean DEFAULT_ALLOW_AUTO_FAILBACK;
    private static long DEFAULT_INITIAL_REPLICATION_SYNC_TIMEOUT;
    private static boolean DEFAULT_FAILOVER_ON_SERVER_SHUTDOWN;
    private static boolean DEFAULT_WAIT_FOR_ACTIVATION;
    private static boolean DEFAULT_POPULATE_VALIDATED_USER;
    private static boolean DEFAULT_REJECT_EMPTY_VALIDATED_USER;
    private static boolean DEFAULT_SCALE_DOWN_ENABLED;
    private static int DEFAULT_GROUPING_HANDLER_TIMEOUT;
    private static int DEFAULT_GROUPING_HANDLER_GROUP_TIMEOUT;
    private static long DEFAULT_GROUPING_HANDLER_REAPER_PERIOD;
    private static String DEFAULT_STORE_TYPE;
    private static String DEFAULT_DATABASE_URL;
    private static String DEFAULT_JDBC_DRIVER_CLASS_NAME;
    private static String DEFAULT_JDBC_DATA_SOURCE_CLASS_NAME;
    private static String DEFAULT_MESSAGE_TABLE_NAME;
    private static String DEFAULT_BINDINGS_TABLE_NAME;
    private static final String DEFAULT_LARGE_MESSAGES_TABLE_NAME = "LARGE_MESSAGES";
    private static final String DEFAULT_PAGE_STORE_TABLE_NAME = "PAGE_STORE";
    private static final String DEFAULT_NODE_MANAGER_STORE_TABLE_NAME = "NODE_MANAGER_STORE";
    private static final int DEFAULT_JDBC_NETWORK_TIMEOUT;
    private static final long DEFAULT_JDBC_LOCK_RENEW_PERIOD_MILLIS;
    private static final long DEFAULT_JDBC_LOCK_EXPIRATION_MILLIS;
    private static final long DEFAULT_JDBC_JOURNAL_SYNC_PERIOD_MILLIS = 5L;
    private static final long DEFAULT_JDBC_LOCK_ACQUISITION_TIMEOUT_MILLIS = -1L;
    public static final long DEFAULT_CONNECTION_TTL_CHECK_INTERVAL = 2000L;
    public static final long DEFAULT_CONFIGURATION_FILE_REFRESH_PERIOD = 5000L;
    public static final boolean DEFAULT_AMQP_USE_CORE_SUBSCRIPTION_NAMING = false;
    public static final long DEFAULT_GLOBAL_MAX_SIZE;
    public static final long DEFAULT_GLOBAL_MAX_MESSAGES = -1L;
    public static final int DEFAULT_MAX_DISK_USAGE;
    public static final int DEFAULT_DISK_SCAN = 5000;
    public static final int DEFAULT_MAX_QUEUE_CONSUMERS = -1;
    public static final int DEFAULT_CONSUMER_PRIORITY = 0;
    public static final boolean DEFAULT_EXCLUSIVE = false;
    public static final boolean DEFAULT_LAST_VALUE = false;
    public static final SimpleString DEFAULT_LAST_VALUE_KEY;
    public static final boolean DEFAULT_NON_DESTRUCTIVE = false;
    public static final boolean DEFAULT_PURGE_ON_NO_CONSUMERS = false;
    public static final boolean DEFAULT_ENABLED = true;
    public static final boolean DEFAULT_QUEUE_AUTO_DELETE = true;
    public static final boolean DEFAULT_CREATED_QUEUE_AUTO_DELETE = false;
    public static final long DEFAULT_QUEUE_AUTO_DELETE_DELAY = 0L;
    public static final long DEFAULT_QUEUE_AUTO_DELETE_MESSAGE_COUNT = 0L;
    public static final long DEFAULT_RING_SIZE = -1L;
    public static final int DEFAULT_CONSUMERS_BEFORE_DISPATCH = 0;
    public static final long DEFAULT_DELAY_BEFORE_DISPATCH = -1L;
    public static final int DEFAULT_GROUP_BUCKETS = -1;
    public static final boolean DEFAULT_GROUP_REBALANCE = false;
    public static final boolean DEFAULT_GROUP_REBALANCE_PAUSE_DISPATCH = false;
    public static final SimpleString DEFAULT_GROUP_FIRST_KEY;
    public static final RoutingType DEFAULT_ROUTING_TYPE;
    public static final String DEFAULT_SYSTEM_PROPERTY_PREFIX = "brokerconfig.";
    public static final String BROKER_PROPERTIES_SYSTEM_PROPERTY_NAME = "broker.properties";
    public static final String BROKER_PROPERTIES_KEY_SURROUND = "\"";
    public static final String BROKER_PROPERTIES_KEY_SURROUND_PROPERTY = "key.surround";
    public static String DEFAULT_NETWORK_CHECK_LIST;
    public static String DEFAULT_NETWORK_CHECK_URL_LIST;
    public static long DEFAULT_NETWORK_CHECK_PERIOD;
    public static int DEFAULT_NETWORK_CHECK_TIMEOUT;
    public static String DEFAULT_NETWORK_CHECK_NIC;
    public static final String DEFAULT_INTERNAL_NAMING_PREFIX = "$.artemis.internal.";
    public static boolean DEFAULT_VOTE_ON_REPLICATION_FAILURE;
    private static int DEFAULT_VOTE_RETRIES;
    private static long DEFAULT_VOTE_RETRY_WAIT;
    private static int DEFAULT_QUORUM_VOTE_WAIT;
    private static long DEFAULT_RETRY_REPLICATION_WAIT;
    public static int DEFAULT_QUORUM_SIZE;
    public static final boolean DEFAULT_ANALYZE_CRITICAL = true;
    public static final long DEFAULT_ANALYZE_CRITICAL_TIMEOUT = 120000L;
    public static final long DEFAULT_RETROACTIVE_MESSAGE_COUNT = 0L;
    public static final CriticalAnalyzerPolicy DEFAULT_ANALYZE_CRITICAL_POLICY;
    private static long DEFAULT_FEDERATION_FAILURE_CHECK_PERIOD;
    private static long DEFAULT_FEDERATION_CONNECTION_TTL;
    private static long DEFAULT_FEDERATION_CALL_TIMEOUT;
    private static long DEFAULT_FEDERATION_RETRY_INTERVAL;
    private static double DEFAULT_FEDERATION_RETRY_INTERVAL_MULTIPLIER;
    private static long DEFAULT_FEDERATION_MAX_RETRY_INTERVAL;
    private static int DEFAULT_FEDERATION_INITIAL_CONNECT_ATTEMPTS;
    private static int DEFAULT_FEDERATION_RECONNECT_ATTEMPTS;
    private static long DEFAULT_FEDERATION_CALL_FAILOVER_TIMEOUT;
    private static final boolean DEFAULT_JVM_MEMORY_METRICS = true;
    private static final boolean DEFAULT_JVM_GC_METRICS = false;
    private static final boolean DEFAULT_JVM_THREAD_METRICS = false;
    public static final String DEFAULT_TEMPORARY_QUEUE_NAMESPACE = "";
    private static final String DEFAULT_DISTRIBUTED_PRIMITIVE_MANAGER_CLASS_NAME = "org.apache.activemq.artemis.quorum.zookeeper.CuratorDistributedPrimitiveManager";
    public static int DEFAULT_BRIDGE_CONCURRENCY;
    private static final boolean DEFAULT_NETTY_POOL_METRICS = false;
    private static long DEFAULT_MQTT_SESSION_SCAN_INTERVAL;
    public static boolean DEFAULT_SUPPRESS_SESSION_NOTIFICATIONS;

    private ActiveMQDefaultConfiguration() {
    }

    public static long getDefaultClientFailureCheckPeriod() {
        return DEFAULT_CLIENT_FAILURE_CHECK_PERIOD;
    }

    public static long getDefaultFileDeployerScanPeriod() {
        return DEFAULT_FILE_DEPLOYER_SCAN_PERIOD;
    }

    public static int getDefaultJournalMaxIoAio() {
        return DEFAULT_JOURNAL_MAX_IO_AIO;
    }

    public static int getDefaultJournalBufferTimeoutAio() {
        return DEFAULT_JOURNAL_BUFFER_TIMEOUT_AIO;
    }

    public static int getDefaultJournalBufferSizeAio() {
        return DEFAULT_JOURNAL_BUFFER_SIZE_AIO;
    }

    public static int getDefaultJournalMaxIoNio() {
        return DEFAULT_JOURNAL_MAX_IO_NIO;
    }

    public static int getDefaultJournalBufferTimeoutNio() {
        return DEFAULT_JOURNAL_BUFFER_TIMEOUT_NIO;
    }

    public static int getDefaultJournalBufferSizeNio() {
        return DEFAULT_JOURNAL_BUFFER_SIZE_NIO;
    }

    public static String getPropMaskPassword() {
        return PROP_MASK_PASSWORD;
    }

    public static String getPropPasswordCodec() {
        return PROP_PASSWORD_CODEC;
    }

    public static String getDefaultHapolicyType() {
        return DEFAULT_HAPOLICY_TYPE;
    }

    public static String getDefaultHapolicyBackupStrategy() {
        return DEFAULT_HAPOLICY_BACKUP_STRATEGY;
    }

    public static boolean isDefaultResolveProtocols() {
        return DEFAULT_RESOLVE_PROTOCOLS;
    }

    public static boolean isDefaultFileDeploymentEnabled() {
        return DEFAULT_FILE_DEPLOYMENT_ENABLED;
    }

    public static boolean isDefaultPersistenceEnabled() {
        return DEFAULT_PERSISTENCE_ENABLED;
    }

    public static boolean isDefaultJournalDatasync() {
        return DEFAULT_JOURNAL_DATASYNC;
    }

    public static int getDefaultScheduledThreadPoolMaxSize() {
        return DEFAULT_SCHEDULED_THREAD_POOL_MAX_SIZE;
    }

    public static int getDefaultThreadPoolMaxSize() {
        return DEFAULT_THREAD_POOL_MAX_SIZE;
    }

    public static boolean isDefaultSecurityEnabled() {
        return DEFAULT_SECURITY_ENABLED;
    }

    public static boolean isDefaultGracefulShutdownEnabled() {
        return DEFAULT_GRACEFUL_SHUTDOWN_ENABLED;
    }

    public static long getDefaultGracefulShutdownTimeout() {
        return DEFAULT_GRACEFUL_SHUTDOWN_TIMEOUT;
    }

    public static long getDefaultSecurityInvalidationInterval() {
        return DEFAULT_SECURITY_INVALIDATION_INTERVAL;
    }

    public static long getDefaultAuthenticationCacheSize() {
        return DEFAULT_AUTHENTICATION_CACHE_SIZE;
    }

    public static long getDefaultAuthorizationCacheSize() {
        return DEFAULT_AUTHORIZATION_CACHE_SIZE;
    }

    public static long getDefaultJournalLockAcquisitionTimeout() {
        return DEFAULT_JOURNAL_LOCK_ACQUISITION_TIMEOUT;
    }

    public static boolean isDefaultWildcardRoutingEnabled() {
        return DEFAULT_WILDCARD_ROUTING_ENABLED;
    }

    public static String getDefaultAddressPathSeparator() {
        return DEFAULT_ADDRESS_PATH_SEPARATOR;
    }

    public static SimpleString getDefaultManagementAddress() {
        return DEFAULT_MANAGEMENT_ADDRESS;
    }

    public static SimpleString getDefaultManagementNotificationAddress() {
        return DEFAULT_MANAGEMENT_NOTIFICATION_ADDRESS;
    }

    public static String getDefaultClusterAddress() {
        return DEFAULT_CLUSTER_ADDRESS;
    }

    public static String getDefaultClusterUser() {
        return DEFAULT_CLUSTER_USER;
    }

    public static String getDefaultClusterPassword() {
        return DEFAULT_CLUSTER_PASSWORD;
    }

    public static String getDefaultFederationUser() {
        return DEFAULT_CLUSTER_USER;
    }

    public static String getDefaultFederationPassword() {
        return DEFAULT_CLUSTER_PASSWORD;
    }

    public static Boolean isDefaultMaskPassword() {
        return DEFAULT_MASK_PASSWORD;
    }

    public static boolean isDefaultJmxManagementEnabled() {
        return DEFAULT_JMX_MANAGEMENT_ENABLED;
    }

    public static String getDefaultJmxDomain() {
        return DEFAULT_JMX_DOMAIN;
    }

    public static boolean isDefaultJMXUseBrokerName() {
        return DEFAULT_JMX_IS_USE_BROKER_NAME;
    }

    public static boolean isDefaultMessageCounterEnabled() {
        return DEFAULT_MESSAGE_COUNTER_ENABLED;
    }

    public static long getDefaultMessageCounterSamplePeriod() {
        return DEFAULT_MESSAGE_COUNTER_SAMPLE_PERIOD;
    }

    public static int getDefaultMessageCounterMaxDayHistory() {
        return DEFAULT_MESSAGE_COUNTER_MAX_DAY_HISTORY;
    }

    public static long getDefaultConnectionTtlOverride() {
        return DEFAULT_CONNECTION_TTL_OVERRIDE;
    }

    public static boolean isDefaultAsyncConnectionExecutionEnabled() {
        return DEFAULT_ASYNC_CONNECTION_EXECUTION_ENABLED;
    }

    public static long getDefaultTransactionTimeout() {
        return DEFAULT_TRANSACTION_TIMEOUT;
    }

    public static long getDefaultTransactionTimeoutScanPeriod() {
        return DEFAULT_TRANSACTION_TIMEOUT_SCAN_PERIOD;
    }

    public static long getDefaultMessageExpiryScanPeriod() {
        return DEFAULT_MESSAGE_EXPIRY_SCAN_PERIOD;
    }

    @Deprecated
    public static int getDefaultMessageExpiryThreadPriority() {
        return DEFAULT_MESSAGE_EXPIRY_THREAD_PRIORITY;
    }

    public static long getDefaultAddressQueueScanPeriod() {
        return DEFAULT_ADDRESS_QUEUE_SCAN_PERIOD;
    }

    static void setDefaultAddressQueueScanPeriod(long scanPeriod) {
        DEFAULT_ADDRESS_QUEUE_SCAN_PERIOD = scanPeriod;
    }

    public static int getDefaultIdCacheSize() {
        return DEFAULT_ID_CACHE_SIZE;
    }

    public static boolean isDefaultPersistIdCache() {
        return DEFAULT_PERSIST_ID_CACHE;
    }

    public static boolean isDefaultPersistDeliveryCountBeforeDelivery() {
        return DEFAULT_PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY;
    }

    public static String getDefaultPagingDir() {
        return DEFAULT_PAGING_DIR;
    }

    public static String getDefaultBindingsDirectory() {
        return DEFAULT_BINDINGS_DIRECTORY;
    }

    public static boolean isDefaultCreateBindingsDir() {
        return DEFAULT_CREATE_BINDINGS_DIR;
    }

    public static int getDefaultMaxConcurrentPageIo() {
        return DEFAULT_MAX_CONCURRENT_PAGE_IO;
    }

    public static boolean isDefaultReadWholePage() {
        return DEFAULT_READ_WHOLE_PAGE;
    }

    public static String getDefaultJournalDir() {
        return DEFAULT_JOURNAL_DIR;
    }

    public static String getDefaultDataDir() {
        return DEFAULT_DATA_DIR;
    }

    public static boolean isDefaultCreateJournalDir() {
        return DEFAULT_CREATE_JOURNAL_DIR;
    }

    public static boolean isDefaultJournalSyncTransactional() {
        return DEFAULT_JOURNAL_SYNC_TRANSACTIONAL;
    }

    public static boolean isDefaultJournalSyncNonTransactional() {
        return DEFAULT_JOURNAL_SYNC_NON_TRANSACTIONAL;
    }

    public static boolean isDefaultJournalLogWriteRate() {
        return DEFAULT_JOURNAL_LOG_WRITE_RATE;
    }

    public static int getDefaultJournalFileSize() {
        return DEFAULT_JOURNAL_FILE_SIZE;
    }

    public static int getDefaultJournalMinFiles() {
        return DEFAULT_JOURNAL_MIN_FILES;
    }

    public static int getDefaultJournalPoolFiles() {
        return DEFAULT_JOURNAL_POOL_FILES;
    }

    public static int getDefaultJournalCompactPercentage() {
        return DEFAULT_JOURNAL_COMPACT_PERCENTAGE;
    }

    public static int getDefaultJournalFileOpenTimeout() {
        return DEFAULT_JOURNAL_FILE_OPEN_TIMEOUT;
    }

    public static int getDefaultJournalCompactMinFiles() {
        return DEFAULT_JOURNAL_COMPACT_MIN_FILES;
    }

    public static int getDefaultJournalMaxAtticFiles() {
        return DEFAULT_JOURNAL_MAX_ATTIC_FILES;
    }

    public static long getDefaultServerDumpInterval() {
        return DEFAULT_SERVER_DUMP_INTERVAL;
    }

    public static int getDefaultMemoryWarningThreshold() {
        return DEFAULT_MEMORY_WARNING_THRESHOLD;
    }

    public static long getDefaultMemoryMeasureInterval() {
        return DEFAULT_MEMORY_MEASURE_INTERVAL;
    }

    public static String getDefaultLargeMessagesDir() {
        return DEFAULT_LARGE_MESSAGES_DIR;
    }

    public static long getDefaultBroadcastPeriod() {
        return DEFAULT_BROADCAST_PERIOD;
    }

    public static int getDefaultBroadcastRefreshTimeout() {
        return DEFAULT_BROADCAST_REFRESH_TIMEOUT;
    }

    public static long getDefaultConnectionTtl() {
        return DEFAULT_CONNECTION_TTL;
    }

    public static double getDefaultRetryIntervalMultiplier() {
        return DEFAULT_RETRY_INTERVAL_MULTIPLIER;
    }

    public static long getDefaultMaxRetryInterval() {
        return DEFAULT_MAX_RETRY_INTERVAL;
    }

    public static int getDefaultBridgeInitialConnectAttempts() {
        return DEFAULT_BRIDGE_INITIAL_CONNECT_ATTEMPTS;
    }

    public static int getDefaultBridgeReconnectAttempts() {
        return DEFAULT_BRIDGE_RECONNECT_ATTEMPTS;
    }

    public static boolean isDefaultBridgeDuplicateDetection() {
        return DEFAULT_BRIDGE_DUPLICATE_DETECTION;
    }

    public static int getDefaultBridgeConfirmationWindowSize() {
        return DEFAULT_BRIDGE_CONFIRMATION_WINDOW_SIZE;
    }

    public static int getDefaultBridgeProducerWindowSize() {
        return DEFAULT_BRIDGE_PRODUCER_WINDOW_SIZE;
    }

    public static int getDefaultBridgeConnectSameNode() {
        return DEFAULT_BRIDGE_CONNECT_SAME_NODE;
    }

    public static long getDefaultClusterFailureCheckPeriod() {
        return DEFAULT_CLUSTER_FAILURE_CHECK_PERIOD;
    }

    public static long getDefaultClusterConnectionTtl() {
        return DEFAULT_CLUSTER_CONNECTION_TTL;
    }

    public static long getDefaultClusterCallTimeout() {
        return DEFAULT_CLUSTER_CALL_TIMEOUT;
    }

    public static long getDefaultClusterRetryInterval() {
        return DEFAULT_CLUSTER_RETRY_INTERVAL;
    }

    public static double getDefaultClusterRetryIntervalMultiplier() {
        return DEFAULT_CLUSTER_RETRY_INTERVAL_MULTIPLIER;
    }

    public static long getDefaultClusterMaxRetryInterval() {
        return DEFAULT_CLUSTER_MAX_RETRY_INTERVAL;
    }

    public static int getDefaultClusterInitialConnectAttempts() {
        return DEFAULT_CLUSTER_INITIAL_CONNECT_ATTEMPTS;
    }

    public static int getDefaultClusterReconnectAttempts() {
        return DEFAULT_CLUSTER_RECONNECT_ATTEMPTS;
    }

    public static boolean isDefaultClusterDuplicateDetection() {
        return DEFAULT_CLUSTER_DUPLICATE_DETECTION;
    }

    public static boolean isDefaultClusterForwardWhenNoConsumers() {
        return DEFAULT_CLUSTER_FORWARD_WHEN_NO_CONSUMERS;
    }

    public static String getDefaultClusterMessageLoadBalancingType() {
        return DEFAULT_CLUSTER_MESSAGE_LOAD_BALANCING_TYPE;
    }

    public static int getDefaultClusterMaxHops() {
        return DEFAULT_CLUSTER_MAX_HOPS;
    }

    public static int getDefaultClusterConfirmationWindowSize() {
        return DEFAULT_CLUSTER_CONFIRMATION_WINDOW_SIZE;
    }

    public static long getDefaultClusterCallFailoverTimeout() {
        return DEFAULT_CLUSTER_CALL_FAILOVER_TIMEOUT;
    }

    public static long getDefaultClusterNotificationInterval() {
        return DEFAULT_CLUSTER_NOTIFICATION_INTERVAL;
    }

    public static int getDefaultClusterNotificationAttempts() {
        return DEFAULT_CLUSTER_NOTIFICATION_ATTEMPTS;
    }

    public static boolean isDefaultDivertExclusive() {
        return DEFAULT_DIVERT_EXCLUSIVE;
    }

    public static String getDefaultDivertRoutingType() {
        return DEFAULT_DIVERT_ROUTING_TYPE;
    }

    public static String getDefaultBridgeRoutingType() {
        return DEFAULT_BRIDGE_ROUTING_TYPE;
    }

    public static boolean isDefaultHapolicyRequestBackup() {
        return DEFAULT_HAPOLICY_REQUEST_BACKUP;
    }

    public static int getDefaultHapolicyBackupRequestRetries() {
        return DEFAULT_HAPOLICY_BACKUP_REQUEST_RETRIES;
    }

    public static long getDefaultHapolicyBackupRequestRetryInterval() {
        return DEFAULT_HAPOLICY_BACKUP_REQUEST_RETRY_INTERVAL;
    }

    public static int getDefaultHapolicyMaxBackups() {
        return DEFAULT_HAPOLICY_MAX_BACKUPS;
    }

    public static int getDefaultHapolicyBackupPortOffset() {
        return DEFAULT_HAPOLICY_BACKUP_PORT_OFFSET;
    }

    public static boolean isDefaultCheckForLiveServer() {
        return DEFAULT_CHECK_FOR_LIVE_SERVER;
    }

    public static int getDefaultMaxSavedReplicatedJournalsSize() {
        return DEFAULT_MAX_SAVED_REPLICATED_JOURNALS_SIZE;
    }

    public static boolean isDefaultRestartBackup() {
        return DEFAULT_RESTART_BACKUP;
    }

    public static boolean isDefaultAllowAutoFailback() {
        return DEFAULT_ALLOW_AUTO_FAILBACK;
    }

    public static long getDefaultInitialReplicationSyncTimeout() {
        return DEFAULT_INITIAL_REPLICATION_SYNC_TIMEOUT;
    }

    @Deprecated
    public static long getDefaultFailbackDelay() {
        return 5000L;
    }

    public static boolean isDefaultFailoverOnServerShutdown() {
        return DEFAULT_FAILOVER_ON_SERVER_SHUTDOWN;
    }

    public static boolean isDefaultWaitForActivation() {
        return DEFAULT_WAIT_FOR_ACTIVATION;
    }

    public static boolean isDefaultPopulateValidatedUser() {
        return DEFAULT_POPULATE_VALIDATED_USER;
    }

    public static boolean isDefaultRejectEmptyValidatedUser() {
        return DEFAULT_REJECT_EMPTY_VALIDATED_USER;
    }

    public static boolean isDefaultScaleDownEnabled() {
        return DEFAULT_SCALE_DOWN_ENABLED;
    }

    public static int getDefaultGroupingHandlerTimeout() {
        return DEFAULT_GROUPING_HANDLER_TIMEOUT;
    }

    public static int getDefaultGroupingHandlerGroupTimeout() {
        return DEFAULT_GROUPING_HANDLER_GROUP_TIMEOUT;
    }

    public static long getDefaultGroupingHandlerReaperPeriod() {
        return DEFAULT_GROUPING_HANDLER_REAPER_PERIOD;
    }

    public static String getDefaultStoreType() {
        return DEFAULT_STORE_TYPE;
    }

    public static String getDefaultDatabaseUrl() {
        return DEFAULT_DATABASE_URL;
    }

    public static String getDefaultMessageTableName() {
        return DEFAULT_MESSAGE_TABLE_NAME;
    }

    public static String getDefaultBindingsTableName() {
        return DEFAULT_BINDINGS_TABLE_NAME;
    }

    public static String getDefaultDriverClassName() {
        return DEFAULT_JDBC_DRIVER_CLASS_NAME;
    }

    public static String getDefaultDataSourceClassName() {
        return DEFAULT_JDBC_DATA_SOURCE_CLASS_NAME;
    }

    public static String getDefaultLargeMessagesTableName() {
        return DEFAULT_LARGE_MESSAGES_TABLE_NAME;
    }

    public static String getDefaultPageStoreTableName() {
        return DEFAULT_PAGE_STORE_TABLE_NAME;
    }

    public static String getDefaultNodeManagerStoreTableName() {
        return DEFAULT_NODE_MANAGER_STORE_TABLE_NAME;
    }

    public static int getDefaultJdbcNetworkTimeout() {
        return DEFAULT_JDBC_NETWORK_TIMEOUT;
    }

    public static long getDefaultJdbcLockRenewPeriodMillis() {
        return DEFAULT_JDBC_LOCK_RENEW_PERIOD_MILLIS;
    }

    public static long getDefaultJdbcJournalSyncPeriodMillis() {
        return 5L;
    }

    public static long getDefaultJdbcLockExpirationMillis() {
        return DEFAULT_JDBC_LOCK_EXPIRATION_MILLIS;
    }

    public static long getDefaultJdbcLockAcquisitionTimeoutMillis() {
        return -1L;
    }

    public static long getDefaultConnectionTtlCheckInterval() {
        return 2000L;
    }

    public static long getDefaultConfigurationFileRefreshPeriod() {
        return 5000L;
    }

    public static boolean getDefaultAmqpUseCoreSubscriptionNaming() {
        return false;
    }

    public static long getDefaultMaxGlobalSize() {
        return DEFAULT_GLOBAL_MAX_SIZE;
    }

    public static long getDefaultMaxGlobalMessages() {
        return -1L;
    }

    public static int getDefaultMaxDiskUsage() {
        return DEFAULT_MAX_DISK_USAGE;
    }

    public static int getDefaultDiskScanPeriod() {
        return 5000;
    }

    public static int getDefaultMaxQueueConsumers() {
        return -1;
    }

    public static int getDefaultConsumerPriority() {
        return 0;
    }

    public static boolean getDefaultExclusive() {
        return false;
    }

    public static boolean getDefaultLastValue() {
        return false;
    }

    public static SimpleString getDefaultLastValueKey() {
        return DEFAULT_LAST_VALUE_KEY;
    }

    public static boolean getDefaultNonDestructive() {
        return false;
    }

    public static boolean getDefaultPurgeOnNoConsumers() {
        return false;
    }

    public static boolean getDefaultEnabled() {
        return true;
    }

    public static boolean getDefaultQueueAutoDelete(boolean autoCreated) {
        return autoCreated ? ActiveMQDefaultConfiguration.getDefaultQueueAutoDelete() : ActiveMQDefaultConfiguration.getDefaultCreatedQueueAutoDelete();
    }

    public static boolean getDefaultQueueAutoDelete() {
        return true;
    }

    public static boolean getDefaultCreatedQueueAutoDelete() {
        return false;
    }

    public static long getDefaultQueueAutoDeleteDelay() {
        return 0L;
    }

    public static long getDefaultQueueAutoDeleteMessageCount() {
        return 0L;
    }

    public static long getDefaultRingSize() {
        return -1L;
    }

    public static long getDefaultRetroactiveMessageCount() {
        return 0L;
    }

    public static int getDefaultConsumersBeforeDispatch() {
        return 0;
    }

    public static long getDefaultDelayBeforeDispatch() {
        return -1L;
    }

    public static int getDefaultGroupBuckets() {
        return -1;
    }

    public static boolean getDefaultGroupRebalance() {
        return false;
    }

    public static boolean getDefaultGroupRebalancePauseDispatch() {
        return false;
    }

    public static SimpleString getDefaultGroupFirstKey() {
        return DEFAULT_GROUP_FIRST_KEY;
    }

    public static String getInternalNamingPrefix() {
        return DEFAULT_INTERNAL_NAMING_PREFIX;
    }

    public static RoutingType getDefaultRoutingType() {
        return DEFAULT_ROUTING_TYPE;
    }

    public static String getDefaultSystemPropertyPrefix() {
        return DEFAULT_SYSTEM_PROPERTY_PREFIX;
    }

    public static String getDefaultBrokerPropertiesKeySurround() {
        return BROKER_PROPERTIES_KEY_SURROUND;
    }

    public static String getDefaultNetworkCheckList() {
        return DEFAULT_NETWORK_CHECK_LIST;
    }

    public static String getDefaultNetworkCheckURLList() {
        return DEFAULT_NETWORK_CHECK_URL_LIST;
    }

    public static long getDefaultNetworkCheckPeriod() {
        return DEFAULT_NETWORK_CHECK_PERIOD;
    }

    public static int getDefaultNetworkCheckTimeout() {
        return DEFAULT_NETWORK_CHECK_TIMEOUT;
    }

    public static String getDefaultNetworkCheckNic() {
        return DEFAULT_NETWORK_CHECK_NIC;
    }

    public static boolean getDefaultVoteOnReplicationFailure() {
        return DEFAULT_VOTE_ON_REPLICATION_FAILURE;
    }

    public static int getDefaultQuorumSize() {
        return DEFAULT_QUORUM_SIZE;
    }

    public static boolean getCriticalAnalyzer() {
        return true;
    }

    public static long getCriticalAnalyzerTimeout() {
        return 120000L;
    }

    public static long getCriticalAnalyzerCheckPeriod(long timeout) {
        return timeout / 2L;
    }

    public static CriticalAnalyzerPolicy getCriticalAnalyzerPolicy() {
        return DEFAULT_ANALYZE_CRITICAL_POLICY;
    }

    public static int getDefaultVoteRetries() {
        return DEFAULT_VOTE_RETRIES;
    }

    public static long getDefaultVoteRetryWait() {
        return DEFAULT_VOTE_RETRY_WAIT;
    }

    public static int getDefaultQuorumVoteWait() {
        return DEFAULT_QUORUM_VOTE_WAIT;
    }

    public static long getDefaultRetryReplicationWait() {
        return DEFAULT_RETRY_REPLICATION_WAIT;
    }

    public static long getDefaultFederationFailureCheckPeriod() {
        return DEFAULT_FEDERATION_FAILURE_CHECK_PERIOD;
    }

    public static long getDefaultFederationConnectionTtl() {
        return DEFAULT_FEDERATION_CONNECTION_TTL;
    }

    public static long getDefaultFederationCallTimeout() {
        return DEFAULT_FEDERATION_CALL_TIMEOUT;
    }

    public static long getDefaultFederationRetryInterval() {
        return DEFAULT_FEDERATION_RETRY_INTERVAL;
    }

    public static double getDefaultFederationRetryIntervalMultiplier() {
        return DEFAULT_FEDERATION_RETRY_INTERVAL_MULTIPLIER;
    }

    public static long getDefaultFederationMaxRetryInterval() {
        return DEFAULT_FEDERATION_MAX_RETRY_INTERVAL;
    }

    public static int getDefaultFederationInitialConnectAttempts() {
        return DEFAULT_FEDERATION_INITIAL_CONNECT_ATTEMPTS;
    }

    public static int getDefaultFederationReconnectAttempts() {
        return DEFAULT_FEDERATION_RECONNECT_ATTEMPTS;
    }

    public static long getDefaultFederationCallFailoverTimeout() {
        return DEFAULT_FEDERATION_CALL_FAILOVER_TIMEOUT;
    }

    public static boolean getDefaultJvmMemoryMetrics() {
        return true;
    }

    public static boolean getDefaultJvmGcMetrics() {
        return false;
    }

    public static boolean getDefaultJvmThreadMetrics() {
        return false;
    }

    public static String getDefaultTemporaryQueueNamespace() {
        return DEFAULT_TEMPORARY_QUEUE_NAMESPACE;
    }

    public static String getDefaultDistributedPrimitiveManagerClassName() {
        return DEFAULT_DISTRIBUTED_PRIMITIVE_MANAGER_CLASS_NAME;
    }

    public static int getDefaultBridgeConcurrency() {
        return DEFAULT_BRIDGE_CONCURRENCY;
    }

    public static Boolean getDefaultNettyPoolMetrics() {
        return false;
    }

    public static long getMqttSessionScanInterval() {
        return DEFAULT_MQTT_SESSION_SCAN_INTERVAL;
    }

    public static boolean getDefaultSuppressSessionNotifications() {
        return DEFAULT_SUPPRESS_SESSION_NOTIFICATIONS;
    }

    static {
        int maxDisk;
        logger = Logger.getLogger(ActiveMQDefaultConfiguration.class);
        DEFAULT_CLIENT_FAILURE_CHECK_PERIOD = 30000L;
        DEFAULT_FILE_DEPLOYER_SCAN_PERIOD = 5000L;
        DEFAULT_JOURNAL_MAX_IO_AIO = 4096;
        DEFAULT_JOURNAL_POOL_FILES = -1;
        DEFAULT_JOURNAL_BUFFER_TIMEOUT_AIO = 500000;
        DEFAULT_JOURNAL_BUFFER_SIZE_AIO = 501760;
        DEFAULT_JOURNAL_MAX_IO_NIO = 1;
        DEFAULT_JOURNAL_BUFFER_TIMEOUT_NIO = 3333333;
        DEFAULT_JOURNAL_BUFFER_SIZE_NIO = 501760;
        PROP_MASK_PASSWORD = "activemq.usemaskedpassword";
        PROP_PASSWORD_CODEC = "activemq.passwordcodec";
        DEFAULT_HAPOLICY_TYPE = "NONE";
        DEFAULT_HAPOLICY_BACKUP_STRATEGY = "FULL";
        DEFAULT_RESOLVE_PROTOCOLS = true;
        DEFAULT_FILE_DEPLOYMENT_ENABLED = false;
        DEFAULT_PERSISTENCE_ENABLED = true;
        DEFAULT_JOURNAL_DATASYNC = true;
        DEFAULT_SCHEDULED_THREAD_POOL_MAX_SIZE = 5;
        DEFAULT_THREAD_POOL_MAX_SIZE = 30;
        DEFAULT_SECURITY_ENABLED = true;
        DEFAULT_GRACEFUL_SHUTDOWN_ENABLED = false;
        DEFAULT_GRACEFUL_SHUTDOWN_TIMEOUT = -1L;
        DEFAULT_SECURITY_INVALIDATION_INTERVAL = 10000L;
        DEFAULT_AUTHENTICATION_CACHE_SIZE = 1000L;
        DEFAULT_AUTHORIZATION_CACHE_SIZE = 1000L;
        DEFAULT_JOURNAL_LOCK_ACQUISITION_TIMEOUT = -1L;
        DEFAULT_WILDCARD_ROUTING_ENABLED = true;
        DEFAULT_ADDRESS_PATH_SEPARATOR = ".";
        DEFAULT_MANAGEMENT_ADDRESS = new SimpleString("activemq.management");
        DEFAULT_MANAGEMENT_NOTIFICATION_ADDRESS = new SimpleString("activemq.notifications");
        DEFAULT_CLUSTER_ADDRESS = DEFAULT_TEMPORARY_QUEUE_NAMESPACE;
        DEFAULT_CLUSTER_USER = "ACTIVEMQ.CLUSTER.ADMIN.USER";
        DEFAULT_CLUSTER_PASSWORD = "CHANGE ME!!";
        DEFAULT_FEDERATION_USER = "ACTIVEMQ.CLUSTER.ADMIN.USER";
        DEFAULT_FEDERATION_PASSWORD = "CHANGE ME!!";
        DEFAULT_MASK_PASSWORD = null;
        DEFAULT_JMX_MANAGEMENT_ENABLED = true;
        DEFAULT_JMX_DOMAIN = "org.apache.activemq.artemis";
        DEFAULT_JMX_IS_USE_BROKER_NAME = true;
        DEFAULT_MESSAGE_COUNTER_ENABLED = false;
        DEFAULT_MESSAGE_COUNTER_SAMPLE_PERIOD = 10000L;
        DEFAULT_MESSAGE_COUNTER_MAX_DAY_HISTORY = 10;
        DEFAULT_CONNECTION_TTL_OVERRIDE = -1L;
        DEFAULT_ASYNC_CONNECTION_EXECUTION_ENABLED = true;
        DEFAULT_TRANSACTION_TIMEOUT = 300000L;
        DEFAULT_TRANSACTION_TIMEOUT_SCAN_PERIOD = 1000L;
        DEFAULT_MESSAGE_EXPIRY_SCAN_PERIOD = 30000L;
        DEFAULT_ADDRESS_QUEUE_SCAN_PERIOD = 30000L;
        DEFAULT_MESSAGE_EXPIRY_THREAD_PRIORITY = 3;
        DEFAULT_ID_CACHE_SIZE = 20000;
        DEFAULT_PERSIST_ID_CACHE = true;
        DEFAULT_PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY = false;
        DEFAULT_PAGING_DIR = "data/paging";
        DEFAULT_BINDINGS_DIRECTORY = "data/bindings";
        DEFAULT_CREATE_BINDINGS_DIR = true;
        DEFAULT_MAX_CONCURRENT_PAGE_IO = 5;
        DEFAULT_READ_WHOLE_PAGE = false;
        DEFAULT_JOURNAL_DIR = "data/journal";
        DEFAULT_DATA_DIR = "data";
        DEFAULT_CREATE_JOURNAL_DIR = true;
        DEFAULT_JOURNAL_SYNC_TRANSACTIONAL = true;
        DEFAULT_JOURNAL_SYNC_NON_TRANSACTIONAL = true;
        DEFAULT_JOURNAL_LOG_WRITE_RATE = false;
        DEFAULT_JOURNAL_FILE_SIZE = 0xA00000;
        DEFAULT_JOURNAL_MIN_FILES = 2;
        DEFAULT_JOURNAL_COMPACT_PERCENTAGE = 30;
        DEFAULT_JOURNAL_FILE_OPEN_TIMEOUT = 5;
        DEFAULT_JOURNAL_COMPACT_MIN_FILES = 10;
        DEFAULT_JOURNAL_MAX_ATTIC_FILES = 10;
        DEFAULT_SERVER_DUMP_INTERVAL = -1L;
        DEFAULT_MEMORY_WARNING_THRESHOLD = 25;
        DEFAULT_MEMORY_MEASURE_INTERVAL = -1L;
        DEFAULT_LARGE_MESSAGES_DIR = "data/largemessages";
        DEFAULT_BROADCAST_PERIOD = 2000L;
        DEFAULT_BROADCAST_REFRESH_TIMEOUT = 10000;
        DEFAULT_CONNECTION_TTL = 60000L;
        DEFAULT_RETRY_INTERVAL_MULTIPLIER = 1.0;
        DEFAULT_MAX_RETRY_INTERVAL = 2000L;
        DEFAULT_BRIDGE_INITIAL_CONNECT_ATTEMPTS = -1;
        DEFAULT_BRIDGE_RECONNECT_ATTEMPTS = -1;
        DEFAULT_BRIDGE_DUPLICATE_DETECTION = true;
        DEFAULT_BRIDGE_CONFIRMATION_WINDOW_SIZE = 0xA00000;
        DEFAULT_BRIDGE_PRODUCER_WINDOW_SIZE = 0x100000;
        DEFAULT_BRIDGE_CONNECT_SAME_NODE = 10;
        DEFAULT_CLUSTER_FAILURE_CHECK_PERIOD = 30000L;
        DEFAULT_CLUSTER_CONNECTION_TTL = 60000L;
        DEFAULT_CLUSTER_CALL_TIMEOUT = 30000L;
        DEFAULT_CLUSTER_RETRY_INTERVAL = 500L;
        DEFAULT_CLUSTER_RETRY_INTERVAL_MULTIPLIER = 1.0;
        DEFAULT_CLUSTER_MAX_RETRY_INTERVAL = 2000L;
        DEFAULT_CLUSTER_INITIAL_CONNECT_ATTEMPTS = -1;
        DEFAULT_CLUSTER_RECONNECT_ATTEMPTS = -1;
        DEFAULT_CLUSTER_DUPLICATE_DETECTION = true;
        DEFAULT_CLUSTER_FORWARD_WHEN_NO_CONSUMERS = false;
        DEFAULT_CLUSTER_MESSAGE_LOAD_BALANCING_TYPE = "ON_DEMAND";
        DEFAULT_CLUSTER_MAX_HOPS = 1;
        DEFAULT_CLUSTER_CONFIRMATION_WINDOW_SIZE = 0xA00000;
        DEFAULT_CLUSTER_CALL_FAILOVER_TIMEOUT = -1L;
        DEFAULT_CLUSTER_NOTIFICATION_INTERVAL = 1000L;
        DEFAULT_CLUSTER_NOTIFICATION_ATTEMPTS = 2;
        DEFAULT_DIVERT_EXCLUSIVE = false;
        DEFAULT_DIVERT_ROUTING_TYPE = ComponentConfigurationRoutingType.STRIP.toString();
        DEFAULT_BRIDGE_ROUTING_TYPE = ComponentConfigurationRoutingType.PASS.toString();
        DEFAULT_HAPOLICY_REQUEST_BACKUP = false;
        DEFAULT_HAPOLICY_BACKUP_REQUEST_RETRIES = -1;
        DEFAULT_HAPOLICY_BACKUP_REQUEST_RETRY_INTERVAL = 5000L;
        DEFAULT_HAPOLICY_MAX_BACKUPS = 1;
        DEFAULT_HAPOLICY_BACKUP_PORT_OFFSET = 100;
        DEFAULT_CHECK_FOR_LIVE_SERVER = false;
        DEFAULT_MAX_SAVED_REPLICATED_JOURNALS_SIZE = 2;
        DEFAULT_RESTART_BACKUP = true;
        DEFAULT_ALLOW_AUTO_FAILBACK = true;
        DEFAULT_INITIAL_REPLICATION_SYNC_TIMEOUT = 30000L;
        DEFAULT_FAILOVER_ON_SERVER_SHUTDOWN = false;
        DEFAULT_WAIT_FOR_ACTIVATION = true;
        DEFAULT_POPULATE_VALIDATED_USER = false;
        DEFAULT_REJECT_EMPTY_VALIDATED_USER = false;
        DEFAULT_SCALE_DOWN_ENABLED = true;
        DEFAULT_GROUPING_HANDLER_TIMEOUT = 5000;
        DEFAULT_GROUPING_HANDLER_GROUP_TIMEOUT = -1;
        DEFAULT_GROUPING_HANDLER_REAPER_PERIOD = 30000L;
        DEFAULT_STORE_TYPE = "FILE";
        DEFAULT_DATABASE_URL = null;
        DEFAULT_JDBC_DRIVER_CLASS_NAME = "org.apache.derby.jdbc.EmbeddedDriver";
        DEFAULT_JDBC_DATA_SOURCE_CLASS_NAME = "org.apache.commons.dbcp2.BasicDataSource";
        DEFAULT_MESSAGE_TABLE_NAME = "MESSAGES";
        DEFAULT_BINDINGS_TABLE_NAME = "BINDINGS";
        DEFAULT_JDBC_NETWORK_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(20L);
        DEFAULT_JDBC_LOCK_RENEW_PERIOD_MILLIS = TimeUnit.SECONDS.toMillis(4L);
        DEFAULT_JDBC_LOCK_EXPIRATION_MILLIS = TimeUnit.SECONDS.toMillis(20L);
        DEFAULT_GLOBAL_MAX_SIZE = Runtime.getRuntime().maxMemory() / 2L;
        try {
            maxDisk = Integer.parseInt(System.getProperty(ActiveMQDefaultConfiguration.getDefaultSystemPropertyPrefix() + "maxDiskUsage", "90"));
        }
        catch (Throwable e) {
            logger.warn((Object)e);
            maxDisk = 90;
        }
        DEFAULT_MAX_DISK_USAGE = maxDisk;
        DEFAULT_LAST_VALUE_KEY = null;
        DEFAULT_GROUP_FIRST_KEY = null;
        DEFAULT_ROUTING_TYPE = RoutingType.MULTICAST;
        DEFAULT_NETWORK_CHECK_LIST = null;
        DEFAULT_NETWORK_CHECK_URL_LIST = null;
        DEFAULT_NETWORK_CHECK_PERIOD = 5000L;
        DEFAULT_NETWORK_CHECK_TIMEOUT = 1000;
        DEFAULT_NETWORK_CHECK_NIC = null;
        DEFAULT_VOTE_ON_REPLICATION_FAILURE = false;
        DEFAULT_VOTE_RETRIES = 12;
        DEFAULT_VOTE_RETRY_WAIT = 5000L;
        DEFAULT_QUORUM_VOTE_WAIT = 30;
        DEFAULT_RETRY_REPLICATION_WAIT = 2000L;
        DEFAULT_QUORUM_SIZE = -1;
        DEFAULT_ANALYZE_CRITICAL_POLICY = CriticalAnalyzerPolicy.LOG;
        DEFAULT_FEDERATION_FAILURE_CHECK_PERIOD = 30000L;
        DEFAULT_FEDERATION_CONNECTION_TTL = ActiveMQDefaultConfiguration.getDefaultConnectionTtl();
        DEFAULT_FEDERATION_CALL_TIMEOUT = 30000L;
        DEFAULT_FEDERATION_RETRY_INTERVAL = 500L;
        DEFAULT_FEDERATION_RETRY_INTERVAL_MULTIPLIER = ActiveMQDefaultConfiguration.getDefaultRetryIntervalMultiplier();
        DEFAULT_FEDERATION_MAX_RETRY_INTERVAL = ActiveMQDefaultConfiguration.getDefaultMaxRetryInterval();
        DEFAULT_FEDERATION_INITIAL_CONNECT_ATTEMPTS = -1;
        DEFAULT_FEDERATION_RECONNECT_ATTEMPTS = -1;
        DEFAULT_FEDERATION_CALL_FAILOVER_TIMEOUT = -1L;
        DEFAULT_BRIDGE_CONCURRENCY = 1;
        DEFAULT_MQTT_SESSION_SCAN_INTERVAL = 500L;
        DEFAULT_SUPPRESS_SESSION_NOTIFICATIONS = false;
    }
}

