/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.io.InterruptedIOException;
import java.util.List;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.BytesMessage;
import org.apache.activemq.artemis.shaded.org.jgroups.Event;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.PhysicalAddress;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.Discovery;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.PingData;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.PingHeader;
import org.apache.activemq.artemis.shaded.org.jgroups.util.NameCache;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Responses;

public class PING
extends Discovery {
    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public void findMembers(List<Address> members, boolean initial_discovery, Responses responses) {
        try {
            this.sendDiscoveryRequest(this.cluster_name, members, initial_discovery);
        }
        catch (InterruptedIOException | InterruptedException exception) {
        }
        catch (Throwable ex) {
            this.log.error(String.format("%s: failed sending discovery request", this.local_addr), ex);
        }
    }

    protected void sendDiscoveryRequest(String cluster_name, List<Address> members_to_find, boolean initial_discovery) throws Exception {
        PhysicalAddress physical_addr = (PhysicalAddress)this.down(new Event(87, this.local_addr));
        PingData data = new PingData(this.local_addr, false, NameCache.get(this.local_addr), physical_addr);
        if (members_to_find != null && members_to_find.size() <= this.max_members_in_discovery_request) {
            data.mbrs(members_to_find);
        }
        PingHeader hdr = new PingHeader(1).clusterName(cluster_name).initialDiscovery(initial_discovery);
        Message msg = new BytesMessage(null).putHeader(this.getId(), hdr).setFlag(Message.Flag.DONT_BUNDLE, Message.Flag.OOB).setFlag(Message.TransientFlag.DONT_LOOPBACK);
        if (data != null) {
            msg.setArray(PING.marshal(data));
        }
        this.sendMcastDiscoveryRequest(msg);
    }

    protected void sendMcastDiscoveryRequest(Message msg) {
        this.down_prot.down(msg);
    }
}

