/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.demos;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.activemq.artemis.shaded.org.jgroups.JChannel;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.Receiver;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.LogFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.Discovery;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.FD_ALL3;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.FD_SOCK;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.FRAG2;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.MERGE3;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.MFC;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.MPING;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.TCP;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.TCPPING;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.TP;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.UFC;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.UNICAST3;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.VERIFY_SUSPECT;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.pbcast.GMS;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.pbcast.NAKACK2;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.pbcast.STABLE;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Configurator;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.DiagnosticsHandler;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.NonReflectiveProbeHandler;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.ProtocolStack;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class ProgrammaticChat {
    protected static final JChannel ch;
    protected static final NonReflectiveProbeHandler h;

    public static void main(String[] args) throws Exception {
        String name = null;
        String bind_addr = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-name".equals(args[i])) {
                name = args[++i];
                continue;
            }
            if ("-bind_addr".equals(args[i])) {
                bind_addr = args[++i];
                continue;
            }
            System.out.printf("%s [-h] [-name name] [-bind_addr addr]\n", ProgrammaticChat.class.getSimpleName());
            return;
        }
        ch.name(name);
        InetAddress ba = bind_addr == null ? Util.getAddress("site_local", Util.getIpStackType()) : InetAddress.getByName(bind_addr);
        InetAddress diag_addr = Util.getAddress("224.0.75.75", Util.getIpStackType());
        InetAddress mping_mcast = Util.getAddress("230.5.6.7", Util.getIpStackType());
        ProtocolStack stack = ch.getProtocolStack();
        Object transport = stack.getTransport().setBindAddress(ba);
        ((TP)transport).getDiagnosticsHandler().setMcastAddress(diag_addr);
        Discovery discovery = (Discovery)stack.findProtocol((Class<? extends Protocol>)TCPPING.class);
        if (discovery != null) {
            ((TCPPING)discovery).initialHosts(Collections.singletonList(new InetSocketAddress(ba, 7800)));
        }
        if ((discovery = (Discovery)stack.findProtocol((Class<? extends Protocol>)MPING.class)) != null) {
            ((MPING)discovery).setMcastAddr(mping_mcast);
        }
        ch.connect("ChatCluster");
        DiagnosticsHandler diag_handler = ((TP)transport).getDiagnosticsHandler();
        if (diag_handler != null) {
            Set<DiagnosticsHandler.ProbeHandler> probe_handlers = diag_handler.getProbeHandlers();
            probe_handlers.removeIf(probe_handler -> {
                String[] keys = probe_handler.supportedKeys();
                return keys != null && Stream.of(keys).anyMatch(s -> s.startsWith("jmx"));
            });
        }
        ((TP)transport).registerProbeHandler(h);
        while (true) {
            String line = Util.readStringFromStdin(": ");
            ch.send(null, line);
        }
    }

    static {
        try {
            LogFactory.useJdkLogger(true);
            Configurator.skipSettingDefaultValues(true);
            TCP tcp = (TCP)new TCP().setBindPort(7800);
            Protocol[] prot_stack = new Protocol[]{tcp, new TCPPING(), new MPING(), new MERGE3(), new FD_SOCK(), new FD_ALL3(), new VERIFY_SUSPECT(), new NAKACK2(), new UNICAST3(), new STABLE(), new GMS().setJoinTimeout(1000L), new UFC(), new MFC(), new FRAG2()};
            ch = new JChannel(prot_stack);
            ch.getProtocolStack().getTransport().getDiagnosticsHandler().enableTcp(true).enableUdp(false);
            Configurator.skipSettingDefaultValues(false);
            h = new NonReflectiveProbeHandler(ch).initialize(ch.getProtocolStack().getProtocols());
            ch.setReceiver(new Receiver(){

                @Override
                public void viewAccepted(View new_view) {
                    System.out.println("view: " + new_view);
                }

                @Override
                public void receive(Message msg) {
                    System.out.println("<< " + msg.getObject() + " [" + msg.getSrc() + "]");
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

