/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import com.google.common.base.CaseFormat;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.mqtt.MqttConnAckVariableHeader;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectPayload;
import io.netty.handler.codec.mqtt.MqttConnectVariableHeader;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttPubReplyMessageVariableHeader;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttReasonCodeAndPropertiesVariableHeader;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTLogger;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSession;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSessionState;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.jboss.logging.Logger;

public class MQTTUtil {
    private static final Logger logger = Logger.getLogger(MQTTUtil.class);
    public static final boolean DURABLE_MESSAGES = true;
    public static final boolean SESSION_AUTO_COMMIT_SENDS = true;
    public static final boolean SESSION_AUTO_COMMIT_ACKS = true;
    public static final boolean SESSION_PREACKNOWLEDGE = false;
    public static final boolean SESSION_XA = false;
    public static final boolean SESSION_AUTO_CREATE_QUEUE = false;
    public static final String MQTT_RETAIN_ADDRESS_PREFIX = "$sys.mqtt.retain.";
    public static final SimpleString MQTT_QOS_LEVEL_KEY = SimpleString.toSimpleString((String)"mqtt.qos.level");
    public static final SimpleString MQTT_MESSAGE_ID_KEY = SimpleString.toSimpleString((String)"mqtt.message.id");
    public static final SimpleString MQTT_MESSAGE_TYPE_KEY = SimpleString.toSimpleString((String)"mqtt.message.type");
    public static final SimpleString MQTT_MESSAGE_RETAIN_KEY = SimpleString.toSimpleString((String)"mqtt.message.retain");
    public static final SimpleString MQTT_PAYLOAD_FORMAT_INDICATOR_KEY = SimpleString.toSimpleString((String)"mqtt.payload.format.indicator");
    public static final SimpleString MQTT_RESPONSE_TOPIC_KEY = SimpleString.toSimpleString((String)"mqtt.response.topic");
    public static final SimpleString MQTT_CORRELATION_DATA_KEY = SimpleString.toSimpleString((String)"mqtt.correlation.data");
    public static final String MQTT_USER_PROPERTY_EXISTS_KEY = "mqtt.user.property.exists";
    public static final String MQTT_USER_PROPERTY_KEY_PREFIX = "mqtt.ordered.user.property.";
    public static final SimpleString MQTT_USER_PROPERTY_KEY_PREFIX_SIMPLE = SimpleString.toSimpleString((String)"mqtt.ordered.user.property.");
    public static final SimpleString MQTT_CONTENT_TYPE_KEY = SimpleString.toSimpleString((String)"mqtt.content.type");
    public static final String MANAGEMENT_QUEUE_PREFIX = "$sys.mqtt.queue.qos2.";
    public static final String SHARED_SUBSCRIPTION_PREFIX = "$share/";
    public static final long FOUR_BYTE_INT_MAX = Long.decode("0xFFFFFFFF");
    public static final int TWO_BYTE_INT_MAX;
    public static final int VARIABLE_BYTE_INT_MAX = 0xFFFFFFF;
    public static final int MAX_PACKET_SIZE = 0xFFFFFFF;
    public static final long KEEP_ALIVE_ADJUSTMENT = 1500L;
    public static final int DEFAULT_SERVER_KEEP_ALIVE = 60;
    public static final int DEFAULT_TOPIC_ALIAS_MAX;
    public static final int DEFAULT_RECEIVE_MAXIMUM;
    public static final int DEFAULT_MAXIMUM_PACKET_SIZE = 0xFFFFFFF;
    public static final WildcardConfiguration MQTT_WILDCARD;

    public static String convertMqttTopicFilterToCoreAddress(String filter, WildcardConfiguration wildcardConfiguration) {
        return MQTTUtil.convertMqttTopicFilterToCoreAddress(null, filter, wildcardConfiguration);
    }

    public static String convertMqttTopicFilterToCoreAddress(String prefixToAdd, String filter, WildcardConfiguration wildcardConfiguration) {
        if (filter == null) {
            return "";
        }
        Object converted = MQTT_WILDCARD.convert(filter, wildcardConfiguration);
        if (prefixToAdd != null) {
            converted = prefixToAdd + (String)converted;
        }
        return converted;
    }

    public static String convertCoreAddressToMqttTopicFilter(String address, WildcardConfiguration wildcardConfiguration) {
        if (address == null) {
            return "";
        }
        if (address.startsWith(MQTT_RETAIN_ADDRESS_PREFIX)) {
            address = address.substring(MQTT_RETAIN_ADDRESS_PREFIX.length());
        }
        return wildcardConfiguration.convert(address, MQTT_WILDCARD);
    }

    private static ICoreMessage createServerMessage(MQTTSession session, SimpleString address, MqttPublishMessage mqttPublishMessage) {
        String contentType;
        List userProperties;
        byte[] correlationData;
        String responseTopic;
        long id = session.getServer().getStorageManager().generateID();
        CoreMessage message = new CoreMessage(id, mqttPublishMessage.fixedHeader().remainingLength(), session.getCoreMessageObjectPools());
        message.setAddress(address);
        message.putBooleanProperty(MQTT_MESSAGE_RETAIN_KEY, mqttPublishMessage.fixedHeader().isRetain());
        message.putIntProperty(MQTT_QOS_LEVEL_KEY, mqttPublishMessage.fixedHeader().qosLevel().value());
        message.setType((byte)4);
        message.putStringProperty(MessageUtil.CONNECTION_ID_PROPERTY_NAME, session.getState().getClientId());
        MqttProperties properties = mqttPublishMessage.variableHeader() == null ? null : mqttPublishMessage.variableHeader().properties();
        Integer payloadIndicatorFormat = MQTTUtil.getProperty(Integer.class, properties, MqttProperties.MqttPropertyType.PAYLOAD_FORMAT_INDICATOR);
        if (payloadIndicatorFormat != null) {
            message.putIntProperty(MQTT_PAYLOAD_FORMAT_INDICATOR_KEY, payloadIndicatorFormat.intValue());
        }
        if ((responseTopic = MQTTUtil.getProperty(String.class, properties, MqttProperties.MqttPropertyType.RESPONSE_TOPIC)) != null) {
            message.putStringProperty(MQTT_RESPONSE_TOPIC_KEY, responseTopic);
        }
        if ((correlationData = MQTTUtil.getProperty(byte[].class, properties, MqttProperties.MqttPropertyType.CORRELATION_DATA)) != null) {
            message.putBytesProperty(MQTT_CORRELATION_DATA_KEY, correlationData);
        }
        if ((userProperties = MQTTUtil.getProperty(List.class, properties, MqttProperties.MqttPropertyType.USER_PROPERTY)) != null && userProperties.size() != 0) {
            message.putIntProperty(MQTT_USER_PROPERTY_EXISTS_KEY, userProperties.size());
            for (int i = 0; i < userProperties.size(); ++i) {
                String key = MQTT_USER_PROPERTY_KEY_PREFIX + i + "." + ((MqttProperties.StringPair)userProperties.get((int)i)).key;
                message.putStringProperty(key, ((MqttProperties.StringPair)userProperties.get((int)i)).value);
            }
        }
        if ((contentType = MQTTUtil.getProperty(String.class, properties, MqttProperties.MqttPropertyType.CONTENT_TYPE)) != null) {
            message.putStringProperty(MQTT_CONTENT_TYPE_KEY, contentType);
        }
        long time = System.currentTimeMillis();
        message.setTimestamp(time);
        Integer messageExpiryInterval = MQTTUtil.getProperty(Integer.class, properties, MqttProperties.MqttPropertyType.PUBLICATION_EXPIRY_INTERVAL);
        if (messageExpiryInterval != null) {
            message.setExpiration(time + (long)(messageExpiryInterval * 1000));
        }
        return message;
    }

    public static Message createServerMessageFromByteBuf(MQTTSession session, String topic, MqttPublishMessage mqttPublishMessage) {
        String coreAddress = MQTTUtil.convertMqttTopicFilterToCoreAddress(topic, session.getWildcardConfiguration());
        SimpleString address = SimpleString.toSimpleString((String)coreAddress, (SimpleString.StringSimpleStringPool)session.getCoreMessageObjectPools().getAddressStringSimpleStringPool());
        ICoreMessage message = MQTTUtil.createServerMessage(session, address, mqttPublishMessage);
        ByteBuf payload = mqttPublishMessage.payload();
        message.getBodyBuffer().writeBytes(payload, 0, payload.readableBytes());
        return message;
    }

    public static Message createPubRelMessage(MQTTSession session, SimpleString address, int messageId) {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBREL, false, MqttQoS.AT_LEAST_ONCE, false, 0);
        MqttPublishMessage publishMessage = new MqttPublishMessage(fixedHeader, null, null);
        Message message = MQTTUtil.createServerMessage(session, address, publishMessage).putIntProperty(MQTT_MESSAGE_ID_KEY, messageId).putIntProperty(MQTT_MESSAGE_TYPE_KEY, MqttMessageType.PUBREL.value());
        return message;
    }

    public static void logMessage(MQTTSessionState state, MqttMessage message, boolean inbound) {
        if (logger.isTraceEnabled()) {
            StringBuilder log = new StringBuilder("MQTT(");
            if (state != null) {
                log.append(state.getClientId());
            }
            if (inbound) {
                log.append("): IN << ");
            } else {
                log.append("): OUT >> ");
            }
            if (message.fixedHeader() != null) {
                log.append(message.fixedHeader().messageType().toString());
                if (message.variableHeader() instanceof MqttMessageIdVariableHeader) {
                    log.append("(" + ((MqttMessageIdVariableHeader)message.variableHeader()).messageId() + ")");
                }
                switch (message.fixedHeader().messageType()) {
                    case PUBLISH: {
                        MqttPublishVariableHeader publishHeader = (MqttPublishVariableHeader)message.variableHeader();
                        String topicName = publishHeader.topicName();
                        if (topicName == null || topicName.length() == 0) {
                            topicName = "<empty>";
                        }
                        log.append("(" + publishHeader.packetId() + ")").append(" topic=" + topicName).append(", qos=" + message.fixedHeader().qosLevel().value()).append(", retain=" + message.fixedHeader().isRetain()).append(", dup=" + message.fixedHeader().isDup()).append(", remainingLength=" + message.fixedHeader().remainingLength());
                        for (MqttProperties.MqttProperty property : ((MqttPublishMessage)message).variableHeader().properties().listAll()) {
                            Object value = property.value();
                            if (value != null && value instanceof byte[]) {
                                value = new String((byte[])value, StandardCharsets.UTF_8);
                            }
                            log.append(", " + MQTTUtil.formatCase(MqttProperties.MqttPropertyType.valueOf((int)property.propertyId()).name()) + "=" + value);
                        }
                        log.append(", payload=" + MQTTUtil.getPayloadForLogging((MqttPublishMessage)message, 256));
                        break;
                    }
                    case CONNECT: {
                        MqttConnectVariableHeader connectHeader = (MqttConnectVariableHeader)message.variableHeader();
                        MqttConnectPayload payload = ((MqttConnectMessage)message).payload();
                        log.append(" protocol=(").append(connectHeader.name()).append(", ").append(connectHeader.version()).append(")").append(", hasPassword=").append(connectHeader.hasPassword()).append(", isCleanStart=").append(connectHeader.isCleanSession()).append(", keepAliveTimeSeconds=").append(connectHeader.keepAliveTimeSeconds()).append(", clientIdentifier=").append(payload.clientIdentifier()).append(", hasUserName=").append(connectHeader.hasUserName()).append(", isWillFlag=").append(connectHeader.isWillFlag());
                        if (connectHeader.isWillFlag()) {
                            log.append(", willQos=").append(connectHeader.willQos()).append(", isWillRetain=").append(connectHeader.isWillRetain()).append(", willTopic=").append(payload.willTopic());
                        }
                        for (MqttProperties.MqttProperty property : connectHeader.properties().listAll()) {
                            log.append(", " + MQTTUtil.formatCase(MqttProperties.MqttPropertyType.valueOf((int)property.propertyId()).name()) + "=" + property.value());
                        }
                        break;
                    }
                    case CONNACK: {
                        MqttConnAckVariableHeader connackHeader = (MqttConnAckVariableHeader)message.variableHeader();
                        log.append(" connectReasonCode=").append(MQTTUtil.formatByte(connackHeader.connectReturnCode().byteValue())).append(", sessionPresent=").append(connackHeader.isSessionPresent());
                        for (MqttProperties.MqttProperty property : connackHeader.properties().listAll()) {
                            log.append(", " + MQTTUtil.formatCase(MqttProperties.MqttPropertyType.valueOf((int)property.propertyId()).name()) + "=" + property.value());
                        }
                        break;
                    }
                    case SUBSCRIBE: {
                        for (MqttTopicSubscription sub : ((MqttSubscribeMessage)message).payload().topicSubscriptions()) {
                            log.append("\n\t" + sub.topicName() + " : " + sub.qualityOfService());
                        }
                        break;
                    }
                    case SUBACK: {
                        for (Integer qos : ((MqttSubAckMessage)message).payload().grantedQoSLevels()) {
                            log.append("\n\t" + qos);
                        }
                        break;
                    }
                    case UNSUBSCRIBE: {
                        for (String topic : ((MqttUnsubscribeMessage)message).payload().topics()) {
                            log.append("\n\t" + topic);
                        }
                        break;
                    }
                    case PUBACK: {
                        break;
                    }
                    case PUBREC: 
                    case PUBREL: 
                    case PUBCOMP: {
                        MqttPubReplyMessageVariableHeader pubReplyVariableHeader = (MqttPubReplyMessageVariableHeader)message.variableHeader();
                        log.append(" reasonCode=").append(MQTTUtil.formatByte(pubReplyVariableHeader.reasonCode()));
                        break;
                    }
                    case DISCONNECT: {
                        MqttReasonCodeAndPropertiesVariableHeader disconnectVariableHeader = (MqttReasonCodeAndPropertiesVariableHeader)message.variableHeader();
                        log.append(" reasonCode=").append(MQTTUtil.formatByte(disconnectVariableHeader.reasonCode()));
                    }
                }
                logger.trace((Object)log.toString());
            }
        }
    }

    private static String formatByte(byte bite) {
        return String.format("0x%02X ", bite);
    }

    private static String formatCase(String string) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, string);
    }

    private static String getPayloadForLogging(MqttPublishMessage message, int maxPayloadLogSize) {
        if (message.payload() == null) {
            return "<empty>";
        }
        String publishPayload = message.payload().toString(StandardCharsets.UTF_8);
        if (publishPayload.length() == 0) {
            return "<empty>";
        }
        return publishPayload.length() > maxPayloadLogSize ? publishPayload.substring(0, maxPayloadLogSize) : publishPayload;
    }

    public static int calculateRemainingLength(String topicName, MqttProperties properties, ByteBuf payload) {
        int size = 0;
        int PACKET_ID_SIZE = 2;
        size += 2;
        size += ByteBufUtil.utf8Bytes((CharSequence)topicName);
        size += MQTTUtil.calculatePublishPropertiesSize(properties);
        return size += payload.resetReaderIndex().readableBytes();
    }

    private static int calculatePublishPropertiesSize(MqttProperties properties) {
        int size = 0;
        block11: for (MqttProperties.MqttProperty property : properties.listAll()) {
            MqttProperties.MqttPropertyType propertyType = MqttProperties.MqttPropertyType.valueOf((int)property.propertyId());
            switch (propertyType) {
                case PAYLOAD_FORMAT_INDICATOR: {
                    size += MQTTUtil.calculateVariableByteIntegerSize(property.propertyId());
                    ++size;
                    break;
                }
                case TOPIC_ALIAS: {
                    size += MQTTUtil.calculateVariableByteIntegerSize(property.propertyId());
                    size += 2;
                    break;
                }
                case PUBLICATION_EXPIRY_INTERVAL: {
                    size += MQTTUtil.calculateVariableByteIntegerSize(property.propertyId());
                    size += 4;
                    break;
                }
                case SUBSCRIPTION_IDENTIFIER: {
                    size += MQTTUtil.calculateVariableByteIntegerSize(property.propertyId());
                    size += MQTTUtil.calculateVariableByteIntegerSize((Integer)((MqttProperties.IntegerProperty)property).value());
                    break;
                }
                case CONTENT_TYPE: 
                case RESPONSE_TOPIC: {
                    size += MQTTUtil.calculateVariableByteIntegerSize(property.propertyId());
                    size += ByteBufUtil.utf8Bytes((CharSequence)((CharSequence)((MqttProperties.StringProperty)property).value()));
                    break;
                }
                case USER_PROPERTY: {
                    for (MqttProperties.StringPair pair : (List)((MqttProperties.UserProperties)property).value()) {
                        size += MQTTUtil.calculateVariableByteIntegerSize(property.propertyId());
                        size += ByteBufUtil.utf8Bytes((CharSequence)pair.key);
                        size += ByteBufUtil.utf8Bytes((CharSequence)pair.value);
                    }
                    continue block11;
                }
                case CORRELATION_DATA: {
                    size += MQTTUtil.calculateVariableByteIntegerSize(property.propertyId());
                    size += 2;
                    size += ((byte[])((MqttProperties.BinaryProperty)property).value()).length;
                    break;
                }
                default: {
                    throw new EncoderException("Unknown property type: " + propertyType);
                }
            }
        }
        size += MQTTUtil.calculateVariableByteIntegerSize(size);
        return size;
    }

    public static int calculateMessageSize(MqttPublishMessage message) {
        return 1 + MQTTUtil.calculateVariableByteIntegerSize(message.fixedHeader().remainingLength()) + message.fixedHeader().remainingLength();
    }

    private static int calculateVariableByteIntegerSize(int vbi) {
        int count = 0;
        do {
            ++count;
        } while ((vbi /= 128) > 0);
        return count;
    }

    public static <T> T getProperty(Class<T> type, MqttProperties properties, MqttProperties.MqttPropertyType propertyName) {
        return MQTTUtil.getProperty(type, properties, propertyName, null);
    }

    public static <T> T getProperty(Class<T> type, MqttProperties properties, MqttProperties.MqttPropertyType propertyName, T defaultReturnValue) {
        MqttProperties.MqttProperty o;
        if (properties != null && (o = properties.getProperty(propertyName.value())) != null) {
            try {
                return type.cast(o.value());
            }
            catch (ClassCastException e) {
                MQTTLogger.LOGGER.failedToCastProperty(propertyName.toString());
                throw e;
            }
        }
        return defaultReturnValue == null ? null : (T)defaultReturnValue;
    }

    static {
        DEFAULT_TOPIC_ALIAS_MAX = TWO_BYTE_INT_MAX = Integer.decode("0xFFFF").intValue();
        DEFAULT_RECEIVE_MAXIMUM = TWO_BYTE_INT_MAX;
        MQTT_WILDCARD = new MQTTWildcardConfiguration();
    }

    public static class MQTTWildcardConfiguration
    extends WildcardConfiguration {
        public MQTTWildcardConfiguration() {
            this.setDelimiter('/');
            this.setSingleWord('+');
            this.setAnyWords('#');
        }
    }
}

