/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.critical;

import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.artemis.utils.critical.CriticalCloseable;
import org.apache.activemq.artemis.utils.critical.CriticalMeasure;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public class MultiThreadCriticalMeasureTest {
    private static final Logger logger = Logger.getLogger(MultiThreadCriticalMeasureTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiThread() throws Throwable {
        int THREADS = 100;
        AtomicInteger errors = new AtomicInteger(0);
        Thread[] threads = new Thread[THREADS];
        AtomicBoolean running = new AtomicBoolean(true);
        ReusableLatch latch = new ReusableLatch(0);
        ReusableLatch latchOnMeasure = new ReusableLatch(0);
        try {
            int i;
            CriticalMeasure measure = new CriticalMeasure(null, 0);
            CyclicBarrier barrier = new CyclicBarrier(THREADS + 1);
            Runnable runnable = () -> {
                try {
                    logger.debug((Object)("Thread " + Thread.currentThread().getName() + " waiting to Star"));
                    barrier.await();
                    logger.debug((Object)("Thread " + Thread.currentThread().getName() + " Started"));
                    while (running.get()) {
                        if (!latch.await(1L, TimeUnit.NANOSECONDS)) {
                            latch.await();
                        }
                        CriticalCloseable closeable = measure.measure();
                        try {
                            latchOnMeasure.await();
                        }
                        finally {
                            if (closeable == null) continue;
                            closeable.close();
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
            };
            for (i = 0; i < THREADS; ++i) {
                threads[i] = new Thread(runnable, "t=" + i);
                threads[i].start();
            }
            logger.debug((Object)"Going to release it now");
            barrier.await();
            for (i = 0; i < 50; ++i) {
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
                logger.debug((Object)("Count up " + i));
                latch.countUp();
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(20L));
                Assert.assertFalse((boolean)measure.checkExpiration(TimeUnit.MILLISECONDS.toNanos(10L), false));
                logger.debug((Object)"Count down");
                latch.countDown();
            }
            latchOnMeasure.countUp();
            Assert.assertTrue((boolean)Wait.waitFor(() -> measure.checkExpiration(TimeUnit.MILLISECONDS.toNanos(100L), false), 1000L, 1L));
        }
        finally {
            latch.countDown();
            latchOnMeasure.countDown();
            running.set(false);
            Assert.assertEquals((long)0L, (long)errors.get());
            for (Thread t : threads) {
                if (t == null) continue;
                t.join(100L);
                if (!t.isAlive()) continue;
                t.interrupt();
            }
        }
    }
}

