/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.critical;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzerImpl;
import org.apache.activemq.artemis.utils.critical.CriticalCloseable;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;
import org.apache.activemq.artemis.utils.critical.CriticalComponentImpl;
import org.apache.activemq.artemis.utils.critical.CriticalMeasure;
import org.junit.Assert;
import org.junit.Test;

public class CriticalMeasureTest {
    @Test
    public void testCriticalMeasure() throws Exception {
        CriticalMeasure measure = new CriticalMeasure(null, 1);
        long time = System.nanoTime();
        measure.timeEnter = time - TimeUnit.SECONDS.toNanos(5L);
        Assert.assertFalse((boolean)measure.checkExpiration(TimeUnit.SECONDS.toNanos(30L), false));
    }

    @Test
    public void testCriticalMeasureTakingLongButSucceeding() throws Exception {
        CriticalAnalyzerImpl analyzer = new CriticalAnalyzerImpl();
        CriticalComponentImpl component = new CriticalComponentImpl((CriticalAnalyzer)analyzer, 5);
        CriticalMeasure measure = new CriticalMeasure((CriticalComponent)component, 1);
        long time = System.nanoTime();
        measure.enterCritical();
        measure.timeEnter = time - TimeUnit.MINUTES.toNanos(30L);
        measure.leaveCritical();
        Assert.assertFalse((boolean)measure.checkExpiration(TimeUnit.SECONDS.toNanos(30L), false));
    }

    @Test
    public void testCriticalFailure() throws Exception {
        CriticalAnalyzerImpl analyzer = new CriticalAnalyzerImpl();
        CriticalComponentImpl component = new CriticalComponentImpl((CriticalAnalyzer)analyzer, 5);
        CriticalMeasure measure = new CriticalMeasure((CriticalComponent)component, 1);
        long time = System.nanoTime();
        CriticalCloseable closeable = measure.measure();
        measure.timeEnter = time - TimeUnit.MINUTES.toNanos(5L);
        Assert.assertTrue((boolean)measure.checkExpiration(TimeUnit.SECONDS.toNanos(30L), false));
        Assert.assertTrue((boolean)measure.checkExpiration(TimeUnit.SECONDS.toNanos(30L), true));
        Assert.assertFalse((boolean)measure.checkExpiration(TimeUnit.SECONDS.toNanos(30L), false));
        closeable.close();
    }

    @Test
    public void testWithCloseable() throws Exception {
        CriticalAnalyzerImpl analyzer = new CriticalAnalyzerImpl();
        CriticalComponentImpl component = new CriticalComponentImpl((CriticalAnalyzer)analyzer, 5);
        try (CriticalCloseable theMeasure = component.measureCritical(0);){
            LockSupport.parkNanos(1000L);
            Assert.assertTrue((boolean)component.checkExpiration(100L, false));
        }
        Assert.assertFalse((boolean)component.checkExpiration(100L, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRace() throws Exception {
        CriticalAnalyzerImpl analyzer = new CriticalAnalyzerImpl();
        CriticalComponentImpl component = new CriticalComponentImpl((CriticalAnalyzer)analyzer, 5);
        AtomicInteger errors = new AtomicInteger(0);
        AtomicBoolean running = new AtomicBoolean(true);
        Thread t = new Thread(() -> CriticalMeasureTest.lambda$testRace$0(running, (CriticalComponent)component, errors));
        t.start();
        try {
            long timeRunning = System.currentTimeMillis() + 100L;
            while (timeRunning > System.currentTimeMillis()) {
                CriticalCloseable theMeasure = component.measureCritical(0);
                try {
                    LockSupport.parkNanos(1L);
                }
                finally {
                    if (theMeasure == null) continue;
                    theMeasure.close();
                }
            }
        }
        finally {
            running.set(false);
        }
        t.join(1000L);
        Assert.assertFalse((boolean)t.isAlive());
        Assert.assertEquals((long)0L, (long)errors.get());
    }

    private static /* synthetic */ void lambda$testRace$0(AtomicBoolean running, CriticalComponent component, AtomicInteger errors) {
        long oneSecond = TimeUnit.SECONDS.toNanos(1L);
        while (running.get()) {
            if (!component.checkExpiration(oneSecond, false)) continue;
            errors.incrementAndGet();
        }
    }
}

