/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.critical;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.utils.ArtemisCloseable;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.ThreadLeakCheckRule;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzerImpl;
import org.apache.activemq.artemis.utils.critical.CriticalCloseable;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;
import org.apache.activemq.artemis.utils.critical.CriticalComponentImpl;
import org.apache.activemq.artemis.utils.critical.CriticalMeasure;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class CriticalAnalyzerTest {
    @Rule
    public ThreadLeakCheckRule rule = new ThreadLeakCheckRule();
    private CriticalAnalyzer analyzer;

    @After
    public void tearDown() throws Exception {
        if (this.analyzer != null) {
            this.analyzer.stop();
        }
    }

    @Test
    public void testDummy() {
        this.analyzer = new CriticalAnalyzerImpl().setTimeout(100L, TimeUnit.MILLISECONDS).setCheckTime(50L, TimeUnit.MILLISECONDS);
        CriticalComponentImpl component = new CriticalComponentImpl(this.analyzer, 2);
        this.analyzer.add((CriticalComponent)component);
        CriticalCloseable closeable1 = component.measureCritical(0);
        Assert.assertFalse((boolean)CriticalMeasure.isDummy((ArtemisCloseable)closeable1));
        CriticalCloseable closeable2 = component.measureCritical(0);
        Assert.assertTrue((boolean)CriticalMeasure.isDummy((ArtemisCloseable)closeable2));
        closeable1.close();
        closeable2 = component.measureCritical(0);
        Assert.assertFalse((boolean)CriticalMeasure.isDummy((ArtemisCloseable)closeable2));
    }

    @Test
    public void testCall() {
        this.analyzer = new CriticalAnalyzerImpl().setTimeout(100L, TimeUnit.MILLISECONDS).setCheckTime(50L, TimeUnit.MILLISECONDS);
        CriticalComponentImpl component = new CriticalComponentImpl(this.analyzer, 2);
        this.analyzer.add((CriticalComponent)component);
        CriticalCloseable closeable = component.measureCritical(0);
        Assert.assertFalse((boolean)CriticalMeasure.isDummy((ArtemisCloseable)closeable));
        CriticalCloseable dummy = component.measureCritical(0);
        boolean exception = false;
        try {
            dummy.beforeClose(() -> System.out.println("never hapening"));
        }
        catch (Throwable e) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
        AtomicInteger value = new AtomicInteger(0);
        closeable.beforeClose(() -> value.set(1000));
        Assert.assertEquals((long)0L, (long)value.get());
        closeable.close();
        Assert.assertEquals((long)1000L, (long)value.get());
    }

    @Test
    public void testAction() throws Exception {
        this.analyzer = new CriticalAnalyzerImpl().setTimeout(100L, TimeUnit.MILLISECONDS).setCheckTime(50L, TimeUnit.MILLISECONDS);
        this.analyzer.add(new CriticalComponent(){

            public CriticalAnalyzer getCriticalAnalyzer() {
                return null;
            }

            public CriticalCloseable measureCritical(int path) {
                return null;
            }

            public boolean checkExpiration(long timeout, boolean reset) {
                return true;
            }
        });
        CountDownLatch latch = new CountDownLatch(1);
        this.analyzer.start();
        this.analyzer.addAction(comp -> latch.countDown());
        Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        this.analyzer.stop();
    }

    @Test
    public void testActionOnImpl() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.analyzer = new CriticalAnalyzerImpl().setTimeout(10L, TimeUnit.MILLISECONDS).setCheckTime(5L, TimeUnit.MILLISECONDS);
        this.analyzer.addAction(comp -> latch.countDown());
        CriticalComponentImpl component = new CriticalComponentImpl(this.analyzer, 2);
        this.analyzer.add((CriticalComponent)component);
        component.measureCritical(0).close();
        component.measureCritical(1);
        this.analyzer.start();
        Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        this.analyzer.stop();
    }

    @Test
    public void testEnterNoLeaveNoExpire() throws Exception {
        this.analyzer = new CriticalAnalyzerImpl().setTimeout(10L, TimeUnit.MILLISECONDS).setCheckTime(5L, TimeUnit.MILLISECONDS);
        CriticalComponentImpl component = new CriticalComponentImpl(this.analyzer, 2);
        component.measureCritical(0);
        Assert.assertFalse((boolean)component.checkExpiration(TimeUnit.MINUTES.toNanos(1L), false));
        this.analyzer.stop();
    }

    @Test
    public void testEnterNoLeaveExpire() throws Exception {
        this.analyzer = new CriticalAnalyzerImpl().setTimeout(10L, TimeUnit.MILLISECONDS).setCheckTime(5L, TimeUnit.MILLISECONDS);
        CriticalComponentImpl component = new CriticalComponentImpl(this.analyzer, 2);
        component.measureCritical(0);
        Thread.sleep(50L);
        Assert.assertTrue((boolean)component.checkExpiration(0L, false));
        this.analyzer.stop();
    }

    @Test
    public void testNegative() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.analyzer = new CriticalAnalyzerImpl().setTimeout(10L, TimeUnit.MILLISECONDS).setCheckTime(5L, TimeUnit.MILLISECONDS);
        this.analyzer.addAction(comp -> latch.countDown());
        CriticalComponentImpl component = new CriticalComponentImpl(this.analyzer, 1);
        this.analyzer.add((CriticalComponent)component);
        component.measureCritical(0).close();
        this.analyzer.start();
        Assert.assertFalse((boolean)latch.await(100L, TimeUnit.MILLISECONDS));
        this.analyzer.stop();
    }

    @Test
    public void testPositive() throws Exception {
        ReusableLatch latch = new ReusableLatch(1);
        this.analyzer = new CriticalAnalyzerImpl().setTimeout(10L, TimeUnit.MILLISECONDS).setCheckTime(5L, TimeUnit.MILLISECONDS);
        this.analyzer.addAction(comp -> latch.countDown());
        CriticalComponentImpl component = new CriticalComponentImpl(this.analyzer, 1);
        this.analyzer.add((CriticalComponent)component);
        CriticalCloseable measure = component.measureCritical(0);
        Thread.sleep(50L);
        this.analyzer.start();
        Assert.assertTrue((boolean)latch.await(100L, TimeUnit.MILLISECONDS));
        measure.close();
        latch.setCount(1);
        Assert.assertFalse((boolean)latch.await(100L, TimeUnit.MILLISECONDS));
        this.analyzer.stop();
    }
}

