/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.collections;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.utils.collections.NoOpMap;
import org.junit.Assert;
import org.junit.Test;

public class NoOpMapTest {
    @Test
    public void testPut() {
        Map map = NoOpMap.instance();
        Assert.assertNull((Object)map.put("hello", "world"));
        Assert.assertNull((Object)map.put("hello", "world2"));
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testGet() {
        Map map = NoOpMap.instance();
        map.put("hello", "world");
        Assert.assertNull(map.get("hello"));
    }

    @Test
    public void testValues() {
        Map map = NoOpMap.instance();
        map.put("hello", "world");
        Collection values = map.values();
        Assert.assertEquals((long)0L, (long)values.size());
    }

    @Test
    public void testKeys() {
        Map map = NoOpMap.instance();
        map.put("hello", "world");
        Set keySet = map.keySet();
        Assert.assertEquals((long)0L, (long)keySet.size());
    }

    @Test
    public void testEntrySet() {
        Map map = NoOpMap.instance();
        map.put("hello", "world");
        Set entrySet = map.entrySet();
        Assert.assertEquals((long)0L, (long)entrySet.size());
    }

    @Test
    public void testIsEmpty() {
        Map map = NoOpMap.instance();
        map.put("hello", "world");
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testRemove() {
        Map map = NoOpMap.instance();
        map.put("hello", "world");
        Assert.assertNull(map.remove("hello"));
    }

    @Test
    public void testReplace() {
        Map map = NoOpMap.instance();
        map.put("hello", "world");
        Assert.assertNull((Object)map.replace("hello", "world2"));
        map.put("hello", "world");
        Assert.assertFalse((boolean)map.replace("hello", "world", "world2"));
    }
}

