/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.collections;

import java.util.Collection;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import org.apache.activemq.artemis.utils.collections.LongHashSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;

public class LongHashSetTest {
    private static final int INITIAL_CAPACITY = 100;
    private final LongHashSet testSet = new LongHashSet(100);

    @Test
    public void initiallyContainsNoElements() {
        for (long i = 0L; i < 10000L; ++i) {
            Assert.assertFalse((boolean)this.testSet.contains(i));
        }
    }

    @Test
    public void initiallyContainsNoBoxedElements() {
        for (long i = 0L; i < 10000L; ++i) {
            Assert.assertFalse((boolean)this.testSet.contains((Object)i));
        }
    }

    @Test
    public void containsAddedElement() {
        Assert.assertTrue((boolean)this.testSet.add(1L));
        Assert.assertTrue((boolean)this.testSet.contains(1L));
    }

    @Test
    public void addingAnElementTwiceDoesNothing() {
        Assert.assertTrue((boolean)this.testSet.add(1L));
        Assert.assertFalse((boolean)this.testSet.add(1L));
    }

    @Test
    public void containsAddedBoxedElements() {
        Assert.assertTrue((boolean)this.testSet.add(1L));
        Assert.assertTrue((boolean)this.testSet.add(Long.valueOf(2L)));
        Assert.assertTrue((boolean)this.testSet.contains((Object)1L));
        Assert.assertTrue((boolean)this.testSet.contains(2L));
    }

    @Test
    public void removingAnElementFromAnEmptyListDoesNothing() {
        Assert.assertFalse((boolean)this.testSet.remove(0L));
    }

    @Test
    public void removingAPresentElementRemovesIt() {
        Assert.assertTrue((boolean)this.testSet.add(1L));
        Assert.assertTrue((boolean)this.testSet.remove(1L));
        Assert.assertFalse((boolean)this.testSet.contains(1L));
    }

    @Test
    public void sizeIsInitiallyZero() {
        Assert.assertEquals((long)0L, (long)this.testSet.size());
    }

    @Test
    public void sizeIncrementsWithNumberOfAddedElements() {
        LongHashSetTest.addTwoElements(this.testSet);
        Assert.assertEquals((long)2L, (long)this.testSet.size());
    }

    @Test
    public void sizeContainsNumberOfNewElements() {
        this.testSet.add(1L);
        this.testSet.add(1L);
        Assert.assertEquals((long)1L, (long)this.testSet.size());
    }

    @Test
    public void iteratorsListElements() {
        LongHashSetTest.addTwoElements(this.testSet);
        this.assertIteratorHasElements();
    }

    @Test
    public void iteratorsStartFromTheBeginningEveryTime() {
        this.iteratorsListElements();
        this.assertIteratorHasElements();
    }

    @Test
    public void iteratorsListElementsWithoutHasNext() {
        LongHashSetTest.addTwoElements(this.testSet);
        this.assertIteratorHasElementsWithoutHasNext();
    }

    @Test
    public void iteratorsStartFromTheBeginningEveryTimeWithoutHasNext() {
        this.iteratorsListElementsWithoutHasNext();
        this.assertIteratorHasElementsWithoutHasNext();
    }

    @Test(expected=NoSuchElementException.class)
    public void iteratorsThrowNoSuchElementException() {
        LongHashSetTest.addTwoElements(this.testSet);
        this.exhaustIterator();
    }

    @Test(expected=NoSuchElementException.class)
    public void iteratorsThrowNoSuchElementExceptionFromTheBeginningEveryTime() {
        LongHashSetTest.addTwoElements(this.testSet);
        try {
            this.exhaustIterator();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.exhaustIterator();
    }

    @Test
    public void iteratorHasNoElements() {
        Assert.assertFalse((boolean)this.testSet.iterator().hasNext());
    }

    @Test(expected=NoSuchElementException.class)
    public void iteratorThrowExceptionForEmptySet() {
        this.testSet.iterator().next();
    }

    @Test
    public void clearRemovesAllElementsOfTheSet() {
        LongHashSetTest.addTwoElements(this.testSet);
        this.testSet.clear();
        Assert.assertEquals((long)0L, (long)this.testSet.size());
        Assert.assertFalse((boolean)this.testSet.contains(1L));
        Assert.assertFalse((boolean)this.testSet.contains(1001L));
    }

    @Test
    public void twoEmptySetsAreEqual() {
        LongHashSet other = new LongHashSet(100);
        Assert.assertEquals((Object)this.testSet, (Object)other);
    }

    @Test
    public void setsWithTheSameValuesAreEqual() {
        LongHashSet other = new LongHashSet(100);
        LongHashSetTest.addTwoElements(this.testSet);
        LongHashSetTest.addTwoElements(other);
        Assert.assertEquals((Object)this.testSet, (Object)other);
    }

    @Test
    public void setsWithTheDifferentSizesAreNotEqual() {
        LongHashSet other = new LongHashSet(100);
        LongHashSetTest.addTwoElements(this.testSet);
        other.add(1001L);
        Assert.assertNotEquals((Object)this.testSet, (Object)other);
    }

    @Test
    public void setsWithTheDifferentValuesAreNotEqual() {
        LongHashSet other = new LongHashSet(100);
        LongHashSetTest.addTwoElements(this.testSet);
        other.add(2L);
        other.add(1001L);
        Assert.assertNotEquals((Object)this.testSet, (Object)other);
    }

    @Test
    public void twoEmptySetsHaveTheSameHashcode() {
        Assert.assertEquals((long)this.testSet.hashCode(), (long)new LongHashSet(100).hashCode());
    }

    @Test
    public void setsWithTheSameValuesHaveTheSameHashcode() {
        LongHashSet other = new LongHashSet(100);
        LongHashSetTest.addTwoElements(this.testSet);
        LongHashSetTest.addTwoElements(other);
        Assert.assertEquals((long)this.testSet.hashCode(), (long)other.hashCode());
    }

    @Test
    public void reducesSizeWhenElementRemoved() {
        LongHashSetTest.addTwoElements(this.testSet);
        this.testSet.remove(1001L);
        Assert.assertEquals((long)1L, (long)this.testSet.size());
    }

    @Test(expected=ArrayStoreException.class)
    public void toArrayThrowsArrayStoreExceptionForWrongType() {
        this.testSet.toArray((Object[])new String[1]);
    }

    @Test(expected=NullPointerException.class)
    public void toArrayThrowsNullPointerExceptionForNullArgument() {
        Object[] into = null;
        this.testSet.toArray(into);
    }

    @Test
    public void toArrayCopiesElementsIntoSufficientlySizedArray() {
        LongHashSetTest.addTwoElements(this.testSet);
        Long[] result = (Long[])this.testSet.toArray((Object[])new Long[this.testSet.size()]);
        LongHashSetTest.assertArrayContainingElements(result);
    }

    @Test
    public void toArrayCopiesElementsIntoNewArray() {
        LongHashSetTest.addTwoElements(this.testSet);
        Long[] result = (Long[])this.testSet.toArray((Object[])new Long[this.testSet.size()]);
        LongHashSetTest.assertArrayContainingElements(result);
    }

    @Test
    public void toArraySupportsEmptyCollection() {
        Object[] result = (Long[])this.testSet.toArray((Object[])new Long[this.testSet.size()]);
        Assert.assertArrayEquals((Object[])result, (Object[])new Long[0]);
    }

    @Test
    public void chainCompactionShouldNotCauseElementsToBeMovedBeforeTheirHash() {
        LongHashSet requiredFields = new LongHashSet(14);
        requiredFields.add(8L);
        requiredFields.add(9L);
        requiredFields.add(35L);
        requiredFields.add(49L);
        requiredFields.add(56L);
        Assert.assertTrue((String)"Failed to remove 8", (boolean)requiredFields.remove(8L));
        Assert.assertTrue((String)"Failed to remove 9", (boolean)requiredFields.remove(9L));
        MatcherAssert.assertThat((Object)requiredFields, (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{35L, 49L, 56L}));
    }

    @Test
    public void shouldResizeWhenItHitsCapacity() {
        long i;
        for (i = 0L; i < 200L; ++i) {
            Assert.assertTrue((boolean)this.testSet.add(i));
        }
        for (i = 0L; i < 200L; ++i) {
            Assert.assertTrue((boolean)this.testSet.contains(i));
        }
    }

    @Test
    public void containsEmptySet() {
        LongHashSet other = new LongHashSet(100);
        Assert.assertTrue((boolean)this.testSet.containsAll(other));
        Assert.assertTrue((boolean)this.testSet.containsAll((Collection)other));
    }

    @Test
    public void containsSubset() {
        LongHashSetTest.addTwoElements(this.testSet);
        LongHashSet subset = new LongHashSet(100);
        subset.add(1L);
        Assert.assertTrue((boolean)this.testSet.containsAll(subset));
        Assert.assertTrue((boolean)this.testSet.containsAll((Collection)subset));
    }

    @Test
    public void doesNotContainDisjointSet() {
        LongHashSetTest.addTwoElements(this.testSet);
        LongHashSet other = new LongHashSet(100);
        other.add(1L);
        other.add(1002L);
        Assert.assertFalse((boolean)this.testSet.containsAll(other));
        Assert.assertFalse((boolean)this.testSet.containsAll((Collection)other));
    }

    @Test
    public void doesNotContainSuperset() {
        LongHashSetTest.addTwoElements(this.testSet);
        LongHashSet superset = new LongHashSet(100);
        LongHashSetTest.addTwoElements(superset);
        superset.add(15L);
        Assert.assertFalse((boolean)this.testSet.containsAll(superset));
        Assert.assertFalse((boolean)this.testSet.containsAll((Collection)superset));
    }

    @Test
    public void addingEmptySetDoesNothing() {
        LongHashSetTest.addTwoElements(this.testSet);
        Assert.assertFalse((boolean)this.testSet.addAll((Collection)new LongHashSet(100)));
        Assert.assertFalse((boolean)this.testSet.addAll(new HashSet()));
        LongHashSetTest.assertContainsElements((Set<Long>)this.testSet);
    }

    @Test
    public void addingSubsetDoesNothing() {
        LongHashSetTest.addTwoElements(this.testSet);
        LongHashSet subset = new LongHashSet(100);
        subset.add(1L);
        HashSet subSetCollection = new HashSet(subset);
        Assert.assertFalse((boolean)this.testSet.addAll((Collection)subset));
        Assert.assertFalse((boolean)this.testSet.addAll(subSetCollection));
        LongHashSetTest.assertContainsElements((Set<Long>)this.testSet);
    }

    @Test
    public void addingEqualSetDoesNothing() {
        LongHashSetTest.addTwoElements(this.testSet);
        LongHashSet equal = new LongHashSet(100);
        LongHashSetTest.addTwoElements(equal);
        HashSet equalCollection = new HashSet(equal);
        Assert.assertFalse((boolean)this.testSet.addAll((Collection)equal));
        Assert.assertFalse((boolean)this.testSet.addAll(equalCollection));
        LongHashSetTest.assertContainsElements((Set<Long>)this.testSet);
    }

    @Test
    public void containsValuesAddedFromDisjointSetPrimitive() {
        LongHashSetTest.addTwoElements(this.testSet);
        LongHashSet disjoint = new LongHashSet(100);
        disjoint.add(2L);
        disjoint.add(1002L);
        Assert.assertTrue((boolean)this.testSet.addAll((Collection)disjoint));
        Assert.assertTrue((boolean)this.testSet.contains(1L));
        Assert.assertTrue((boolean)this.testSet.contains(1001L));
        Assert.assertTrue((boolean)this.testSet.containsAll(disjoint));
    }

    @Test
    public void containsValuesAddedFromDisjointSet() {
        LongHashSetTest.addTwoElements(this.testSet);
        HashSet<Long> disjoint = new HashSet<Long>();
        disjoint.add(2L);
        disjoint.add(1002L);
        Assert.assertTrue((boolean)this.testSet.addAll(disjoint));
        Assert.assertTrue((boolean)this.testSet.contains(1L));
        Assert.assertTrue((boolean)this.testSet.contains(1001L));
        Assert.assertTrue((boolean)this.testSet.containsAll(disjoint));
    }

    @Test
    public void containsValuesAddedFromIntersectingSetPrimitive() {
        LongHashSetTest.addTwoElements(this.testSet);
        LongHashSet intersecting = new LongHashSet(100);
        intersecting.add(1L);
        intersecting.add(1002L);
        Assert.assertTrue((boolean)this.testSet.addAll((Collection)intersecting));
        Assert.assertTrue((boolean)this.testSet.contains(1L));
        Assert.assertTrue((boolean)this.testSet.contains(1001L));
        Assert.assertTrue((boolean)this.testSet.containsAll(intersecting));
    }

    @Test
    public void containsValuesAddedFromIntersectingSet() {
        LongHashSetTest.addTwoElements(this.testSet);
        HashSet<Long> intersecting = new HashSet<Long>();
        intersecting.add(1L);
        intersecting.add(1002L);
        Assert.assertTrue((boolean)this.testSet.addAll(intersecting));
        Assert.assertTrue((boolean)this.testSet.contains(1L));
        Assert.assertTrue((boolean)this.testSet.contains(1001L));
        Assert.assertTrue((boolean)this.testSet.containsAll(intersecting));
    }

    @Test
    public void removingEmptySetDoesNothing() {
        LongHashSetTest.addTwoElements(this.testSet);
        Assert.assertFalse((boolean)this.testSet.removeAll((Collection)new LongHashSet(100)));
        Assert.assertFalse((boolean)this.testSet.removeAll(new HashSet()));
        LongHashSetTest.assertContainsElements((Set<Long>)this.testSet);
    }

    @Test
    public void removingDisjointSetDoesNothing() {
        LongHashSetTest.addTwoElements(this.testSet);
        LongHashSet disjoint = new LongHashSet(100);
        disjoint.add(2L);
        disjoint.add(1002L);
        Assert.assertFalse((boolean)this.testSet.removeAll((Collection)disjoint));
        Assert.assertFalse((boolean)this.testSet.removeAll(new HashSet()));
        LongHashSetTest.assertContainsElements((Set<Long>)this.testSet);
    }

    @Test
    public void doesNotContainRemovedIntersectingSetPrimitive() {
        LongHashSetTest.addTwoElements(this.testSet);
        LongHashSet intersecting = new LongHashSet(100);
        intersecting.add(1L);
        intersecting.add(1002L);
        Assert.assertTrue((boolean)this.testSet.removeAll((Collection)intersecting));
        Assert.assertTrue((boolean)this.testSet.contains(1001L));
        Assert.assertFalse((boolean)this.testSet.containsAll(intersecting));
    }

    @Test
    public void doesNotContainRemovedIntersectingSet() {
        LongHashSetTest.addTwoElements(this.testSet);
        HashSet<Long> intersecting = new HashSet<Long>();
        intersecting.add(1L);
        intersecting.add(1002L);
        Assert.assertTrue((boolean)this.testSet.removeAll(intersecting));
        Assert.assertTrue((boolean)this.testSet.contains(1001L));
        Assert.assertFalse((boolean)this.testSet.containsAll(intersecting));
    }

    @Test
    public void isEmptyAfterRemovingEqualSetPrimitive() {
        LongHashSetTest.addTwoElements(this.testSet);
        LongHashSet equal = new LongHashSet(100);
        LongHashSetTest.addTwoElements(equal);
        Assert.assertTrue((boolean)this.testSet.removeAll((Collection)equal));
        Assert.assertTrue((boolean)this.testSet.isEmpty());
    }

    @Test
    public void isEmptyAfterRemovingEqualSet() {
        LongHashSetTest.addTwoElements(this.testSet);
        HashSet<Long> equal = new HashSet<Long>();
        LongHashSetTest.addTwoElements(equal);
        Assert.assertTrue((boolean)this.testSet.removeAll(equal));
        Assert.assertTrue((boolean)this.testSet.isEmpty());
    }

    @Test
    public void removeElementsFromIterator() {
        LongHashSetTest.addTwoElements(this.testSet);
        LongHashSet.LongIterator iterator = this.testSet.iterator();
        while (iterator.hasNext()) {
            if (iterator.nextValue() != 1L) continue;
            iterator.remove();
        }
        MatcherAssert.assertThat((Object)this.testSet, (Matcher)Matchers.contains((Object[])new Long[]{1001L}));
        MatcherAssert.assertThat((Object)this.testSet, (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void shouldNotContainMissingValueInitially() {
        Assert.assertFalse((boolean)this.testSet.contains(-2L));
    }

    @Test
    public void shouldAllowMissingValue() {
        Assert.assertTrue((boolean)this.testSet.add(-2L));
        Assert.assertTrue((boolean)this.testSet.contains(-2L));
        Assert.assertFalse((boolean)this.testSet.add(-2L));
    }

    @Test
    public void shouldAllowRemovalOfMissingValue() {
        Assert.assertTrue((boolean)this.testSet.add(-2L));
        Assert.assertTrue((boolean)this.testSet.remove(-2L));
        Assert.assertFalse((boolean)this.testSet.contains(-2L));
        Assert.assertFalse((boolean)this.testSet.remove(-2L));
    }

    @Test
    public void sizeAccountsForMissingValue() {
        this.testSet.add(1L);
        this.testSet.add(-2L);
        Assert.assertEquals((long)2L, (long)this.testSet.size());
    }

    @Test
    public void toArrayCopiesElementsIntoNewArrayIncludingMissingValue() {
        LongHashSetTest.addTwoElements(this.testSet);
        this.testSet.add(-2L);
        Long[] result = (Long[])this.testSet.toArray((Object[])new Long[this.testSet.size()]);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Long[]{1L, 1001L, -2L}));
    }

    @Test
    public void toObjectArrayCopiesElementsIntoNewArrayIncludingMissingValue() {
        LongHashSetTest.addTwoElements(this.testSet);
        this.testSet.add(-2L);
        Object[] result = this.testSet.toArray();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Object[]{1L, 1001L, -2L}));
    }

    @Test
    public void equalsAccountsForMissingValue() {
        LongHashSetTest.addTwoElements(this.testSet);
        this.testSet.add(-2L);
        LongHashSet other = new LongHashSet(100);
        LongHashSetTest.addTwoElements(other);
        Assert.assertNotEquals((Object)this.testSet, (Object)other);
        other.add(-2L);
        Assert.assertEquals((Object)this.testSet, (Object)other);
        this.testSet.remove(-2L);
        Assert.assertNotEquals((Object)this.testSet, (Object)other);
    }

    @Test
    public void consecutiveValuesShouldBeCorrectlyStored() {
        for (long i = 0L; i < 10000L; ++i) {
            this.testSet.add(i);
        }
        MatcherAssert.assertThat((Object)this.testSet, (Matcher)Matchers.hasSize((int)10000));
        int distinctElements = 0;
        LongHashSet.LongIterator longIterator = this.testSet.iterator();
        while (longIterator.hasNext()) {
            long ignore = (Long)longIterator.next();
            ++distinctElements;
        }
        MatcherAssert.assertThat((Object)distinctElements, (Matcher)Matchers.is((Object)10000));
    }

    @Test
    public void hashCodeAccountsForMissingValue() {
        LongHashSetTest.addTwoElements(this.testSet);
        this.testSet.add(-2L);
        LongHashSet other = new LongHashSet(100);
        LongHashSetTest.addTwoElements(other);
        Assert.assertNotEquals((long)this.testSet.hashCode(), (long)other.hashCode());
        other.add(-2L);
        Assert.assertEquals((long)this.testSet.hashCode(), (long)other.hashCode());
        this.testSet.remove(-2L);
        Assert.assertNotEquals((long)this.testSet.hashCode(), (long)other.hashCode());
    }

    @Test
    public void iteratorAccountsForMissingValue() {
        LongHashSetTest.addTwoElements(this.testSet);
        this.testSet.add(-2L);
        int missingValueCount = 0;
        LongHashSet.LongIterator iterator = this.testSet.iterator();
        while (iterator.hasNext()) {
            if (iterator.nextValue() != -2L) continue;
            ++missingValueCount;
        }
        Assert.assertEquals((long)1L, (long)missingValueCount);
    }

    @Test
    public void iteratorCanRemoveMissingValue() {
        LongHashSetTest.addTwoElements(this.testSet);
        this.testSet.add(-2L);
        LongHashSet.LongIterator iterator = this.testSet.iterator();
        while (iterator.hasNext()) {
            if (iterator.nextValue() != -2L) continue;
            iterator.remove();
        }
        Assert.assertFalse((boolean)this.testSet.contains(-2L));
    }

    @Test
    public void shouldGenerateStringRepresentation() {
        long[] testEntries;
        for (long testEntry : testEntries = new long[]{3L, 1L, -2L, 19L, 7L, 11L, 12L, 7L}) {
            this.testSet.add(testEntry);
        }
        String mapAsAString = "{1, 19, 11, 7, 3, 12, -2}";
        MatcherAssert.assertThat((Object)this.testSet.toString(), (Matcher)IsEqual.equalTo((Object)"{1, 19, 11, 7, 3, 12, -2}"));
    }

    @Test
    public void shouldRemoveMissingValueWhenCleared() {
        Assert.assertTrue((boolean)this.testSet.add(-2L));
        this.testSet.clear();
        Assert.assertFalse((boolean)this.testSet.contains(-2L));
    }

    @Test
    public void shouldHaveCompatibleEqualsAndHashcode() {
        HashSet<Long> compatibleSet = new HashSet<Long>();
        long seed = System.nanoTime();
        Random r = new Random(seed);
        for (long i = 0L; i < 1024L; ++i) {
            long value = r.nextLong();
            compatibleSet.add(value);
            this.testSet.add(value);
        }
        if (r.nextBoolean()) {
            compatibleSet.add(-2L);
            this.testSet.add(-2L);
        }
        Assert.assertEquals((String)("Fail with seed:" + seed), (Object)this.testSet, compatibleSet);
        Assert.assertEquals((String)("Fail with seed:" + seed), compatibleSet, (Object)this.testSet);
        Assert.assertEquals((String)("Fail with seed:" + seed), (long)compatibleSet.hashCode(), (long)this.testSet.hashCode());
    }

    private static void addTwoElements(LongHashSet obj) {
        obj.add(1L);
        obj.add(1001L);
    }

    private static void addTwoElements(HashSet<Long> obj) {
        obj.add(1L);
        obj.add(1001L);
    }

    private void assertIteratorHasElements() {
        LongHashSet.LongIterator iter = this.testSet.iterator();
        HashSet<Long> values = new HashSet<Long>();
        Assert.assertTrue((boolean)iter.hasNext());
        values.add((Long)iter.next());
        Assert.assertTrue((boolean)iter.hasNext());
        values.add((Long)iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
        LongHashSetTest.assertContainsElements(values);
    }

    private void assertIteratorHasElementsWithoutHasNext() {
        LongHashSet.LongIterator iter = this.testSet.iterator();
        HashSet<Long> values = new HashSet<Long>();
        values.add((Long)iter.next());
        values.add((Long)iter.next());
        LongHashSetTest.assertContainsElements(values);
    }

    private static void assertArrayContainingElements(Long[] result) {
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Long[]{1L, 1001L}));
    }

    private static void assertContainsElements(Set<Long> other) {
        MatcherAssert.assertThat(other, (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{1L, 1001L}));
    }

    private void exhaustIterator() {
        LongHashSet.LongIterator iterator = this.testSet.iterator();
        iterator.next();
        iterator.next();
        iterator.next();
    }
}

