/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.collections;

import java.util.Arrays;
import org.apache.activemq.artemis.utils.collections.ConcurrentAppendOnlyChunkedList;
import org.junit.Assert;
import org.junit.Test;

public class ConcurrentAppendOnlyChunkedListTest {
    private static final int CHUNK_SIZE = 16;
    private static final int ELEMENTS = 65;
    private final ConcurrentAppendOnlyChunkedList<Integer> chunkedList = new ConcurrentAppendOnlyChunkedList(16);

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToCreateNotPowerOf2ChunkSizeCollection() {
        new ConcurrentAppendOnlyChunkedList(3);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToCreateNegativeChunkSizeCollection() {
        new ConcurrentAppendOnlyChunkedList(-1);
    }

    @Test
    public void shouldNumberOfElementsBeTheSameOfTheAddedElements() {
        int messages = 65;
        for (int i = 0; i < 65; ++i) {
            Assert.assertEquals((long)i, (long)this.chunkedList.size());
            this.chunkedList.add((Object)i);
        }
        Assert.assertEquals((long)65L, (long)this.chunkedList.size());
    }

    @Test
    public void shouldNumberOfElementsBeTheSameOfAddAllElements() {
        int messages = 65;
        Object[] elements = new Integer[65];
        for (int i = 0; i < 65; ++i) {
            Integer element = i;
            elements[i] = element;
        }
        this.chunkedList.addAll(elements);
        Assert.assertEquals((long)65L, (long)this.chunkedList.size());
    }

    @Test
    public void shouldGetReturnNullIfEmpty() {
        Assert.assertNull((Object)this.chunkedList.get(0));
    }

    @Test
    public void shouldNegativeIndexedGetReturnNull() {
        Assert.assertNull((Object)this.chunkedList.get(-1));
        this.chunkedList.add((Object)0);
        Assert.assertNull((Object)this.chunkedList.get(-1));
    }

    @Test
    public void shouldGetReturnNullIfExceedSize() {
        int messages = 65;
        for (int i = 0; i < 65; ++i) {
            Integer element = i;
            this.chunkedList.add((Object)element);
            Assert.assertNull((Object)this.chunkedList.get(i + 1));
        }
    }

    @Test
    public void shouldGetReturnElementsAccordingToAddOrder() {
        int i;
        int messages = 65;
        Object[] elements = new Integer[65];
        for (int i2 = 0; i2 < 65; ++i2) {
            Integer element;
            elements[i2] = element = Integer.valueOf(i2);
            this.chunkedList.add((Object)element);
        }
        Object[] cachedElements = new Integer[65];
        for (i = 0; i < 65; ++i) {
            cachedElements[i] = (Integer)this.chunkedList.get(i);
        }
        Assert.assertArrayEquals((Object[])elements, (Object[])cachedElements);
        Arrays.fill(cachedElements, null);
        for (i = 64; i >= 0; --i) {
            cachedElements[i] = (Integer)this.chunkedList.get(i);
        }
        Assert.assertArrayEquals((Object[])elements, (Object[])cachedElements);
    }

    @Test
    public void shouldGetReturnElementsAccordingToAddAllOrder() {
        int messages = 65;
        Object[] elements = new Integer[65];
        for (int i = 0; i < 65; ++i) {
            Integer element = i;
            elements[i] = element;
        }
        this.chunkedList.addAll(elements);
        Object[] cachedElements = new Integer[65];
        for (int i = 0; i < 65; ++i) {
            cachedElements[i] = (Integer)this.chunkedList.get(i);
        }
        Assert.assertArrayEquals((Object[])elements, (Object[])cachedElements);
    }

    @Test
    public void shouldToArrayReturnElementsAccordingToAddOrder() {
        int messages = 65;
        Object[] elements = new Integer[65];
        for (int i = 0; i < 65; ++i) {
            Integer element;
            elements[i] = element = Integer.valueOf(i);
            this.chunkedList.add((Object)element);
        }
        Object[] cachedElements = (Integer[])this.chunkedList.toArray(Integer[]::new);
        Assert.assertArrayEquals((Object[])elements, (Object[])cachedElements);
    }

    @Test
    public void shouldToArrayWithIndexReturnElementsAccordingToAddOrder() {
        int messages = 65;
        Object[] elements = new Integer[65];
        for (int i = 0; i < 65; ++i) {
            Integer element;
            elements[i] = element = Integer.valueOf(i);
            this.chunkedList.add((Object)element);
        }
        int offset = 10;
        Integer[] cachedElements = (Integer[])this.chunkedList.toArray(size -> new Integer[10 + size], 10);
        Assert.assertArrayEquals((Object[])elements, (Object[])Arrays.copyOfRange(cachedElements, 10, cachedElements.length));
        Assert.assertArrayEquals((Object[])new Integer[10], (Object[])Arrays.copyOfRange(cachedElements, 0, 10));
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void shouldFailToArrayWithInsufficientArrayCapacity() {
        int messages = 65;
        Integer[] elements = new Integer[65];
        for (int i = 0; i < 65; ++i) {
            Integer element;
            elements[i] = element = Integer.valueOf(i);
            this.chunkedList.add((Object)element);
        }
        int offset = 10;
        this.chunkedList.toArray(size -> new Integer[10 + size - 1], 10);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void shouldFailToArrayWithNegativeStartIndex() {
        this.chunkedList.toArray(Integer[]::new, -1);
    }

    @Test(expected=NullPointerException.class)
    public void shouldFailToArrayWithNullArray() {
        this.chunkedList.toArray(size -> null);
    }

    @Test
    public void shouldToArrayReturnElementsAccordingToAddAllOrder() {
        int messages = 65;
        Object[] elements = new Integer[65];
        for (int i = 0; i < 65; ++i) {
            Integer element = i;
            elements[i] = element;
        }
        this.chunkedList.addAll(elements);
        Object[] cachedElements = (Integer[])this.chunkedList.toArray(Integer[]::new);
        Assert.assertArrayEquals((Object[])elements, (Object[])cachedElements);
    }

    @Test
    public void shouldToArrayReturnEmptyArrayIfEmpty() {
        Object[] array = (Integer[])this.chunkedList.toArray(Integer[]::new);
        Assert.assertArrayEquals((Object[])new Integer[0], (Object[])array);
    }
}

