/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.utils.uri.BeanSupport;
import org.apache.activemq.artemis.utils.uri.URIFactory;
import org.apache.activemq.artemis.utils.uri.URISchema;
import org.apache.activemq.artemis.utils.uri.URISupport;
import org.junit.Assert;
import org.junit.Test;

public class URIParserTest {
    @Test
    public void testSchemaFruit() throws Throwable {
        FruitParser parser = new FruitParser();
        Fruit fruit = (Fruit)parser.newObject(new URI("fruit://some:guy@fair-market:3030?color=green&fluentName=something"), null);
        Assert.assertEquals((Object)"fruit", (Object)fruit.getName());
        Assert.assertEquals((long)3030L, (long)fruit.getPort());
        Assert.assertEquals((Object)"fair-market", (Object)fruit.getHost());
        Assert.assertEquals((Object)"some:guy", (Object)fruit.getUserInfo());
        Assert.assertEquals((Object)"green", (Object)fruit.getColor());
        Assert.assertEquals((Object)"something", (Object)fruit.getFluentName());
    }

    @Test
    public void testGenerateWithEncoding() throws Throwable {
        FruitParser parser = new FruitParser();
        Fruit myFruit = new Fruit("tomato&fruit");
        myFruit.setHost("somehost&uui");
        myFruit.setFluentName("apples&bananas with &host=3344");
        URI uri = parser.createSchema("fruit", myFruit);
        Fruit newFruit = (Fruit)parser.newObject(uri, "something");
        Assert.assertEquals((Object)myFruit.getHost(), (Object)newFruit.getHost());
        Assert.assertEquals((Object)myFruit.getFluentName(), (Object)newFruit.getFluentName());
    }

    @Test
    public void testSchemaNoHosProperty() throws Throwable {
        FruitParser parser = new FruitParser();
        FruitBase fruit = (FruitBase)parser.newObject(new URI("base://some:guy@fair-market:3030?color=green&fluentName=something"), null);
        Assert.assertEquals((Object)"base", (Object)fruit.getName());
        Assert.assertEquals((Object)"green", (Object)fruit.getColor());
        Assert.assertEquals((Object)"something", (Object)fruit.getFluentName());
    }

    @Test
    public void testSchemaNoHostOnURL() throws Throwable {
        FruitParser parser = new FruitParser();
        Fruit fruit = (Fruit)parser.newObject(new URI("fruit://some:guy@port?color=green&fluentName=something"), null);
        Assert.assertEquals((Object)"fruit", (Object)fruit.getName());
        Assert.assertEquals((Object)"green", (Object)fruit.getColor());
        Assert.assertEquals((Object)"something", (Object)fruit.getFluentName());
    }

    @Test
    public void testQueryConversion() throws Exception {
        HashMap<String, String> query = new HashMap<String, String>();
        String queryString = URISupport.createQueryString(query);
        Assert.assertTrue((boolean)queryString.isEmpty());
        query.put("key1", "value1");
        queryString = URISupport.createQueryString(query);
        Assert.assertEquals((Object)"key1=value1", (Object)queryString);
        query.put("key3", "value3");
        queryString = URISupport.createQueryString(query);
        Assert.assertEquals((Object)"key1=value1&key3=value3", (Object)queryString);
        query.put("key2", "value2");
        queryString = URISupport.createQueryString(query);
        Assert.assertEquals((Object)"key1=value1&key2=value2&key3=value3", (Object)queryString);
    }

    public static class Fruit
    extends FruitBase {
        String host;
        int port;
        String userInfo;

        public Fruit(String name) {
            super(name);
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getHost() {
            return this.host;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public int getPort() {
            return this.port;
        }

        public void setUserInfo(String userInfo) {
            this.userInfo = userInfo;
        }

        public String getUserInfo() {
            return this.userInfo;
        }

        @Override
        public String toString() {
            return "Fruit{host='" + this.host + "', port=" + this.port + ", userInfo='" + this.userInfo + "'super=" + super.toString() + "}";
        }
    }

    public static class FruitBase {
        final String name;
        String fluentName;
        String color;

        FruitBase(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public String getFluentName() {
            return this.fluentName;
        }

        public FruitBase setFluentName(String name) {
            this.fluentName = name;
            return this;
        }

        public String toString() {
            return "FruitBase{name='" + this.name + "', fluentName='" + this.fluentName + "', color='" + this.color + "'}";
        }
    }

    class FruitBaseSchema
    extends URISchema<FruitBase, String> {
        FruitBaseSchema() {
        }

        public String getSchemaName() {
            return "base";
        }

        public FruitBase internalNewObject(URI uri, Map<String, String> query, String fruitName) throws Exception {
            return (FruitBase)BeanSupport.setData((URI)uri, (Object)new FruitBase(this.getSchemaName()), query);
        }
    }

    class FruitSchema
    extends URISchema<FruitBase, String> {
        FruitSchema() {
        }

        public String getSchemaName() {
            return "fruit";
        }

        public FruitBase internalNewObject(URI uri, Map<String, String> query, String fruitName) throws Exception {
            return (FruitBase)BeanSupport.setData((URI)uri, (Object)new Fruit(this.getSchemaName()), query);
        }
    }

    class FruitParser
    extends URIFactory<FruitBase, String> {
        FruitParser() {
            this.registerSchema(new FruitSchema());
            this.registerSchema(new FruitBaseSchema());
        }
    }
}

