/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.lang.invoke.CallSite;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class ThreadLeakCheckRule
extends TestWatcher {
    private static Logger log = Logger.getLogger(ThreadLeakCheckRule.class);
    private static Set<String> knownThreads = new HashSet<String>();
    protected boolean enabled = true;
    protected boolean testFailed = false;
    protected Description testDescription = null;
    protected Throwable failure = null;
    protected Map<Thread, StackTraceElement[]> previousThreads;
    private static int failedGCCalls = 0;

    protected void starting(Description description) {
        this.previousThreads = Thread.getAllStackTraces();
    }

    public void disable() {
        this.enabled = false;
    }

    protected void failed(Throwable e, Description description) {
        this.failure = e;
        this.testFailed = true;
        this.testDescription = description;
    }

    protected void succeeded(Description description) {
        this.testFailed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finished(Description description) {
        log.debug((Object)("checking thread enabled? " + this.enabled + " testFailed? " + this.testFailed));
        try {
            if (this.enabled) {
                boolean failed = true;
                boolean failedOnce = false;
                long timeout = System.currentTimeMillis() + (long)(this.testFailed ? 30000 : 60000);
                while (failed && timeout > System.currentTimeMillis()) {
                    failed = this.checkThread();
                    if (!failed) continue;
                    failedOnce = true;
                    ThreadLeakCheckRule.forceGC();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Throwable throwable) {}
                }
                if (failed) {
                    if (!this.testFailed) {
                        Assert.fail((String)"Thread leaked");
                    } else {
                        System.out.println("***********************************************************************");
                        System.out.println("             The test failed and there is a leak");
                        System.out.println("***********************************************************************");
                        this.failure.printStackTrace();
                        Assert.fail((String)("Test " + this.testDescription + " Failed with a leak - " + this.failure.getMessage()));
                    }
                } else if (failedOnce) {
                    System.out.println("******************** Threads cleared after retries ********************");
                    System.out.println();
                }
            } else {
                this.enabled = true;
            }
        }
        finally {
            this.previousThreads = null;
        }
    }

    public static void forceGC() {
        if (failedGCCalls >= 10) {
            log.info((Object)"ignoring forceGC call since it seems System.gc is not working anyways");
            return;
        }
        log.info((Object)"#test forceGC");
        CountDownLatch finalized = new CountDownLatch(1);
        WeakReference<DumbReference> dumbReference = new WeakReference<DumbReference>(new DumbReference(finalized));
        long timeout = System.currentTimeMillis() + 1000L;
        while ((dumbReference.get() != null || finalized.getCount() != 0L) && System.currentTimeMillis() < timeout) {
            System.gc();
            System.runFinalization();
            try {
                finalized.await(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (dumbReference.get() != null) {
            ++failedGCCalls;
            log.info((Object)"It seems that GC is disabled at your VM");
        } else {
            failedGCCalls = 0;
        }
        log.info((Object)"#test forceGC Done ");
    }

    public static void forceGC(Reference<?> ref, long timeout) {
        long waitUntil = System.currentTimeMillis() + timeout;
        while (ref.get() != null && System.currentTimeMillis() < waitUntil) {
            ArrayList<CallSite> list = new ArrayList<CallSite>();
            for (int i = 0; i < 1000; ++i) {
                list.add((CallSite)((Object)("Some string with garbage with concatenation " + i)));
            }
            list.clear();
            list = null;
            System.gc();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void removeKownThread(String name) {
        knownThreads.remove(name);
    }

    public static void addKownThread(String name) {
        knownThreads.add(name);
    }

    private boolean checkThread() {
        boolean failedThread = false;
        Map<Thread, StackTraceElement[]> postThreads = Thread.getAllStackTraces();
        if (postThreads != null && this.previousThreads != null && postThreads.size() > this.previousThreads.size()) {
            for (Thread aliveThread : postThreads.keySet()) {
                StackTraceElement[] elements;
                if (!aliveThread.isAlive() || this.isExpectedThread(aliveThread) || this.previousThreads.containsKey(aliveThread)) continue;
                if (!failedThread) {
                    System.out.println("*********************************************************************************");
                    System.out.println("LEAKING THREADS");
                }
                failedThread = true;
                System.out.println("=============================================================================");
                System.out.println("Thread " + aliveThread + " is still alive with the following stackTrace:");
                for (StackTraceElement el : elements = postThreads.get(aliveThread)) {
                    System.out.println(el);
                }
                aliveThread.interrupt();
            }
            if (failedThread) {
                System.out.println("*********************************************************************************");
            }
        }
        return failedThread;
    }

    private boolean isExpectedThread(Thread thread) {
        String threadName = thread.getName();
        ThreadGroup group = thread.getThreadGroup();
        boolean isSystemThread = group != null && "system".equals(group.getName());
        String javaVendor = System.getProperty("java.vendor");
        if (threadName.contains("SunPKCS11")) {
            return true;
        }
        if (threadName.contains("Keep-Alive-Timer")) {
            return true;
        }
        if (threadName.contains("Attach Listener")) {
            return true;
        }
        if ((javaVendor.contains("IBM") || isSystemThread) && threadName.equals("process reaper")) {
            return true;
        }
        if ((javaVendor.contains("IBM") || isSystemThread) && threadName.equals("ClassCache Reaper")) {
            return true;
        }
        if (javaVendor.contains("IBM") && threadName.equals("MemoryPoolMXBean notification dispatcher")) {
            return true;
        }
        if (threadName.contains("MemoryMXBean")) {
            return true;
        }
        if (threadName.contains("globalEventExecutor")) {
            return true;
        }
        if (threadName.contains("threadDeathWatcher")) {
            return true;
        }
        if (threadName.contains("netty-threads")) {
            return true;
        }
        if (threadName.contains("threadDeathWatcher")) {
            return true;
        }
        if (threadName.contains("Abandoned connection cleanup thread")) {
            return true;
        }
        if (threadName.contains("hawtdispatch") || group != null && group.getName().contains("hawtdispatch")) {
            return true;
        }
        if (threadName.contains("ObjectCleanerThread")) {
            return true;
        }
        if (threadName.contains("RMI TCP")) {
            return true;
        }
        if (threadName.contains("RMI Scheduler")) {
            return true;
        }
        if (threadName.contains("RMI RenewClean")) {
            return true;
        }
        if (threadName.contains("Signal Dispatcher")) {
            return true;
        }
        if (threadName.contains("ForkJoinPool.commonPool")) {
            return true;
        }
        if (threadName.contains("GC Daemon")) {
            return true;
        }
        for (StackTraceElement element : thread.getStackTrace()) {
            if (!element.getClassName().contains("org.jboss.byteman.agent.TransformListener")) continue;
            return true;
        }
        for (String known : knownThreads) {
            if (!threadName.contains(known)) continue;
            return true;
        }
        return false;
    }

    protected static class DumbReference {
        private CountDownLatch finalized;

        public DumbReference(CountDownLatch finalized) {
            this.finalized = finalized;
        }

        public void finalize() throws Throwable {
            this.finalized.countDown();
            super.finalize();
        }
    }
}

