/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.ReferenceCounterUtil;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.junit.Assert;
import org.junit.Test;

public class ReferenceCounterTest
extends Assert {
    @Test
    public void testReferenceNoExecutor() throws Exception {
        this.internalTestReferenceNoExecutor(null);
    }

    @Test
    public void testReferenceWithExecutor() throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        this.internalTestReferenceNoExecutor(executor);
        executor.shutdown();
    }

    @Test
    public void testReferenceValidExecutorUsed() throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        LatchRunner runner = new LatchRunner();
        ReferenceCounterUtil counter = new ReferenceCounterUtil((Runnable)runner, (Executor)executor);
        counter.increment();
        counter.decrement();
        runner.latch.await(5L, TimeUnit.SECONDS);
        ReferenceCounterTest.assertNotSame((Object)runner.lastThreadUsed, (Object)Thread.currentThread());
        runner.latch.setCount(1);
        runner.lastThreadUsed = Thread.currentThread();
        counter.check();
        runner.latch.await(5L, TimeUnit.SECONDS);
        ReferenceCounterTest.assertNotSame((Object)runner.lastThreadUsed, (Object)Thread.currentThread());
        executor.shutdown();
    }

    public void internalTestReferenceNoExecutor(Executor executor) throws Exception {
        LatchRunner runner = new LatchRunner();
        final ReferenceCounterUtil ref = executor == null ? new ReferenceCounterUtil((Runnable)runner) : new ReferenceCounterUtil((Runnable)runner, executor);
        Thread[] t = new Thread[100];
        for (int i = 0; i < t.length; ++i) {
            t[i] = new Thread(){

                @Override
                public void run() {
                    ref.increment();
                }
            };
            t[i].start();
        }
        for (Thread tx : t) {
            tx.join();
        }
        for (int i = 0; i < t.length; ++i) {
            t[i] = new Thread(){

                @Override
                public void run() {
                    ref.decrement();
                }
            };
            t[i].start();
        }
        for (Thread tx : t) {
            tx.join();
        }
        ReferenceCounterTest.assertTrue((boolean)runner.latch.await(5L, TimeUnit.SECONDS));
        ReferenceCounterTest.assertEquals((long)1L, (long)runner.counts.get());
    }

    class LatchRunner
    implements Runnable {
        final ReusableLatch latch = new ReusableLatch(1);
        final AtomicInteger counts = new AtomicInteger(0);
        volatile Thread lastThreadUsed = Thread.currentThread();

        LatchRunner() {
        }

        @Override
        public void run() {
            this.lastThreadUsed = Thread.currentThread();
            this.counts.incrementAndGet();
            this.latch.countDown();
        }
    }
}

