/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.HashMap;
import org.apache.activemq.artemis.utils.DefaultSensitiveStringCodec;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public class DefaultSensitiveStringCodecTest {
    private static final Logger log = Logger.getLogger(DefaultSensitiveStringCodecTest.class);

    @Test
    public void testDefaultAlgorithm() throws Exception {
        DefaultSensitiveStringCodec codec = PasswordMaskingUtil.getDefaultCodec();
        Assert.assertTrue((boolean)(codec instanceof DefaultSensitiveStringCodec));
    }

    @Test
    public void testOnewayAlgorithm() throws Exception {
        DefaultSensitiveStringCodec codec = new DefaultSensitiveStringCodec();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("algorithm", "one-way");
        codec.init(params);
        String plainText = "some_password";
        String maskedText = codec.encode((Object)plainText);
        log.debug((Object)("encoded value: " + maskedText));
        try {
            codec.decode((Object)maskedText);
            Assert.fail((String)"one way algorithm can't decode");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)codec.verify(plainText.toCharArray(), maskedText));
        String otherPassword = "some_other_password";
        Assert.assertFalse((boolean)codec.verify(otherPassword.toCharArray(), maskedText));
    }

    @Test
    public void testTwowayAlgorithm() throws Exception {
        DefaultSensitiveStringCodec codec = new DefaultSensitiveStringCodec();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("algorithm", "two-way");
        codec.init(params);
        String plainText = "some_password";
        String maskedText = codec.encode((Object)plainText);
        log.debug((Object)("encoded value: " + maskedText));
        String decoded = codec.decode((Object)maskedText);
        log.debug((Object)("encoded value: " + maskedText));
        Assert.assertEquals((String)("decoded result not match: " + decoded), (Object)decoded, (Object)plainText);
    }
}

