/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.BytesMessage;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.JMSRuntimeException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.qpid.jms.JmsConnection;
import org.apache.qpid.jms.JmsConsumer;
import org.apache.qpid.jms.JmsMessageConsumer;
import org.apache.qpid.jms.JmsMessageProducer;
import org.apache.qpid.jms.JmsProducer;
import org.apache.qpid.jms.JmsSession;
import org.apache.qpid.jms.exceptions.JmsExceptionSupport;
import org.apache.qpid.jms.provider.ProviderConstants;

public class JmsContext
implements JMSContext,
AutoCloseable {
    private final JmsConnection connection;
    private final AtomicLong connectionRefCount;
    private final int sessionMode;
    private JmsSession session;
    private JmsMessageProducer sharedProducer;
    private boolean autoStart = true;

    public JmsContext(JmsConnection connection, int sessionMode) {
        this(connection, sessionMode, new AtomicLong(1L));
    }

    private JmsContext(JmsConnection connection, int sessionMode, AtomicLong connectionRefCount) {
        this.connection = connection;
        this.sessionMode = sessionMode;
        this.connectionRefCount = connectionRefCount;
    }

    public void start() {
        try {
            this.connection.start();
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public void stop() {
        try {
            this.connection.stop();
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    @Override
    public synchronized void close() {
        JMSRuntimeException failure;
        block7: {
            failure = null;
            try {
                if (this.session != null) {
                    this.session.close();
                }
            }
            catch (JMSException jmse) {
                failure = JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
            }
            if (this.connectionRefCount.decrementAndGet() == 0L) {
                try {
                    this.connection.close();
                }
                catch (JMSException jmse) {
                    if (failure != null) break block7;
                    failure = JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
                }
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void acknowledge() {
        if (this.getSessionMode() == 2) {
            try {
                this.getSession().acknowledge(ProviderConstants.ACK_TYPE.ACCEPTED);
            }
            catch (JMSException jmse) {
                throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
            }
        }
    }

    public void commit() {
        try {
            this.getSession().commit();
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public void rollback() {
        try {
            this.getSession().rollback();
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public void recover() {
        try {
            this.getSession().recover();
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public void unsubscribe(String name) {
        try {
            this.getSession().unsubscribe(name);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public BytesMessage createBytesMessage() {
        try {
            return this.getSession().createBytesMessage();
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public MapMessage createMapMessage() {
        try {
            return this.getSession().createMapMessage();
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public Message createMessage() {
        try {
            return this.getSession().createMessage();
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public ObjectMessage createObjectMessage() {
        try {
            return this.getSession().createObjectMessage();
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public ObjectMessage createObjectMessage(Serializable object) {
        try {
            return this.getSession().createObjectMessage(object);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public StreamMessage createStreamMessage() {
        try {
            return this.getSession().createStreamMessage();
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public TextMessage createTextMessage() {
        try {
            return this.getSession().createTextMessage();
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public TextMessage createTextMessage(String text) {
        try {
            return this.getSession().createTextMessage(text);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public Queue createQueue(String queueName) {
        try {
            return this.getSession().createQueue(queueName);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public Topic createTopic(String topicName) {
        try {
            return this.getSession().createTopic(topicName);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public TemporaryQueue createTemporaryQueue() {
        try {
            return this.getSession().createTemporaryQueue();
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public TemporaryTopic createTemporaryTopic() {
        try {
            return this.getSession().createTemporaryTopic();
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public synchronized JMSContext createContext(int sessionMode) {
        if (this.connectionRefCount.get() == 0L) {
            throw new IllegalStateRuntimeException("The Connection is closed");
        }
        JmsSession.validateSessionMode(sessionMode);
        this.connectionRefCount.incrementAndGet();
        return new JmsContext(this.connection, sessionMode, this.connectionRefCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMSProducer createProducer() {
        try {
            if (this.sharedProducer == null) {
                JmsContext jmsContext = this;
                synchronized (jmsContext) {
                    if (this.sharedProducer == null) {
                        this.sharedProducer = (JmsMessageProducer)this.getSession().createProducer(null);
                    }
                }
            }
            return new JmsProducer(this.getSession(), this.sharedProducer);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public JMSConsumer createConsumer(Destination destination) {
        try {
            return this.startIfNeeded(new JmsConsumer(this.getSession(), (JmsMessageConsumer)this.getSession().createConsumer(destination)));
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public JMSConsumer createConsumer(Destination destination, String selector) {
        try {
            return this.startIfNeeded(new JmsConsumer(this.getSession(), (JmsMessageConsumer)this.getSession().createConsumer(destination, selector)));
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public JMSConsumer createConsumer(Destination destination, String selector, boolean noLocal) {
        try {
            return this.startIfNeeded(new JmsConsumer(this.getSession(), (JmsMessageConsumer)this.getSession().createConsumer(destination, selector, noLocal)));
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name) {
        try {
            return this.startIfNeeded(new JmsConsumer(this.getSession(), (JmsMessageConsumer)this.getSession().createDurableConsumer(topic, name)));
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name, String selector, boolean noLocal) {
        try {
            return this.startIfNeeded(new JmsConsumer(this.getSession(), (JmsMessageConsumer)this.getSession().createDurableConsumer(topic, name, selector, noLocal)));
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public JMSConsumer createSharedConsumer(Topic topic, String name) {
        try {
            return this.startIfNeeded(new JmsConsumer(this.getSession(), (JmsMessageConsumer)this.getSession().createSharedConsumer(topic, name)));
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public JMSConsumer createSharedConsumer(Topic topic, String name, String selector) {
        try {
            return this.startIfNeeded(new JmsConsumer(this.getSession(), (JmsMessageConsumer)this.getSession().createSharedConsumer(topic, name, selector)));
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name) {
        try {
            return this.startIfNeeded(new JmsConsumer(this.getSession(), (JmsMessageConsumer)this.getSession().createSharedDurableConsumer(topic, name)));
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name, String selector) {
        try {
            return this.startIfNeeded(new JmsConsumer(this.getSession(), (JmsMessageConsumer)this.getSession().createSharedDurableConsumer(topic, name, selector)));
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public QueueBrowser createBrowser(Queue queue) {
        try {
            return this.startIfNeeded(this.getSession().createBrowser(queue));
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public QueueBrowser createBrowser(Queue queue, String selector) {
        try {
            return this.startIfNeeded(this.getSession().createBrowser(queue, selector));
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public boolean getAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public String getClientID() {
        try {
            return this.connection.getClientID();
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public void setClientID(String clientID) {
        try {
            this.connection.setClientID(clientID);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public ExceptionListener getExceptionListener() {
        try {
            return this.connection.getExceptionListener();
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public void setExceptionListener(ExceptionListener listener) {
        try {
            this.connection.setExceptionListener(listener);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public ConnectionMetaData getMetaData() {
        try {
            return this.connection.getMetaData();
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
        }
    }

    public int getSessionMode() {
        return this.sessionMode;
    }

    public boolean getTransacted() {
        return this.sessionMode == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JmsSession getSession() {
        if (this.session == null) {
            JmsContext jmsContext = this;
            synchronized (jmsContext) {
                if (this.session == null) {
                    try {
                        this.session = (JmsSession)this.connection.createSession(this.getSessionMode());
                    }
                    catch (JMSException jmse) {
                        throw JmsExceptionSupport.createRuntimeException((Exception)((Object)jmse));
                    }
                }
            }
        }
        return this.session;
    }

    private QueueBrowser startIfNeeded(QueueBrowser browser) throws JMSException {
        if (this.getAutoStart()) {
            this.connection.start();
        }
        return browser;
    }

    private JmsConsumer startIfNeeded(JmsConsumer consumer) throws JMSException {
        if (this.getAutoStart()) {
            this.connection.start();
        }
        return consumer;
    }
}

