/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.util.LinkedList;
import java.util.List;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.Log;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.LogFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

@Deprecated
public class RetransmitTable {
    protected final int num_rows;
    protected final int msgs_per_row;
    protected final double resize_factor;
    protected Message[][] matrix;
    protected long offset;
    protected int size = 0;
    protected long highest_seqno_purged;
    protected long highest_seqno;
    protected long max_compaction_time = 120000L;
    protected long last_compaction_timestamp = 0L;
    protected boolean automatic_purging;
    protected static final long DEFAULT_MAX_COMPACTION_TIME = 120000L;
    protected static final double DEFAULT_RESIZE_FACTOR = 1.2;
    protected static final Log log = LogFactory.getLog(RetransmitTable.class);

    public RetransmitTable() {
        this(5, 8192, 0L, 1.2);
    }

    public RetransmitTable(int num_rows, int msgs_per_row, long offset) {
        this(num_rows, msgs_per_row, offset, 1.2);
    }

    public RetransmitTable(int num_rows, int msgs_per_row, long offset, double resize_factor) {
        this(num_rows, msgs_per_row, offset, resize_factor, 120000L, false);
    }

    public RetransmitTable(int num_rows, int msgs_per_row, long offset, double resize_factor, long max_compaction_time, boolean automatic_purging) {
        this.num_rows = num_rows;
        this.msgs_per_row = Util.getNextHigherPowerOfTwo(msgs_per_row);
        this.resize_factor = resize_factor;
        this.max_compaction_time = max_compaction_time;
        this.automatic_purging = automatic_purging;
        this.highest_seqno_purged = this.highest_seqno = offset;
        this.offset = this.highest_seqno;
        this.matrix = new Message[num_rows][];
        if (resize_factor <= 1.0) {
            throw new IllegalArgumentException("resize_factor needs to be > 1");
        }
    }

    public int getLength() {
        return this.matrix.length;
    }

    public long getOffset() {
        return this.offset;
    }

    public int capacity() {
        return this.matrix.length * this.msgs_per_row;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }

    public long getHighest() {
        return this.highest_seqno;
    }

    public long getHighestPurged() {
        return this.highest_seqno_purged;
    }

    public long getMaxCompactionTime() {
        return this.max_compaction_time;
    }

    public void setMaxCompactionTime(long max_compaction_time) {
        this.max_compaction_time = max_compaction_time;
    }

    public boolean isAutomaticPurging() {
        return this.automatic_purging;
    }

    public void setAutomaticPurging(boolean automatic_purging) {
        this.automatic_purging = automatic_purging;
    }

    public double getFillFactor() {
        return this.size == 0 ? 0.0 : (double)((int)((double)this.size / (double)this.capacity() * 100.0));
    }

    public boolean put(long seqno, Message msg) {
        return this.putIfAbsent(seqno, msg) == null;
    }

    public Message putIfAbsent(long seqno, Message msg) {
        int index;
        Message[] row;
        Message existing_msg;
        int row_index = this.computeRow(seqno);
        if (row_index >= this.matrix.length) {
            this.resize(seqno);
            row_index = this.computeRow(seqno);
        }
        if ((existing_msg = (row = this.getRow(row_index))[index = this.computeIndex(seqno)]) == null) {
            row[index] = msg;
            ++this.size;
            if (seqno > this.highest_seqno) {
                this.highest_seqno = seqno;
            }
            return null;
        }
        return existing_msg;
    }

    public Message get(long seqno) {
        int row_index = this.computeRow(seqno);
        if (row_index < 0 || row_index >= this.matrix.length) {
            return null;
        }
        Message[] row = this.matrix[row_index];
        if (row == null) {
            return null;
        }
        int index = this.computeIndex(seqno);
        return index >= 0 ? row[index] : null;
    }

    public List<Message> get(long from, long to) {
        LinkedList<Message> retval = null;
        for (long seqno = from; seqno <= to; ++seqno) {
            Message msg = this.get(seqno);
            if (msg == null) continue;
            if (retval == null) {
                retval = new LinkedList<Message>();
            }
            retval.add(msg);
        }
        return retval;
    }

    public Message remove(long seqno) {
        int row_index = this.computeRow(seqno);
        if (row_index < 0 || row_index >= this.matrix.length) {
            return null;
        }
        Message[] row = this.matrix[row_index];
        if (row == null) {
            return null;
        }
        int index = this.computeIndex(seqno);
        if (index < 0) {
            return null;
        }
        Message existing_msg = row[index];
        if (existing_msg != null) {
            row[index] = null;
            this.size = Math.max(this.size - 1, 0);
            if (this.automatic_purging && seqno > this.highest_seqno_purged) {
                this.highest_seqno_purged = seqno;
            }
        }
        return existing_msg;
    }

    public void clear() {
        this.matrix = new Message[this.num_rows][];
        this.size = 0;
        this.highest_seqno = 0L;
        this.highest_seqno_purged = 0L;
        this.offset = 0L;
    }

    public void purge(long seqno) {
        int num_rows_to_remove = (int)(seqno - this.offset) / this.msgs_per_row;
        for (int i = 0; i < num_rows_to_remove; ++i) {
            this.matrix[i] = null;
        }
        int row_index = this.computeRow(seqno);
        if (row_index < 0 || row_index >= this.matrix.length) {
            return;
        }
        Message[] row = this.matrix[row_index];
        if (row != null) {
            int index = this.computeIndex(seqno);
            for (int i = 0; i <= index; ++i) {
                row[i] = null;
            }
        }
        this.size = this.computeSize();
        if (seqno > this.highest_seqno_purged) {
            this.highest_seqno_purged = seqno;
        }
        if (this.max_compaction_time <= 0L) {
            return;
        }
        long current_time = System.currentTimeMillis();
        if (this.last_compaction_timestamp > 0L) {
            if (current_time - this.last_compaction_timestamp >= this.max_compaction_time) {
                this.compact();
                this.last_compaction_timestamp = current_time;
            }
        } else {
            this.last_compaction_timestamp = current_time;
        }
    }

    protected void resize(long seqno) {
        int num_rows_to_purge = (int)((this.highest_seqno_purged - this.offset) / (long)this.msgs_per_row);
        int row_index = this.computeRow(seqno) - num_rows_to_purge;
        if (row_index < 0) {
            return;
        }
        int new_size = Math.max(row_index + 1, this.matrix.length);
        if (new_size > this.matrix.length) {
            Message[][] new_matrix = new Message[new_size][];
            System.arraycopy(this.matrix, num_rows_to_purge, new_matrix, 0, this.matrix.length - num_rows_to_purge);
            this.matrix = new_matrix;
        } else if (num_rows_to_purge > 0) {
            this.move(num_rows_to_purge);
        }
        this.offset += (long)(num_rows_to_purge * this.msgs_per_row);
        this.size = this.computeSize();
    }

    protected void move(int num_rows) {
        int i;
        if (num_rows <= 0 || num_rows > this.matrix.length) {
            return;
        }
        int target_index = 0;
        for (i = num_rows; i < this.matrix.length; ++i) {
            this.matrix[target_index++] = this.matrix[i];
        }
        for (i = this.matrix.length - num_rows; i < this.matrix.length; ++i) {
            this.matrix[i] = null;
        }
    }

    public void compact() {
        int from = this.computeRow(this.highest_seqno_purged);
        int to = this.computeRow(this.highest_seqno);
        int range = to - from + 1;
        int new_size = (int)Math.max((double)range * this.resize_factor, (double)(range + 1));
        if ((new_size = Math.max(new_size, this.num_rows)) < this.matrix.length) {
            if (log.isTraceEnabled()) {
                log.trace("compacting matrix from " + this.matrix.length + " rows to " + new_size + " rows");
            }
            Message[][] new_matrix = new Message[new_size][];
            System.arraycopy(this.matrix, from, new_matrix, 0, range);
            this.matrix = new_matrix;
            this.offset += (long)(from * this.msgs_per_row);
            this.size = this.computeSize();
        }
    }

    public int computeSize() {
        int retval = 0;
        int from = this.computeRow(this.highest_seqno_purged);
        int to = this.computeRow(this.highest_seqno);
        for (int i = from; i <= to; ++i) {
            Message[] row = this.matrix[i];
            if (row == null) continue;
            for (int j = 0; j < row.length; ++j) {
                if (row[j] == null) continue;
                ++retval;
            }
        }
        return retval;
    }

    public int getNullMessages(long from, long to) {
        int retval = 0;
        for (long i = from + 1L; i < to; ++i) {
            Message[] row;
            int row_index = this.computeRow(i);
            if (row_index < 0 || row_index >= this.matrix.length || (row = this.matrix[row_index]) != null && row[this.computeIndex(i)] != null) continue;
            ++retval;
        }
        return retval;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("size=" + this.size + ", capacity=" + this.capacity() + ", highest=" + this.highest_seqno + ", highest_purged=" + this.highest_seqno_purged);
        return sb.toString();
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < this.matrix.length; ++i) {
            Message[] row = this.matrix[i];
            if (row == null) continue;
            for (int j = 0; j < row.length; ++j) {
                if (row[j] == null) continue;
                long seqno = this.offset + (long)(i * this.msgs_per_row) + (long)j;
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(seqno);
            }
        }
        return sb.toString();
    }

    public String dumpMatrix() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.matrix.length; ++i) {
            Message[] row = this.matrix[i];
            sb.append(i + ": ");
            if (row == null) {
                sb.append("\n");
                continue;
            }
            for (int j = 0; j < row.length; ++j) {
                if (row[j] != null) {
                    sb.append("* ");
                    continue;
                }
                sb.append("  ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public long sizeOfAllMessages(boolean include_headers) {
        long retval = 0L;
        for (int i = 0; i < this.matrix.length; ++i) {
            Message[] row = this.matrix[i];
            if (row == null) continue;
            for (int j = 0; j < row.length; ++j) {
                Message msg = row[j];
                if (msg == null) continue;
                retval += include_headers ? msg.size() : (long)msg.getLength();
            }
        }
        return retval;
    }

    protected Message[] getRow(int index) {
        Message[] row = this.matrix[index];
        if (row == null) {
            row = new Message[this.msgs_per_row];
            this.matrix[index] = row;
        }
        return row;
    }

    protected int computeRow(long seqno) {
        int diff = (int)(seqno - this.offset);
        if (diff < 0) {
            return diff;
        }
        return diff / this.msgs_per_row;
    }

    protected int computeIndex(long seqno) {
        int diff = (int)(seqno - this.offset);
        if (diff < 0) {
            return diff;
        }
        return diff & this.msgs_per_row - 1;
    }
}

