/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols.pbcast;

import java.io.DataInput;
import java.io.DataOutput;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Digest;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Streamable;

public class JoinRsp
implements Streamable {
    protected View view;
    protected Digest digest;
    protected String fail_reason;
    protected static final byte VIEW_PRESENT = 1;
    protected static final byte DIGEST_PRESENT = 2;
    protected static final byte FAIL_REASON_PRESENT = 4;

    public JoinRsp() {
    }

    public JoinRsp(View v, Digest d) {
        this.view = v;
        this.digest = d;
    }

    public JoinRsp(String fail_reason) {
        this.fail_reason = fail_reason;
    }

    public View getView() {
        return this.view;
    }

    public Digest getDigest() {
        return this.digest;
    }

    public String getFailReason() {
        return this.fail_reason;
    }

    public JoinRsp setFailReason(String r) {
        this.fail_reason = r;
        return this;
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        byte flags = 0;
        if (this.view != null) {
            flags = (byte)(flags | 1);
        }
        if (this.digest != null) {
            flags = (byte)(flags | 2);
        }
        if (this.fail_reason != null) {
            flags = (byte)(flags | 4);
        }
        out.writeByte(flags);
        if (this.view != null) {
            this.view.writeTo(out);
        }
        if (this.digest != null) {
            this.digest.writeTo(out, false);
        }
        if (this.fail_reason != null) {
            out.writeUTF(this.fail_reason);
        }
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        byte flags = in.readByte();
        if ((flags & 1) == 1) {
            this.view = new View();
            this.view.readFrom(in);
        }
        if ((flags & 2) == 2) {
            this.digest = new Digest(this.view.getMembersRaw());
            this.digest.readFrom(in, false);
        }
        if ((flags & 4) == 4) {
            this.fail_reason = in.readUTF();
        }
    }

    public int serializedSize() {
        int retval = 1;
        if (this.view != null) {
            retval += this.view.serializedSize();
        }
        if (this.digest != null) {
            retval = (int)((long)retval + this.digest.serializedSize(false));
        }
        if (this.fail_reason != null) {
            retval += this.fail_reason.length() + 2;
        }
        return retval;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.view != null) {
            sb.append("view: ").append(this.view);
        }
        if (this.digest != null) {
            sb.append(", digest: ").append(this.digest);
        }
        if (this.fail_reason != null) {
            sb.append("fail reason: ").append(this.fail_reason);
        }
        return sb.toString();
    }
}

