/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.rest.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.activemq.artemis.rest.ActiveMQRestLogger;

public class TimeoutTask
implements Runnable {
    protected boolean running = true;
    protected int interval = 10;
    protected final Lock callbacksLock = new ReentrantLock();
    protected Map<String, Callback> callbacks = new HashMap<String, Callback>();
    protected final Lock pendingCallbacksLock = new ReentrantLock();
    protected Map<String, Callback> pendingCallbacks = new HashMap<String, Callback>();
    protected Thread thread;

    public TimeoutTask(int interval) {
        this.interval = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(Callback callback, String token) {
        if (this.callbacksLock.tryLock()) {
            try {
                this.callbacks.put(token, callback);
            }
            finally {
                this.callbacksLock.unlock();
            }
        }
        this.pendingCallbacksLock.lock();
        try {
            this.pendingCallbacks.put(token, callback);
        }
        finally {
            this.pendingCallbacksLock.unlock();
        }
    }

    public synchronized void remove(String token) {
        this.callbacksLock.lock();
        try {
            this.callbacks.remove(token);
        }
        finally {
            this.callbacksLock.unlock();
        }
    }

    public synchronized void stop() {
        this.running = false;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public synchronized int getInterval() {
        return this.interval;
    }

    public synchronized void setInterval(int interval) {
        this.interval = interval;
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            try {
                Thread.sleep((long)this.interval * 1000L);
            }
            catch (InterruptedException e) {
                this.running = false;
                break;
            }
            HashMap<String, Callback> expiredCallbacks = new HashMap<String, Callback>();
            int liveConsumers = 0;
            int deadConsumers = 0;
            this.callbacksLock.lock();
            try {
                long startTime = System.currentTimeMillis();
                ArrayList<String> tokens = new ArrayList<String>(this.callbacks.size());
                for (String token : this.callbacks.keySet()) {
                    tokens.add(token);
                }
                for (String token : tokens) {
                    Callback callback = this.callbacks.get(token);
                    if (callback.testTimeout(token, false)) {
                        ++deadConsumers;
                        expiredCallbacks.put(token, callback);
                        this.callbacks.remove(token);
                        continue;
                    }
                    ++liveConsumers;
                }
                ActiveMQRestLogger.LOGGER.debug("Finished testing callbacks for timeouts in " + (System.currentTimeMillis() - startTime) + "ms. (Live: " + liveConsumers + ", Expired: " + deadConsumers + ")");
                this.pendingCallbacksLock.lock();
                try {
                    if (this.pendingCallbacks.size() > 0) {
                        ActiveMQRestLogger.LOGGER.debug("Found " + this.pendingCallbacks.size() + " callbacks to add.");
                        this.callbacks.putAll(this.pendingCallbacks);
                        this.pendingCallbacks.clear();
                    }
                }
                finally {
                    this.pendingCallbacksLock.unlock();
                }
            }
            finally {
                this.callbacksLock.unlock();
            }
            if (expiredCallbacks.size() <= 0) continue;
            ArrayList<String> tokens = new ArrayList<String>(expiredCallbacks.size());
            for (String token : expiredCallbacks.keySet()) {
                tokens.add(token);
            }
            for (String token : tokens) {
                Callback expired = (Callback)expiredCallbacks.get(token);
                expired.shutdown(token);
            }
        }
    }

    public static interface Callback {
        public boolean testTimeout(String var1, boolean var2);

        public void shutdown(String var1);
    }
}

