/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.rest.queue.push;

import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.rest.queue.push.UriTemplateStrategy;
import org.apache.activemq.artemis.rest.queue.push.xml.XmlHttpHeader;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.specimpl.ResteasyUriBuilder;
import org.jboss.resteasy.spi.Link;

public class ActiveMQPushStrategy
extends UriTemplateStrategy {
    protected boolean initialized = false;

    @Override
    public void start() throws Exception {
    }

    protected void initialize() throws Exception {
        super.start();
        this.initialized = true;
        this.initAuthentication();
        ClientRequest request = this.executor.createRequest(this.registration.getTarget().getHref());
        for (XmlHttpHeader header : this.registration.getHeaders()) {
            request.header(header.getName(), (Object)header.getValue());
        }
        ClientResponse res = request.head();
        if (res.getStatus() != 200) {
            throw new RuntimeException("Failed to query REST destination for init information.  Status: " + res.getStatus());
        }
        String url = (String)res.getHeaders().getFirst((Object)"msg-create-with-id");
        if (url == null) {
            if (res.getLinkHeader() == null) {
                throw new RuntimeException("Could not find create-with-id URL");
            }
            Link link = res.getLinkHeader().getLinkByTitle("create-with-id");
            if (link == null) {
                throw new RuntimeException("Could not find create-with-id URL");
            }
            url = link.getHref();
        }
        this.targetUri = ResteasyUriBuilder.fromTemplate((String)url);
    }

    @Override
    public boolean push(ClientMessage message) {
        if (!this.initialized) {
            try {
                this.initialize();
                this.initialized = true;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize.", e);
            }
        }
        return super.push(message);
    }
}

