/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.rest.queue;

import javax.ws.rs.core.Response;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.jms.client.ConnectionFactoryOptions;
import org.apache.activemq.artemis.rest.ActiveMQRestLogger;
import org.apache.activemq.artemis.rest.HttpHeaderProperty;
import org.apache.activemq.artemis.rest.queue.ConsumedHttpMessage;
import org.apache.activemq.artemis.rest.queue.ConsumedObjectMessage;

public abstract class ConsumedMessage {
    public static final String POSTED_AS_HTTP_MESSAGE = "postedAsHttpMessage";
    protected ClientMessage message;

    public ConsumedMessage(ClientMessage message) {
        this.message = message;
    }

    public long getMessageID() {
        return this.message.getMessageID();
    }

    public abstract void build(Response.ResponseBuilder var1);

    protected void buildHeaders(Response.ResponseBuilder builder) {
        for (SimpleString key : this.message.getPropertyNames()) {
            String k = key.toString();
            String headerName = HttpHeaderProperty.fromPropertyName(k);
            if (headerName == null) continue;
            builder.header(headerName, (Object)this.message.getStringProperty(k));
            ActiveMQRestLogger.LOGGER.debug("Adding " + headerName + "=" + this.message.getStringProperty(k));
        }
    }

    public static ConsumedMessage createConsumedMessage(ClientMessage message, ConnectionFactoryOptions options) {
        Boolean aBoolean = message.getBooleanProperty(POSTED_AS_HTTP_MESSAGE);
        if (aBoolean != null && aBoolean.booleanValue()) {
            return new ConsumedHttpMessage(message);
        }
        if (message.getType() == 2) {
            return new ConsumedObjectMessage(message, options);
        }
        throw new IllegalArgumentException("ClientMessage must be an HTTP message or an Object message: " + message + " type: " + message.getType());
    }
}

