/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.rest.queue;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.rest.ActiveMQRestLogger;
import org.apache.activemq.artemis.rest.queue.ConsumersResource;
import org.apache.activemq.artemis.rest.queue.DestinationResource;
import org.apache.activemq.artemis.rest.queue.PostMessage;
import org.apache.activemq.artemis.rest.queue.QueueDestinationsResource;
import org.apache.activemq.artemis.rest.queue.push.PushConsumerResource;

public class QueueResource
extends DestinationResource {
    protected ConsumersResource consumers;
    protected PushConsumerResource pushConsumers;
    private QueueDestinationsResource queueDestinationsResource;

    public void start() throws Exception {
    }

    public void stop() {
        this.consumers.stop();
        this.pushConsumers.stop();
        this.sender.cleanup();
    }

    @GET
    @Produces(value={"application/xml"})
    public Response get(@Context UriInfo uriInfo, @Context HttpServletRequest requestContext) {
        ActiveMQRestLogger.LOGGER.debug("Handling GET request for \"" + this.destination + "\" from " + requestContext.getRemoteAddr() + ":" + requestContext.getRemotePort());
        StringBuilder msg = new StringBuilder();
        msg.append("<queue>").append("<name>").append(this.destination).append("</name>").append("<atom:link rel=\"create\" href=\"").append(this.createSenderLink(uriInfo)).append("\"/>").append("<atom:link rel=\"create-with-id\" href=\"").append(this.createSenderWithIdLink(uriInfo)).append("\"/>").append("<atom:link rel=\"pull-consumers\" href=\"").append(this.createConsumersLink(uriInfo)).append("\"/>").append("<atom:link rel=\"push-consumers\" href=\"").append(this.createPushConsumersLink(uriInfo)).append("\"/>").append("</queue>");
        Response.ResponseBuilder builder = Response.ok((Object)msg.toString());
        this.setSenderLink(builder, uriInfo);
        this.setSenderWithIdLink(builder, uriInfo);
        this.setConsumersLink(builder, uriInfo);
        this.setPushConsumersLink(builder, uriInfo);
        return builder.build();
    }

    @HEAD
    @Produces(value={"application/xml"})
    public Response head(@Context UriInfo uriInfo) {
        ActiveMQRestLogger.LOGGER.debug("Handling HEAD request for \"" + uriInfo.getRequestUri() + "\"");
        Response.ResponseBuilder builder = Response.ok();
        this.setSenderLink(builder, uriInfo);
        this.setSenderWithIdLink(builder, uriInfo);
        this.setConsumersLink(builder, uriInfo);
        this.setPushConsumersLink(builder, uriInfo);
        return builder.build();
    }

    protected void setSenderLink(Response.ResponseBuilder response, UriInfo info) {
        String uri = this.createSenderLink(info);
        this.serviceManager.getLinkStrategy().setLinkHeader(response, "create", "create", uri, null);
    }

    protected String createSenderLink(UriInfo info) {
        UriBuilder builder = info.getRequestUriBuilder();
        builder.path("create");
        String uri = builder.build(new Object[0]).toString();
        return uri;
    }

    protected void setSenderWithIdLink(Response.ResponseBuilder response, UriInfo info) {
        String uri = this.createSenderWithIdLink(info);
        this.serviceManager.getLinkStrategy().setLinkHeader(response, "create-with-id", "create-with-id", uri, null);
    }

    protected String createSenderWithIdLink(UriInfo info) {
        UriBuilder builder = info.getRequestUriBuilder();
        builder.path("create");
        Object uri = builder.build(new Object[0]).toString();
        uri = (String)uri + "/{id}";
        return uri;
    }

    protected void setConsumersLink(Response.ResponseBuilder response, UriInfo info) {
        String uri = this.createConsumersLink(info);
        this.serviceManager.getLinkStrategy().setLinkHeader(response, "pull-consumers", "pull-consumers", uri, null);
    }

    protected String createConsumersLink(UriInfo info) {
        UriBuilder builder = info.getRequestUriBuilder();
        builder.path("pull-consumers");
        String uri = builder.build(new Object[0]).toString();
        return uri;
    }

    protected void setPushConsumersLink(Response.ResponseBuilder response, UriInfo info) {
        String uri = this.createPushConsumersLink(info);
        this.serviceManager.getLinkStrategy().setLinkHeader(response, "push-consumers", "push-consumers", uri, null);
    }

    protected String createPushConsumersLink(UriInfo info) {
        UriBuilder builder = info.getRequestUriBuilder();
        builder.path("push-consumers");
        String uri = builder.build(new Object[0]).toString();
        return uri;
    }

    public void setConsumers(ConsumersResource consumers) {
        this.consumers = consumers;
    }

    @Path(value="create")
    public PostMessage post() throws Exception {
        return this.sender;
    }

    @Path(value="pull-consumers")
    public ConsumersResource getConsumers() {
        return this.consumers;
    }

    public void setPushConsumers(PushConsumerResource pushConsumers) {
        this.pushConsumers = pushConsumers;
    }

    @Path(value="push-consumers")
    public PushConsumerResource getPushConsumers() {
        return this.pushConsumers;
    }

    public void setQueueDestinationsResource(QueueDestinationsResource queueDestinationsResource) {
        this.queueDestinationsResource = queueDestinationsResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    public void deleteQueue(@Context UriInfo uriInfo) throws Exception {
        ActiveMQRestLogger.LOGGER.debug("Handling DELETE request for \"" + uriInfo.getPath() + "\"");
        this.queueDestinationsResource.getQueues().remove(this.destination);
        this.stop();
        ClientSession session = this.serviceManager.getSessionFactory().createSession(false, false, false);
        try {
            SimpleString queueName = new SimpleString(this.destination);
            session.deleteQueue(queueName);
        }
        finally {
            try {
                session.close();
            }
            catch (Exception exception) {}
        }
    }
}

