/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.actors;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.artemis.utils.actors.ThresholdActor;
import org.junit.Assert;
import org.junit.Test;

public class ThresholdActorTest {
    Semaphore semaphore = new Semaphore(1);
    AtomicInteger result = new AtomicInteger(0);
    AtomicInteger lastProcessed = new AtomicInteger(0);
    AtomicInteger errors = new AtomicInteger(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void limitedSize() throws Exception {
        this.lastProcessed.set(0);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        AtomicInteger timesOpen = new AtomicInteger(0);
        AtomicInteger timesClose = new AtomicInteger(0);
        AtomicBoolean open = new AtomicBoolean(true);
        try {
            this.semaphore.acquire();
            ThresholdActor actor = new ThresholdActor((Executor)executorService, this::limitedProcess, 10, s -> 1, () -> {
                timesClose.incrementAndGet();
                open.set(false);
            }, () -> {
                timesOpen.incrementAndGet();
                open.set(true);
            });
            for (int i = 0; i < 10; ++i) {
                actor.act((Object)i);
            }
            Assert.assertTrue((boolean)open.get());
            Assert.assertEquals((long)0L, (long)timesClose.get());
            actor.act((Object)99);
            Assert.assertEquals((long)1L, (long)timesClose.get());
            Assert.assertEquals((long)0L, (long)timesOpen.get());
            Assert.assertFalse((boolean)open.get());
            actor.act((Object)1000);
            actor.flush();
            Assert.assertEquals((long)1L, (long)timesClose.get());
            Assert.assertEquals((long)0L, (long)timesOpen.get());
            Assert.assertFalse((boolean)open.get());
            this.semaphore.release();
            Wait.assertTrue(open::get);
            Assert.assertEquals((long)1L, (long)timesClose.get());
            Assert.assertEquals((long)1L, (long)timesOpen.get());
            Wait.assertEquals(1000, this.lastProcessed::get, 5000L, 1L);
            actor.flush();
            open.set(false);
            Wait.assertEquals(2, timesOpen::get, 5000L, 1L);
            Wait.assertTrue(open::get);
        }
        finally {
            executorService.shutdown();
        }
    }

    public void limitedProcess(Integer i) {
        try {
            this.semaphore.acquire();
            this.result.incrementAndGet();
            this.lastProcessed.set(i);
            this.semaphore.release();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static int getSize(Element e) {
        return e.size;
    }

    protected void process(Element e) {
        this.lastProcessed.set(e.i);
    }

    public void block() {
        try {
            if (!this.semaphore.tryAcquire()) {
                this.errors.incrementAndGet();
                System.err.println("acquire failed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unblock() {
        this.semaphore.release();
    }

    @Test
    public void testFlow() throws Exception {
        this.testFlow(true);
    }

    @Test
    public void testFlow2() throws Exception {
        this.testFlow(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFlow(boolean respectSemaphore) throws Exception {
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        try {
            ThresholdActor actor = new ThresholdActor((Executor)executorService, this::process, 20, e -> e.size, this::block, this::unblock);
            int LAST_ELEMENT = 1111;
            CountDownLatch latchDone = new CountDownLatch(1);
            executorService.execute(() -> {
                for (int i = 0; i <= 1111; ++i) {
                    try {
                        if (respectSemaphore) {
                            this.semaphore.acquire();
                            this.semaphore.release();
                        }
                        actor.act((Object)new Element(i, i % 2 == 0 ? 20 : 1));
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.errors.incrementAndGet();
                    }
                }
                latchDone.countDown();
            });
            Assert.assertTrue((boolean)latchDone.await(10L, TimeUnit.SECONDS));
            Wait.assertEquals(1111, this.lastProcessed::get);
            Assert.assertEquals((long)0L, (long)this.errors.get());
        }
        finally {
            executorService.shutdown();
        }
    }

    static class Element {
        int i;
        int size;

        Element(int i, int size) {
            this.i = i;
            this.size = size;
        }
    }
}

