/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.junit.Assert;
import org.junit.Test;

public class HumanReadableByteCountTest {
    @Test
    public void testDefaultLocale() {
        this.internalTest(Locale.getDefault());
    }

    @Test
    public void testEnglishLocale() {
        this.internalTest(Locale.ENGLISH);
    }

    @Test
    public void testFrenchLocale() {
        this.internalTest(Locale.FRENCH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalTest(Locale testLocale) {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(testLocale);
        DecimalFormat decimalFormat = new DecimalFormat("###.0", DecimalFormatSymbols.getInstance(testLocale));
        try {
            String[] suffixes = new String[]{"K", "M", "G", "T", "P", "E"};
            Assert.assertEquals((Object)"0B", (Object)ByteUtil.getHumanReadableByteCount((long)0L));
            Assert.assertEquals((Object)(decimalFormat.format(999.0) + "B"), (Object)ByteUtil.getHumanReadableByteCount((long)999L));
            Assert.assertEquals((Object)(decimalFormat.format(500.0) + "B"), (Object)ByteUtil.getHumanReadableByteCount((long)500L));
            int i = 0;
            int j = 3;
            while (i < 6) {
                long magnitude = (long)Math.pow(10.0, j);
                Assert.assertEquals((Object)(decimalFormat.format(1.0) + suffixes[i] + "B"), (Object)ByteUtil.getHumanReadableByteCount((long)magnitude));
                Assert.assertEquals((Object)(decimalFormat.format(1.3) + suffixes[i] + "B"), (Object)ByteUtil.getHumanReadableByteCount((long)(magnitude + (long)(0.25 * (double)magnitude))));
                Assert.assertEquals((Object)(decimalFormat.format(1.5) + suffixes[i] + "B"), (Object)ByteUtil.getHumanReadableByteCount((long)(magnitude + (long)(0.5 * (double)magnitude))));
                Assert.assertEquals((Object)(decimalFormat.format(1.9) + suffixes[i] + "B"), (Object)ByteUtil.getHumanReadableByteCount((long)(magnitude + (long)(0.9 * (double)magnitude))));
                Assert.assertEquals((Object)(decimalFormat.format(4.2) + suffixes[i] + "B"), (Object)ByteUtil.getHumanReadableByteCount((long)(magnitude + (long)(3.2 * (double)magnitude))));
                ++i;
                j += 3;
            }
        }
        finally {
            Locale.setDefault(defaultLocale);
        }
    }
}

