/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.rest.queue.push;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.jms.client.ConnectionFactoryOptions;
import org.apache.activemq.artemis.rest.ActiveMQRestLogger;
import org.apache.activemq.artemis.rest.queue.push.PushConsumer;
import org.apache.activemq.artemis.rest.queue.push.PushStore;
import org.apache.activemq.artemis.rest.queue.push.xml.PushRegistration;

public class PushConsumerResource {
    protected Map<String, PushConsumer> consumers = new ConcurrentHashMap<String, PushConsumer>();
    protected ClientSessionFactory sessionFactory;
    protected String destination;
    protected final String startup = Long.toString(System.currentTimeMillis());
    protected final AtomicLong sessionCounter = new AtomicLong(1L);
    protected PushStore pushStore;
    private ConnectionFactoryOptions jmsOptions;

    public void start() {
    }

    public void stop() {
        for (PushConsumer consumer : this.consumers.values()) {
            consumer.stop();
        }
    }

    public PushStore getPushStore() {
        return this.pushStore;
    }

    public void setPushStore(PushStore pushStore) {
        this.pushStore = pushStore;
    }

    public void addRegistration(PushRegistration reg) throws Exception {
        if (!reg.isEnabled()) {
            return;
        }
        PushConsumer consumer = new PushConsumer(this.sessionFactory, this.destination, reg.getId(), reg, this.pushStore, this.jmsOptions);
        consumer.start();
        this.consumers.put(reg.getId(), consumer);
    }

    @POST
    @Consumes(value={"application/xml"})
    public Response create(@Context UriInfo uriInfo, PushRegistration registration) {
        ActiveMQRestLogger.LOGGER.debug("Handling POST request for \"" + uriInfo.getPath() + "\"");
        String genId = this.sessionCounter.getAndIncrement() + "-" + this.startup;
        registration.setId(genId);
        registration.setDestination(this.destination);
        PushConsumer consumer = new PushConsumer(this.sessionFactory, this.destination, genId, registration, this.pushStore, this.jmsOptions);
        try {
            consumer.start();
            if (registration.isDurable() && this.pushStore != null) {
                this.pushStore.add(registration);
            }
        }
        catch (Exception e) {
            consumer.stop();
            throw new WebApplicationException((Throwable)e, Response.serverError().entity((Object)"Failed to start consumer.").type("text/plain").build());
        }
        this.consumers.put(genId, consumer);
        UriBuilder location = uriInfo.getAbsolutePathBuilder();
        location.path(genId);
        return Response.created((URI)location.build(new Object[0])).build();
    }

    @GET
    @Path(value="{consumer-id}")
    @Produces(value={"application/xml"})
    public PushRegistration getConsumer(@Context UriInfo uriInfo, @PathParam(value="consumer-id") String consumerId) {
        ActiveMQRestLogger.LOGGER.debug("Handling GET request for \"" + uriInfo.getPath() + "\"");
        PushConsumer consumer = this.consumers.get(consumerId);
        if (consumer == null) {
            throw new WebApplicationException(Response.status((int)404).entity((Object)"Could not find consumer.").type("text/plain").build());
        }
        return consumer.getRegistration();
    }

    @DELETE
    @Path(value="{consumer-id}")
    public void deleteConsumer(@Context UriInfo uriInfo, @PathParam(value="consumer-id") String consumerId) {
        ActiveMQRestLogger.LOGGER.debug("Handling DELETE request for \"" + uriInfo.getPath() + "\"");
        PushConsumer consumer = this.consumers.remove(consumerId);
        if (consumer == null) {
            throw new WebApplicationException(Response.status((int)404).entity((Object)"Could not find consumer.").type("text/plain").build());
        }
        consumer.stop();
    }

    public Map<String, PushConsumer> getConsumers() {
        return this.consumers;
    }

    public ClientSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(ClientSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setJmsOptions(ConnectionFactoryOptions jmsOptions) {
        this.jmsOptions = jmsOptions;
    }
}

