/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.rest.integration;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.activemq.artemis.jms.client.ConnectionFactoryOptions;
import org.apache.activemq.artemis.rest.MessageServiceManager;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class RestMessagingBootstrapListener
implements ServletContextListener,
ConnectionFactoryOptions {
    MessageServiceManager manager;
    private String deserializationBlackList;
    private String deserializationWhiteList;

    public void contextInitialized(ServletContextEvent contextEvent) {
        ServletContext context = contextEvent.getServletContext();
        ResteasyDeployment resteasyDeployment = (ResteasyDeployment)context.getAttribute(ResteasyDeployment.class.getName());
        if (resteasyDeployment == null) {
            throw new RuntimeException("You must install RESTEasy as a Bootstrap Listener and it must be listed before this class");
        }
        Registry registry = resteasyDeployment.getRegistry();
        String configfile = context.getInitParameter("rest.messaging.config.file");
        this.deserializationBlackList = context.getInitParameter("org.apache.activemq.artemis.jms.deserialization.blacklist");
        this.deserializationWhiteList = context.getInitParameter("org.apache.activemq.artemis.jms.deserialization.whitelist");
        this.manager = new MessageServiceManager(this);
        if (configfile != null) {
            this.manager.setConfigResourcePath(configfile);
        }
        try {
            this.manager.start();
            registry.addSingletonResource((Object)this.manager.getQueueManager().getDestination());
            registry.addSingletonResource((Object)this.manager.getTopicManager().getDestination());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        if (this.manager != null) {
            this.manager.stop();
        }
    }

    public String getDeserializationBlackList() {
        return this.deserializationBlackList;
    }

    public void setDeserializationBlackList(String blackList) {
        this.deserializationBlackList = blackList;
    }

    public String getDeserializationWhiteList() {
        return this.deserializationWhiteList;
    }

    public void setDeserializationWhiteList(String whiteList) {
        this.deserializationWhiteList = whiteList;
    }
}

