/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.apache.johnzon.core;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.JsonChars;

final class JsonObjectImpl
extends AbstractMap<String, JsonValue>
implements JsonObject,
Serializable {
    private Integer hashCode = null;
    private final Map<String, JsonValue> unmodifieableBackingMap;

    private <T> T value(String name, Class<T> clazz) {
        JsonValue v = this.unmodifieableBackingMap.get(name);
        if (v != null) {
            return clazz.cast(v);
        }
        throw new NullPointerException("no mapping for " + name);
    }

    JsonObjectImpl(Map<String, JsonValue> backingMap) {
        this.unmodifieableBackingMap = backingMap;
    }

    public JsonArray getJsonArray(String name) {
        return this.value(name, JsonArray.class);
    }

    public JsonObject getJsonObject(String name) {
        return this.value(name, JsonObject.class);
    }

    public JsonNumber getJsonNumber(String name) {
        return this.value(name, JsonNumber.class);
    }

    public JsonString getJsonString(String name) {
        return this.value(name, JsonString.class);
    }

    public String getString(String name) {
        return this.getJsonString(name).getString();
    }

    public String getString(String name, String defaultValue) {
        JsonValue v = this.unmodifieableBackingMap.get(name);
        if (v != null) {
            if (v instanceof JsonString) {
                return ((JsonString)JsonString.class.cast(v)).getString();
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public int getInt(String name) {
        return this.getJsonNumber(name).intValue();
    }

    public int getInt(String name, int defaultValue) {
        JsonValue v = this.unmodifieableBackingMap.get(name);
        if (v != null) {
            if (v instanceof JsonNumber) {
                return ((JsonNumber)JsonNumber.class.cast(v)).intValue();
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public boolean getBoolean(String name) {
        return this.value(name, JsonValue.class) == JsonValue.TRUE;
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        JsonValue v = this.unmodifieableBackingMap.get(name);
        if (v != null) {
            if (v == JsonValue.TRUE) {
                return true;
            }
            if (v == JsonValue.FALSE) {
                return false;
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public boolean isNull(String name) {
        return this.value(name, JsonValue.class) == JsonValue.NULL;
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.OBJECT;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        Iterator<Map.Entry<String, JsonValue>> it = this.unmodifieableBackingMap.entrySet().iterator();
        boolean hasNext = it.hasNext();
        while (hasNext) {
            Map.Entry<String, JsonValue> entry = it.next();
            builder.append('\"').append(entry.getKey()).append("\":");
            JsonValue value = entry.getValue();
            if (JsonString.class.isInstance(value)) {
                builder.append(value.toString());
            } else {
                builder.append(value != JsonValue.NULL ? value.toString() : JsonChars.NULL);
            }
            if (!(hasNext = it.hasNext())) continue;
            builder.append(",");
        }
        return builder.append('}').toString();
    }

    @Override
    public boolean equals(Object obj) {
        return JsonObjectImpl.class.isInstance(obj) && this.unmodifieableBackingMap.equals(((JsonObjectImpl)JsonObjectImpl.class.cast((Object)obj)).unmodifieableBackingMap);
    }

    @Override
    public int hashCode() {
        Integer h = this.hashCode;
        if (h == null) {
            this.hashCode = h = Integer.valueOf(this.unmodifieableBackingMap.hashCode());
        }
        return h;
    }

    @Override
    public Set<Map.Entry<String, JsonValue>> entrySet() {
        return this.unmodifieableBackingMap.entrySet();
    }
}

